/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.form;

import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.receivers.MultiFileBuffer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.activation.MimetypesFileTypeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.VException;
import org.kopi.galite.visual.VExecFailedException;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VImageField;
import org.kopi.galite.visual.form.VStringField;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0002%&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0002J\u0016\u0010\u001b\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u0019R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler;", "", "block", "Lorg/kopi/galite/visual/form/VBlock;", "(Lorg/kopi/galite/visual/form/VBlock;)V", "acceptedFlavors", "", "", "getAcceptedFlavors$galite_core", "()Ljava/util/Set;", "fileList", "", "Ljava/io/File;", "filesCount", "", "isChartBlockContext", "", "isChartBlockContext$galite_core", "()Z", "isUploadStarted", "streamHandler", "Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler$StreamHandler;", "getStreamHandler$galite_core", "()Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler$StreamHandler;", "acceptDrop", "", "file", "handleDrop", "flavor", "files", "handleImage", "target", "Lorg/kopi/galite/visual/form/VImageField;", "onFinish", "buffer", "Lcom/vaadin/flow/component/upload/Receiver;", "onStart", "Companion", "StreamHandler", "galite-core"})
public final class DBlockDropHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VBlock block;
    @Nullable
    private List<File> fileList;
    private int filesCount;
    private boolean isUploadStarted;
    @NotNull
    private final StreamHandler streamHandler;
    @NotNull
    private static final MimetypesFileTypeMap MIMETYPES_FILE_TYPEMAP = new MimetypesFileTypeMap();
    public static final int MAX_SIZE_TO_WAIT = 0x3200000;

    public DBlockDropHandler(@NotNull VBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        this.block = block2;
        this.streamHandler = new StreamHandler();
    }

    @NotNull
    public final StreamHandler getStreamHandler$galite_core() {
        return this.streamHandler;
    }

    public final void onStart() {
        if (!this.isUploadStarted) {
            this.fileList = new ArrayList();
            this.isUploadStarted = true;
        }
    }

    public final void onFinish(@NotNull Receiver buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer instanceof MultiFileBuffer) {
            this.filesCount = ((MultiFileBuffer)buffer).getFiles().size();
        }
        this.isUploadStarted = false;
    }

    private final void acceptDrop(File file) {
        if (file != null) {
            try {
                boolean success;
                boolean bl;
                if (this.isChartBlockContext$galite_core()) {
                    List<File> list = this.fileList;
                    Intrinsics.checkNotNull(list);
                    list.add(file);
                    List<File> list2 = this.fileList;
                    Intrinsics.checkNotNull(list2);
                    bl = this.handleDrop(list2);
                } else {
                    bl = success = this.handleDrop(file, DBlockDropHandler.Companion.getExtension(file));
                }
                if (!success) {
                    new VExecFailedException("Unable to upload file.");
                }
            }
            catch (VException e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public final Set<String> getAcceptedFlavors$galite_core() {
        return this.block.getAcceptedFlavors();
    }

    private final boolean handleDrop(List<File> files) {
        int n = 0;
        int n2 = files.size();
        while (n < n2) {
            int i;
            File file;
            if (this.handleDrop(file = files.get(i = n++), DBlockDropHandler.Companion.getExtension(file))) continue;
            return false;
        }
        return true;
    }

    private final boolean handleDrop(File file, String flavor) {
        boolean bl;
        String string = flavor;
        if (string == null) {
            string = "";
        }
        VField vField2 = this.block.getDropTarget(string);
        if (vField2 == null) {
            return false;
        }
        VField target = vField2;
        target.onBeforeDrop();
        if (target instanceof VStringField) {
            if (target.getWidth() < file.getAbsolutePath().length()) {
                bl = false;
            } else if (this.isChartBlockContext$galite_core()) {
                int rec = DBlockDropHandler.Companion.getFirstUnfilledRecord(this.block, target);
                this.block.setActiveRecord(rec);
                this.block.setCurrentRecord(rec);
                target.setString(rec, file.getAbsolutePath());
                target.onAfterDrop();
                this.block.setActiveRecord(rec + 1);
                this.block.setCurrentRecord(rec + 1);
                this.block.gotoRecord(this.block.getActiveRecord());
                bl = true;
            } else {
                target.setString(file.getAbsolutePath());
                target.onAfterDrop();
                bl = true;
            }
        } else {
            bl = target instanceof VImageField ? (!target.isInternal() ? (DBlockDropHandler.Companion.isImage(file) ? this.handleImage((VImageField)target, file) : false) : this.handleImage((VImageField)target, file)) : false;
        }
        return bl;
    }

    private final boolean handleImage(VImageField target, File file) {
        boolean bl;
        if (this.isChartBlockContext$galite_core()) {
            int rec = DBlockDropHandler.Companion.getFirstUnfilledRecord(this.block, target);
            this.block.setActiveRecord(rec);
            this.block.setCurrentRecord(rec);
            target.setImage(rec, DBlockDropHandler.Companion.toByteArray(file));
            target.onAfterDrop();
            this.block.setActiveRecord(rec + 1);
            this.block.setCurrentRecord(rec + 1);
            this.block.gotoRecord(this.block.getActiveRecord());
            bl = true;
        } else {
            target.setImage(DBlockDropHandler.Companion.toByteArray(file));
            target.onAfterDrop();
            bl = true;
        }
        return bl;
    }

    public final boolean isChartBlockContext$galite_core() {
        return this.block.noDetail() || this.block.isMulti() && !this.block.isDetailMode();
    }

    static {
        MIMETYPES_FILE_TYPEMAP.addMimeTypes("image/png png");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0004J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0004J\u0012\u0010\b\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ&\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u0017"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler$StreamHandler;", "", "(Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler;)V", "createTempFile", "Ljava/io/File;", "defaultName", "", "getBaseFileName", "getExtension", "onProgress", "", "bytesReceived", "", "contentLength", "streamingFailed", "fileName", "mimeType", "exception", "Ljava/lang/Exception;", "streamingFinished", "bas", "Ljava/io/ByteArrayOutputStream;", "streamingStarted", "galite-core"})
    public final class StreamHandler {
        public StreamHandler() {
            Intrinsics.checkNotNullParameter((Object)DBlockDropHandler.this, (String)"this$0");
        }

        public final void onProgress(long bytesReceived, long contentLength) {
            if (contentLength > 0x3200000L) {
                DBlockDropHandler.this.block.getForm().setCurrentJob((int)bytesReceived);
            }
        }

        public final void streamingStarted(long contentLength) {
            if (contentLength > 0x3200000L) {
                DBlockDropHandler.this.block.getForm().setProgressDialog("", (int)contentLength);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void streamingFinished(@NotNull String fileName, @NotNull String mimeType, long contentLength, @NotNull ByteArrayOutputStream bas) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)bas, (String)"bas");
            try {
                FileOutputStream out = null;
                File temp = this.createTempFile(fileName);
                out = new FileOutputStream(temp);
                bas.writeTo(out);
                DBlockDropHandler.this.acceptDrop(temp);
            }
            catch (IOException e) {
                DBlockDropHandler.this.acceptDrop(null);
            }
            finally {
                if (contentLength > 0x3200000L) {
                    DBlockDropHandler.this.block.getForm().unsetProgressDialog();
                }
            }
        }

        public final void streamingFailed(@NotNull String fileName, @NotNull String mimeType, long contentLength, @NotNull Exception exception) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            exception.printStackTrace(System.err);
            new Thread(() -> StreamHandler.streamingFailed$lambda-0(DBlockDropHandler.this, exception)).start();
        }

        @NotNull
        protected final File createTempFile(@Nullable String defaultName) {
            String basename = this.getBaseFileName(defaultName);
            String extension = this.getExtension(defaultName);
            File file = File.createTempFile(basename, "." + extension, null);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(basename, \".$extension\", null)");
            return file;
        }

        @NotNull
        protected final String getExtension(@Nullable String defaultName) {
            int index;
            if (defaultName != null && (index = StringsKt.lastIndexOf$default((CharSequence)defaultName, (char)'.', (int)0, (boolean)false, (int)6, null)) != -1) {
                String string = defaultName.substring(Math.min(defaultName.length(), index + 1));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                return string;
            }
            return "";
        }

        @NotNull
        protected final String getBaseFileName(@Nullable String defaultName) {
            int index;
            if (defaultName != null && (index = StringsKt.lastIndexOf$default((CharSequence)defaultName, (char)'.', (int)0, (boolean)false, (int)6, null)) != -1) {
                String string = defaultName.substring(0, Math.min(defaultName.length(), index));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return string;
            }
            return "";
        }

        private static final void streamingFailed$lambda-0(DBlockDropHandler this$0, Exception $exception) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$exception, (String)"$exception");
            this$0.block.getForm().error($exception.getMessage());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler$Companion;", "", "()V", "MAX_SIZE_TO_WAIT", "", "MIMETYPES_FILE_TYPEMAP", "Ljavax/activation/MimetypesFileTypeMap;", "copy", "", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "bufferSize", "getExtension", "", "file", "Ljava/io/File;", "getFirstUnfilledRecord", "block", "Lorg/kopi/galite/visual/form/VBlock;", "target", "Lorg/kopi/galite/visual/form/VField;", "isImage", "", "toByteArray", "", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getExtension(File file) {
            String extension = null;
            String name = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            int index = StringsKt.lastIndexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (index > 0 && index < name.length() - 1) {
                String string = name.substring(index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                extension = string2;
            }
            return extension;
        }

        private final boolean isImage(File file) {
            String mimeType = MIMETYPES_FILE_TYPEMAP.getContentType(file);
            Intrinsics.checkNotNullExpressionValue((Object)mimeType, (String)"mimeType");
            String[] stringArray = new String[]{"/"};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)mimeType, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return Intrinsics.areEqual((Object)stringArray2[0], (Object)"image");
        }

        private final byte[] toByteArray(File file) {
            byte[] byArray;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.copy(new FileInputStream(file), baos, 1024);
                byArray = baos.toByteArray();
            }
            catch (IOException e) {
                byArray = null;
            }
            return byArray;
        }

        private final void copy(InputStream input, OutputStream output, int bufferSize) {
            byte[] buf = new byte[bufferSize];
            int bytesRead = input.read(buf);
            while (bytesRead != -1) {
                output.write(buf, 0, bytesRead);
                bytesRead = input.read(buf);
            }
            output.flush();
        }

        private final int getFirstUnfilledRecord(VBlock block2, VField target) {
            int n = 0;
            int n2 = block2.getBufferSize();
            while (n < n2) {
                int i;
                if (!target.isNull(i = n++)) continue;
                return i;
            }
            return 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

