/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.form;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.block.Block;
import org.kopi.galite.visual.ui.vaadin.common.VCaption;
import org.kopi.galite.visual.ui.vaadin.common.VTable;
import org.kopi.galite.visual.ui.vaadin.event.PositionPanelListener;
import org.kopi.galite.visual.ui.vaadin.form.DBlock;
import org.kopi.galite.visual.ui.vaadin.form.FormListener;
import org.kopi.galite.visual.ui.vaadin.form.Page;
import org.kopi.galite.visual.ui.vaadin.form.PositionPanel;

@CssImport(value="./styles/galite/form.css")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ&\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,J\u000e\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0015J\u000e\u00100\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0007H\u0004J\u0010\u00104\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u0007H\u0002J\u0006\u00105\u001a\u00020,J\b\u00106\u001a\u00020'H\u0002J\b\u00107\u001a\u00020'H\u0002J\b\u00108\u001a\u00020'H\u0002J\u0010\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020\u0004H\u0002J\b\u0010;\u001a\u00020'H\u0002J\u0010\u0010<\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0004H\u0002J\b\u0010=\u001a\u00020'H\u0016J\b\u0010>\u001a\u00020'H\u0016J\b\u0010?\u001a\u00020'H\u0016J\u000e\u0010@\u001a\u00020'2\u0006\u0010A\u001a\u00020\u0004J\u0010\u0010B\u001a\u00020'2\u0006\u0010:\u001a\u00020\u0004H\u0016J\b\u0010C\u001a\u00020'H\u0016J\b\u0010D\u001a\u00020'H\u0004J\u001c\u0010D\u001a\u00020'2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u000e\u0010E\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0015J\u000e\u0010F\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0002J\u0010\u0010G\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0004H\u0002J\u001d\u0010H\u001a\u00020'2\u0006\u0010(\u001a\u00020I2\u0006\u0010*\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bJJ!\u0010K\u001a\u00020'2\u0012\u0010L\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u0018\"\u00020 H\u0002\u00a2\u0006\u0002\u0010MJ-\u0010K\u001a\u00020'2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\b\u0010N\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010OJ\u001e\u0010K\u001a\u00020'2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0016\u0010\u000f\u001a\u00020'2\u0006\u0010P\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020\u0004J\u0016\u0010R\u001a\u00020'2\u0006\u0010S\u001a\u00020,2\u0006\u0010*\u001a\u00020\u0004J\u0016\u0010T\u001a\u00020'2\u0006\u0010P\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020\u0004J\u0006\u0010U\u001a\u00020'R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u001c\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00190\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u000e\"\u0004\b%\u0010\u0010\u00a8\u0006V"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/Form;", "Lcom/vaadin/flow/component/html/Div;", "Lorg/kopi/galite/visual/ui/vaadin/event/PositionPanelListener;", "pageCount", "", "titles", "", "", "(ILjava/util/List;)V", "blockInfo", "Lorg/kopi/galite/visual/ui/vaadin/form/PositionPanel;", "currentPage", "currentPosition", "getCurrentPosition", "()I", "setCurrentPosition", "(I)V", "lastSelected", "Lcom/vaadin/flow/component/tabs/Tab;", "listeners", "", "Lorg/kopi/galite/visual/ui/vaadin/form/FormListener;", "getPageCount", "pages", "", "Lorg/kopi/galite/visual/ui/vaadin/form/Page;", "[Lorg/kopi/galite/visual/ui/vaadin/form/Page;", "tabPanel", "Lcom/vaadin/flow/component/tabs/Tabs;", "tabs", "tabsToPages", "", "Lcom/vaadin/flow/component/Component;", "getTitles", "()Ljava/util/List;", "totalPositions", "getTotalPositions", "setTotalPositions", "addBlock", "", "block", "Lorg/kopi/galite/visual/ui/vaadin/block/Block;", "page", "isFollow", "", "isChart", "addFormListener", "l", "addPositionPanelListener", "createCaption", "Lorg/kopi/galite/visual/ui/vaadin/common/VCaption;", "title", "createTabLabel", "delegateCaptionHandling", "fireGotoFirstPosition", "fireGotoLastPosition", "fireGotoNextPosition", "fireGotoPosition", "posno", "fireGotoPrevPosition", "firePageSelected", "gotoFirstPosition", "gotoLastPosition", "gotoNextPosition", "gotoPage", "i", "gotoPosition", "gotoPrevPosition", "init", "removeFormListener", "removePositionPanelListener", "selectPage", "setBorder", "Lorg/kopi/galite/visual/ui/vaadin/form/DBlock;", "setBorder$galite_core", "setContent", "components", "([Lcom/vaadin/flow/component/Component;)V", "separator", "(I[Ljava/lang/String;Ljava/lang/String;)V", "current", "total", "setEnabled", "enabled", "setPosition", "showBlockInfo", "galite-core"})
public final class Form
extends Div
implements PositionPanelListener {
    private final int pageCount;
    @NotNull
    private final List<String> titles;
    private int currentPosition;
    private int totalPositions;
    private int currentPage;
    @NotNull
    private Page<?>[] pages;
    @NotNull
    private final Map<Tab, Component> tabsToPages;
    @NotNull
    private final List<Tab> tabs;
    @Nullable
    private Tabs tabPanel;
    @NotNull
    private List<FormListener> listeners;
    @Nullable
    private Tab lastSelected;
    @NotNull
    private PositionPanel blockInfo;

    public Form(int pageCount, @NotNull List<String> titles) {
        Intrinsics.checkNotNullParameter(titles, (String)"titles");
        this.pageCount = pageCount;
        this.titles = titles;
        this.currentPage = -1;
        this.pages = new Page[this.pageCount == 0 ? 1 : this.pageCount];
        this.tabsToPages = new LinkedHashMap();
        this.tabs = new ArrayList();
        this.listeners = new ArrayList();
        this.blockInfo = new PositionPanel();
        this.setClassName("k-form");
        this.init(this.pageCount, this.titles);
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    @NotNull
    public final List<String> getTitles() {
        return this.titles;
    }

    public final int getCurrentPosition() {
        return this.currentPosition;
    }

    public final void setCurrentPosition(int n) {
        this.currentPosition = n;
    }

    public final int getTotalPositions() {
        return this.totalPositions;
    }

    public final void setTotalPositions(int n) {
        this.totalPositions = n;
    }

    private final void setContent(int pageCount, List<String> titles) {
        if (pageCount == 0) {
            Component[] componentArray = new Component[1];
            Page<?> page = this.pages[0];
            Intrinsics.checkNotNull(page);
            componentArray[0] = (Component)page;
            this.setContent(componentArray);
        } else {
            Tabs tabs = this.tabPanel = new Tabs();
            Intrinsics.checkNotNull((Object)tabs);
            tabs.setClassName("k-form-tab");
            int n = 0;
            int n2 = this.pages.length;
            while (n < n2) {
                Page<?> page;
                int i = n++;
                Tab tab = this.createTabLabel(titles.get(i));
                this.tabs.add(tab);
                Tab[] tabArray = this.tabsToPages;
                Intrinsics.checkNotNull(this.pages[i]);
                tabArray.put((Tab)tab, page);
                Tabs tabs2 = this.tabPanel;
                Intrinsics.checkNotNull((Object)tabs2);
                tabArray = new Tab[]{tab};
                tabs2.add(tabArray);
                tab.setEnabled(false);
                tab.addClassName("tab");
            }
            Tabs tabs3 = this.tabPanel;
            Intrinsics.checkNotNull((Object)tabs3);
            tabs3.addSelectedChangeListener(new ComponentEventListener(this){
                final /* synthetic */ Form this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void onComponentEvent(Tabs.SelectedChangeEvent it) {
                    if (it.isFromClient()) {
                        Form.access$setLastSelected$p(this.this$0, it.getPreviousTab());
                        Tabs tabs = Form.access$getTabPanel$p(this.this$0);
                        Intrinsics.checkNotNull((Object)tabs);
                        tabs.setSelectedTab(Form.access$getLastSelected$p(this.this$0));
                        Form.access$firePageSelected(this.this$0, ArraysKt.indexOf((Object[])Form.access$getPages$p(this.this$0), Form.access$getTabsToPages$p(this.this$0).get(it.getSelectedTab())));
                    }
                }
            });
            Component[] componentArray = new Component[2];
            Tabs tabs4 = this.tabPanel;
            Intrinsics.checkNotNull((Object)tabs4);
            componentArray[0] = (Component)tabs4;
            Page<?>[] pageArray = this.pages;
            componentArray[1] = (Component)new Div((Component[])Arrays.copyOf(pageArray, pageArray.length));
            this.setContent(componentArray);
        }
    }

    private final void setContent(Component ... components) {
        this.removeAll();
        VTable table = new VTable(0, 0);
        Component[] $this$forEach$iv = components;
        boolean $i$f$forEach = false;
        for (Component element$iv : $this$forEach$iv) {
            Component it = element$iv;
            boolean bl = false;
            table.addInNewRow(it);
        }
        Component[] componentArray = new Component[]{table};
        this.add(componentArray);
    }

    private final void selectPage(int page) {
        if (this.tabPanel != null) {
            this.tabs.get(page).setEnabled(true);
            Tabs tabs = this.tabPanel;
            Intrinsics.checkNotNull((Object)tabs);
            tabs.setSelectedIndex(page);
            Tabs tabs2 = this.tabPanel;
            Intrinsics.checkNotNull((Object)tabs2);
            this.lastSelected = tabs2.getSelectedTab();
        }
    }

    private final Tab createTabLabel(String title) {
        String string;
        if (StringsKt.endsWith$default((String)title, (String)"<CENTER>", (boolean)false, (int)2, null)) {
            String string2 = title.substring(0, title.length() - 8);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = string2;
        } else {
            string = title;
        }
        return new Tab(string);
    }

    public final void addBlock(@NotNull Block block2, int page, boolean isFollow, boolean isChart) {
        FlexComponent.JustifyContentMode hAlign;
        Intrinsics.checkNotNullParameter((Object)((Object)block2), (String)"block");
        FlexComponent.JustifyContentMode justifyContentMode = hAlign = isChart ? FlexComponent.JustifyContentMode.CENTER : FlexComponent.JustifyContentMode.START;
        if (isFollow) {
            Page<?> page2 = this.pages[page];
            Intrinsics.checkNotNull(page2);
            page2.addFollow(block2, hAlign);
        } else {
            Page<?> page3 = this.pages[page];
            Intrinsics.checkNotNull(page3);
            page3.add(block2, hAlign);
        }
        block2.layout();
        block2.layoutAlignedComponents();
    }

    public final void setBorder$galite_core(@NotNull DBlock block2, int page) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        block2.setBorder$galite_core(block2.getModel().getBorder(), block2.getModel().getTitle(), this.pages[page]);
    }

    public final void gotoPage(int i) {
        this.currentPage = i;
        Tab tab = this.lastSelected;
        if (tab != null) {
            Tab it = tab;
            boolean bl = false;
            Component component = this.tabsToPages.get(it);
            Intrinsics.checkNotNull((Object)component);
            component.setVisible(false);
            it.setSelected(false);
        }
        Tab tab2 = this.lastSelected;
        if (tab2 != null) {
            tab2.removeClassName("selected-tab");
        }
        Page<?> page = this.pages[i];
        Intrinsics.checkNotNull(page);
        page.setVisible(true);
        this.selectPage(i);
        if (this.tabPanel != null) {
            Tabs tabs = this.tabPanel;
            Intrinsics.checkNotNull((Object)tabs);
            tabs.getComponentAt(this.currentPage).getElement().getClassList().add((Object)"selected-tab");
        }
    }

    public final void setPosition(int current, int total) {
        this.currentPosition = current;
        this.totalPositions = total;
        this.blockInfo.setPosition(current, total);
    }

    public final void init(int pageCount, @NotNull List<String> titles) {
        Intrinsics.checkNotNullParameter(titles, (String)"titles");
        this.pages = new Page[pageCount == 0 ? 1 : pageCount];
        int n = 0;
        int n2 = this.pages.length;
        while (n < n2) {
            int i = n++;
            this.pages[i] = pageCount != 0 ? (StringsKt.endsWith$default((String)titles.get(i), (String)"<CENTER>", (boolean)false, (int)2, null) ? new Page<Component>((Component)new HorizontalLayout()) : new Page<Component>((Component)new VerticalLayout())) : new Page<Component>((Component)new VerticalLayout());
            Page<?> page = this.pages[i];
            Intrinsics.checkNotNull(page);
            page.setVisible(false);
            if (pageCount == 0) {
                Page<?> page2 = this.pages[i];
                Intrinsics.checkNotNull(page2);
                page2.getStyle().set("max-height", "calc(100vh - 210px)");
                continue;
            }
            Page<?> page3 = this.pages[i];
            Intrinsics.checkNotNull(page3);
            page3.getStyle().set("max-height", "calc(100vh - 260px)");
        }
        this.setContent(pageCount, titles);
    }

    public final void showBlockInfo() {
        this.blockInfo.setVisible(false);
        this.blockInfo.show();
    }

    private final void setContent(int pageCount, String[] titles, String separator) {
    }

    @NotNull
    protected final VCaption createCaption(@NotNull String title) {
        String string;
        VCaption vCaption;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        VCaption caption = vCaption = new VCaption(true);
        boolean bl = false;
        if (StringsKt.endsWith$default((String)title, (String)"<CENTER>", (boolean)false, (int)2, null)) {
            String string2 = title.substring(0, title.length() - 8);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = string2;
        } else {
            string = title;
        }
        caption.setCaption(string);
        return vCaption;
    }

    public final void setEnabled(boolean enabled, int page) {
        Tab tab = (Tab)CollectionsKt.getOrNull(this.tabs, (int)page);
        if (tab != null) {
            tab.setEnabled(enabled);
        }
    }

    public final void addFormListener(@NotNull FormListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    public final void removeFormListener(@NotNull FormListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.remove(l);
    }

    public final void addPositionPanelListener(@NotNull PositionPanelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        if (this.blockInfo != null) {
            this.blockInfo.addPositionPanelListener(l);
        }
    }

    public final void removePositionPanelListener(@NotNull PositionPanelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.blockInfo.removePositionPanelListener(l);
    }

    private final void firePageSelected(int page) {
        for (FormListener l : this.listeners) {
            l.onPageSelection(page);
        }
    }

    private final void fireGotoNextPosition() {
        for (FormListener l : this.listeners) {
            l.gotoNextPosition();
        }
    }

    private final void fireGotoPrevPosition() {
        for (FormListener l : this.listeners) {
            l.gotoPrevPosition();
        }
    }

    private final void fireGotoLastPosition() {
        for (FormListener l : this.listeners) {
            l.gotoLastPosition();
        }
    }

    private final void fireGotoFirstPosition() {
        for (FormListener l : this.listeners) {
            l.gotoFirstPosition();
        }
    }

    private final void fireGotoPosition(int posno) {
        for (FormListener l : this.listeners) {
            l.gotoPosition(posno);
        }
    }

    protected final void init() {
        this.addPositionPanelListener(this);
    }

    public final boolean delegateCaptionHandling() {
        return false;
    }

    @Override
    public void gotoNextPosition() {
        this.fireGotoNextPosition();
    }

    @Override
    public void gotoPrevPosition() {
        this.fireGotoPrevPosition();
    }

    @Override
    public void gotoLastPosition() {
        this.fireGotoLastPosition();
    }

    @Override
    public void gotoFirstPosition() {
        this.fireGotoFirstPosition();
    }

    @Override
    public void gotoPosition(int posno) {
        this.fireGotoPosition(posno);
    }

    public final void setCurrentPosition(int current, int total) {
        this.setPosition(current, total);
    }

    public static final /* synthetic */ void access$setLastSelected$p(Form $this, Tab tab) {
        $this.lastSelected = tab;
    }

    public static final /* synthetic */ Tabs access$getTabPanel$p(Form $this) {
        return $this.tabPanel;
    }

    public static final /* synthetic */ Tab access$getLastSelected$p(Form $this) {
        return $this.lastSelected;
    }

    public static final /* synthetic */ void access$firePageSelected(Form $this, int page) {
        $this.firePageSelected(page);
    }

    public static final /* synthetic */ Page[] access$getPages$p(Form $this) {
        return $this.pages;
    }

    public static final /* synthetic */ Map access$getTabsToPages$p(Form $this) {
        return $this.tabsToPages;
    }
}

