/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.InvocationEvent;
import javax.swing.JScrollBar;
import org.kopi.galite.visual.Action;
import org.kopi.galite.visual.VException;
import org.kopi.galite.visual.form.LayoutManager;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.vkopi.lib.ui.swing.form.DBlock;
import org.kopi.vkopi.lib.ui.swing.form.DForm;
import org.kopi.vkopi.lib.ui.swing.form.KopiMultiBlockLayout;
import org.kopi.vkopi.lib.ui.swing.visual.SwingThreadHandler;

public class DChartBlock
extends DBlock {
    private AdjustmentListener adjustmentListener;
    private JScrollBar scrollBar;
    private static final long serialVersionUID = -7342909071556158313L;

    public DChartBlock(DForm form, VBlock model2) {
        super(form, model2);
        if (this.getModel().getDisplaySize() < this.getModel().getBufferSize()) {
            this.scrollBar = this.createScrollBar();
            this.scrollBar.setFocusable(false);
            this.addScrollBar(this.scrollBar);
        }
    }

    protected void addScrollBar(JScrollBar bar) {
        this.add(bar);
    }

    protected JScrollBar createScrollBar() {
        JScrollBar scrollBar = new JScrollBar(1, 0, this.getModel().getDisplaySize(), 0, this.getModel().getBufferSize() - 1);
        this.adjustmentListener = new AdjustmentListener(){
            private boolean init;

            @Override
            public void adjustmentValueChanged(final AdjustmentEvent e) {
                if (((DForm)DChartBlock.this.getFormView()).getInAction()) {
                    return;
                }
                DChartBlock.this.getFormView().performAsyncAction(new Action("chart"){

                    @Override
                    public void execute() throws VException {
                        if (!init) {
                            init = true;
                        } else {
                            try {
                                DChartBlock.this.setScrollPos(e.getValue());
                            }
                            catch (VException e2) {
                                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new RNCEvent());
                                throw e2;
                            }
                        }
                    }
                });
            }
        };
        return scrollBar;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new KopiMultiBlockLayout(this.displayedFields, this.getModel().getDisplaySize() + 1);
    }

    @Override
    public void validRecordNumberChanged() {
        if (this.getModel().getDisplaySize() < this.getModel().getBufferSize()) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new RNCEvent());
        }
    }

    @Override
    protected void refresh(boolean force) {
        SwingThreadHandler.verifyRunsInEventThread("DBlock refresh");
        super.refresh(force);
        if (this.scrollBar != null) {
            this.updateScrollbar();
        }
    }

    private void updateScrollbar() {
        SwingThreadHandler.verifyRunsInEventThread("DChartBlock updateScrollbar");
        int validRecords = this.getModel().getNumberOfValidRecord();
        int dispSize = this.getModel().getDisplaySize();
        if (validRecords > dispSize) {
            this.scrollBar.removeAdjustmentListener(this.adjustmentListener);
            this.scrollBar.setValues(this.getModel().getNumberOfValidRecordBefore(this.getRecordFromDisplayLine(0)), dispSize, 0, validRecords);
            this.scrollBar.addAdjustmentListener(this.adjustmentListener);
            this.scrollBar.setEnabled(true);
        } else {
            this.scrollBar.setEnabled(false);
        }
    }

    @Override
    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        int id = existingEvent.getID();
        switch (id) {
            case 2100: {
                return existingEvent;
            }
        }
        return super.coalesceEvents(existingEvent, newEvent);
    }

    class RNCEvent
    extends InvocationEvent
    implements Runnable {
        static final int EVT_RNC = 2100;
        private static final long serialVersionUID = 1727735012273500143L;

        RNCEvent() {
            super(DChartBlock.this, 2100, null, null, false);
            this.runnable = this;
        }

        @Override
        public void run() {
            DChartBlock.this.updateScrollbar();
        }
    }
}

