/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.spellchecker;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Suggestions {
    private int offset;
    private String type;
    private List<String> suggestions;
    private String originalWord;
    public static final String RLT_ERROR = new String("Error");
    public static final String RLT_OK = new String("OK ");
    public static final String RLT_NONE = new String("None");
    public static final String RLT_SUGGESTION = new String("Suggestion");

    public Suggestions(String line) {
        if (line == null || line.length() <= 0) {
            this.processError(line);
        } else if (line.charAt(0) == '*') {
            this.processOk(line);
        } else if (line.charAt(0) == '&') {
            this.processSuggestion(line);
        } else if (line.charAt(0) == '#') {
            this.processNone(line);
        } else {
            this.processError(line);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getSuggestions() {
        return this.suggestions;
    }

    public String getOriginalWord() {
        return this.originalWord;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[type:");
        buff.append(this.type);
        buff.append(",originalWord:");
        buff.append(this.originalWord);
        buff.append(",offset:");
        buff.append(this.offset);
        buff.append(",suggestions:");
        buff.append(this.suggestions);
        return buff.toString();
    }

    private void processError(String line) {
        this.offset = 0;
        this.type = RLT_ERROR;
        this.suggestions = new ArrayList<String>();
        this.originalWord = "";
    }

    private void processOk(String line) {
        this.offset = 0;
        this.type = RLT_OK;
        this.suggestions = new ArrayList<String>();
        this.originalWord = "";
    }

    private void processNone(String line) {
        StringTokenizer st = new StringTokenizer(line);
        this.type = RLT_NONE;
        this.suggestions = new ArrayList<String>();
        st.nextToken();
        this.originalWord = st.nextToken();
        this.offset = Integer.parseInt(st.nextToken());
    }

    private void processSuggestion(String line) {
        StringTokenizer st = new StringTokenizer(line);
        this.type = RLT_SUGGESTION;
        st.nextToken();
        this.originalWord = st.nextToken();
        int count = Integer.parseInt(st.nextToken().trim());
        this.suggestions = new ArrayList<String>(count);
        this.offset = Integer.parseInt(st.nextToken(":").trim());
        st = new StringTokenizer(st.nextToken(":"), ",");
        while (st.hasMoreTokens()) {
            this.suggestions.add(st.nextToken().trim());
        }
    }
}

