/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.kopi.galite.visual.ApplicationContext;
import org.kopi.galite.visual.VException;
import org.kopi.galite.visual.VRuntimeException;
import org.kopi.vkopi.lib.ui.swing.visual.DWindow;

public class SwingThreadHandler {
    private static final int INTERVAL = 80;
    private static final QueueHandler queueHandler = new QueueHandler();
    private static final Timer swingTimer = new Timer(80, queueHandler);
    private static final ArrayList<Runnable> queue = new ArrayList(2000);
    private static final SwingThreadHandler runner;

    private SwingThreadHandler() {
    }

    private void invoke(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                runnable.run();
            }
            catch (Throwable failure) {
                SwingThreadHandler.sendDebugMail("invoke in awt-thread ", runnable.toString(), failure);
            }
        } else {
            this.addDebugableEventToQueue(runnable);
        }
    }

    private void invokeAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ite) {
                Throwable throwable = ite.getTargetException();
                if (throwable instanceof VRuntimeException) {
                    throw (VRuntimeException)throwable;
                }
                if (throwable instanceof VException) {
                    throw new VRuntimeException(throwable.getMessage(), throwable);
                }
                if (throwable != null) {
                    throw new RuntimeException(throwable.getMessage(), throwable);
                }
                throw new RuntimeException(ite);
            }
        }
    }

    public static void start(Runnable runnable) {
        runner.invoke(runnable);
    }

    public static void startAndWait(Runnable runnable) {
        runner.invokeAndWait(runnable);
    }

    public static void start(final DWindow model2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    model2.run();
                }
                catch (Exception e) {
                    throw new VRuntimeException(e.getMessage(), e);
                }
            }
        };
        runner.invoke(runnable);
    }

    public static void startAndWait(final DWindow model2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    model2.run();
                }
                catch (Exception e) {
                    throw new VRuntimeException(e.getMessage(), e);
                }
            }
        };
        runner.invokeAndWait(runnable);
    }

    public static void verifyRunsInEventThread(String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            System.out.println("Must be called in event disp, Thread. " + message);
            Thread.dumpStack();
            if (!ApplicationContext.Companion.getDefaults().isDebugModeEnabled()) {
                try {
                    ApplicationContext.Companion.reportTrouble("SwingThreadHandler " + Thread.currentThread(), "verifyRunsInEventThread", "message", new RuntimeException(message));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startEnqueued(Runnable runner) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                runner.run();
            }
            catch (Throwable failure) {
                SwingThreadHandler.sendDebugMail("invoke in awt-thread ", runner.toString(), failure);
            }
        } else {
            ArrayList<Runnable> arrayList = queue;
            synchronized (arrayList) {
                queue.add(runner);
            }
        }
    }

    private static final void sendDebugMail(final String where, final String data, final Throwable failure) {
        if (!ApplicationContext.Companion.getDefaults().isDebugModeEnabled()) {
            Runnable localRunner = new Runnable(){

                @Override
                public void run() {
                    ApplicationContext.Companion.reportTrouble("Event Handling Queue", where, data, failure);
                }
            };
            new Thread(localRunner).start();
        } else {
            failure.printStackTrace();
        }
    }

    private void addDebugableEventToQueue(Runnable runnable) {
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        eq.postEvent(new DebugableEvent(Toolkit.getDefaultToolkit(), runnable));
    }

    static {
        swingTimer.setInitialDelay(0);
        swingTimer.setCoalesce(true);
        swingTimer.start();
        runner = new SwingThreadHandler();
    }

    class DebugableEvent
    extends InvocationEvent {
        private static final long serialVersionUID = -8836047819796761837L;

        DebugableEvent(Object source, Runnable runnable) {
            super(source, runnable);
        }

        @Override
        public void dispatch() {
            try {
                super.dispatch();
            }
            catch (Throwable failure) {
                SwingThreadHandler.sendDebugMail("invoke in awt-thread ", this.runnable.toString(), failure);
            }
        }
    }

    private static class QueueHandler
    implements ActionListener {
        private QueueHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Runnable> arrayList = queue;
            synchronized (arrayList) {
                int size = queue.size();
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        Runnable runner = queue.get(i);
                        try {
                            runner.run();
                            continue;
                        }
                        catch (Throwable failure) {
                            SwingThreadHandler.sendDebugMail("enqued jobs", runner.toString(), failure);
                        }
                    }
                    queue.clear();
                }
            }
        }
    }
}

