/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.util.mailer.Mailer;
import org.kopi.galite.visual.ApplicationConfiguration;
import org.kopi.galite.visual.PropertyException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lorg/kopi/galite/visual/VerifyConfiguration;", "", "()V", "verifyConfiguration", "", "smtpServer", "", "failureRecipient", "applicationName", "Companion", "galite-core"})
public final class VerifyConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VerifyConfiguration verifyConfiguration = new VerifyConfiguration();
    @NotNull
    private static final String STR_BASIC = "   ........................................................................";
    @NotNull
    private static final String STR_OK = " [OK]";
    @NotNull
    private static final String STR_FAILED = " [FAILED]";

    private VerifyConfiguration() {
    }

    public final void verifyConfiguration(@Nullable String smtpServer, @NotNull String failureRecipient, @NotNull String applicationName) {
        boolean bl;
        String string;
        Intrinsics.checkNotNullParameter((Object)failureRecipient, (String)"failureRecipient");
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        boolean configurationError = false;
        String hostname = null;
        try {
            ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.Companion.getConfiguration();
            Intrinsics.checkNotNull((Object)applicationConfiguration);
            String string2 = applicationConfiguration.getStringFor("debugging.mail.sender");
            if (string2 == null) {
                throw new PropertyException();
            }
            string = string2;
        }
        catch (PropertyException e) {
            throw new Exception("Couldn't find the debugging mail sender while sending an error report mail", e);
        }
        String failureSender = string;
        try {
            InetAddress inetAdress = InetAddress.getLocalHost();
            String string3 = inetAdress.getCanonicalHostName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"inetAdress.canonicalHostName");
            hostname = string3;
            writer.println(VerifyConfiguration.Companion.formatMessage("Getting hostname ", false));
        }
        catch (UnknownHostException e) {
            hostname = "unknown";
            writer.println(VerifyConfiguration.Companion.formatMessage("Getting hostname ", true));
            e.printStackTrace(writer);
            writer.println();
            configurationError = true;
        }
        boolean isAssertOn = false;
        boolean it = bl = true;
        boolean bl2 = false;
        isAssertOn = it;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        writer.println(VerifyConfiguration.Companion.formatMessage("java called with option -ea", !isAssertOn));
        boolean bl3 = configurationError = configurationError || !isAssertOn;
        if (configurationError) {
            Mailer.Companion.sendMail(smtpServer, failureRecipient, null, null, "[KOPI CONFIGURATION] " + applicationName + " " + System.getProperty("user.name", "") + "@" + hostname, buffer.toString(), failureSender);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/kopi/galite/visual/VerifyConfiguration$Companion;", "", "()V", "STR_BASIC", "", "STR_FAILED", "STR_OK", "verifyConfiguration", "Lorg/kopi/galite/visual/VerifyConfiguration;", "getVerifyConfiguration", "()Lorg/kopi/galite/visual/VerifyConfiguration;", "formatMessage", "message", "fail", "", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        private final String formatMessage(String message, boolean fail) {
            Object object;
            String string;
            if (message.length() >= 70) {
                string = message.substring(0, 70);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                object = string;
            } else {
                string = VerifyConfiguration.STR_BASIC.substring(0, 70 - message.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                object = message + string;
            }
            String result = object;
            return fail ? result + VerifyConfiguration.STR_FAILED : result + VerifyConfiguration.STR_OK;
        }

        @NotNull
        public final VerifyConfiguration getVerifyConfiguration() {
            return verifyConfiguration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

