/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.form;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ResultRow;
import org.kopi.galite.type.DefaultFormatKt;
import org.kopi.galite.visual.Message;
import org.kopi.galite.visual.MessageCode;
import org.kopi.galite.visual.VException;
import org.kopi.galite.visual.VlibProperties;
import org.kopi.galite.visual.form.PredefinedValueHandler;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VDateField;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VFieldException;
import org.kopi.galite.visual.form.VTimeField;
import org.kopi.galite.visual.list.VListColumn;
import org.kopi.galite.visual.list.VTimestampColumn;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0012\u0010\u001c\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\rJ\f\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\r\u0010!\u001a\u00020\"H\u0010\u00a2\u0006\u0002\b#J\u0012\u0010$\u001a\u0004\u0018\u00010\u00162\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020\u0003H\u0016J\b\u0010)\u001a\u00020\u0012H\u0016J\b\u0010*\u001a\u00020\u0012H\u0016J\b\u0010+\u001a\u00020\u0010H\u0016J\b\u0010,\u001a\u00020\u0010H\u0016J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0003H\u0016J\b\u0010.\u001a\u00020\u0010H\u0016J\u0010\u0010/\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0015\u00101\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b2J\u001e\u00103\u001a\u0004\u0018\u00010\u00162\u0006\u00104\u001a\u0002052\n\u00106\u001a\u0006\u0012\u0002\b\u000307H\u0016J\u0010\u00108\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0003H\u0016J\u001a\u00109\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00032\b\u0010:\u001a\u0004\u0018\u00010\u0016H\u0016J\u001a\u0010;\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00032\b\u0010:\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010<\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010=\u001a\u00020\u00122\b\u0010>\u001a\u0004\u0018\u00010\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006?"}, d2={"Lorg/kopi/galite/visual/form/VTimestampField;", "Lorg/kopi/galite/visual/form/VField;", "bufferSize", "", "kClass", "Lkotlin/reflect/KClass;", "(ILkotlin/reflect/KClass;)V", "getBufferSize", "()I", "getKClass", "()Lkotlin/reflect/KClass;", "value", "", "Ljava/time/temporal/Temporal;", "[Ljava/time/temporal/Temporal;", "checkText", "", "s", "", "checkType", "", "rec", "", "copyRecord", "f", "t", "enumerateValue", "desc", "fillField", "handler", "Lorg/kopi/galite/visual/form/PredefinedValueHandler;", "getCurrentTimestamp", "getDataType", "getListColumn", "Lorg/kopi/galite/visual/list/VListColumn;", "getListColumn$galite_core", "getObjectImpl", "r", "getSqlImpl", "getTextImpl", "getTimestamp", "getTypeInformation", "getTypeName", "hasAutofill", "hasNextPreviousEntry", "isNullImpl", "isNumeric", "parseDate", "parseTime", "parseTimestamp", "parseTimestamp$galite_core", "retrieveQuery", "result", "Lorg/jetbrains/exposed/sql/ResultRow;", "column", "Lorg/jetbrains/exposed/sql/Column;", "setNull", "setObject", "v", "setTimestamp", "toObject", "toText", "o", "galite-core"})
public final class VTimestampField
extends VField {
    private final int bufferSize;
    @Nullable
    private final KClass<?> kClass;
    @NotNull
    private Temporal[] value;

    public VTimestampField(int bufferSize, @Nullable KClass<?> kClass) {
        super(19, 1);
        this.bufferSize = bufferSize;
        this.kClass = kClass;
        this.value = new Temporal[2 * this.bufferSize];
    }

    public /* synthetic */ VTimestampField(int n, KClass kClass, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            kClass = null;
        }
        this(n, kClass);
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    @Nullable
    public final KClass<?> getKClass() {
        return this.kClass;
    }

    @Override
    public boolean hasAutofill() {
        return true;
    }

    @Override
    @NotNull
    public String getTypeInformation() {
        return Message.INSTANCE.getMessage("timestamp-type-field");
    }

    @Override
    @NotNull
    public String getTypeName() {
        return VlibProperties.getString("Timestamp");
    }

    @Override
    public boolean hasNextPreviousEntry() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    @NotNull
    public VListColumn getListColumn$galite_core() {
        return new VTimestampColumn(this.getHeader(), null, null, this.getPriority() >= 0);
    }

    @Override
    public boolean checkText(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return true;
    }

    @Override
    public void checkType(int rec, @Nullable Object s) {
        if (Intrinsics.areEqual((Object)(s instanceof String ? (String)s : null), (Object)"")) {
            this.setNull(rec);
        } else {
            Object object = s;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            Temporal timestamp = this.parseTimestamp$galite_core((String)object);
            this.checkConstraint(timestamp);
            this.setTimestamp(rec, timestamp);
        }
    }

    @NotNull
    public final Temporal parseTimestamp$galite_core(@NotNull String s) {
        Temporal temporal;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        CharSequence charSequence = s;
        Regex regex = new Regex("[ T]");
        int n = 2;
        List timestamp = regex.split(charSequence, n);
        String date = this.parseDate((String)timestamp.get(0));
        String time = this.parseTime((String)timestamp.get(1));
        if (Intrinsics.areEqual(this.kClass, (Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class))) {
            LocalDateTime localDateTime = Timestamp.valueOf(date + " " + time).toLocalDateTime();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"valueOf(\"$date $time\").toLocalDateTime()");
            temporal = localDateTime;
        } else {
            Instant instant = Timestamp.valueOf(date + " " + time).toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"valueOf(\"$date $time\").toInstant()");
            temporal = instant;
        }
        return temporal;
    }

    private final String parseDate(String s) {
        LocalDate now;
        int day = 0;
        int month = 0;
        int year = -2;
        StringTokenizer tokens = new StringTokenizer(s, "/.#-");
        if (!tokens.hasMoreTokens()) {
            throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00003", null, false, 6, null), null, 4, null);
        }
        String string = tokens.nextToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokens.nextToken()");
        year = VDateField.Companion.stringToInt$galite_core(string);
        if (tokens.hasMoreTokens()) {
            string = tokens.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokens.nextToken()");
            month = VDateField.Companion.stringToInt$galite_core(string);
        }
        if (tokens.hasMoreTokens()) {
            string = tokens.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokens.nextToken()");
            day = VDateField.Companion.stringToInt$galite_core(string);
        }
        if (tokens.hasMoreTokens() || day == -1 || month == -1 || year == -1) {
            throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00003", null, false, 6, null), null, 4, null);
        }
        if (month == 0) {
            now = LocalDate.now();
            month = now.getMonthValue();
            year = now.getYear();
        } else if (year == -2) {
            now = LocalDate.now();
            year = now.getYear();
        } else if (year < 50) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        } else if (year < 1000) {
            throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00003", null, false, 6, null), null, 4, null);
        }
        if (!VDateField.Companion.isDate$galite_core(day, month, year)) {
            throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00003", null, false, 6, null), null, 4, null);
        }
        String string2 = "%04d-%02d-%02d";
        Object[] objectArray = new Object[]{year, month, day};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return string3;
    }

    private final String parseTime(String s) {
        String string;
        int hours = -1;
        int minutes = 0;
        int seconds = 0;
        String buffer = s + "\u0000";
        int bp = 0;
        int state = 1;
        while (state > 0) {
            switch (state) {
                case 1: {
                    char c = buffer.charAt(bp);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        hours = buffer.charAt(bp) - 48;
                        state = 2;
                        break;
                    }
                    if (buffer.charAt(bp) == '\u0000') {
                        state = 0;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    char c = buffer.charAt(bp);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        hours = 10 * hours + (buffer.charAt(bp) - 48);
                        state = 3;
                        break;
                    }
                    if (buffer.charAt(bp) == ':') {
                        state = 4;
                        break;
                    }
                    if (buffer.charAt(bp) == '\u0000') {
                        state = 0;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 3: {
                    state = buffer.charAt(bp) == ':' ? 4 : (buffer.charAt(bp) == '\u0000' ? 0 : -1);
                    break;
                }
                case 4: {
                    char c = buffer.charAt(bp);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        minutes = buffer.charAt(bp) - 48;
                        state = 5;
                        break;
                    }
                    if (buffer.charAt(bp) == '\u0000') {
                        state = 0;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 5: {
                    char c = buffer.charAt(bp);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        minutes = 10 * minutes + (buffer.charAt(bp) - 48);
                        state = 6;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 6: {
                    state = buffer.charAt(bp) == ':' ? 7 : (buffer.charAt(bp) == '\u0000' ? 0 : -1);
                    break;
                }
                case 7: {
                    char c = buffer.charAt(bp);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        seconds = buffer.charAt(bp) - 48;
                        state = 8;
                        break;
                    }
                    if (buffer.charAt(bp) == '\u0000') {
                        state = 0;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 8: {
                    char c = buffer.charAt(bp);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        seconds = 10 * seconds + (buffer.charAt(bp) - 48);
                        state = 9;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 9: {
                    state = buffer.charAt(bp) == '\u0000' ? 0 : -1;
                }
            }
            ++bp;
        }
        if (state == -1) {
            throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00007", null, false, 6, null), null, 4, null);
        }
        if (hours == -1) {
            string = null;
        } else {
            if (!VTimeField.Companion.isTime$galite_core(hours, minutes)) {
                throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00007", null, false, 6, null), null, 4, null);
            }
            String string2 = "%02d:%02d:%02d";
            Object[] objectArray = new Object[]{hours, minutes, seconds};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            string = string3;
        }
        return string;
    }

    @Override
    public void setNull(int r) {
        this.setTimestamp(r, null);
    }

    @Override
    public void setTimestamp(int r, @Nullable Temporal v) {
        if (this.isChangedUI() || this.value[r] == null && v != null || this.value[r] != null && !Intrinsics.areEqual((Object)this.value[r], (Object)v)) {
            this.trail(r);
            this.value[r] = v;
            this.setChanged(r);
        }
    }

    @Override
    public void setObject(int r, @Nullable Object v) {
        this.setTimestamp(r, v instanceof Temporal ? (Temporal)v : null);
    }

    @Override
    @Nullable
    public Object retrieveQuery(@NotNull ResultRow result, @NotNull Column<?> column2) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        Object tmp = result.get((Expression)column2);
        return tmp instanceof Timestamp ? ((Timestamp)tmp).toInstant() : ((tmp instanceof LocalDateTime ? true : tmp instanceof Instant) ? tmp : null);
    }

    @Override
    public boolean isNullImpl(int r) {
        return this.value[r] == null;
    }

    @Override
    @Nullable
    public Temporal getTimestamp(int r) {
        Object object;
        Object object2;
        return Intrinsics.areEqual(this.kClass, (Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class)) ? (Temporal)((object2 = this.getObject(r)) instanceof LocalDateTime ? (LocalDateTime)object2 : null) : (Temporal)((object = this.getObject(r)) instanceof Instant ? (Instant)object : null);
    }

    @Override
    @Nullable
    public Object getObjectImpl(int r) {
        return this.value[r];
    }

    @Override
    @NotNull
    public String toText(@Nullable Object o) {
        String string;
        if (o == null) {
            string = "";
        } else {
            Object object = o;
            String text = object instanceof Instant ? DefaultFormatKt.format((Instant)((Instant)o)) : (object instanceof LocalDateTime ? DefaultFormatKt.format((LocalDateTime)((LocalDateTime)o)) : o.toString());
            String string2 = text.substring(0, Math.min(this.getWidth(), text.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = string2;
        }
        return string;
    }

    @Override
    @Nullable
    public Object toObject(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return Intrinsics.areEqual((Object)s, (Object)"") ? (Instant)null : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).parse(s).toInstant();
    }

    @Override
    @NotNull
    public String getTextImpl(int r) {
        String string;
        if (this.value[r] == null) {
            string = "";
        } else {
            String string2;
            if (Intrinsics.areEqual(this.kClass, (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
                Temporal temporal = this.value[r];
                Intrinsics.checkNotNull((Object)temporal);
                string2 = DefaultFormatKt.format((Instant)((Instant)temporal));
            } else {
                Temporal temporal = this.value[r];
                Intrinsics.checkNotNull((Object)temporal);
                string2 = DefaultFormatKt.format((LocalDateTime)((LocalDateTime)temporal));
            }
            String text = string2;
            String string3 = text.substring(0, Math.min(this.getWidth(), text.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = string3;
        }
        return string;
    }

    @Override
    @Nullable
    public Temporal getSqlImpl(int r) {
        return this.value[r];
    }

    @Override
    public void copyRecord(int f, int t) {
        Temporal oldValue = this.value[t];
        this.value[t] = this.value[f];
        VBlock vBlock = this.getBlock();
        Intrinsics.checkNotNull((Object)vBlock);
        if (t < vBlock.getBufferSize() && (oldValue != null && this.value[t] == null || oldValue == null && this.value[t] != null || oldValue != null && !Intrinsics.areEqual((Object)oldValue, (Object)this.value[t]))) {
            this.fireValueChanged(t);
        }
    }

    @NotNull
    public final Temporal getCurrentTimestamp() {
        Temporal temporal;
        if (Intrinsics.areEqual(this.kClass, (Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class))) {
            LocalDateTime localDateTime = LocalDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now()");
            temporal = localDateTime;
        } else {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            temporal = instant;
        }
        return temporal;
    }

    @Override
    @NotNull
    public KClass<?> getDataType() {
        KClass<?> kClass = this.kClass;
        Intrinsics.checkNotNull(kClass);
        return kClass;
    }

    @Override
    public boolean fillField(@Nullable PredefinedValueHandler handler) {
        boolean bl;
        if (this.getList() == null) {
            VBlock vBlock = this.getBlock();
            Intrinsics.checkNotNull((Object)vBlock);
            this.setTimestamp(vBlock.getActiveRecord(), this.getCurrentTimestamp());
            bl = true;
        } else {
            bl = super.fillField(handler);
        }
        return bl;
    }

    @Override
    public void enumerateValue(boolean desc) {
        VBlock vBlock = this.getBlock();
        Intrinsics.checkNotNull((Object)vBlock);
        int record = vBlock.getActiveRecord();
        if (this.getList() != null) {
            super.enumerateValue(desc);
        } else if (this.isNull(record)) {
            this.setTimestamp(record, this.getCurrentTimestamp());
        } else {
            Comparable<Instant> comparable;
            try {
                this.checkType(this.getText(record));
            }
            catch (VException e) {
                this.setTimestamp(record, this.getCurrentTimestamp());
            }
            Temporal temporal = this.getTimestamp(record);
            if (temporal == null ? true : temporal instanceof Instant) {
                Temporal temporal2 = this.getTimestamp(record);
                Instant instant = temporal2 instanceof Instant ? (Instant)temporal2 : null;
                comparable = instant == null ? null : instant.plusMillis(desc ? -1L : 1L);
            } else {
                Temporal temporal3 = this.getTimestamp(record);
                LocalDateTime localDateTime = temporal3 instanceof LocalDateTime ? (LocalDateTime)temporal3 : null;
                comparable = localDateTime == null ? null : localDateTime.plus(desc ? -1L : 1L, ChronoUnit.MILLIS);
            }
            this.setTimestamp(record, (Temporal)((Object)comparable));
        }
    }
}

