/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.main;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutEvent;
import com.vaadin.flow.component.ShortcutEventListener;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.base.LocalizedProperties;
import org.kopi.galite.visual.ui.vaadin.base.VInputButton;
import org.kopi.galite.visual.ui.vaadin.common.VContent;
import org.kopi.galite.visual.ui.vaadin.common.VHeader;
import org.kopi.galite.visual.ui.vaadin.common.VMain;
import org.kopi.galite.visual.ui.vaadin.main.MainWindowListener;
import org.kopi.galite.visual.ui.vaadin.main.VWelcome;
import org.kopi.galite.visual.ui.vaadin.main.VWindowContainer;
import org.kopi.galite.visual.ui.vaadin.main.VWindows;
import org.kopi.galite.visual.ui.vaadin.main.VWindowsDisplay;
import org.kopi.galite.visual.ui.vaadin.main.VWindowsMenuItem;
import org.kopi.galite.visual.ui.vaadin.menu.ModuleList;
import org.kopi.galite.visual.ui.vaadin.visual.DUserMenu;
import org.kopi.galite.visual.ui.vaadin.visual.VApplication;
import org.kopi.galite.visual.ui.vaadin.window.Window;

@CssImport(value="./styles/galite/login.css")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 f2\u00020\u00012\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004:\u0001fB%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u0002062\u0006\u00108\u001a\u00020$J\u0016\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\bJ\r\u0010<\u001a\u000206H\u0000\u00a2\u0006\u0002\b=J\r\u0010>\u001a\u000206H\u0000\u00a2\u0006\u0002\b?J\r\u0010@\u001a\u000206H\u0000\u00a2\u0006\u0002\bAJ\r\u0010B\u001a\u000206H\u0000\u00a2\u0006\u0002\bCJ\r\u0010D\u001a\u000206H\u0000\u00a2\u0006\u0002\bEJ\u000e\u0010F\u001a\u0002062\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u0002062\u0006\u0010G\u001a\u00020HJ\u0015\u0010J\u001a\u0002062\u0006\u0010K\u001a\u00020LH\u0000\u00a2\u0006\u0002\bMJ\u0012\u0010N\u001a\u0002062\b\u0010O\u001a\u0004\u0018\u00010PH\u0014J\u000e\u0010Q\u001a\u0002062\u0006\u00108\u001a\u00020$J\u000e\u0010R\u001a\u0002062\u0006\u0010:\u001a\u00020\u001aJ\u0006\u0010S\u001a\u000206J\u000e\u0010T\u001a\u0002062\u0006\u0010U\u001a\u00020VJ\u000e\u0010W\u001a\u0002062\u0006\u0010X\u001a\u00020VJ\u0010\u0010Y\u001a\u0002062\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u001a\u0010Z\u001a\u0002062\b\u0010[\u001a\u0004\u0018\u00010\b2\b\u0010\\\u001a\u0004\u0018\u00010\bJ\u001c\u0010]\u001a\u0002062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010\bJ\u000e\u0010^\u001a\u0002062\u0006\u0010U\u001a\u00020VJ\u000e\u0010_\u001a\u0002062\u0006\u0010`\u001a\u00020\bJ\u000e\u0010a\u001a\u0002062\u0006\u0010U\u001a\u00020bJ\u000e\u0010c\u001a\u0002062\u0006\u0010X\u001a\u00020VJ\u0006\u0010d\u001a\u000206J\u0016\u0010e\u001a\u0002062\u0006\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0012R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0012R\u000e\u0010&\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010.\u001a\b\u0012\u0004\u0012\u00020\u001a0#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/main/MainWindow;", "Lcom/vaadin/flow/component/orderedlayout/VerticalLayout;", "Lcom/vaadin/flow/component/HasStyle;", "Lcom/vaadin/flow/component/HasSize;", "Lcom/vaadin/flow/component/Focusable;", "locale", "Ljava/util/Locale;", "logo", "", "href", "application", "Lorg/kopi/galite/visual/ui/vaadin/visual/VApplication;", "(Ljava/util/Locale;Ljava/lang/String;Ljava/lang/String;Lorg/kopi/galite/visual/ui/vaadin/visual/VApplication;)V", "getApplication", "()Lorg/kopi/galite/visual/ui/vaadin/visual/VApplication;", "value", "connectedUser", "getConnectedUser", "()Ljava/lang/String;", "setConnectedUser", "(Ljava/lang/String;)V", "container", "Lorg/kopi/galite/visual/ui/vaadin/main/VWindowContainer;", "content", "Lorg/kopi/galite/visual/ui/vaadin/common/VContent;", "currentWindow", "Lcom/vaadin/flow/component/Component;", "getCurrentWindow", "()Lcom/vaadin/flow/component/Component;", "setCurrentWindow", "(Lcom/vaadin/flow/component/Component;)V", "header", "Lorg/kopi/galite/visual/ui/vaadin/common/VHeader;", "getHref", "listeners", "", "Lorg/kopi/galite/visual/ui/vaadin/main/MainWindowListener;", "getLogo", "originalWindowTitle", "welcome", "Lorg/kopi/galite/visual/ui/vaadin/main/VWelcome;", "windows", "", "Lcom/vaadin/flow/component/contextmenu/MenuItem;", "windowsLink", "Lorg/kopi/galite/visual/ui/vaadin/main/VWindows;", "windowsList", "getWindowsList$galite_core", "()Ljava/util/List;", "setWindowsList$galite_core", "(Ljava/util/List;)V", "windowsMenu", "Lorg/kopi/galite/visual/ui/vaadin/main/VWindowsDisplay;", "addLinksListeners", "", "addMainWindowListener", "l", "addWindow", "window", "title", "fireOnAdmin", "fireOnAdmin$galite_core", "fireOnHelp", "fireOnHelp$galite_core", "fireOnLogout", "fireOnLogout$galite_core", "fireOnSupport", "fireOnSupport$galite_core", "fireOnUser", "fireOnUser$galite_core", "goToNextPage", "event", "Lcom/vaadin/flow/component/ShortcutEvent;", "goToPreviousPage", "gotoWindow", "next", "", "gotoWindow$galite_core", "onAttach", "attachEvent", "Lcom/vaadin/flow/component/AttachEvent;", "removeMainWindowListener", "removeWindow", "resetTitle", "setAdminMenu", "moduleList", "Lorg/kopi/galite/visual/ui/vaadin/menu/ModuleList;", "setBookmarksMenu", "menu", "setHref", "setImage", "url", "alt", "setLogo", "setMainMenu", "setTarget", "target", "setUserMenu", "Lorg/kopi/galite/visual/ui/vaadin/visual/DUserMenu;", "setWorkspaceContextItemMenu", "showWindowsMenu", "updateWindowTitle", "Companion", "galite-core"})
public final class MainWindow
extends VerticalLayout
implements HasStyle,
HasSize,
Focusable<MainWindow> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String logo;
    @NotNull
    private final String href;
    @NotNull
    private final VApplication application;
    @NotNull
    private final List<MainWindowListener> listeners;
    @NotNull
    private final VHeader header;
    @NotNull
    private final VWindows windowsLink;
    @NotNull
    private final VWelcome welcome;
    @NotNull
    private final VContent content;
    @NotNull
    private final String locale;
    @NotNull
    private List<Component> windowsList;
    @NotNull
    private final Map<Component, MenuItem> windows;
    @NotNull
    private final VWindowsDisplay windowsMenu;
    @NotNull
    private final VWindowContainer container;
    @Nullable
    private Component currentWindow;
    @NotNull
    private String originalWindowTitle;
    @NotNull
    private String connectedUser;
    public static MainWindow instance;

    public MainWindow(@NotNull Locale locale, @NotNull String logo, @NotNull String href2, @NotNull VApplication application) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)logo, (String)"logo");
        Intrinsics.checkNotNullParameter((Object)href2, (String)"href");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.logo = logo;
        this.href = href2;
        this.application = application;
        this.listeners = new ArrayList();
        this.header = new VHeader();
        this.windowsLink = new VWindows();
        this.welcome = new VWelcome();
        this.content = new VContent();
        String string = locale.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"locale.toString()");
        this.locale = string;
        this.windowsList = new ArrayList();
        this.windows = new LinkedHashMap();
        this.windowsMenu = new VWindowsDisplay();
        this.container = new VWindowContainer(this.windowsMenu.getMenu());
        this.originalWindowTitle = "";
        VMain main = new VMain();
        this.setWidthFull();
        this.setClassName("k-main-window");
        this.setHref(this.href);
        MainWindow.setLogo$default(this, this.logo, null, 2, null);
        this.setTarget("_blank");
        this.content.setContent((Component)this.container);
        Component[] componentArray = new Component[]{(Component)this.header};
        this.add(componentArray);
        Div welcomeContainer = new Div();
        welcomeContainer.setId("welcome_container");
        Div horizontalAlignContainer = new Div();
        horizontalAlignContainer.setId("horizontal_align_container");
        Component[] componentArray2 = new Component[]{(Component)this.welcome};
        horizontalAlignContainer.add(componentArray2);
        componentArray2 = new Component[]{(Component)horizontalAlignContainer};
        welcomeContainer.add(componentArray2);
        this.header.setWelcome((Component)welcomeContainer);
        this.windowsMenu.setText(LocalizedProperties.INSTANCE.getString(this.locale, "windowsText"));
        componentArray2 = new Component[]{(Component)this.windowsLink};
        this.welcome.add(componentArray2);
        main.setContent((Component)this.content);
        main.setSizeFull();
        this.content.setWidth("100%");
        this.content.setHeight("100%");
        componentArray2 = new Component[]{(Component)main};
        this.add(componentArray2);
        this.addLinksListeners();
        componentArray2 = new KeyModifier[]{KeyModifier.of((String)"Alt")};
        Shortcuts.addShortcutListener((Component)((Component)this), (ShortcutEventListener)new ShortcutEventListener(){

            public final void onShortcut(@NotNull ShortcutEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                MainWindow.this.goToPreviousPage(p0);
            }
        }, (Key)Key.PAGE_UP, (KeyModifier[])componentArray2);
        componentArray2 = new KeyModifier[]{KeyModifier.of((String)"Alt")};
        Shortcuts.addShortcutListener((Component)((Component)this), (ShortcutEventListener)new ShortcutEventListener(){

            public final void onShortcut(@NotNull ShortcutEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                MainWindow.this.goToNextPage(p0);
            }
        }, (Key)Key.PAGE_DOWN, (KeyModifier[])componentArray2);
        Companion.setInstance(this);
        this.connectedUser = "";
    }

    @NotNull
    public final String getLogo() {
        return this.logo;
    }

    @NotNull
    public final String getHref() {
        return this.href;
    }

    @NotNull
    public final VApplication getApplication() {
        return this.application;
    }

    @NotNull
    public final List<Component> getWindowsList$galite_core() {
        return this.windowsList;
    }

    public final void setWindowsList$galite_core(@NotNull List<Component> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.windowsList = list;
    }

    @Nullable
    public final Component getCurrentWindow() {
        return this.currentWindow;
    }

    public final void setCurrentWindow(@Nullable Component component) {
        this.currentWindow = component;
    }

    public final void setMainMenu(@NotNull ModuleList moduleList) {
        Intrinsics.checkNotNullParameter((Object)((Object)moduleList), (String)"moduleList");
        this.header.setMainMenu((Component)moduleList);
        Component[] componentArray = new Component[]{(Component)moduleList};
        this.header.expand(componentArray);
    }

    public final void updateWindowTitle(@NotNull Component window, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.container.updateWindowTitle(window, title);
        this.windowsMenu.updateCaption(window, title);
        this.application.setPageTitle$galite_core(title);
    }

    public final void setUserMenu(@NotNull DUserMenu moduleList) {
        Intrinsics.checkNotNullParameter((Object)moduleList, (String)"moduleList");
        this.welcome.setUserMenu(moduleList);
    }

    public final void setAdminMenu(@NotNull ModuleList moduleList) {
        Intrinsics.checkNotNullParameter((Object)((Object)moduleList), (String)"moduleList");
        this.welcome.setAdminMenu(moduleList);
    }

    public final void setBookmarksMenu(@NotNull ModuleList menu) {
        Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
        this.welcome.setBookmarksMenu(menu);
    }

    public final void setWorkspaceContextItemMenu(@NotNull ModuleList menu) {
        Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
        this.welcome.setWorkspaceContextItemMenu(menu);
    }

    public final void addWindow(@NotNull Component window, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        VWindowsMenuItem item = this.windowsMenu.addWindow(window, title);
        this.windowsList.add(window);
        this.container.addWindow(window, title);
        this.currentWindow = this.container.showWindow(window);
        item.addClickListener(new ComponentEventListener(this, item, window){
            final /* synthetic */ MainWindow this$0;
            final /* synthetic */ VWindowsMenuItem $item;
            final /* synthetic */ Component $window;
            {
                this.this$0 = $receiver;
                this.$item = $item;
                this.$window = $window;
            }

            public final void onComponentEvent(ClickEvent<VInputButton> it) {
                if (!Intrinsics.areEqual((Object)this.this$0.getCurrentWindow(), (Object)this.$item.getWindow())) {
                    this.this$0.setCurrentWindow(MainWindow.access$getContainer$p(this.this$0).showWindow(this.$item.getWindow()));
                    if (this.this$0.getCurrentWindow() instanceof Window) {
                        Component component = this.this$0.getCurrentWindow();
                        if (component == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.window.Window");
                        }
                        ((Window)component).goBackToLastFocusedTextField();
                        this.$window.setVisible(true);
                    }
                    MainWindow.access$getWindowsMenu$p(this.this$0).hideMenu();
                }
            }
        });
    }

    public final void removeWindow(@NotNull Component window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.windowsList.remove(window);
        this.currentWindow = this.container.removeWindow(window);
        this.windowsMenu.removeWindow(window);
        if (this.currentWindow instanceof Window) {
            Component component = this.currentWindow;
            if (component == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.window.Window");
            }
            ((Window)component).goBackToLastFocusedTextField();
        }
        if (this.windows.size() <= 1) {
            this.windowsLink.setEnabled(false);
        }
        if (this.currentWindow == null) {
            this.application.setPageTitle$galite_core(this.originalWindowTitle);
        }
    }

    @NotNull
    public final String getConnectedUser() {
        return this.connectedUser;
    }

    public final void setConnectedUser(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.connectedUser = value;
        this.welcome.setConnectedUser(value);
    }

    public final void showWindowsMenu() {
        this.windowsMenu.showMenu();
    }

    public final void addLinksListeners() {
        this.windowsLink.addClickListener(new ComponentEventListener(this){
            final /* synthetic */ MainWindow this$0;
            {
                this.this$0 = $receiver;
            }

            public final void onComponentEvent(ClickEvent<Div> it) {
                if (MainWindow.access$getWindowsLink$p(this.this$0).isEnabled()) {
                    MainWindow.access$getWindowsLink$p(this.this$0).showLabel();
                    MainWindow.access$getWindowsLink$p(this.this$0).focus();
                    this.this$0.showWindowsMenu();
                }
            }
        });
    }

    public final void addMainWindowListener(@NotNull MainWindowListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    public final void removeMainWindowListener(@NotNull MainWindowListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    public final void fireOnSupport$galite_core() {
        for (MainWindowListener l : this.listeners) {
            l.onSupport();
        }
    }

    public final void fireOnHelp$galite_core() {
        for (MainWindowListener l : this.listeners) {
            l.onHelp();
        }
    }

    public final void fireOnAdmin$galite_core() {
        for (MainWindowListener l : this.listeners) {
            l.onAdmin();
        }
    }

    public final void fireOnLogout$galite_core() {
        for (MainWindowListener l : this.listeners) {
            l.onLogout();
        }
    }

    public final void fireOnUser$galite_core() {
        for (MainWindowListener l : this.listeners) {
            l.onUser();
        }
    }

    public final void setHref(@Nullable String href2) {
        this.header.setHref(href2);
    }

    public final void setTarget(@NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.header.setTarget(target);
    }

    public final void setImage(@Nullable String url, @Nullable String alt) {
        String string = url;
        Intrinsics.checkNotNull((Object)string);
        this.header.setImage(string, alt);
    }

    public final void setLogo(@Nullable String logo, @Nullable String alt) {
        if (logo != null) {
            this.header.setImage(logo, alt);
        }
    }

    public static /* synthetic */ void setLogo$default(MainWindow mainWindow, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        mainWindow.setLogo(string, string2);
    }

    public final void goToNextPage(@NotNull ShortcutEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.gotoWindow$galite_core(true);
    }

    public final void goToPreviousPage(@NotNull ShortcutEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.gotoWindow$galite_core(false);
    }

    public final void resetTitle() {
        this.application.setPageTitle$galite_core(this.originalWindowTitle);
    }

    protected void onAttach(@Nullable AttachEvent attachEvent) {
        String string = ((UI)this.getUI().get()).getInternals().getTitle();
        if (string == null) {
            string = "";
        }
        this.originalWindowTitle = string;
    }

    public final void gotoWindow$galite_core(boolean next) {
        if (this.container.isEmpty()) {
            return;
        }
        Component component = this.currentWindow = next ? this.container.showNextWindow() : this.container.showPreviousWindow();
        if (this.currentWindow instanceof Window) {
            Component component2 = this.currentWindow;
            if (component2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.window.Window");
            }
            ((Window)component2).goBackToLastFocusedTextField();
        }
    }

    public static final /* synthetic */ VWindowContainer access$getContainer$p(MainWindow $this) {
        return $this.container;
    }

    public static final /* synthetic */ VWindowsDisplay access$getWindowsMenu$p(MainWindow $this) {
        return $this.windowsMenu;
    }

    public static final /* synthetic */ VWindows access$getWindowsLink$p(MainWindow $this) {
        return $this.windowsLink;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/main/MainWindow$Companion;", "", "()V", "instance", "Lorg/kopi/galite/visual/ui/vaadin/main/MainWindow;", "getInstance", "()Lorg/kopi/galite/visual/ui/vaadin/main/MainWindow;", "setInstance", "(Lorg/kopi/galite/visual/ui/vaadin/main/MainWindow;)V", "locale", "", "getLocale", "()Ljava/lang/String;", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MainWindow getInstance() {
            MainWindow mainWindow = instance;
            if (mainWindow != null) {
                return mainWindow;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            return null;
        }

        public final void setInstance(@NotNull MainWindow mainWindow) {
            Intrinsics.checkNotNullParameter((Object)((Object)mainWindow), (String)"<set-?>");
            instance = mainWindow;
        }

        @NotNull
        public final String getLocale() {
            return this.getInstance().locale;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

