/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.kopi.galite.util.base.InconsistencyException;
import org.kopi.galite.visual.MessageCode;
import org.kopi.galite.visual.UWindow;
import org.kopi.galite.visual.VException;
import org.kopi.galite.visual.VRuntimeException;
import org.kopi.galite.visual.VlibProperties;
import org.kopi.galite.visual.form.UField;
import org.kopi.galite.visual.form.UListDialog;
import org.kopi.galite.visual.form.VDictionary;
import org.kopi.galite.visual.form.VForm;
import org.kopi.galite.visual.form.VListDialog;
import org.kopi.vkopi.lib.ui.swing.base.ListDialogCellRenderer;
import org.kopi.vkopi.lib.ui.swing.visual.DObject;
import org.kopi.vkopi.lib.ui.swing.visual.DWindow;
import org.kopi.vkopi.lib.ui.swing.visual.SwingThreadHandler;
import org.kopi.vkopi.lib.ui.swing.visual.Utils;

public class DListDialog
extends JPanel
implements UListDialog {
    private final VListDialog model;
    private JTable table;
    private JDialog popup;
    private JDialog dialog;
    private KeyListener listener;
    private Component listenerOwner;
    private JScrollPane scrollpane;
    private boolean escaped = true;
    private boolean doNewForm;
    private static final int rowHeight = UIManager.getInt("ListDialog.row.height");
    private static final long serialVersionUID = 7488615622311380907L;

    public DListDialog(VListDialog model2) {
        this.model = model2;
    }

    @Override
    public int selectFromDialog(UWindow window, UField field, boolean showSingleEntry) {
        return this.selectFromDialogIn((Component)((Object)field), showSingleEntry);
    }

    @Override
    public int selectFromDialog(UWindow window, boolean showSingleEntry) {
        try {
            return this.selectFromJDialog(window != null ? (Component)((Object)window) : DObject.phantom, showSingleEntry);
        }
        catch (VException v) {
            throw new VRuntimeException(v);
        }
    }

    private int selectFromJDialog(Component parent, boolean showSingleEntry) throws VException {
        if (!showSingleEntry && this.model.getCount() == 1) {
            return this.model.convert(0);
        }
        this.dialog = parent instanceof Frame ? new JDialog((Frame)parent, true) : new JDialog(Utils.getFrameAncestor(parent), true);
        this.build();
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)this, "Center");
        this.addKeyListener();
        this.dialog.pack();
        this.table.requestFocusInWindow();
        this.dialog.setVisible(true);
        if (this.escaped) {
            return -1;
        }
        if (this.doNewForm) {
            return this.doNewForm(this.model.getForm(), this.model.getNewForm());
        }
        return ((ListDialogTableModel)this.table.getModel()).getSelectedElement();
    }

    private int selectFromDialogIn(Component field, boolean showSingleEntry) {
        DisplayHandler handler = new DisplayHandler(field, showSingleEntry);
        SwingThreadHandler.startAndWait(handler);
        return handler.getReturnValue();
    }

    private void build() {
        this.setLayout(new BorderLayout());
        this.table = new JTable(new ListDialogTableModel());
        this.table.setFocusable(true);
        this.table.setSelectionMode(0);
        this.table.setAutoscrolls(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setRowSelectionInterval(0, 0);
        this.table.setIntercellSpacing(new Dimension(2, 0));
        this.table.setRowHeight(rowHeight);
        this.table.setShowGrid(false);
        ListDialogCellRenderer renderer = new ListDialogCellRenderer(this.model.getColumns());
        for (int i = 0; i < this.table.getModel().getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DListDialog.this.escaped = false;
                e.consume();
                DListDialog.this.dispose();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DListDialog.this.escaped = false;
                e.consume();
                DListDialog.this.dispose();
            }
        });
        this.table.getColumnModel().addColumnModelListener((ListDialogTableModel)this.table.getModel());
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 0;
        int height = 0;
        for (int i = 0; i < this.table.getModel().getColumnCount(); ++i) {
            int columnWidth = Toolkit.getDefaultToolkit().getFontMetrics(this.table.getFont()).stringWidth("W") * this.model.getSizes()[i];
            this.table.getColumnModel().getColumn(i).setPreferredWidth(columnWidth);
            width += columnWidth;
        }
        height = this.table.getRowHeight() * this.table.getRowCount();
        this.table.setPreferredScrollableViewportSize(new Dimension(Math.min(width, (int)((float)screen.width * 0.8f)), Math.min(height, (int)((float)screen.height * 0.8f))));
        if (this.table.getModel().getColumnCount() == 1) {
            this.table.setAutoResizeMode(0);
            this.table.setTableHeader(null);
        } else {
            this.table.setAutoResizeMode(0);
        }
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.getVerticalScrollBar().setFocusable(false);
        this.scrollpane.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        this.add(this.scrollpane);
    }

    private void addKeyListener() {
        this.listener = new KeyAdapter(){
            String current = "";

            @Override
            public void keyPressed(KeyEvent k) {
                int key = k.getKeyCode();
                switch (key) {
                    case 32: {
                        if (DListDialog.this.model.getNewForm() != null || DListDialog.this.model.isForceNew()) {
                            DListDialog.this.doNewForm = true;
                        }
                    }
                    case 10: {
                        DListDialog.this.escaped = false;
                    }
                    case 27: {
                        DListDialog.this.dispose();
                        break;
                    }
                    case 33: {
                        int select = DListDialog.this.table.getSelectedRow();
                        select = Math.max(0, select - 20);
                        DListDialog.this.ensureSelectionIsVisible(select);
                        this.current = "";
                        break;
                    }
                    case 34: {
                        int select = DListDialog.this.table.getSelectedRow();
                        select = Math.min(DListDialog.this.table.getRowCount() - 1, select + 20);
                        DListDialog.this.ensureSelectionIsVisible(select);
                        this.current = "";
                        break;
                    }
                    case 40: {
                        int select = DListDialog.this.table.getSelectedRow();
                        if (++select < DListDialog.this.table.getRowCount()) {
                            DListDialog.this.ensureSelectionIsVisible(select);
                        }
                        this.current = "";
                        break;
                    }
                    case 38: {
                        int select = DListDialog.this.table.getSelectedRow();
                        if (select-- > 0) {
                            DListDialog.this.ensureSelectionIsVisible(select);
                        }
                        this.current = "";
                        break;
                    }
                    default: {
                        int i;
                        char aKey = k.getKeyChar();
                        if (!Character.isLetterOrDigit(aKey)) {
                            return;
                        }
                        this.current = this.current + ("" + aKey).toLowerCase().charAt(0);
                        for (i = 0; i < DListDialog.this.table.getModel().getRowCount(); ++i) {
                            int comp;
                            String text2 = ((ListDialogTableModel)DListDialog.this.table.getModel()).getDisplayedValueAt(i).toString();
                            if (!this.current.equalsIgnoreCase(text2.substring(0, comp = Math.min(text2.length(), this.current.length())))) continue;
                            DListDialog.this.ensureSelectionIsVisible(i);
                            break;
                        }
                        if (i != DListDialog.this.table.getModel().getRowCount()) break;
                        Toolkit.getDefaultToolkit().beep();
                        this.current = "";
                    }
                }
                k.consume();
            }
        };
        this.table.addKeyListener(this.listener);
        this.table.requestFocusInWindow();
    }

    private void ensureSelectionIsVisible(int select) {
        BoundedRangeModel brm = this.scrollpane.getVerticalScrollBar().getModel();
        int oldSel = -1;
        int size = this.table.getRowHeight();
        int min = brm.getValue() / size;
        int max = (brm.getValue() + brm.getExtent()) / size;
        if (select < min) {
            brm.setValue((select + 1) * size - brm.getExtent());
            oldSel = this.table.getSelectedRow();
        } else if (select > max - 1) {
            brm.setValue(select * size);
            oldSel = this.table.getSelectedRow();
        }
        this.table.setRowSelectionInterval(select, select);
        if (brm.getValue() / size != min) {
            int min2 = brm.getValue() / size;
            int max2 = (brm.getValue() + brm.getExtent()) / size;
            if (oldSel >= min2 && oldSel <= max2) {
                final int oldSelFinal = oldSel;
                ((AbstractTableModel)this.table.getModel()).fireTableRowsUpdated(oldSel, oldSel);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((AbstractTableModel)DListDialog.this.table.getModel()).fireTableRowsUpdated(oldSelFinal, oldSelFinal);
                    }
                });
            }
        }
    }

    private int doNewForm(VForm form, VDictionary cstr) throws VException {
        if (form != null && cstr != null) {
            return cstr.add();
        }
        return VListDialog.Companion.getNEW_CLICKED();
    }

    private void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        } else {
            this.popup.dispose();
        }
    }

    private class ListDialogTableModel
    extends AbstractTableModel
    implements TableColumnModelListener {
        private static final long serialVersionUID = 1956519774210966774L;

        public ListDialogTableModel() {
            if (DListDialog.this.model.getData().length != 0 && DListDialog.this.model.getCount() > DListDialog.this.model.getData()[0].length) {
                throw new InconsistencyException("UNEXPECTED DIFFERENT SIZE IN SELECTi DIALOG");
            }
            if (DListDialog.this.model.getTitles() != null && DListDialog.this.model.getData().length > DListDialog.this.model.getTitles().length) {
                throw new InconsistencyException("UNEXPECTED DIFFERENT SIZE IN SELECT DIALOG");
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            this.sort();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        public int getSelectedElement() {
            return DListDialog.this.model.convert(DListDialog.this.table.getSelectedRow());
        }

        @Override
        public int getColumnCount() {
            return DListDialog.this.model.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return DListDialog.this.model.getCount() - (DListDialog.this.model.isSkipFirstLine() ? 1 : 0);
        }

        @Override
        public Object getValueAt(int row, int col) {
            return DListDialog.this.model.getData()[col][DListDialog.this.model.getTranslatedIdents()[row]];
        }

        public Object getValueAt(int row) {
            return DListDialog.this.model.getData()[DListDialog.this.table.convertColumnIndexToModel(0)][DListDialog.this.model.getTranslatedIdents()[row]];
        }

        public Object getDisplayedValueAt(int row) {
            return DListDialog.this.model.getColumns()[DListDialog.this.table.convertColumnIndexToModel(0)].formatObject(this.getValueAt(row));
        }

        @Override
        public String getColumnName(int column2) {
            return DListDialog.this.model.getColumnName(column2);
        }

        private void sort() {
            int left = 0;
            int sel = -1;
            if (DListDialog.this.table != null) {
                sel = this.getSelectedElement();
                left = DListDialog.this.table.convertColumnIndexToModel(0);
            }
            DListDialog.this.model.sort(left);
            if (DListDialog.this.table != null) {
                for (int i = 0; i < DListDialog.this.model.getCount(); ++i) {
                    if (DListDialog.this.model.getIdents()[DListDialog.this.model.getTranslatedIdents()[i]] != sel) continue;
                    DListDialog.this.table.setRowSelectionInterval(i, i);
                }
                DListDialog.this.table.tableChanged(new TableModelEvent(this));
            }
        }
    }

    private class DisplayHandler
    implements Runnable {
        private int retVal;
        private Component field;
        private boolean showSingleEntry;

        public DisplayHandler(Component field, boolean showSingleEntry) {
            this.field = field;
            this.showSingleEntry = showSingleEntry;
        }

        @Override
        public void run() {
            this.retVal = this.selectFromDialogAWT(this.field, this.showSingleEntry);
        }

        public int getReturnValue() {
            return this.retVal;
        }

        private int selectFromDialogAWT(Component field, boolean showSingleEntry) {
            try {
                Frame focus;
                if (field != null) {
                    focus = Utils.getFrameAncestor(field);
                } else {
                    Window window;
                    for (window = FocusManager.getCurrentManager().getFocusedWindow(); !(window instanceof Frame) && window != null; window = window.getOwner()) {
                    }
                    focus = window instanceof Frame ? (Frame)window : null;
                }
                if (DListDialog.this.model.isTooManyRows()) {
                    Object[] options = new Object[]{VlibProperties.getString("CLOSE")};
                    JOptionPane.showOptionDialog(focus, MessageCode.INSTANCE.getMessage("VIS-00028"), VlibProperties.getString("Notice"), -1, 1, DWindow.ICN_NOTICE, options, options[0]);
                }
                DListDialog.this.build();
                if (!showSingleEntry && DListDialog.this.table.getModel().getRowCount() == 1) {
                    return DListDialog.this.model.convert(0);
                }
                DListDialog.this.popup = new JDialog(focus, true);
                DListDialog.this.popup.setUndecorated(true);
                JPanel panel = new JPanel();
                panel.setBorder(new EtchedBorder());
                DListDialog.this.popup.getContentPane().add(panel);
                panel.setLayout(new BorderLayout());
                panel.add((Component)DListDialog.this, "Center");
                if (DListDialog.this.model.getNewForm() != null || DListDialog.this.model.isForceNew()) {
                    JButton button = new JButton(VlibProperties.getString("new-record"));
                    panel.add((Component)button, "South");
                    button.setFocusable(true);
                    button.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            if (e.getKeyCode() == 27) {
                                DListDialog.this.dispose();
                                e.consume();
                            }
                        }
                    });
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DListDialog.this.doNewForm = true;
                            DListDialog.this.escaped = false;
                            DListDialog.this.dispose();
                        }
                    });
                }
                DListDialog.this.addKeyListener();
                DListDialog.this.popup.pack();
                this.positionPopup(focus, field, panel);
                if (DListDialog.this.listenerOwner != null) {
                    ((DWindow)DListDialog.this.listenerOwner).setCursor(Cursor.getDefaultCursor());
                }
                DListDialog.this.popup.setFocusCycleRoot(true);
                DListDialog.this.popup.setVisible(true);
                VForm temp = DListDialog.this.model.getForm();
                DListDialog.this.model.setForm(null);
                if (DListDialog.this.escaped) {
                    return -1;
                }
                if (DListDialog.this.doNewForm) {
                    if (DListDialog.this.listenerOwner != null) {
                        ((DWindow)DListDialog.this.listenerOwner).setCursor(Cursor.getPredefinedCursor(3));
                    }
                    return DListDialog.this.doNewForm(temp, DListDialog.this.model.getNewForm());
                }
                return ((ListDialogTableModel)DListDialog.this.table.getModel()).getSelectedElement();
            }
            catch (VException v) {
                throw new VRuntimeException(v);
            }
        }

        private void positionPopup(Frame frame, Component field, JPanel panel) {
            Point tryHere;
            if (field != null) {
                tryHere = field.getLocationOnScreen();
                tryHere.y += field.getSize().height;
            } else {
                tryHere = null;
            }
            Rectangle location = Utils.calculateBounds(DListDialog.this.popup, tryHere, frame);
            DListDialog.this.popup.setLocation(new Point(location.x, location.y));
        }
    }
}

