/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import org.kopi.galite.util.base.InconsistencyException;
import org.kopi.galite.visual.form.Alignment;
import org.kopi.galite.visual.form.LayoutManager;

public class KopiMultiBlockLayout
implements LayoutManager {
    Component[][] components;
    Alignment[][] aligns;
    int[] sizes;
    int[] realPos;
    int height;
    int width;
    boolean computed = false;
    int hgap = 0;
    int vgap = 0;
    int columnHeight;
    JScrollBar scrollBar;
    private static final int textHeight;

    public KopiMultiBlockLayout(int col, int line) {
        this.components = new Component[col][line];
        this.aligns = new Alignment[col][line];
        this.sizes = new int[col];
        this.realPos = new int[col];
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints instanceof Alignment) {
                Alignment align;
                this.aligns[align.getX()][align.getY()] = align = (Alignment)constraints;
                this.components[align.getX()][align.getY()] = comp;
            } else if (comp instanceof JScrollBar) {
                this.scrollBar = (JScrollBar)comp;
            } else {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a Alignment");
            }
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalArgumentException("dont use this deprecated method please");
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        throw new InconsistencyException("removeLayoutComponent not yet supported");
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public int getColumnPos(int x) {
        if (x < this.realPos.length - 1) {
            return this.realPos[x + 1];
        }
        if (x == this.realPos.length - 1) {
            return this.realPos[x] + this.sizes[x] + this.hgap;
        }
        return 0;
    }

    private void precalculateSize() {
        int x;
        this.height = 0;
        this.width = this.hgap;
        this.columnHeight = textHeight;
        for (x = 0; x < this.components.length; ++x) {
        }
        for (x = 0; x < this.components.length; ++x) {
            this.sizes[x] = Math.max(this.sizes[x], this.components[x][1].getPreferredSize().width);
            this.width += this.sizes[x] + this.hgap;
        }
        this.height = this.components[0].length * (this.vgap + this.columnHeight) + this.vgap;
        if (this.scrollBar != null) {
            this.width += 2 * this.hgap + this.scrollBar.getPreferredSize().width;
        }
        this.computed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            if (!this.computed) {
                this.precalculateSize();
            }
            Dimension dim = new Dimension(this.width, this.height);
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.computed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int extra_size_H;
            Insets insets = target.getInsets();
            int top = insets.top;
            int left = insets.left;
            int right = target.getSize().width - insets.right;
            if (!this.computed) {
                this.precalculateSize();
            }
            if ((extra_size_H = right - left - this.width) < 0) {
                extra_size_H = 0;
            }
            left += this.hgap + extra_size_H / 2;
            for (int x = 0; x < this.components.length; ++x) {
                this.realPos[x] = left - 2 * this.hgap;
                Dimension d1 = this.components[x][1].getPreferredSize();
                this.components[x][0].setBounds(this.aligns[x][1].getALG_RIGHT() ? left + this.sizes[x] - d1.width : left, 0 * (this.columnHeight + this.vgap) + this.vgap + insets.top, d1.width, this.columnHeight);
                for (int y = 1; y < this.components[0].length; ++y) {
                    Dimension d = this.components[x][y].getPreferredSize();
                    this.components[x][y].setBounds(this.aligns[x][y].getALG_RIGHT() ? left + this.sizes[x] - d.width : left, y * (this.columnHeight + this.vgap) + this.vgap + (y == 0 ? 2 : 0) + insets.top, d.width, d.height);
                }
                left += this.sizes[x] + this.hgap;
            }
            if (this.scrollBar != null) {
                this.scrollBar.setBounds(left, this.columnHeight + this.vgap + top, this.scrollBar.getPreferredSize().width, this.height - this.columnHeight - this.vgap);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    static {
        Font font = UIManager.getFont("KopiLayout.font");
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        textHeight = fm.getHeight() + UIManager.getInt("FieldText.y.space");
    }
}

