/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.UIManager;
import org.kopi.galite.util.base.InconsistencyException;
import org.kopi.galite.visual.form.Alignment;
import org.kopi.galite.visual.form.LayoutManager;
import org.kopi.galite.visual.form.MultiFieldAlignment;
import org.kopi.galite.visual.form.ViewBlockAlignment;
import org.kopi.vkopi.lib.ui.swing.form.DLabel;

public class KopiSimpleBlockLayout
implements LayoutManager {
    Component[][] components;
    Alignment[][] aligns;
    Vector<Component> follows;
    Vector<Alignment> followsAligns;
    int[] minStart;
    int[] sizes;
    int height;
    int width;
    boolean computed = false;
    ViewBlockAlignment align;
    int hgap = 7;
    int vgap = 1;
    int columnHeight = 20;
    private static final int textHeight;

    public KopiSimpleBlockLayout(int col, int line, ViewBlockAlignment align) {
        this.components = new Component[col][line];
        this.aligns = new Alignment[col][line];
        this.sizes = new int[col];
        this.minStart = new int[this.components.length + 2];
        this.follows = new Vector();
        this.followsAligns = new Vector();
        this.align = align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints instanceof Alignment) {
                Alignment align = (Alignment)constraints;
                if (align.getWidth() < 0) {
                    this.follows.addElement(comp);
                    this.followsAligns.addElement(align);
                } else {
                    this.aligns[align.getX()][align.getY()] = align;
                    this.components[align.getX()][align.getY()] = comp;
                }
            } else {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a Alignment");
            }
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalArgumentException("dont use this deprecated method please");
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        throw new InconsistencyException("removeLayoutComponent not yet supported");
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    private void precalculateSize() {
        int x;
        this.height = 0;
        this.width = 0;
        this.columnHeight = textHeight + 9;
        for (x = 0; x < this.components.length + 1; ++x) {
            this.minStart[x] = 0;
        }
        if (this.components.length == 0) {
            return;
        }
        for (x = 0; x < this.components.length; ++x) {
            int width_c = 0;
            int height_c = 0;
            for (int y = 0; y < this.components[0].length; ++y) {
                if (this.components[x][y] != null && !(this.aligns[x][y] instanceof MultiFieldAlignment)) {
                    Dimension dim = this.getDimension(x, y);
                    this.minStart[x + this.aligns[x][y].getWidth()] = Math.max(this.minStart[x] + dim.width + this.hgap, this.minStart[x + this.aligns[x][y].getWidth()]);
                    if (this.aligns[x][y].getWidth() == 1) {
                        width_c = Math.max(width_c, dim.width + this.hgap);
                    }
                    height_c = Math.max(height_c, y * (this.columnHeight + this.vgap) + dim.height);
                    continue;
                }
                if (this.components[x][y] == null) continue;
            }
            this.sizes[x] = width_c;
            this.width = Math.max(this.width + width_c, this.minStart[x + 1]);
            this.height = Math.max(this.height, height_c);
        }
        if (this.align != null) {
            for (x = 0; x < this.components.length; ++x) {
                if (x % 2 == 1 && this.align.isChart() && this.align.isAligned(x / 2 + 1)) {
                    this.minStart[x + 1] = this.align.getMinStart(x / 2 + 1);
                    continue;
                }
                if (this.align.isChart()) continue;
                this.minStart[x] = x % 2 == 1 ? this.align.getMinStart(x / 2 + 1) : this.align.getLabelMinStart(x / 2 + 1);
            }
        }
        if (this.width > this.hgap) {
            this.width -= this.hgap;
        }
        if (this.height > this.vgap) {
            this.height -= this.vgap;
        }
        this.computed = true;
    }

    private Dimension getDimension(int x, int y) {
        Dimension dim = this.components[x][y].getPreferredSize();
        int width = dim.width;
        int height = dim.height;
        for (int i = 0; i < this.follows.size(); ++i) {
            Alignment align = this.followsAligns.elementAt(i);
            if (align.getX() != x || align.getY() != y) continue;
            Component comp = this.follows.elementAt(i);
            Dimension dim2 = comp.getPreferredSize();
            width += dim2.width + this.hgap;
            height = Math.max(height, dim2.height);
        }
        if (width != dim.width || height != dim.height) {
            return new Dimension(width, height);
        }
        return dim;
    }

    @Override
    public int getColumnPos(int x) {
        if (x < this.minStart.length) {
            return this.minStart[x];
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            if (!this.computed) {
                this.precalculateSize();
            }
            Dimension dim = new Dimension(this.width, this.height);
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.computed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int top = insets.top;
            int left = insets.left;
            if (this.components.length == 0) {
                return;
            }
            if (!this.computed) {
                this.precalculateSize();
            }
            for (int x = 0; x < this.components.length; ++x) {
                for (int y = 0; y < this.components[0].length; ++y) {
                    int cleft;
                    if (this.components[x][y] == null) continue;
                    Dimension d = this.components[x][y].getPreferredSize();
                    int sup = 0;
                    if (this.aligns[x][y] instanceof MultiFieldAlignment) {
                        if (this.aligns[x][y].getAlignRight()) {
                            cleft = (x - 1) / 2 * (Math.max(d.width, this.components[x][y + 1].getPreferredSize().width) + this.hgap) + insets.left;
                            sup = 5;
                        } else {
                            cleft = (x - 1) / 2 * (Math.max(d.width, this.components[x][y - 1].getPreferredSize().width) + this.hgap) + insets.left;
                        }
                    } else {
                        cleft = !this.aligns[x][y].getAlignRight() && this.align != null && this.align.isAligned(x / 2 + 1) ? (this.components[x][y] instanceof DLabel ? insets.left : (this.align.isChart() ? this.minStart[x + 1] - d.width : this.minStart[x])) : (this.align != null && this.align.isAligned(x / 2 + 1) ? insets.left : (this.aligns[x][y].getAlignRight() ? this.minStart[x + 1] - d.width : left));
                    }
                    this.components[x][y].setBounds(cleft, y * (this.vgap + this.columnHeight) + top + sup, this.aligns[x][y].getAlignRight() || !this.aligns[x][y].getUseAll() ? d.width : this.minStart[x + 1] - cleft, d.height);
                }
                left = this.minStart[x + 1];
            }
            for (int i = 0; i < this.follows.size(); ++i) {
                Alignment align = this.followsAligns.elementAt(i);
                Component comp = this.follows.elementAt(i);
                Dimension d = comp.getPreferredSize();
                comp.setBounds(this.components[align.getX()][align.getY()].getLocation().x + this.hgap + this.components[align.getX()][align.getY()].getPreferredSize().width, align.getY() * (this.vgap + this.columnHeight) + top, d.width, d.height);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    static {
        Font font = UIManager.getFont("KopiLayout.font");
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        textHeight = fm.getHeight();
    }
}

