/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.Color;
import java.awt.Toolkit;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.kopi.galite.util.base.InconsistencyException;
import org.kopi.galite.visual.ApplicationContext;
import org.kopi.galite.visual.form.ModelTransformer;
import org.kopi.galite.visual.form.VDecimalField;
import org.kopi.galite.visual.form.VField;
import org.kopi.vkopi.lib.ui.swing.form.KopiDocument;

public class KopiStyledDocument
extends HTMLDocument
implements KopiDocument {
    private final VField model;
    private final ModelTransformer transformer;
    private HTMLEditorKit editorKit;
    private int state;
    private boolean alert;
    private boolean autofill = false;
    private boolean hasCriticalValue;
    private boolean hasAction;
    private Color bgColor;

    public KopiStyledDocument(VField model2, ModelTransformer transformer) {
        this.model = model2;
        this.transformer = transformer;
    }

    public void setEditorKit(HTMLEditorKit editorKit) {
        this.editorKit = editorKit;
    }

    @Override
    public synchronized String getModelText() {
        try {
            String text = this.getText(0, this.getLength());
            return this.transformer.toModel(text);
        }
        catch (BadLocationException e) {
            throw new InconsistencyException("BadLocationException in KopiFieldDocument");
        }
    }

    @Override
    public synchronized void setModelText(String s) {
        try {
            super.remove(0, this.getLength());
            s = this.transformer.toGui(s);
            try {
                this.editorKit.insertHTML(this, this.getLength(), s, 0, 0, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (BadLocationException e) {
            throw new InconsistencyException("BadLocationException in KopiFieldDocument");
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        Object text = this.getText(0, this.getLength());
        text = ((String)text).substring(0, offs) + ((String)text).substring(offs + len);
        if (!this.transformer.checkFormat((String)(text = this.transformer.toModel((String)text)))) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.model.checkText((String)text)) {
            super.remove(offs, len);
            this.model.onTextChange(this.getText(0, this.getLength()));
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        DecimalFormatSymbols symbols;
        if (str == null) {
            return;
        }
        if (this.model instanceof VDecimalField && str.equals(".") && (symbols = new DecimalFormatSymbols(ApplicationContext.Companion.getDefaultLocale())).getDecimalSeparator() != '.') {
            str = str.replace('.', symbols.getDecimalSeparator());
        }
        Object text = this.getText(0, this.getLength());
        text = ((String)text).substring(0, offs) + str + ((String)text).substring(offs);
        if (!this.transformer.checkFormat((String)(text = this.transformer.toModel((String)text)))) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.model.checkText((String)text)) {
            super.insertString(offs, str, a);
            this.model.onTextChange(this.getText(0, this.getLength()));
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public boolean getAutofill() {
        return this.autofill;
    }

    @Override
    public boolean isAlert() {
        return this.alert;
    }

    @Override
    public boolean hasCriticalValue() {
        return this.hasCriticalValue;
    }

    @Override
    public boolean hasAction() {
        return this.hasAction;
    }

    @Override
    public Color getBgColor() {
        return this.bgColor;
    }

    @Override
    public Object getModel() {
        return this.model;
    }

    @Override
    public void setState(int state) {
        this.state = state;
    }

    @Override
    public void setHasCriticalValue(boolean hasCriticalValue) {
        this.hasCriticalValue = hasCriticalValue;
    }

    @Override
    public void setHasAction(boolean hasAction) {
        this.hasAction = hasAction;
    }

    @Override
    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    @Override
    public void setAlert(boolean alert) {
        this.alert = alert;
    }

    @Override
    public void setAutofill(boolean autofill2) {
        this.autofill = autofill2;
    }
}

