/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JPopupMenu;

public class Utils
extends org.kopi.vkopi.lib.ui.swing.base.Utils {
    private static final Insets SCN_INSESTS = new Insets(22, 22, 22, 22);

    public static Component getRoot(Component c, Class<?> type) {
        Component root = null;
        Component p = c;
        while (p != null) {
            if (type.isAssignableFrom(p.getClass())) {
                root = p;
            }
            if (p instanceof Window) {
                return root;
            }
            if (p instanceof JPopupMenu) {
                p = ((JPopupMenu)p).getInvoker();
                continue;
            }
            p = p.getParent();
        }
        return root;
    }

    public static Window getWindowAncestor(Component c) {
        return (Window)Utils.getRoot(c, Window.class);
    }

    public static Frame getFrameAncestor(Component c) {
        return (Frame)Utils.getRoot(c, Frame.class);
    }

    public static Rectangle calculateBounds(Component component, Point position, Frame frame) {
        Rectangle location = new Rectangle();
        Insets insets = Utils.getScreenInsets();
        Dimension componentSize = component.getPreferredSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int minX = insets.left;
        int minY = insets.top;
        int maxX = screen.width - insets.right;
        int maxY = screen.height - insets.bottom;
        int maxWidth = screen.width - insets.right - insets.left;
        int maxHeight = screen.height - insets.bottom - insets.top;
        if (position == null) {
            Point center;
            if (frame != null) {
                Point frameLocationOnScreen = frame.getLocationOnScreen();
                center = new Point(frameLocationOnScreen.x + frame.getSize().width / 2, frameLocationOnScreen.y + frame.getSize().height / 2);
            } else {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                center = ge.getCenterPoint();
            }
            position = new Point();
            position.x = center.x - componentSize.width / 2;
            position.y = center.y - componentSize.height / 2;
        }
        location.x = maxWidth <= componentSize.width ? minX : (position.x < minX ? minX : (position.x + componentSize.width <= maxX ? position.x : maxX - componentSize.width));
        location.y = maxHeight <= componentSize.height ? minY : (position.y < minY ? minY : (position.y + componentSize.height <= maxY ? position.y : maxY - componentSize.height));
        location.width = Math.min(maxWidth, componentSize.width);
        location.height = Math.min(maxHeight, componentSize.height);
        return location;
    }

    private static Insets getScreenInsets() {
        try {
            if (System.getProperty("os.name").startsWith("Linux")) {
                return SCN_INSESTS;
            }
            Toolkit tk = Toolkit.getDefaultToolkit();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
            Insets insets = tk.getScreenInsets(gc);
            return insets;
        }
        catch (Exception e) {
            return SCN_INSESTS;
        }
    }
}

