/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.dsl.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.kopi.galite.util.base.InconsistencyException;
import org.kopi.galite.visual.domain.Domain;
import org.kopi.galite.visual.dsl.common.CodeDescription;
import org.kopi.galite.visual.dsl.common.FieldList;
import org.kopi.galite.visual.dsl.common.ListDescription;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\tJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ,\u0010\r\u001a\u00020\u0007\"\u0010\b\u0000\u0010\u000e*\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u00120\u0011J\u0014\u0010\u0013\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u001a\u0010\u0017\u001a\u00020\u00072\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\tJ\u0016\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\tJ\u0014\u0010\u001e\u001a\u00020\u00072\f\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010 J\u001a\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#J\u0012\u0010$\u001a\u00020\u00052\b\u0010%\u001a\u0004\u0018\u00010\tH\u0004J\u0012\u0010&\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010\u0005H\u0004J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0005H\u0004J\u001e\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020-R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/kopi/galite/visual/dsl/common/LocalizationWriter;", "", "()V", "currentHierarchy", "Ljava/util/Stack;", "Lorg/jdom2/Element;", "genActorDefinition", "", "ident", "", "label", "help", "genCodeDesc", "genCodeType", "T", "", "codes", "", "Lorg/kopi/galite/visual/dsl/common/CodeDescription;", "genFieldList", "columns", "", "Lorg/kopi/galite/visual/dsl/common/ListDescription;", "genListDesc", "column", "Lorg/jetbrains/exposed/sql/ExpressionWithColumnType;", "title", "genMenuDefinition", "genMessageDefinition", "text", "genType", "list", "Lorg/kopi/galite/visual/dsl/common/FieldList;", "genTypeDefinition", "type", "Lorg/kopi/galite/visual/domain/Domain;", "peekNode", "expected", "popNode", "pushNode", "node", "write", "directory", "baseName", "locale", "Ljava/util/Locale;", "galite-core"})
@SourceDebugExtension(value={"SMAP\nLocalizationWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationWriter.kt\norg/kopi/galite/visual/dsl/common/LocalizationWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1855#2,2:180\n*S KotlinDebug\n*F\n+ 1 LocalizationWriter.kt\norg/kopi/galite/visual/dsl/common/LocalizationWriter\n*L\n111#1:180,2\n*E\n"})
public class LocalizationWriter {
    @NotNull
    private final Stack<Element> currentHierarchy = new Stack();

    public final void write(@NotNull String directory, @NotNull String baseName, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Document doc = new Document(this.peekNode(null));
        Format format2 = Format.getPrettyFormat();
        format2.setEncoding("UTF-8");
        format2.setLineSeparator("\n");
        XMLOutputter writer = new XMLOutputter(format2);
        String fileName = baseName + "-" + locale + ".xml";
        File directoryFile = new File(directory);
        if (!directoryFile.exists()) {
            directoryFile.mkdirs();
        }
        writer.output(doc, (OutputStream)new FileOutputStream(new File(directory, fileName)));
    }

    public final void genMenuDefinition(@NotNull String ident, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Element self = new Element("menu");
        self.setAttribute("ident", ident);
        self.setAttribute("label", label);
        this.peekNode(null).addContent((Content)self);
    }

    public final void genActorDefinition(@NotNull String ident, @NotNull String label, @Nullable String help2) {
        Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Element self = new Element("actor");
        self.setAttribute("ident", ident);
        self.setAttribute("label", label);
        if (help2 != null) {
            self.setAttribute("help", help2);
        }
        this.peekNode(null).addContent((Content)self);
    }

    public final void genTypeDefinition(@NotNull String ident, @NotNull Domain<?> type) {
        Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Element self = new Element("type");
        self.setAttribute("ident", ident);
        this.pushNode(self);
        type.genTypeLocalization(this);
        this.popNode(self);
        this.peekNode(null).addContent((Content)self);
    }

    public final void genType(@Nullable FieldList<?> list) {
        block0: {
            FieldList<?> fieldList = list;
            if (fieldList == null) break block0;
            fieldList.genLocalization(this);
        }
    }

    public final <T extends Comparable<? super T>> void genCodeType(@NotNull List<CodeDescription<T>> codes) {
        Intrinsics.checkNotNullParameter(codes, (String)"codes");
        Element self = new Element("code");
        this.pushNode(self);
        Iterable $this$forEach$iv = codes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeDescription code = (CodeDescription)element$iv;
            boolean bl = false;
            code.genLocalization(this);
        }
        this.popNode(self);
        this.peekNode("type").addContent((Content)self);
    }

    public final void genMessageDefinition(@NotNull String ident, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
        Element self = new Element("message");
        self.setAttribute("ident", ident);
        if (text != null) {
            self.setAttribute("text", text);
        }
        this.peekNode(null).addContent((Content)self);
    }

    public final void genFieldList(@NotNull List<ListDescription> columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Element self = new Element("list");
        this.pushNode(self);
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            columns.get(i).genLocalization(this);
        }
        this.popNode(self);
        this.peekNode("type").addContent((Content)self);
    }

    public final void genCodeDesc(@NotNull String ident, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Element self = new Element("codedesc");
        self.setAttribute("ident", ident);
        self.setAttribute("label", label);
        this.peekNode("code").addContent((Content)self);
    }

    public final void genListDesc(@NotNull ExpressionWithColumnType<?> column, @NotNull String title) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Element self = new Element("listdesc");
        self.setAttribute("column", column instanceof Column ? ((Column)column).getName() : title);
        self.setAttribute("title", title);
        this.peekNode("list").addContent((Content)self);
    }

    protected final void pushNode(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.currentHierarchy.push(node);
    }

    protected final void popNode(@Nullable Element expected) {
        Element element = this.currentHierarchy.pop();
        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.jdom2.Element");
        Element actual = element;
        if (expected != null && !Intrinsics.areEqual((Object)actual, (Object)expected)) {
            throw new InconsistencyException("Unexpected name of element to pop");
        }
    }

    @NotNull
    protected final Element peekNode(@Nullable String expected) {
        Element element = this.currentHierarchy.peek();
        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.jdom2.Element");
        Element top = element;
        if (expected != null && !Intrinsics.areEqual((Object)top.getName(), (Object)expected)) {
            throw new InconsistencyException("Unexpected name of element to peek");
        }
        return top;
    }
}

