/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.grid;

import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorTextField;
import org.kopi.galite.visual.ui.vaadin.grid.InvalidEditorFieldException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorMonthField;", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorTextField;", "()V", "check", "", "text", "", "isMonth", "m", "", "y", "toString", "year", "month", "validate", "", "galite-core"})
public final class GridEditorMonthField
extends GridEditorTextField {
    public GridEditorMonthField() {
        super(7);
    }

    @Override
    protected boolean check(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char element = text.charAt(i);
            if (('0' <= element ? element < ':' : false) || element == '.') continue;
            return false;
        }
        return true;
    }

    @Override
    public void validate() {
        String text = this.getValue();
        if (StringsKt.indexOf$default((CharSequence)text, (String)".", (int)0, (boolean)false, (int)6, null) != -1 && StringsKt.indexOf$default((CharSequence)text, (String)".", (int)0, (boolean)false, (int)6, null) == StringsKt.lastIndexOf$default((CharSequence)text, (String)".", (int)0, (boolean)false, (int)6, null)) {
            try {
                String string = text.substring(0, StringsKt.indexOf$default((CharSequence)text, (String)".", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                int month = Integer.parseInt(string);
                String string2 = text.substring(StringsKt.indexOf$default((CharSequence)text, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                int year = Integer.parseInt(string2);
                if (year < 50) {
                    year += 2000;
                } else if (year < 100) {
                    year += 1900;
                }
                if (!this.isMonth(month, year)) {
                    throw new InvalidEditorFieldException(this, "00005", new Object[0]);
                }
                this.setValue(this.toString(year, month));
            }
            catch (Exception e) {
                throw new InvalidEditorFieldException(this, "00005", new Object[0]);
            }
        } else if (StringsKt.indexOf$default((CharSequence)text, (String)".", (int)0, (boolean)false, (int)6, null) == -1) {
            try {
                int month = Integer.parseInt(text);
                int year = LocalDate.now().getYear();
                if (!this.isMonth(month, year)) {
                    throw new InvalidEditorFieldException(this, "00005", new Object[0]);
                }
                this.setValue(this.toString(year, month));
            }
            catch (Exception e) {
                throw new InvalidEditorFieldException(this, "00005", new Object[0]);
            }
        } else {
            throw new InvalidEditorFieldException(this, "00005", new Object[0]);
        }
    }

    @NotNull
    public final String toString(int year, int month) {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append(month / 10);
        $this$toString_u24lambda_u240.append(month % 10);
        $this$toString_u24lambda_u240.append('.');
        $this$toString_u24lambda_u240.append(year);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final boolean isMonth(int m, int y) {
        return y >= 1 && m >= 1 && m <= 12;
    }
}

