/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.list;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializablePredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.form.VListDialog;
import org.kopi.galite.visual.list.VListColumn;
import org.kopi.galite.visual.ui.vaadin.list.ListFilter;

@CssImport(value="./styles/galite/list.css")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004J\u0015\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\b\u001a\u00060\u0002R\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/list/ListTable;", "Lcom/vaadin/flow/component/grid/Grid;", "Lorg/kopi/galite/visual/ui/vaadin/list/ListTable$ListDialogItem;", "model", "Lorg/kopi/galite/visual/form/VListDialog;", "(Lorg/kopi/galite/visual/form/VListDialog;)V", "getModel", "()Lorg/kopi/galite/visual/form/VListDialog;", "selectedItem", "getSelectedItem", "()Lorg/kopi/galite/visual/ui/vaadin/list/ListTable$ListDialogItem;", "widthStyler", "Lcom/vaadin/flow/component/html/Div;", "getWidthStyler$galite_core", "()Lcom/vaadin/flow/component/html/Div;", "setWidthStyler$galite_core", "(Lcom/vaadin/flow/component/html/Div;)V", "buildColumns", "", "buildRows", "getColumnWidth", "", "col", "installFilters", "setTableWidth", "setTableWidth$galite_core", "ListDialogItem", "galite-core"})
@SourceDebugExtension(value={"SMAP\nListTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListTable.kt\norg/kopi/galite/visual/ui/vaadin/list/ListTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1549#2:148\n1620#2,3:149\n1559#2:153\n1590#2,4:154\n1#3:152\n*S KotlinDebug\n*F\n+ 1 ListTable.kt\norg/kopi/galite/visual/ui/vaadin/list/ListTable\n*L\n46#1:148\n46#1:149,3\n67#1:153\n67#1:154,4\n*E\n"})
public final class ListTable
extends Grid<ListDialogItem> {
    @NotNull
    private final VListDialog model;
    @NotNull
    private Div widthStyler;

    public ListTable(@NotNull VListDialog model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.model = model2;
        this.widthStyler = new Div();
        this.setColumnReorderingAllowed(true);
        this.buildRows();
        this.buildColumns();
        this.setTableWidth$galite_core(this.model);
        this.installFilters(this.model);
    }

    @NotNull
    public final VListDialog getModel() {
        return this.model;
    }

    @NotNull
    public final Div getWidthStyler$galite_core() {
        return this.widthStyler;
    }

    public final void setWidthStyler$galite_core(@NotNull Div div) {
        Intrinsics.checkNotNullParameter((Object)div, (String)"<set-?>");
        this.widthStyler = div;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRows() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.model.getCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ListDialogItem((int)it));
        }
        List items = (List)destination$iv$iv;
        this.setItems(items);
    }

    private final void buildColumns() {
        int n = this.model.getColumnCount();
        for (int col = 0; col < n; ++col) {
            this.addColumn(arg_0 -> ListTable.buildColumns$lambda$1(col, arg_0)).setHeader((Component)new Span(this.model.getColumnName(col))).setKey(String.valueOf(col));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void installFilters(@NotNull VListDialog model2) {
        void $this$mapIndexedTo$iv$iv;
        HeaderRow filterRow;
        HeaderRow headerRow;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        HeaderRow it = headerRow = (filterRow = this.appendHeaderRow());
        boolean bl = false;
        this.getElement().getClassList().add((Object)"list-filter");
        List list = this.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
        Iterable $this$mapIndexed$iv = list;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void column;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Grid.Column column2 = (Grid.Column)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            HeaderRow.HeaderCell cell = (HeaderRow.HeaderCell)filterRow.getCell((Grid.Column)column);
            TextField filterField = new TextField();
            Icon search = new Icon(VaadinIcon.SEARCH);
            filterField.setWidthFull();
            filterField.setSuffixComponent((Component)search);
            filterField.setClassName("filter-text");
            filterField.addValueChangeListener(new HasValue.ValueChangeListener(this){
                final /* synthetic */ ListTable this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void valueChanged(AbstractField.ComponentValueChangeEvent<TextField, String> it) {
                    DataProvider dataProvider = this.this$0.getDataProvider();
                    Intrinsics.checkNotNull((Object)dataProvider, (String)"null cannot be cast to non-null type com.vaadin.flow.data.provider.ListDataProvider<@[FlexibleNullability] org.kopi.galite.visual.ui.vaadin.list.ListTable.ListDialogItem?>");
                    ((ListDataProvider)dataProvider).refreshAll();
                }
            });
            filterField.setValueChangeMode(ValueChangeMode.EAGER);
            cell.setComponent((Component)filterField);
            collection.add(filterField);
        }
        List filterFields2 = (List)destination$iv$iv;
        DataProvider dataProvider = this.getDataProvider();
        Intrinsics.checkNotNull((Object)dataProvider, (String)"null cannot be cast to non-null type com.vaadin.flow.data.provider.ListDataProvider<@[FlexibleNullability] org.kopi.galite.visual.ui.vaadin.list.ListTable.ListDialogItem?>");
        ((ListDataProvider)dataProvider).setFilter((SerializablePredicate)new ListFilter(filterFields2, model2, true, false));
        this.getElement().getClassList().add((Object)"filtered");
    }

    public final void setTableWidth$galite_core(@NotNull VListDialog model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        int width = 0;
        int n = model2.getColumnCount();
        for (int col = 0; col < n; ++col) {
            int columnWidth = this.getColumnWidth(model2, col) + 36;
            this.getColumnByKey(String.valueOf(col)).setWidth(columnWidth + "px");
            width += columnWidth;
        }
        this.widthStyler.setWidth((float)width + 20.0f, Unit.PIXELS);
        this.widthStyler.setMinWidth((float)width + 20.0f, Unit.PIXELS);
    }

    private final int getColumnWidth(VListDialog model2, int col) {
        int width = 0;
        width = 0;
        int n = model2.getCount();
        for (int row = 0; row < n; ++row) {
            VListColumn vListColumn = model2.getColumns()[col];
            Intrinsics.checkNotNull((Object)vListColumn);
            String value = String.valueOf(vListColumn.formatObject(model2.getValueAt(row, col)));
            int n2 = value.length();
            String string = model2.getTitles()[col];
            Intrinsics.checkNotNull((Object)string);
            width = RangesKt.coerceAtLeast((int)width, (int)RangesKt.coerceAtLeast((int)n2, (int)string.length()));
        }
        return 8 * width;
    }

    @NotNull
    public final ListDialogItem getSelectedItem() {
        Object object = this.asSingleSelect().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ListDialogItem)object;
    }

    private static final Object buildColumns$lambda$1(int $col, ListDialogItem it) {
        return it.getValueAt($col);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/list/ListTable$ListDialogItem;", "", "row", "", "(Lorg/kopi/galite/visual/ui/vaadin/list/ListTable;I)V", "getRow", "()I", "formatObject", "", "o", "col", "getValueAt", "galite-core"})
    public final class ListDialogItem {
        private final int row;

        public ListDialogItem(int row) {
            this.row = row;
        }

        public final int getRow() {
            return this.row;
        }

        @NotNull
        public final String getValueAt(int col) {
            return this.formatObject(ListTable.this.getModel().getData()[col][ListTable.this.getModel().getTranslatedIdents()[this.row]], col);
        }

        private final String formatObject(Object o, int col) {
            VListColumn vListColumn = ListTable.this.getModel().getColumns()[col];
            Intrinsics.checkNotNull((Object)vListColumn);
            return String.valueOf(vListColumn.formatObject(o));
        }
    }
}

