/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u001d\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0017\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/kopi/galite/visual/util/PlatformFileWriter;", "", "file", "Ljava/io/File;", "encoding", "", "lineSeparator", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V", "fileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "dataStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;Ljava/lang/String;Ljava/lang/String;)V", "getDataStream", "()Ljava/io/OutputStream;", "getEncoding", "()Ljava/lang/String;", "getLineSeparator", "close", "", "nl", "write", "string", "writeln", "galite-core"})
public final class PlatformFileWriter {
    @NotNull
    private final OutputStream dataStream;
    @NotNull
    private final String encoding;
    @NotNull
    private final String lineSeparator;

    public PlatformFileWriter(@NotNull OutputStream dataStream, @NotNull String encoding, @NotNull String lineSeparator) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this.dataStream = dataStream;
        this.encoding = encoding;
        this.lineSeparator = lineSeparator;
    }

    @NotNull
    public final OutputStream getDataStream() {
        return this.dataStream;
    }

    @NotNull
    public final String getEncoding() {
        return this.encoding;
    }

    @NotNull
    public final String getLineSeparator() {
        return this.lineSeparator;
    }

    public PlatformFileWriter(@NotNull File file, @NotNull String encoding, @NotNull String lineSeparator) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this(new FileOutputStream(file), encoding, lineSeparator);
    }

    public PlatformFileWriter(@NotNull String fileName, @NotNull String encoding, @NotNull String lineSeparator) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this(new File(fileName), encoding, lineSeparator);
    }

    public final void write(@Nullable String string) {
        if (string != null) {
            Charset charset = Charset.forName(this.encoding);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            this.dataStream.write(byArray);
        }
    }

    public final void nl() {
        this.write(this.lineSeparator);
    }

    public final void writeln(@Nullable String string) {
        this.write(string);
        this.nl();
    }

    public final void close() {
        this.dataStream.flush();
        this.dataStream.close();
    }
}

