/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.kopi.galite.visual.list.ObjectFormatter;

public class ListDialogCellRenderer
implements TableCellRenderer {
    private ObjectFormatter[] columns;
    private static final CellRenderer renderer = new CellRenderer();
    private static final Color color_back = UIManager.getColor("ListDialog.background");
    private static final Color color_back_sel = UIManager.getColor("ListDialog.background.selected");
    private static final Color color_fore = UIManager.getColor("ListDialog.foreground");
    private static final Color color_fore_sel = UIManager.getColor("ListDialog.foreground.selected");
    private static final Font font_dialog = UIManager.getFont("ListDialog.font");

    public ListDialogCellRenderer(ObjectFormatter[] columns) {
        this.columns = columns;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int col = table.convertColumnIndexToModel(column);
        Object obj = this.columns[col].formatObject(value);
        if (obj instanceof String) {
            renderer.set(this.columns[column].getAlign(), (String)obj, isSelected);
            return renderer;
        }
        return new JLabel((ImageIcon)obj);
    }

    private static class CellRenderer
    extends JComponent {
        private int align;
        private boolean isSelected;
        private String str;
        private static final long serialVersionUID = -3447204841285947085L;

        private CellRenderer() {
        }

        @Override
        public void paint(Graphics g) {
            Dimension size = this.getSize();
            g.setColor(this.isSelected ? color_back_sel : color_back);
            g.fillRect(0, 0, size.width, size.height);
            if (this.str != null && this.str != "" && this.str.length() != 0) {
                g.setColor(Color.black);
                g.setColor(this.isSelected ? color_fore_sel : color_fore);
                g.setFont(font_dialog);
                FontMetrics fm = g.getFontMetrics();
                int stringWidth = fm.stringWidth(this.str);
                int left = this.align == 4 ? size.width - stringWidth - 2 : 2;
                g.drawString(this.str, left, fm.getHeight() - 2);
            }
        }

        public void set(int align, String value, boolean isSelected) {
            this.align = align;
            this.str = value;
            this.isSelected = isSelected;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            return new Dimension(dim.width + 2, dim.height + 2);
        }
    }
}

