/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.dsl.chart;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.dsl.chart.Chart;
import org.kopi.galite.visual.dsl.chart.ChartMeasure;
import org.kopi.galite.visual.dsl.chart.DimensionData;
import org.kopi.galite.visual.dsl.exceptions.MissingMeasureException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0017\u0010\u0007\u001a\u00020\u0004\"\u0004\b\u0000\u0010\b*\u0002H\bH\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/kopi/galite/visual/dsl/chart/Formatter;", "", "()V", "encode", "", "chart", "Lorg/kopi/galite/visual/dsl/chart/Chart;", "quoteIfNecessary", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "galite-core"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/kopi/galite/visual/dsl/chart/Formatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1855#2,2:68\n1855#2:70\n1855#2,2:71\n1856#2:73\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/kopi/galite/visual/dsl/chart/Formatter\n*L\n34#1:68,2\n39#1:70\n43#1:71,2\n39#1:73\n*E\n"})
public final class Formatter {
    @NotNull
    public static final Formatter INSTANCE = new Formatter();

    private Formatter() {
    }

    @NotNull
    public final String encode(@NotNull Chart chart2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
        StringBuilder $this$encode_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$encode_u24lambda_u244.append("[[");
        $this$encode_u24lambda_u244.append(INSTANCE.quoteIfNecessary(chart2.getDimension().getLabel()));
        Iterable $this$forEach$iv = chart2.getMeasures();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChartMeasure it = (ChartMeasure)element$iv;
            boolean bl2 = false;
            $this$encode_u24lambda_u244.append(",");
            $this$encode_u24lambda_u244.append(INSTANCE.quoteIfNecessary(it.getLabel()));
        }
        $this$encode_u24lambda_u244.append("]");
        $this$forEach$iv = chart2.getDimension().getValues();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DimensionData dimensionValue = (DimensionData)element$iv;
            boolean bl3 = false;
            $this$encode_u24lambda_u244.append(",");
            $this$encode_u24lambda_u244.append("[");
            $this$encode_u24lambda_u244.append(INSTANCE.quoteIfNecessary(dimensionValue.getValue()));
            Iterable $this$forEach$iv2 = chart2.getMeasures();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ChartMeasure measure = (ChartMeasure)element$iv2;
                boolean bl4 = false;
                $this$encode_u24lambda_u244.append(",");
                Number number = dimensionValue.getMeasureList().get(measure);
                if (number == null) {
                    boolean bl5 = false;
                    throw new MissingMeasureException(measure, (Comparable<?>)dimensionValue.getValue());
                }
                $this$encode_u24lambda_u244.append(number);
            }
            $this$encode_u24lambda_u244.append("]");
        }
        $this$encode_u24lambda_u244.append("]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final <T> String quoteIfNecessary(T $this$quoteIfNecessary) {
        String stringRepresentation = String.valueOf($this$quoteIfNecessary);
        return !StringsKt.startsWith$default((String)stringRepresentation, (String)"\"", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)stringRepresentation, (String)"\"", (boolean)false, (int)2, null) ? "\"" + stringRepresentation + "\"" : stringRepresentation;
    }
}

