/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util;

import gnu.hylafax.HylaFAXClient;
import gnu.inet.ftp.ServerResponseException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.base.Utils;
import org.kopi.galite.visual.util.FaxException;
import org.kopi.galite.visual.util.FaxStatus;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016J6\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002J.\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ6\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002J,\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ,\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ,\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/kopi/galite/visual/util/HylaFAXUtils;", "", "()V", "HFX_DEFAULT_PORT", "", "getHFX_DEFAULT_PORT", "()I", "setHFX_DEFAULT_PORT", "(I)V", "HFX_DEFAULT_USER", "", "getHFX_DEFAULT_USER", "()Ljava/lang/String;", "setHFX_DEFAULT_USER", "(Ljava/lang/String;)V", "deleteJob", "", "host", "port", "user", "password", "job", "", "getQueue", "Ljava/util/ArrayList;", "qname", "killJob", "readDoneQueue", "Lorg/kopi/galite/visual/util/FaxStatus;", "readQueue", "readRecQueue", "readSendQueue", "readServerStatus", "galite-core"})
@SourceDebugExtension(value={"SMAP\nHylaFAXUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HylaFAXUtils.kt\norg/kopi/galite/visual/util/HylaFAXUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1855#2,2:229\n*S KotlinDebug\n*F\n+ 1 HylaFAXUtils.kt\norg/kopi/galite/visual/util/HylaFAXUtils\n*L\n189#1:229,2\n*E\n"})
public final class HylaFAXUtils {
    @NotNull
    public static final HylaFAXUtils INSTANCE = new HylaFAXUtils();
    private static int HFX_DEFAULT_PORT = 4559;
    @NotNull
    private static String HFX_DEFAULT_USER = "GALITE";

    private HylaFAXUtils() {
    }

    @NotNull
    public final ArrayList<FaxStatus> readSendQueue(@NotNull String host, int port, @NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.readQueue(host, port, user, password, "sendq");
    }

    @NotNull
    public final ArrayList<FaxStatus> readDoneQueue(@NotNull String host, int port, @NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.readQueue(host, port, user, password, "doneq");
    }

    @NotNull
    public final ArrayList<FaxStatus> readRecQueue(@NotNull String host, int port, @NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.readQueue(host, port, user, password, "recvq");
    }

    @NotNull
    public final ArrayList<String> readServerStatus(@NotNull String host, int port, @NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        ArrayList<String> status = null;
        try {
            status = this.getQueue(host, port, user, password, "status");
            Utils.Companion.log("Fax", "READ STATE : host " + host + " / user " + user);
        }
        catch (ConnectException e) {
            throw new FaxException("NO FAX SERVER");
        }
        catch (IOException e) {
            throw new FaxException("Trying read server state: " + e.getMessage(), e);
        }
        catch (ServerResponseException e) {
            throw new FaxException("Trying read server state: " + e.getMessage(), e);
        }
        return status;
    }

    public final void killJob(@NotNull String host, int port, @NotNull String user, @NotNull String password, long job) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        try {
            HylaFAXClient faxClient = new HylaFAXClient();
            faxClient.open(host);
            if (faxClient.user(user)) {
                faxClient.pass(password);
            }
            faxClient.jkill(job);
            Utils.Companion.log("Fax", "Kill 1: " + job);
            faxClient.quit();
        }
        catch (IOException ioe) {
            throw new FaxException(ioe);
        }
        catch (ServerResponseException sre) {
            throw new FaxException(sre);
        }
    }

    public final void deleteJob(@NotNull String host, int port, @NotNull String user, @NotNull String password, long job) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        try {
            HylaFAXClient faxClient = new HylaFAXClient();
            faxClient.open(host);
            if (faxClient.user(user)) {
                faxClient.pass(password);
            }
            faxClient.jdele(job);
            Utils.Companion.log("Fax", "Delete 1: " + job);
            faxClient.quit();
        }
        catch (IOException ioe) {
            throw new FaxException(ioe);
        }
        catch (ServerResponseException sre) {
            throw new FaxException(sre);
        }
    }

    private final ArrayList<String> getQueue(String host, int port, String user, String password, String qname) {
        HylaFAXClient faxClient = new HylaFAXClient();
        faxClient.open(host);
        if (faxClient.user(user)) {
            faxClient.pass(password);
        }
        faxClient.tzone("LOCAL");
        faxClient.rcvfmt("%f| %t| %s| %p| %h| %e");
        faxClient.jobfmt("%j| %J| %o| %e| %a| %P| %D| %.25s");
        faxClient.mdmfmt("Modem %m (%n): %s");
        ArrayList<String> entries = new ArrayList<String>(faxClient.getList(qname));
        faxClient.quit();
        return entries;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ArrayList<FaxStatus> readQueue(String host, int port, String user, String password, String qname) {
        ArrayList<FaxStatus> queue = new ArrayList<FaxStatus>();
        try {
            ArrayList<String> result = this.getQueue(host, port, user, password, qname);
            Utils.Companion.log("Fax", "READ " + qname + " : host " + host + " / user " + user);
            Iterable $this$forEach$iv = result;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String element = (String)element$iv;
                boolean bl = false;
                try {
                    StringTokenizer process = new StringTokenizer(element, "|");
                    if (!Intrinsics.areEqual((Object)qname, (Object)"recvq")) {
                        String string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextToken(...)");
                        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        String string3 = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"nextToken(...)");
                        String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                        String string5 = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"nextToken(...)");
                        String string6 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
                        String string7 = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"nextToken(...)");
                        String string8 = ((Object)StringsKt.trim((CharSequence)string7)).toString();
                        String string9 = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"nextToken(...)");
                        String string10 = ((Object)StringsKt.trim((CharSequence)string9)).toString();
                        String string11 = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"nextToken(...)");
                        String string12 = ((Object)StringsKt.trim((CharSequence)string11)).toString();
                        String string13 = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"nextToken(...)");
                        String string14 = ((Object)StringsKt.trim((CharSequence)string13)).toString();
                        String string15 = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"nextToken(...)");
                        queue.add(new FaxStatus(string2, string4, string6, string8, string10, string12, string14, ((Object)StringsKt.trim((CharSequence)string15)).toString()));
                        continue;
                    }
                    String string = process.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextToken(...)");
                    String string16 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    String string17 = process.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"nextToken(...)");
                    String string18 = ((Object)StringsKt.trim((CharSequence)string17)).toString();
                    String string19 = process.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"nextToken(...)");
                    String string20 = ((Object)StringsKt.trim((CharSequence)string19)).toString();
                    String string21 = process.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string21, (String)"nextToken(...)");
                    String string22 = ((Object)StringsKt.trim((CharSequence)string21)).toString();
                    String string23 = process.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"nextToken(...)");
                    String string24 = ((Object)StringsKt.trim((CharSequence)string23)).toString();
                    String string25 = process.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string25, (String)"nextToken(...)");
                    queue.add(new FaxStatus(string16, string18, string20, string22, string24, ((Object)StringsKt.trim((CharSequence)string25)).toString()));
                }
                catch (Exception e) {
                    String string = e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    throw new FaxException(string, e);
                    return queue;
                }
            }
        }
        catch (ConnectException e) {
            Utils.Companion.log("Fax", "NO FAX SERVER");
            throw new FaxException("NO FAX SERVER");
        }
        catch (IOException e) {
            throw new FaxException(e);
        }
        catch (ServerResponseException e) {
            throw new FaxException(e);
        }
    }

    public final int getHFX_DEFAULT_PORT() {
        return HFX_DEFAULT_PORT;
    }

    public final void setHFX_DEFAULT_PORT(int n) {
        HFX_DEFAULT_PORT = n;
    }

    @NotNull
    public final String getHFX_DEFAULT_USER() {
        return HFX_DEFAULT_USER;
    }

    public final void setHFX_DEFAULT_USER(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        HFX_DEFAULT_USER = string;
    }
}

