/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.dsl.form;

import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.dsl.form.FormField;
import org.kopi.galite.visual.dsl.form.FormPosition;
import org.kopi.galite.visual.form.VPosition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000bB-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u0000H\u0014J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0004R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/kopi/galite/visual/dsl/form/FormCoordinatePosition;", "Lorg/kopi/galite/visual/dsl/form/FormPosition;", "", "line", "", "endLine", "column", "endColumn", "(IIII)V", "chartPos", "(I)V", "(II)V", "(IIIII)V", "columnEnd", "lineEnd", "clone", "createRBPoint", "", "point", "Ljava/awt/Point;", "field", "Lorg/kopi/galite/visual/dsl/form/FormField;", "getChartPosition", "getColumn", "getColumnEnd", "getLine", "getLineEnd", "getPositionModel", "Lorg/kopi/galite/visual/form/VPosition;", "setChartPosition", "translate", "amount", "galite-core"})
public final class FormCoordinatePosition
extends FormPosition
implements Cloneable {
    private final int line;
    private int column;
    private int chartPos;
    private int lineEnd;
    private int columnEnd;

    public FormCoordinatePosition(int line, int endLine, int column, int endColumn, int chartPos) {
        this.line = line;
        this.column = column;
        this.chartPos = chartPos;
        this.lineEnd = endLine == 0 ? this.line : endLine;
        this.columnEnd = endColumn == 0 ? this.column : endColumn;
    }

    public FormCoordinatePosition(int line, int endLine, int column, int endColumn) {
        this(line, endLine, column, endColumn, -1);
    }

    public FormCoordinatePosition(int chartPos) {
        this(-1, -1, -1, -1, chartPos);
    }

    public FormCoordinatePosition(int line, int column) {
        this(line, line, column, column, -1);
    }

    public final void translate(int amount) {
        this.column += amount;
        this.columnEnd += amount;
        this.chartPos += amount;
    }

    @Override
    public void setChartPosition(int chartPos) {
        this.chartPos = chartPos;
    }

    @NotNull
    public FormCoordinatePosition clone() {
        return new FormCoordinatePosition(this.line, this.column);
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getColumnEnd() {
        return -1;
    }

    @Override
    public int getLineEnd() {
        return -1;
    }

    @Override
    public int getChartPosition() {
        return this.chartPos;
    }

    @Override
    public void createRBPoint(@NotNull Point point, @NotNull FormField<?> field) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(field, (String)"field");
        point.x = RangesKt.coerceAtLeast((int)point.x, (int)this.columnEnd);
        point.y = RangesKt.coerceAtLeast((int)point.y, (int)this.lineEnd);
    }

    @Override
    @NotNull
    public VPosition getPositionModel() {
        return new VPosition(this.line, this.lineEnd, this.column, this.columnEnd, this.chartPos);
    }
}

