/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.block;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.upload.AllFinishedEvent;
import com.vaadin.flow.component.upload.FailedEvent;
import com.vaadin.flow.component.upload.FinishedEvent;
import com.vaadin.flow.component.upload.ProgressUpdateEvent;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.StartedEvent;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.component.upload.receivers.MemoryBuffer;
import com.vaadin.flow.component.upload.receivers.MultiFileMemoryBuffer;
import com.vaadin.flow.dom.Element;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.ui.vaadin.form.DBlockDropHandler;

@CssImport(value="./styles/galite/dropwrapper.css", themeFor="vaadin-upload")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/block/BlockDropWrapper;", "Lcom/vaadin/flow/component/orderedlayout/VerticalLayout;", "layout", "Lcom/vaadin/flow/component/Component;", "dropHandler", "Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler;", "(Lcom/vaadin/flow/component/Component;Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler;)V", "buffer", "Lcom/vaadin/flow/component/upload/Receiver;", "getLayout", "()Lcom/vaadin/flow/component/Component;", "upload", "Lcom/vaadin/flow/component/upload/Upload;", "maybeReset", "", "galite-core"})
@SourceDebugExtension(value={"SMAP\nBlockDropWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockDropWrapper.kt\norg/kopi/galite/visual/ui/vaadin/block/BlockDropWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,83:1\n1549#2:84\n1620#2,3:85\n37#3,2:88\n*S KotlinDebug\n*F\n+ 1 BlockDropWrapper.kt\norg/kopi/galite/visual/ui/vaadin/block/BlockDropWrapper\n*L\n39#1:84\n39#1:85,3\n39#1:88,2\n*E\n"})
public final class BlockDropWrapper
extends VerticalLayout {
    @NotNull
    private final Component layout;
    @NotNull
    private final Receiver buffer;
    @NotNull
    private final Upload upload;

    /*
     * WARNING - void declaration
     */
    public BlockDropWrapper(@NotNull Component layout2, @NotNull DBlockDropHandler dropHandler) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)dropHandler, (String)"dropHandler");
        this.layout = layout2;
        this.buffer = dropHandler.isChartBlockContext$galite_core() ? (Receiver)new MultiFileMemoryBuffer() : (Receiver)new MemoryBuffer();
        this.upload = new Upload(this.buffer);
        VerticalLayout dropArea = new VerticalLayout();
        Iterable iterable = dropHandler.getAcceptedFlavors$galite_core();
        Upload upload2 = this.upload;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            collection.add("." + string2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        upload2.setAcceptedFileTypes(Arrays.copyOf(stringArray, stringArray.length));
        this.upload.getElement().getThemeList().add((Object)"drop-wrapper-upload");
        stringArray = new Component[]{this.layout};
        dropArea.add((Component[])stringArray);
        stringArray = new Element[]{dropArea.getElement()};
        this.upload.getElement().appendChild((Element[])stringArray);
        stringArray = new Component[]{this.upload};
        this.add((Component[])stringArray);
        this.upload.addStartedListener(arg_0 -> BlockDropWrapper._init_$lambda$1(dropHandler, arg_0));
        this.upload.addProgressListener(arg_0 -> BlockDropWrapper._init_$lambda$2(dropHandler, arg_0));
        this.upload.addFinishedListener(arg_0 -> BlockDropWrapper._init_$lambda$3(this, dropHandler, arg_0));
        this.upload.addFailedListener(arg_0 -> BlockDropWrapper._init_$lambda$4(dropHandler, arg_0));
        this.upload.addAllFinishedListener(arg_0 -> BlockDropWrapper._init_$lambda$5(dropHandler, this, arg_0));
    }

    @NotNull
    public final Component getLayout() {
        return this.layout;
    }

    private final void maybeReset() {
        if (!(this.buffer instanceof MultiFileMemoryBuffer)) {
            this.upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
        }
    }

    private static final void _init_$lambda$1(DBlockDropHandler $dropHandler, StartedEvent it) {
        Intrinsics.checkNotNullParameter((Object)$dropHandler, (String)"$dropHandler");
        $dropHandler.onStart();
        $dropHandler.getStreamHandler$galite_core().streamingStarted(it.getContentLength());
    }

    private static final void _init_$lambda$2(DBlockDropHandler $dropHandler, ProgressUpdateEvent it) {
        Intrinsics.checkNotNullParameter((Object)$dropHandler, (String)"$dropHandler");
        $dropHandler.getStreamHandler$galite_core().onProgress(it.getReadBytes(), it.getContentLength());
    }

    private static final void _init_$lambda$3(BlockDropWrapper this$0, DBlockDropHandler $dropHandler, FinishedEvent it) {
        OutputStream outputStream;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dropHandler, (String)"$dropHandler");
        if (this$0.buffer instanceof MultiFileMemoryBuffer) {
            outputStream = ((MultiFileMemoryBuffer)this$0.buffer).getOutputBuffer(it.getFileName());
        } else {
            Receiver receiver = this$0.buffer;
            Intrinsics.checkNotNull((Object)receiver, (String)"null cannot be cast to non-null type com.vaadin.flow.component.upload.receivers.MemoryBuffer");
            outputStream = ((MemoryBuffer)receiver).getFileData().getOutputBuffer();
        }
        OutputStream outputStream2 = outputStream;
        DBlockDropHandler.StreamHandler streamHandler = $dropHandler.getStreamHandler$galite_core();
        String string = it.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String string2 = it.getMIMEType();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMIMEType(...)");
        long l = it.getContentLength();
        Intrinsics.checkNotNull((Object)outputStream2, (String)"null cannot be cast to non-null type java.io.ByteArrayOutputStream");
        streamHandler.streamingFinished(string, string2, l, (ByteArrayOutputStream)outputStream2);
    }

    private static final void _init_$lambda$4(DBlockDropHandler $dropHandler, FailedEvent it) {
        Intrinsics.checkNotNullParameter((Object)$dropHandler, (String)"$dropHandler");
        DBlockDropHandler.StreamHandler streamHandler = $dropHandler.getStreamHandler$galite_core();
        String string = it.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String string2 = it.getMIMEType();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMIMEType(...)");
        long l = it.getContentLength();
        Exception exception = it.getReason();
        Intrinsics.checkNotNullExpressionValue((Object)exception, (String)"getReason(...)");
        streamHandler.streamingFailed(string, string2, l, exception);
    }

    private static final void _init_$lambda$5(DBlockDropHandler $dropHandler, BlockDropWrapper this$0, AllFinishedEvent it) {
        Intrinsics.checkNotNullParameter((Object)$dropHandler, (String)"$dropHandler");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        $dropHandler.onFinish(this$0.buffer);
        this$0.maybeReset();
    }
}

