/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.field;

import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyDownEvent;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.KeyPressEvent;
import com.vaadin.flow.component.KeyUpEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.textfield.Autocomplete;
import com.vaadin.flow.component.textfield.HasAutocomplete;
import com.vaadin.flow.component.textfield.HasPrefixAndSuffix;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.dom.DomEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.type.DefaultFormatKt;
import org.kopi.galite.visual.ui.vaadin.base.DecimalFormatSymbols;
import org.kopi.galite.visual.ui.vaadin.base.JSKeyDownHandler;
import org.kopi.galite.visual.ui.vaadin.base.ShortcutAction;
import org.kopi.galite.visual.ui.vaadin.field.DecimalValidator;
import org.kopi.galite.visual.ui.vaadin.field.EnumValidator;
import org.kopi.galite.visual.ui.vaadin.field.TextField;
import org.kopi.galite.visual.ui.vaadin.field.TextValidator;
import org.kopi.galite.visual.ui.vaadin.form.DField;
import org.kopi.galite.visual.ui.vaadin.main.MainWindow;
import org.kopi.galite.visual.ui.vaadin.window.Window;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b*\b\u0016\u0018\u0000*\u001c\b\u0000\u0010\u0001*\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002*\u0006\u0012\u0002\b\u00030\u00042\u00020\u00052\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0000\u0012\u0004\u0012\u00020\u00070\u00062\u00020\b2\u00020\t2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\n2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u00042\u00020\u000b2\u00020\f2\u00020\rB\u000f\b\u0000\u0012\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0007J\u001e\u0010>\u001a\u00020<2\u0014\u0010?\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030A0@H\u0016J\u0006\u0010B\u001a\u00020<J\u000e\u0010C\u001a\u00020<2\u0006\u0010D\u001a\u000203J\b\u0010E\u001a\u00020<H\u0004J\b\u0010F\u001a\u00020<H\u0016J\u0014\u0010G\u001a\u0004\u0018\u00010\u00072\b\u0010H\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u0004\u0018\u00010\u0007J\n\u0010L\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010M\u001a\u00020<2\u0006\u0010D\u001a\u000203H\u0004J\b\u0010N\u001a\u00020 H\u0016J\u0006\u0010O\u001a\u00020<J\r\u0010P\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\"J\u0006\u0010Q\u001a\u00020<J\b\u0010R\u001a\u00020<H\u0002J\b\u0010S\u001a\u00020<H\u0004J\u001c\u0010T\u001a\u00020<2\u0012\u0010U\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000VH\u0016J\u0012\u0010W\u001a\u00020<2\b\u0010X\u001a\u0004\u0018\u00010YH\u0014J\u001c\u0010Z\u001a\u00020<2\u0012\u0010U\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000[H\u0016J\u000e\u0010\\\u001a\u00020<2\u0006\u0010U\u001a\u00020]J\u000e\u0010^\u001a\u00020<2\u0006\u0010U\u001a\u00020_J\u000e\u0010`\u001a\u00020<2\u0006\u0010U\u001a\u00020aJ\u0010\u0010b\u001a\u00020<2\u0006\u0010U\u001a\u00020cH\u0002J\u0006\u0010d\u001a\u00020<J\b\u0010e\u001a\u00020<H\u0002J\b\u0010f\u001a\u00020<H\u0016J\u000e\u0010g\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0007J\u000e\u0010h\u001a\u00020 2\u0006\u0010i\u001a\u00020 J\u000e\u0010j\u001a\u00020<2\u0006\u0010\u0010\u001a\u000203J\u0010\u0010k\u001a\u00020<2\u0006\u0010l\u001a\u00020 H\u0007J\u000e\u0010m\u001a\u00020<2\u0006\u0010n\u001a\u00020 J\u000e\u0010o\u001a\u00020<2\u0006\u0010$\u001a\u00020 J\u001a\u0010p\u001a\u00020<2\b\u0010q\u001a\u0004\u0018\u00010\u00072\b\u0010r\u001a\u0004\u0018\u00010\u0007J\u000e\u0010s\u001a\u00020<2\u0006\u0010t\u001a\u00020 J\u0010\u0010u\u001a\u00020<2\u0006\u0010v\u001a\u00020 H\u0016J\u0010\u0010w\u001a\u00020<2\u0006\u0010i\u001a\u00020 H\u0016J\u000e\u0010x\u001a\u00020<2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010y\u001a\u00020<2\u0006\u0010z\u001a\u00020\u0007J\u0010\u0010{\u001a\u00020<2\u0006\u0010|\u001a\u000203H\u0016J\u0012\u0010}\u001a\u00020<2\b\u0010~\u001a\u0004\u0018\u00010\u0007H\u0014J\u0011\u0010\u007f\u001a\u00020<2\u0007\u0010\u0080\u0001\u001a\u00020 H\u0016J\u0011\u0010\u0081\u0001\u001a\u00020<2\b\u00109\u001a\u0004\u0018\u00010:J\u001a\u0010\u0082\u0001\u001a\u00020<2\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0003\b\u0084\u0001J\u0014\u0010\u0082\u0001\u001a\u00020<2\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u0085\u0001\u001a\u00020<2\u0007\u0010\u0086\u0001\u001a\u000203J\u0007\u0010\u0087\u0001\u001a\u00020<J\u001a\u0010\u0088\u0001\u001a\u00020<2\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0003\b\u008a\u0001J\u0012\u0010\u008b\u0001\u001a\u00020<2\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0007J\u0011\u0010\u008c\u0001\u001a\u00020<2\u0006\u0010|\u001a\u000203H\u0004R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010#\u001a\u0004\b!\u0010\"R\u000e\u0010$\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020 8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010&R$\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0013\u0010-\u001a\u0004\u0018\u00010.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00104\u001a\u0002032\u0006\u00102\u001a\u0002038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008d\u0001"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "C", "Lcom/vaadin/flow/component/AbstractField;", "", "Lcom/vaadin/flow/component/Focusable;", "Lcom/vaadin/flow/component/HasSize;", "Lcom/vaadin/flow/component/AbstractCompositeField;", "", "Lcom/vaadin/flow/component/KeyNotifier;", "Lcom/vaadin/flow/component/HasStyle;", "Lcom/vaadin/flow/component/BlurNotifier;", "Lcom/vaadin/flow/component/textfield/HasAutocomplete;", "Lcom/vaadin/flow/component/textfield/HasPrefixAndSuffix;", "Lorg/kopi/galite/visual/ui/vaadin/base/JSKeyDownHandler;", "internalField", "(Lcom/vaadin/flow/component/AbstractField;)V", "align", "connector", "Lorg/kopi/galite/visual/ui/vaadin/field/TextField;", "getConnector$galite_core", "()Lorg/kopi/galite/visual/ui/vaadin/field/TextField;", "currentText", "fieldConnector", "Lorg/kopi/galite/visual/ui/vaadin/form/DField;", "getFieldConnector$galite_core", "()Lorg/kopi/galite/visual/ui/vaadin/form/DField;", "focusedTextField", "getFocusedTextField", "()Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "setFocusedTextField", "(Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;)V", "hasAutocomplete", "", "getInternalField", "()Lcom/vaadin/flow/component/AbstractField;", "Lcom/vaadin/flow/component/AbstractField;", "isCheckingValue", "isNull", "()Z", "isWordwrap", "keyNavigators", "", "Lorg/kopi/galite/visual/ui/vaadin/base/ShortcutAction;", "getKeyNavigators", "()Ljava/util/Map;", "parentWindow", "Lorg/kopi/galite/visual/ui/vaadin/window/Window;", "getParentWindow", "()Lorg/kopi/galite/visual/ui/vaadin/window/Window;", "periodPressed", "value", "", "size", "getSize", "()I", "setSize", "(I)V", "validationStrategy", "Lorg/kopi/galite/visual/ui/vaadin/field/TextValidator;", "addStyleDependentName", "", "dependentClassName", "addTextValueChangeListener", "listener", "Lcom/vaadin/flow/component/HasValue$ValueChangeListener;", "Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;", "cancelKey", "checkValue", "rec", "clearServerStyles", "focus", "format", "s", "getMaxLength", "", "getSelectedText", "getValue", "handleEnumerationFields", "hasAutoComplete", "hideSuggestions", "initContent", "lazyHideSuggestions", "maybeCancelSuggestions", "maybeReplaceDecimalSeparator", "onBlur", "event", "Lcom/vaadin/flow/component/BlurNotifier$BlurEvent;", "onDetach", "detachEvent", "Lcom/vaadin/flow/component/DetachEvent;", "onFocus", "Lcom/vaadin/flow/component/FocusNotifier$FocusEvent;", "onKeyDown", "Lcom/vaadin/flow/component/KeyDownEvent;", "onKeyPress", "Lcom/vaadin/flow/component/KeyPressEvent;", "onKeyUp", "Lcom/vaadin/flow/component/KeyUpEvent;", "onPasteEvent", "Lcom/vaadin/flow/dom/DomEvent;", "refreshSuggestionList", "refreshSuggestions", "release", "removeStyleDependentName", "requestFocusInWindow", "focused", "setAlign", "setAnimationEnabled", "enable", "setBlink", "blink", "setCheckingValue", "setColor", "foreground", "background", "setDisplayModality", "modal", "setEnabled", "enabled", "setFocus", "setHasAutocomplete", "setInputType", "type", "setMaxLength", "maxLength", "setPresentationValue", "newPresentationValue", "setReadOnly", "readOnly", "setTextValidator", "setValue", "text", "setAnyValue", "setWidth", "width", "showSuggestionList", "showSuggestions", "query", "showSuggestions$galite_core", "updateFieldContent", "updateMaxLength", "galite-core"})
@SourceDebugExtension(value={"SMAP\nInputTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputTextField.kt\norg/kopi/galite/visual/ui/vaadin/field/InputTextField\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,841:1\n107#2:842\n79#2,22:843\n1855#3,2:865\n1855#3,2:867\n*S KotlinDebug\n*F\n+ 1 InputTextField.kt\norg/kopi/galite/visual/ui/vaadin/field/InputTextField\n*L\n135#1:842\n135#1:843,22\n151#1:865,2\n160#1:867,2\n*E\n"})
public class InputTextField<C extends AbstractField<?, ? extends Object>>
extends AbstractCompositeField<C, InputTextField<C>, String>
implements HasSize,
KeyNotifier,
HasStyle,
BlurNotifier<InputTextField<C>>,
Focusable<InputTextField<C>>,
HasAutocomplete,
HasPrefixAndSuffix,
JSKeyDownHandler {
    @NotNull
    private final C internalField;
    @Nullable
    private TextValidator validationStrategy;
    private boolean periodPressed;
    @Nullable
    private String currentText;
    @NotNull
    private final Map<String, ShortcutAction<?>> keyNavigators;
    private boolean hasAutocomplete;
    @Nullable
    private String align;
    private boolean isCheckingValue;
    @Nullable
    private InputTextField<?> focusedTextField;

    public InputTextField(@NotNull C internalField) {
        Intrinsics.checkNotNullParameter(internalField, (String)"internalField");
        super(null);
        this.internalField = internalField;
        this.keyNavigators = new LinkedHashMap();
        this.setClassName("k-textinput");
        this.addFocusListener(this::onFocus);
        this.getElement().setProperty("autoselect", true);
    }

    @NotNull
    protected final C getInternalField() {
        return this.internalField;
    }

    @Nullable
    public final Window getParentWindow() {
        return this.getFieldConnector$galite_core().getWindow$galite_core();
    }

    @Override
    @NotNull
    public Map<String, ShortcutAction<?>> getKeyNavigators() {
        return this.keyNavigators;
    }

    @Nullable
    public final InputTextField<?> getFocusedTextField() {
        return this.focusedTextField;
    }

    public final void setFocusedTextField(@Nullable InputTextField<?> inputTextField) {
        this.focusedTextField = inputTextField;
    }

    protected void setPresentationValue(@Nullable String newPresentationValue) {
        ((AbstractField)this.getContent()).setValue((Object)newPresentationValue);
    }

    public void addTextValueChangeListener(@NotNull HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<?, ?>> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.internalField.addValueChangeListener(listener);
    }

    @Nullable
    public String getValue() {
        return this.format(this.internalField.getValue());
    }

    private final String format(Object s) {
        String string;
        Object object = s;
        if (object instanceof LocalDate) {
            string = DefaultFormatKt.format((LocalDate)((LocalDate)s));
        } else if (object instanceof BigDecimal) {
            string = DefaultFormatKt.format((BigDecimal)((BigDecimal)s));
        } else if (object instanceof LocalTime) {
            string = DefaultFormatKt.format((LocalTime)((LocalTime)s));
        } else if (object instanceof Instant) {
            string = DefaultFormatKt.format((Instant)((Instant)s));
        } else {
            Object object2 = s;
            string = object2 != null ? object2.toString() : null;
        }
        return string;
    }

    @NotNull
    protected C initContent() {
        return this.internalField;
    }

    public final void onKeyPress(@NotNull KeyPressEvent event) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getKey(), (Object)Key.CONTROL) || Intrinsics.areEqual((Object)event.getKey(), (Object)Key.ALT) || Intrinsics.areEqual((Object)event.getKey(), (Object)Key.META)) break block11;
                List list = event.getKey().getKeys();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
                String string = String.valueOf(CollectionsKt.first((List)list));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"valueOf(...)");
                String $this$trim$iv = string;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) || event.getKey() == Key.SPACE) break block12;
            }
            return;
        }
        if (this.getSelectedText() != null && StringsKt.equals$default((String)this.getSelectedText(), (String)this.getValue(), (boolean)false, (int)2, null) && this.validationStrategy != null && this.validationStrategy instanceof EnumValidator) {
            List list = event.getKey().getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                TextValidator textValidator = this.validationStrategy;
                Intrinsics.checkNotNull((Object)textValidator);
                if (textValidator.validate(it)) continue;
                this.cancelKey();
            }
            return;
        }
        if (this.validationStrategy != null) {
            List list = event.getKey().getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                TextValidator textValidator = this.validationStrategy;
                Intrinsics.checkNotNull((Object)textValidator);
                if (textValidator.validate(this.getValue() + it)) continue;
                this.cancelKey();
            }
        }
        if (event.getKey().matches(".")) {
            this.periodPressed = true;
        }
    }

    @Nullable
    public final String getSelectedText() {
        return null;
    }

    public final void cancelKey() {
    }

    private final void onPasteEvent(DomEvent event) {
        if (this.validationStrategy != null) {
            String before = this.getValue();
            TextValidator textValidator = this.validationStrategy;
            Intrinsics.checkNotNull((Object)textValidator);
            if (!textValidator.validate(this.getValue())) {
                this.setValue(before);
            }
        }
    }

    @JvmName(name="setAnyValue")
    public final void setAnyValue(@Nullable Object text) {
        this.setValue(this.format(text));
    }

    public void setValue(@Nullable String text) {
        String text2 = text;
        if (text2 == null) {
            text2 = "";
        }
        this.setPresentationValue(text2);
    }

    public final void setColor(@Nullable String foreground, @Nullable String background) {
        if ((foreground == null || ((CharSequence)foreground).length() == 0) && (background == null || ((CharSequence)background).length() == 0)) {
            this.clearServerStyles();
        }
        this.getStyle().set("text-align", this.align);
        if (foreground != null && ((CharSequence)foreground).length() > 0) {
            this.getStyle().set("color", foreground + " !important");
        }
        if (background != null && ((CharSequence)background).length() > 0) {
            this.getStyle().set("background-color", background + " !important");
        }
    }

    protected final void clearServerStyles() {
        String string = this.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
        String[] stringArray = new String[]{"\\s"};
        for (String style : StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            if (!StringsKt.endsWith$default((String)style, (String)("-" + this.getFieldConnector$galite_core().getPosition()), (boolean)false, (int)2, null)) continue;
            this.removeClassName(style);
        }
    }

    public final void setAlign(int align) {
        if (this.internalField instanceof com.vaadin.flow.component.textfield.TextField) {
            switch (align) {
                case 4: {
                    TextFieldVariant[] textFieldVariantArray = new TextFieldVariant[]{TextFieldVariant.LUMO_ALIGN_RIGHT};
                    ((com.vaadin.flow.component.textfield.TextField)this.internalField).addThemeVariants(textFieldVariantArray);
                    break;
                }
                case 0: {
                    TextFieldVariant[] textFieldVariantArray = new TextFieldVariant[]{TextFieldVariant.LUMO_ALIGN_CENTER};
                    ((com.vaadin.flow.component.textfield.TextField)this.internalField).addThemeVariants(textFieldVariantArray);
                }
            }
        }
    }

    public boolean hasAutoComplete() {
        return this.hasAutocomplete;
    }

    public final void setTextValidator(@Nullable TextValidator validationStrategy) {
        this.validationStrategy = validationStrategy;
    }

    public final void setWidth(int width) {
        this.setWidth(width + "ex");
    }

    public double getMaxLength() {
        return this.getElement().getProperty("maxlength", 0.0);
    }

    public void setMaxLength(int maxLength) {
        this.updateMaxLength(maxLength);
    }

    public int getSize() {
        String string = this.internalField.getElement().getProperty("size");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return Integer.parseInt(string);
    }

    public void setSize(int value) {
        this.getElement().setProperty("size", String.valueOf(value));
    }

    protected final void updateMaxLength(int maxLength) {
        if (maxLength >= 0) {
            this.getElement().setProperty("maxlength", (double)maxLength);
        } else {
            this.getElement().removeAttribute("maxLength");
        }
    }

    public final void setBlink(boolean blink) {
        if (blink) {
            this.addStyleDependentName("blink");
        } else {
            this.removeStyleDependentName("blink");
        }
    }

    public final void updateFieldContent(@Nullable String text) {
        this.setValue(text);
    }

    protected final void handleEnumerationFields(int rec) {
    }

    protected final boolean isWordwrap() {
        String string = this.getElement().getAttribute("wrap");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
        String wrap = string;
        return !Intrinsics.areEqual((Object)"off", (Object)wrap);
    }

    public final void setCheckingValue(boolean isCheckingValue) {
        this.isCheckingValue = isCheckingValue;
    }

    public final void onKeyUp(@NotNull KeyUpEvent event) {
        Key key;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.hasAutocomplete && !(((((((((((Intrinsics.areEqual((Object)(key = event.getKey()), (Object)Key.ARROW_DOWN) ? true : Intrinsics.areEqual((Object)key, (Object)Key.PAGE_DOWN)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.ARROW_UP)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.PAGE_UP)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.ARROW_LEFT)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.ARROW_RIGHT)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.ENTER)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.TAB)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.SHIFT)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.CONTROL)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.ALT)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.ESCAPE))) {
            this.refreshSuggestions();
        }
        if (this.periodPressed) {
            this.maybeReplaceDecimalSeparator();
            this.periodPressed = false;
        }
    }

    protected final void maybeReplaceDecimalSeparator() {
        if (this.validationStrategy instanceof DecimalValidator) {
            String string = this.getValue();
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)".", (boolean)false, (int)2, null)) {
                DecimalFormatSymbols dfs;
                DecimalFormatSymbols decimalFormatSymbols = dfs = DecimalFormatSymbols.Companion.get(MainWindow.Companion.getLocale());
                Intrinsics.checkNotNull((Object)decimalFormatSymbols);
                if (decimalFormatSymbols.getDecimalSeparator() != '.') {
                    String string2 = this.getValue();
                    this.setValue(string2 != null ? StringsKt.replace$default((String)string2, (char)'.', (char)dfs.getDecimalSeparator(), (boolean)false, (int)4, null) : null);
                }
            }
        }
    }

    public final void onKeyDown(@NotNull KeyDownEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public final boolean requestFocusInWindow(boolean focused) {
        if (Intrinsics.areEqual(this.focusedTextField, (Object)this)) {
            return true;
        }
        this.focus();
        this.setFocus(focused);
        return false;
    }

    public void setFocus(boolean focused) {
        if (focused) {
            this.focus();
        } else {
            this.blur();
        }
    }

    public void focus() {
        ((Focusable)this.internalField).focus();
    }

    public void onBlur(@NotNull BlurNotifier.BlurEvent<InputTextField<C>> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (this.focusedTextField != this || this.focusedTextField == null) {
            return;
        }
        this.removeStyleDependentName("focus");
        this.focusedTextField = null;
        this.lazyHideSuggestions();
    }

    public void onFocus(@NotNull FocusNotifier.FocusEvent<InputTextField<C>> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual(this.focusedTextField, (Object)this)) {
            return;
        }
        this.focusedTextField = this;
        this.addStyleDependentName("focus");
        this.maybeCancelSuggestions();
    }

    protected void onDetach(@Nullable DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        if (Intrinsics.areEqual(this.focusedTextField, (Object)this)) {
            this.focusedTextField = null;
        }
    }

    public void setReadOnly(boolean readOnly) {
        boolean wasReadOnly = this.isReadOnly();
        if (readOnly) {
            this.setTabIndex(-1);
        } else if (wasReadOnly && !readOnly && this.getTabIndex() == -1) {
            this.setTabIndex(0);
        }
        super.setReadOnly(readOnly);
    }

    private final void maybeCancelSuggestions() {
        if (this.getValue() != null) {
            String string = this.getValue();
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() == 0) {
                // empty if block
            }
        }
    }

    @NotNull
    public final TextField getConnector$galite_core() {
        Object t = super.getParent().get();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.field.TextField");
        return (TextField)((Object)t);
    }

    public final void checkValue(int rec) {
        this.isCheckingValue = true;
        if (this.validationStrategy != null) {
            String string;
            TextValidator textValidator = this.validationStrategy;
            Intrinsics.checkNotNull((Object)textValidator);
            if (this.getValue() == null) {
                string = "";
            } else {
                String string2 = this.getValue();
                Intrinsics.checkNotNull((Object)string2);
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            }
            textValidator.checkType(this, string);
        }
        this.isCheckingValue = false;
    }

    private final void refreshSuggestions() {
        String text = this.getValue();
        if (text == null || ((CharSequence)text).length() == 0 || (double)text.length() == this.getMaxLength()) {
            this.hideSuggestions();
        } else {
            this.currentText = text;
        }
        this.showSuggestions$galite_core(text);
    }

    public final void hideSuggestions() {
    }

    public final void lazyHideSuggestions() {
    }

    @NotNull
    public final DField getFieldConnector$galite_core() {
        return this.getConnector$galite_core().getFieldParent();
    }

    public final boolean isNull() {
        return this.getValue() == null || Intrinsics.areEqual((Object)"", (Object)this.getValue());
    }

    public final void showSuggestions$galite_core(@Nullable String query) {
        if (!this.hasAutocomplete) {
            return;
        }
    }

    public final void refreshSuggestionList() {
        if (this.isAttached() && this.hasAutocomplete) {
            this.refreshSuggestions();
        }
    }

    public final void showSuggestionList() {
        if (this.isAttached() && this.hasAutocomplete) {
            this.currentText = null;
            this.refreshSuggestions();
        }
    }

    public final void setDisplayModality(boolean modal) {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public void release() {
        this.validationStrategy = null;
        this.currentText = null;
        this.align = null;
    }

    @Deprecated(message="use {@link DefaultSuggestionDisplay#setAnimationEnabled(boolean)} instead")
    public final void setAnimationEnabled(boolean enable) {
    }

    public final void setHasAutocomplete(boolean hasAutocomplete) {
        this.hasAutocomplete = hasAutocomplete;
        this.setAutocomplete(this.hasAutoComplete() ? Autocomplete.ON : Autocomplete.OFF);
    }

    public final void setInputType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.getElement().getNode().runWhenAttached(arg_0 -> InputTextField.setInputType$lambda$3(this, type, arg_0));
    }

    public final void addStyleDependentName(@NotNull String dependentClassName) {
        Intrinsics.checkNotNullParameter((Object)dependentClassName, (String)"dependentClassName");
        if (this.getClassName() != null) {
            this.getElement().getClassList().add((Object)("k-textinput-" + dependentClassName));
        }
    }

    public final void removeStyleDependentName(@NotNull String dependentClassName) {
        Intrinsics.checkNotNullParameter((Object)dependentClassName, (String)"dependentClassName");
        if (this.getClassName() != null) {
            this.getElement().getClassList().remove((Object)("k-textinput-" + dependentClassName));
        }
    }

    @Override
    @ClientCallable
    public void onKeyDown(@NotNull String key, @Nullable String value) {
        JSKeyDownHandler.DefaultImpls.onKeyDown(this, key, value);
    }

    private static final void setInputType$lambda$3(InputTextField this$0, String $type, UI ui) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Serializable[] serializableArray = new Serializable[]{this$0, $type};
        ui.getPage().executeJs("$0.focusElement.type=$1", serializableArray);
    }
}

