/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.field;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.dependency.CssImport;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.base.JSUtilsKt;
import org.kopi.galite.visual.ui.vaadin.base.ShortcutAction;
import org.kopi.galite.visual.ui.vaadin.field.AbstractField;
import org.kopi.galite.visual.ui.vaadin.field.FocusableWysiwygE;
import org.kopi.galite.visual.ui.vaadin.form.DRichTextEditor;

@CssImport(value="./styles/galite/richtext.css")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000 C2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0002CDB5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0016J7\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&\"\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0002\u00a2\u0006\u0002\u0010)J\u001c\u0010*\u001a\u00020\u001f2\u0014\u0010+\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030-0,J\u0015\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b0J\u0018\u00101\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0004H\u0004J\b\u00102\u001a\u00020\u0002H\u0004J\b\u00103\u001a\u00020\u001fH\u0002J\b\u00104\u001a\u00020\u001fH\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020\u0002H\u0004J\n\u00108\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u00109\u001a\u00020\bH\u0016J\b\u0010:\u001a\u00020\bH\u0016J\u0012\u0010;\u001a\u00020\u001f2\b\u0010<\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010=\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020\bH\u0016J\u0010\u0010?\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020\bH\u0016J\u0012\u0010A\u001a\u00020\u001f2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0016\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000f\"\u0004\b\u001d\u0010\u0011\u00a8\u0006E"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/RichTextField;", "Lorg/kopi/galite/visual/ui/vaadin/field/AbstractField;", "", "col", "", "rows", "visibleRows", "noEdit", "", "locale", "Ljava/util/Locale;", "parent", "Lorg/kopi/galite/visual/ui/vaadin/form/DRichTextEditor;", "(IIIZLjava/util/Locale;Lorg/kopi/galite/visual/ui/vaadin/form/DRichTextEditor;)V", "getCol", "()I", "setCol", "(I)V", "editor", "Lorg/kopi/galite/visual/ui/vaadin/field/FocusableWysiwygE;", "isNull", "isNull$galite_core", "()Z", "getNoEdit", "setNoEdit", "(Z)V", "getParent", "()Lorg/kopi/galite/visual/ui/vaadin/form/DRichTextEditor;", "getRows", "setRows", "addFocusListener", "", "function", "Lkotlin/Function0;", "addKeyNavigator", "key", "Lcom/vaadin/flow/component/Key;", "modifiers", "", "Lcom/vaadin/flow/component/KeyModifier;", "navigationAction", "(Lcom/vaadin/flow/component/Key;[Lcom/vaadin/flow/component/KeyModifier;Lkotlin/jvm/functions/Function0;)V", "addTextValueChangeListener", "l", "Lcom/vaadin/flow/component/HasValue$ValueChangeListener;", "Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;", "checkValue", "rec", "checkValue$galite_core", "createConfiguration", "createEditorToolbarGroups", "createNavigatorKeys", "focus", "getContent", "Lcom/vaadin/flow/component/Component;", "getRemovedToolbarButtons", "getValue", "isReadOnly", "isRequiredIndicatorVisible", "setPresentationValue", "newPresentationValue", "setReadOnly", "readOnly", "setRequiredIndicatorVisible", "requiredIndicatorVisible", "setValue", "value", "Companion", "NavigationAction", "galite-core"})
public final class RichTextField
extends AbstractField<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int col;
    private int rows;
    private boolean noEdit;
    @NotNull
    private final DRichTextEditor parent;
    @NotNull
    private final FocusableWysiwygE editor;
    private static final int MIN_WIDTH = 540;
    private static final int LINE_HEIGHT = 20;
    private static final int TOOLBAR_HEIGHT = 66;

    public RichTextField(int col, int rows, int visibleRows, boolean noEdit, @NotNull Locale locale, @NotNull DRichTextEditor parent) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.col = col;
        this.rows = rows;
        this.noEdit = noEdit;
        this.parent = parent;
        this.editor = new FocusableWysiwygE(true);
        this.editor.setClassName("richtext");
        this.editor.setPlaceholder("");
        Component[] componentArray = new Component[]{this.editor};
        this.add(componentArray);
        this.editor.setHeight(66 + 20 * visibleRows, com.vaadin.flow.component.Unit.PIXELS);
        this.editor.setReadOnly(this.noEdit);
        if (8 * this.col < 540) {
            this.editor.setWidth(540.0f, com.vaadin.flow.component.Unit.PIXELS);
        } else {
            this.editor.setWidth(8 * this.col, com.vaadin.flow.component.Unit.PIXELS);
        }
        this.createNavigatorKeys();
        JSUtilsKt.addJSKeyDownListener((Component)this.editor, this.editor.getKeyNavigators());
    }

    public final int getCol() {
        return this.col;
    }

    public final void setCol(int n) {
        this.col = n;
    }

    public final int getRows() {
        return this.rows;
    }

    public final void setRows(int n) {
        this.rows = n;
    }

    public final boolean getNoEdit() {
        return this.noEdit;
    }

    public final void setNoEdit(boolean bl) {
        this.noEdit = bl;
    }

    @NotNull
    public final DRichTextEditor getParent() {
        return this.parent;
    }

    protected final void createConfiguration(@NotNull Locale locale, int visibleRows) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
    }

    @NotNull
    protected final String createEditorToolbarGroups() {
        StringBuilder stringBuilder;
        StringBuilder $this$createEditorToolbarGroups_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createEditorToolbarGroups_u24lambda_u240.append("[");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi', 'paragraph' ] },");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'clipboard', groups: [ 'clipboard', 'undo' ] },");
        $this$createEditorToolbarGroups_u24lambda_u240.append("'/',");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'styles', groups: [ 'styles' ] },");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'links', groups: [ 'links' ] },");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'colors', groups: [ 'colors' ] },");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'insert', groups: [ 'insert' ] },");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'document', groups: [ 'mode', 'document', 'doctools' ] },");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'editing', groups: [ 'find', 'selection', 'spellchecker', 'editing' ] },");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'forms', groups: [ 'forms' ] },");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'tools', groups: [ 'tools' ] },");
        $this$createEditorToolbarGroups_u24lambda_u240.append("'/',");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'others', groups: [ 'others' ] },");
        $this$createEditorToolbarGroups_u24lambda_u240.append("{ name: 'about', groups: [ 'about' ] }");
        $this$createEditorToolbarGroups_u24lambda_u240.append("]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    protected final String getRemovedToolbarButtons() {
        return "'Blockquote,CreateDiv,BidiLtr,BidiRtl,Language,Source,Save,Templates,NewPage,Preview,Print,Anchor,Flash,Smiley,PageBreak,Iframe,PasteFromWord,PasteText,Paste,ImageButton,Button,Select,Textarea,TextField,Radio,Checkbox,HiddenField,Form,Styles,About,Replace,SelectAll,RemoveFormat,CopyFormatting,ShowBlocks'";
    }

    public void setReadOnly(boolean readOnly) {
        this.editor.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.editor.isReadOnly();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        this.editor.setRequiredIndicatorVisible(requiredIndicatorVisible);
    }

    public boolean isRequiredIndicatorVisible() {
        return this.editor.isRequiredIndicatorVisible();
    }

    public final void addTextValueChangeListener(@NotNull HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<?, ?>> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        this.editor.addValueChangeListener(l);
    }

    protected void setPresentationValue(@Nullable String newPresentationValue) {
        this.editor.setValue(newPresentationValue);
    }

    @Override
    @Nullable
    public String getValue() {
        return (String)this.editor.getValue();
    }

    @Override
    public void setValue(@Nullable String value) {
        this.editor.setValue(value);
    }

    @Override
    public boolean isNull$galite_core() {
        return this.getValue() == null;
    }

    @Override
    public void checkValue$galite_core(int rec) {
    }

    @Override
    public void addFocusListener(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.editor.addFocusListener(arg_0 -> RichTextField.addFocusListener$lambda$1(function, arg_0));
    }

    @Override
    public void focus() {
        this.editor.focus();
    }

    @Override
    @NotNull
    public Component getContent() {
        return (Component)this.editor;
    }

    private final void createNavigatorKeys() {
        Key key = Key.ENTER;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"ENTER");
        KeyModifier[] keyModifierArray = new KeyModifier[1];
        Intrinsics.checkNotNullExpressionValue((Object)KeyModifier.of((String)"Control"), (String)"of(...)");
        this.addKeyNavigator(key, keyModifierArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RichTextField this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getParent().gotoNextEmptyMustfill();
            }
        }));
        Key key2 = Key.ENTER;
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"ENTER");
        keyModifierArray = new KeyModifier[1];
        Intrinsics.checkNotNullExpressionValue((Object)KeyModifier.of((String)"Shift"), (String)"of(...)");
        this.addKeyNavigator(key2, keyModifierArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RichTextField this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getParent().onGotoNextBlock();
            }
        }));
        Key key3 = Key.PAGE_DOWN;
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"PAGE_DOWN");
        keyModifierArray = new KeyModifier[1];
        Intrinsics.checkNotNullExpressionValue((Object)KeyModifier.of((String)"Shift"), (String)"of(...)");
        this.addKeyNavigator(key3, keyModifierArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RichTextField this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getParent().gotoNextRecord();
            }
        }));
        Key key4 = Key.PAGE_UP;
        Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"PAGE_UP");
        keyModifierArray = new KeyModifier[1];
        Intrinsics.checkNotNullExpressionValue((Object)KeyModifier.of((String)"Shift"), (String)"of(...)");
        this.addKeyNavigator(key4, keyModifierArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RichTextField this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getParent().gotoPrevRecord();
            }
        }));
        Key key5 = Key.HOME;
        Intrinsics.checkNotNullExpressionValue((Object)key5, (String)"HOME");
        keyModifierArray = new KeyModifier[1];
        Intrinsics.checkNotNullExpressionValue((Object)KeyModifier.of((String)"Shift"), (String)"of(...)");
        this.addKeyNavigator(key5, keyModifierArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RichTextField this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getParent().gotoFirstRecord();
            }
        }));
        Key key6 = Key.END;
        Intrinsics.checkNotNullExpressionValue((Object)key6, (String)"END");
        keyModifierArray = new KeyModifier[1];
        Intrinsics.checkNotNullExpressionValue((Object)KeyModifier.of((String)"Shift"), (String)"of(...)");
        this.addKeyNavigator(key6, keyModifierArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RichTextField this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getParent().gotoLastRecord();
            }
        }));
        Key key7 = Key.TAB;
        Intrinsics.checkNotNullExpressionValue((Object)key7, (String)"TAB");
        keyModifierArray = new KeyModifier[1];
        Intrinsics.checkNotNullExpressionValue((Object)KeyModifier.of((String)"Shift"), (String)"of(...)");
        this.addKeyNavigator(key7, keyModifierArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RichTextField this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getParent().gotoPrevField();
            }
        }));
        Key key8 = Key.TAB;
        Intrinsics.checkNotNullExpressionValue((Object)key8, (String)"TAB");
        this.addKeyNavigator(key8, new KeyModifier[0], (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RichTextField this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getParent().gotoNextField();
            }
        }));
        Key key9 = Key.ARROW_UP;
        Intrinsics.checkNotNullExpressionValue((Object)key9, (String)"ARROW_UP");
        keyModifierArray = new KeyModifier[1];
        Intrinsics.checkNotNullExpressionValue((Object)KeyModifier.of((String)"Shift"), (String)"of(...)");
        this.addKeyNavigator(key9, keyModifierArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RichTextField this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getParent().gotoPrevField();
            }
        }));
        Key key10 = Key.ARROW_DOWN;
        Intrinsics.checkNotNullExpressionValue((Object)key10, (String)"ARROW_DOWN");
        keyModifierArray = new KeyModifier[1];
        Intrinsics.checkNotNullExpressionValue((Object)KeyModifier.of((String)"Shift"), (String)"of(...)");
        this.addKeyNavigator(key10, keyModifierArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RichTextField this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getParent().gotoNextField();
            }
        }));
    }

    private final void addKeyNavigator(Key key, KeyModifier[] modifiers, Function0<Unit> navigationAction) {
        NavigationAction navigator = new NavigationAction(this, key, modifiers, navigationAction);
        String keyNavigator = navigator.getKey();
        this.editor.getKeyNavigators().put(keyNavigator, navigator);
    }

    private static final void addFocusListener$lambda$1(Function0 $function, FocusNotifier.FocusEvent it) {
        Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
        $function.invoke();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/RichTextField$Companion;", "", "()V", "LINE_HEIGHT", "", "MIN_WIDTH", "TOOLBAR_HEIGHT", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/RichTextField$NavigationAction;", "Lorg/kopi/galite/visual/ui/vaadin/base/ShortcutAction;", "Lorg/kopi/galite/visual/ui/vaadin/field/RichTextField;", "field", "key", "Lcom/vaadin/flow/component/Key;", "modifiers", "", "Lcom/vaadin/flow/component/KeyModifier;", "navigationAction", "Lkotlin/Function0;", "", "(Lorg/kopi/galite/visual/ui/vaadin/field/RichTextField;Lorg/kopi/galite/visual/ui/vaadin/field/RichTextField;Lcom/vaadin/flow/component/Key;[Lcom/vaadin/flow/component/KeyModifier;Lkotlin/jvm/functions/Function0;)V", "performAction", "eagerValue", "", "galite-core"})
    public final class NavigationAction
    extends ShortcutAction<RichTextField> {
        public NavigationAction(@NotNull RichTextField field, @NotNull Key key, @NotNull KeyModifier[] modifiers, Function0<Unit> navigationAction) {
            Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
            Intrinsics.checkNotNullParameter(navigationAction, (String)"navigationAction");
            super((Component)field, key, modifiers, navigationAction);
        }

        @Override
        public void performAction(@Nullable String eagerValue) {
            String oldValue = ((RichTextField)((Object)this.getField())).getValue();
            if (!Intrinsics.areEqual((Object)oldValue, (Object)eagerValue)) {
                ((RichTextField)((Object)this.getField())).setValue(eagerValue);
                RichTextField.this.getParent().valueChanged();
            }
            this.getNavigationAction().invoke();
        }
    }
}

