/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.pivottable;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.CssImport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.VWindow;
import org.kopi.galite.visual.dsl.pivottable.Dimension;
import org.kopi.galite.visual.pivottable.MPivotTable;
import org.kopi.galite.visual.pivottable.UPivotTable;
import org.kopi.galite.visual.pivottable.VPivotTable;
import org.kopi.galite.visual.pivottable.VPivotTableColumn;
import org.kopi.galite.visual.pivottable.VPivotTableRow;
import org.kopi.galite.visual.ui.vaadin.visual.DWindow;
import org.vaadin.addons.componentfactory.PivotTable;

@CssImport(value="./styles/galite/pivottable.css")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/pivottable/DPivotTable;", "Lorg/kopi/galite/visual/ui/vaadin/visual/DWindow;", "Lorg/kopi/galite/visual/pivottable/UPivotTable;", "pivotTable", "Lorg/kopi/galite/visual/pivottable/VPivotTable;", "(Lorg/kopi/galite/visual/pivottable/VPivotTable;)V", "columns", "", "", "model", "Lorg/kopi/galite/visual/pivottable/MPivotTable;", "pivotData", "Lorg/vaadin/addons/componentfactory/PivotTable$PivotData;", "pivotOptions", "Lorg/vaadin/addons/componentfactory/PivotTable$PivotOptions;", "rows", "rowsValues", "build", "", "buildRows", "getValueAt", "columnIndex", "", "rowIndex", "run", "galite-core"})
@SourceDebugExtension(value={"SMAP\nDPivotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DPivotTable.kt\norg/kopi/galite/visual/ui/vaadin/pivottable/DPivotTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,109:1\n1855#2,2:110\n37#3,2:112\n37#3,2:114\n37#3,2:116\n*S KotlinDebug\n*F\n+ 1 DPivotTable.kt\norg/kopi/galite/visual/ui/vaadin/pivottable/DPivotTable\n*L\n55#1:110,2\n70#1:112,2\n71#1:114,2\n83#1:116,2\n*E\n"})
public final class DPivotTable
extends DWindow
implements UPivotTable {
    @NotNull
    private final VPivotTable pivotTable;
    @NotNull
    private final MPivotTable model;
    @NotNull
    private final PivotTable.PivotData pivotData;
    @NotNull
    private final PivotTable.PivotOptions pivotOptions;
    @NotNull
    private final List<String> rowsValues;
    @NotNull
    private final List<String> rows;
    @NotNull
    private final List<String> columns;

    public DPivotTable(@NotNull VPivotTable pivotTable2) {
        Intrinsics.checkNotNullParameter((Object)pivotTable2, (String)"pivotTable");
        super(pivotTable2);
        this.pivotTable = pivotTable2;
        this.model = this.pivotTable.getModel();
        this.pivotData = new PivotTable.PivotData();
        this.pivotOptions = new PivotTable.PivotOptions();
        this.rowsValues = new ArrayList();
        this.rows = new ArrayList();
        this.columns = new ArrayList();
        VWindow vWindow = this.getModel();
        Intrinsics.checkNotNull((Object)vWindow);
        vWindow.setDisplay(this);
    }

    @Override
    public void run() {
        this.pivotTable.initPivotTable();
        this.pivotTable.setMenu();
    }

    @Override
    public void build() {
        String[] $this$forEach$iv = (String[])this.model.getColumns();
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            VPivotTableColumn it = (VPivotTableColumn)t;
            boolean bl = false;
            VPivotTableColumn vPivotTableColumn = it;
            VPivotTableColumn vPivotTableColumn2 = it;
            this.pivotData.addColumn(vPivotTableColumn != null ? vPivotTableColumn.getLabel() : null, vPivotTableColumn2 != null ? vPivotTableColumn2.getClass() : null);
            VPivotTableColumn vPivotTableColumn3 = it;
            if ((vPivotTableColumn3 != null ? vPivotTableColumn3.getPosition() : null) == Dimension.Position.ROW) {
                this.rows.add(it.getLabel());
            }
            VPivotTableColumn vPivotTableColumn4 = it;
            if ((vPivotTableColumn4 != null ? vPivotTableColumn4.getPosition() : null) != Dimension.Position.COLUMN) continue;
            this.columns.add(it.getLabel());
        }
        this.buildRows();
        CollectionsKt.chunked((Iterable)this.rowsValues, (int)((Collection)this.model.getColumns()).size(), (Function1)((Function1)new Function1<List<? extends String>, Unit>(this){
            final /* synthetic */ DPivotTable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<String> rows) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(rows, (String)"rows");
                Iterable iterable = rows;
                PivotTable.PivotData pivotData = DPivotTable.access$getPivotData$p(this.this$0);
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it);
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                pivotData.addRow((Object[])Arrays.copyOf(stringArray, stringArray.length));
            }
        }));
        Collection $this$toTypedArray$iv = this.rows;
        boolean $i$f$toTypedArray = false;
        Collection collection = $this$toTypedArray$iv;
        $this$forEach$iv = collection.toArray(new String[0]);
        this.pivotOptions.setRows(Arrays.copyOf($this$forEach$iv, $this$forEach$iv.length));
        $this$toTypedArray$iv = this.columns;
        $i$f$toTypedArray = false;
        Collection collection2 = $this$toTypedArray$iv;
        $this$forEach$iv = collection2.toArray(new String[0]);
        this.pivotOptions.setCols(Arrays.copyOf($this$forEach$iv, $this$forEach$iv.length));
        this.pivotOptions.setRenderer(this.pivotTable.getDefaultRenderer());
        this.pivotOptions.setAggregator((String)this.pivotTable.getAggregator().getFirst(), (String)this.pivotTable.getAggregator().getSecond());
        if (!((Collection)this.rows).isEmpty() && !((Collection)this.columns).isEmpty()) {
            this.pivotOptions.setCharts(true);
        }
        $this$toTypedArray$iv = this.pivotTable.getDisabledRerenders();
        $i$f$toTypedArray = false;
        Collection collection3 = $this$toTypedArray$iv;
        $this$forEach$iv = collection3.toArray(new String[0]);
        this.pivotOptions.setDisabledRenderers(Arrays.copyOf($this$forEach$iv, $this$forEach$iv.length));
        PivotTable.PivotMode pivotMode = this.pivotTable.getInteractive() == 0 ? PivotTable.PivotMode.INTERACTIVE : PivotTable.PivotMode.NONINTERACTIVE;
        PivotTable pivot = new PivotTable((PivotTable.AbstractPivotData)this.pivotData, this.pivotOptions, pivotMode);
        Component[] componentArray = new Component[]{pivot};
        this.add(componentArray);
    }

    private final void buildRows() {
        ArrayList<VPivotTableRow> arrayList = this.model.getUserRows$galite_core();
        Intrinsics.checkNotNull(arrayList);
        int n = ((Collection)arrayList).size();
        for (int i = 0; i < n; ++i) {
            int n2 = ((Collection)this.model.getColumns()).size();
            for (int j = 0; j < n2; ++j) {
                this.rowsValues.add(this.getValueAt(j, i));
            }
        }
    }

    @NotNull
    public final String getValueAt(int columnIndex, int rowIndex) {
        VPivotTableColumn vPivotTableColumn = this.model.getColumns().get(columnIndex);
        Intrinsics.checkNotNull((Object)vPivotTableColumn);
        return vPivotTableColumn.format(this.model.getValueAt(rowIndex, columnIndex));
    }

    public static final /* synthetic */ PivotTable.PivotData access$getPivotData$p(DPivotTable $this) {
        return $this.pivotData;
    }
}

