/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.report;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.grid.ColumnReorderEvent;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.grid.ItemClickEvent;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.selection.SelectionEvent;
import java.awt.Color;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.Action;
import org.kopi.galite.visual.VWindow;
import org.kopi.galite.visual.VlibProperties;
import org.kopi.galite.visual.report.MReport;
import org.kopi.galite.visual.report.Parameters;
import org.kopi.galite.visual.report.Point;
import org.kopi.galite.visual.report.UReport;
import org.kopi.galite.visual.report.VReport;
import org.kopi.galite.visual.report.VReportColumn;
import org.kopi.galite.visual.report.VReportRow;
import org.kopi.galite.visual.report.VSeparatorColumn;
import org.kopi.galite.visual.ui.vaadin.base.BackgroundThreadHandler;
import org.kopi.galite.visual.ui.vaadin.report.ColumnsSelector;
import org.kopi.galite.visual.ui.vaadin.report.DReport;
import org.kopi.galite.visual.ui.vaadin.report.DTable;
import org.kopi.galite.visual.ui.vaadin.report.ReportCellStyler;
import org.kopi.galite.visual.ui.vaadin.report.VTable;
import org.kopi.galite.visual.ui.vaadin.visual.DWindow;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001<B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u001c\u0010\u001e\u001a\u00020\u001c2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u001cH\u0002J\b\u0010$\u001a\u00020\u001cH\u0016J\u0012\u0010%\u001a\f\u0012\b\u0012\u00060'R\u00020\u00000&H\u0002J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u0012H\u0016J\b\u0010*\u001a\u00020\u001cH\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u0007H\u0016J\u0012\u0010.\u001a\u00020\u00072\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u001cH\u0016J\u0010\u00102\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u000e\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u0012J\b\u00105\u001a\u00020\u001cH\u0016J\b\u00106\u001a\u00020\u001cH\u0016J\u0018\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020\u001cH\u0002R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/kopi/galite/visual/ui/vaadin/report/DReport;", "Lorg/kopi/galite/visual/ui/vaadin/visual/DWindow;", "Lorg/kopi/galite/visual/report/UReport;", "report", "Lorg/kopi/galite/visual/report/VReport;", "(Lorg/kopi/galite/visual/report/VReport;)V", "columnCount", "", "getColumnCount", "()I", "columnsSelector", "Lorg/kopi/galite/visual/ui/vaadin/report/ColumnsSelector;", "contextMenuList", "", "Lcom/vaadin/flow/component/contextmenu/ContextMenu;", "getContextMenuList", "()Ljava/util/List;", "displayOrder", "", "getDisplayOrder", "()[I", "model", "Lorg/kopi/galite/visual/report/MReport;", "parameters", "Lorg/kopi/galite/visual/report/Parameters;", "table", "Lorg/kopi/galite/visual/ui/vaadin/report/DTable;", "addColumn", "", "position", "addHeaderListeners", "gridColumn", "Lcom/vaadin/flow/component/grid/Grid$Column;", "header", "Lcom/vaadin/flow/component/orderedlayout/VerticalLayout;", "addTableListeners", "build", "buildRows", "", "Lorg/kopi/galite/visual/ui/vaadin/report/DReport$ReportModelItem;", "columnMoved", "pos", "contentChanged", "getSelectedCell", "Lorg/kopi/galite/visual/report/Point;", "getSelectedColumn", "getSelectedColumnIndex", "getTable", "Lorg/kopi/galite/visual/report/UReport$UTable;", "redisplay", "removeColumn", "reorder", "newOrder", "resetWidth", "run", "setColumnLabel", "column", "label", "", "setInfoTable", "ReportModelItem", "galite-core"})
@SourceDebugExtension(value={"SMAP\nDReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DReport.kt\norg/kopi/galite/visual/ui/vaadin/report/DReport\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,446:1\n215#2,2:447\n1549#3:449\n1620#3,3:450\n*S KotlinDebug\n*F\n+ 1 DReport.kt\norg/kopi/galite/visual/ui/vaadin/report/DReport\n*L\n229#1:447,2\n295#1:449\n295#1:450,3\n*E\n"})
public final class DReport
extends DWindow
implements UReport {
    @NotNull
    private final VReport report;
    @NotNull
    private final MReport model;
    private DTable table;
    @Nullable
    private Parameters parameters;
    @NotNull
    private ColumnsSelector columnsSelector;
    @NotNull
    private final List<ContextMenu> contextMenuList;

    public DReport(@NotNull VReport report2) {
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        super(report2);
        this.report = report2;
        this.model = this.report.getModel();
        this.columnsSelector = new ColumnsSelector();
        this.model.addReportListener(this);
        VWindow vWindow = this.getModel();
        Intrinsics.checkNotNull((Object)vWindow);
        vWindow.setDisplay(this);
        this.setSizeFull();
        Component[] componentArray = new Component[]{this.columnsSelector};
        this.add(componentArray);
        this.contextMenuList = new ArrayList();
    }

    @Override
    public void run() {
        this.report.initReport();
        this.report.setMenu();
        DTable dTable = this.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        dTable.focus();
        this.setInfoTable();
    }

    @Override
    public void build() {
        this.parameters = new Parameters(new Color(71, 184, 221));
        this.table = new DTable(new VTable(this.model, this.buildRows()));
        DTable dTable = this.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        dTable.setColumnReorderingAllowed(true);
        DTable dTable2 = this.table;
        if (dTable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable2 = null;
        }
        Parameters parameters = this.parameters;
        Intrinsics.checkNotNull((Object)parameters);
        DTable dTable3 = this.table;
        if (dTable3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable3 = null;
        }
        dTable2.setCellStyler(new ReportCellStyler(this.model, parameters, dTable3));
        this.getUI().ifPresent(arg_0 -> DReport.build$lambda$0((Function1)new Function1<UI, Unit>(this){
            final /* synthetic */ DReport this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull UI ui) {
                Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
                ui.getPage().retrieveExtendedClientDetails(arg_0 -> build.1.invoke$lambda$0(this.this$0, arg_0));
            }

            private static final void invoke$lambda$0(DReport this$0, ExtendedClientDetails it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                DTable dTable = DReport.access$getTable$p(this$0);
                if (dTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                    dTable = null;
                }
                dTable.setHeight((float)it.getWindowInnerHeight() - (float)200, com.vaadin.flow.component.Unit.PIXELS);
            }

            private static final /* synthetic */ Object $deserializeLambda$(SerializedLambda lambda) {
                if (Intrinsics.areEqual((Object)lambda.getImplMethodName(), (Object)"invoke$lambda$0") && lambda.getImplMethodKind() == 6 && lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/page/Page$ExtendedClientDetailsReceiver") && lambda.getFunctionalInterfaceMethodName().equals("receiveDetails") && lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/page/ExtendedClientDetails;)V") && lambda.getImplClass().equals("org/kopi/galite/visual/ui/vaadin/report/DReport$build$1") && lambda.getImplMethodSignature().equals("(Lorg/kopi/galite/visual/ui/vaadin/report/DReport;Lcom/vaadin/flow/component/page/ExtendedClientDetails;)V")) {
                    return arg_0 -> build.1.invoke$lambda$0((DReport)lambda.getCapturedArg(0), arg_0);
                }
                throw (Throwable)new IllegalArgumentException("Invalid lambda deserialization");
            }
        }, arg_0));
        DTable dTable4 = this.table;
        if (dTable4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable4 = null;
        }
        this.setContent((Component)dTable4);
        this.resetWidth();
        this.addTableListeners();
        DTable dTable5 = this.table;
        if (dTable5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable5 = null;
        }
        GridVariant[] gridVariantArray = new GridVariant[]{GridVariant.LUMO_WRAP_CELL_CONTENT};
        dTable5.addThemeVariants(gridVariantArray);
        DTable dTable6 = this.table;
        if (dTable6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable6 = null;
        }
        this.columnsSelector.build(dTable6);
    }

    @Override
    public void redisplay() {
        this.contentChanged();
    }

    public final void reorder(@NotNull int[] newOrder) {
        Intrinsics.checkNotNullParameter((Object)newOrder, (String)"newOrder");
        this.model.columnMoved(newOrder);
        BackgroundThreadHandler.INSTANCE.accessAndPush(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(this, newOrder){
            final /* synthetic */ DReport this$0;
            final /* synthetic */ int[] $newOrder;
            {
                this.this$0 = $receiver;
                this.$newOrder = $newOrder;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                DTable dTable = DReport.access$getTable$p(this.this$0);
                if (dTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                    dTable = null;
                }
                int[] nArray = this.$newOrder;
                DReport dReport = this.this$0;
                DTable dTable2 = dTable;
                boolean $i$f$map = false;
                void var4_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var10_13 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    DTable dTable3 = DReport.access$getTable$p(dReport);
                    if (dTable3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                        dTable3 = null;
                    }
                    collection.add(dTable3.getColumnByKey(String.valueOf((int)it)));
                }
                dTable2.setColumnOrder((List)destination$iv$iv);
                int n2 = DReport.access$getModel$p(this.this$0).getAccessibleColumnCount();
                for (int col = 0; col < n2; ++col) {
                    DTable dTable4 = DReport.access$getTable$p(this.this$0);
                    if (dTable4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                        dTable4 = null;
                    }
                    Grid.Column column = dTable4.getColumnByKey(String.valueOf(col));
                    VReportColumn vReportColumn = DReport.access$getModel$p(this.this$0).getAccessibleColumn(col);
                    Intrinsics.checkNotNull((Object)vReportColumn);
                    column.setVisible(!vReportColumn.isFolded() || DReport.access$getModel$p(this.this$0).getAccessibleColumn(col) instanceof VSeparatorColumn);
                }
            }
        }));
    }

    @Override
    public void removeColumn(int position) {
        DTable dTable = this.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        int indexInView = dTable.convertColumnIndexToView(position);
        this.model.removeColumn(position);
        DTable dTable2 = this.table;
        if (dTable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable2 = null;
        }
        dTable2.removeColumnByKey(String.valueOf(position));
        this.model.initializeAfterRemovingColumn(indexInView);
        int[] pos = new int[this.model.getAccessibleColumnCount()];
        int n = this.model.getAccessibleColumnCount();
        for (int i = 0; i < n; ++i) {
            pos[i] = this.model.getDisplayOrder(i) > position ? this.model.getDisplayOrder(i) - 1 : this.model.getDisplayOrder(i);
        }
        this.report.columnMoved(pos);
    }

    @Override
    public void addColumn(int position) {
        BackgroundThreadHandler.INSTANCE.accessAndPush(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(position, this){
            final /* synthetic */ int $position;
            final /* synthetic */ DReport this$0;
            {
                this.$position = $position;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                int i;
                int position = this.$position;
                DTable dTable = DReport.access$getTable$p(this.this$0);
                if (dTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                    dTable = null;
                }
                position = dTable.convertColumnIndexToView(position);
                String headerLabel = "col" + DReport.access$getModel$p(this.this$0).getColumnCount();
                Component[] componentArray = new Component[]{new Span(headerLabel)};
                VerticalLayout span = new VerticalLayout(componentArray);
                DReport.access$getModel$p(this.this$0).addColumn(headerLabel, ++position);
                DTable dTable2 = DReport.access$getTable$p(this.this$0);
                if (dTable2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                    dTable2 = null;
                }
                Grid.Column column = DTable.addColumn$default(dTable2, DReport.access$getModel$p(this.this$0).getColumnCount() - 1, null, 2, null);
                column.setHeader((Component)span);
                column.setFlexGrow(0);
                DReport.access$addHeaderListeners(this.this$0, column, span);
                int[] pos = new int[DReport.access$getModel$p(this.this$0).getAccessibleColumnCount()];
                int n = position;
                for (i = 0; i < n; ++i) {
                    pos[i] = DReport.access$getModel$p(this.this$0).getDisplayOrder(i);
                }
                n = DReport.access$getModel$p(this.this$0).getAccessibleColumnCount();
                for (i = position + 1; i < n; ++i) {
                    pos[i] = DReport.access$getModel$p(this.this$0).getDisplayOrder(i - 1);
                }
                pos[position] = DReport.access$getModel$p(this.this$0).getDisplayOrder(DReport.access$getModel$p(this.this$0).getAccessibleColumnCount() - 1);
                DReport.access$getReport$p(this.this$0).columnMoved(pos);
            }
        }));
    }

    @Override
    public void addColumn() {
        DTable dTable = this.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        this.addColumn(dTable.getColumnCount() - 1);
    }

    @Override
    @NotNull
    public UReport.UTable getTable() {
        DTable dTable = this.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        return dTable;
    }

    @Override
    public void contentChanged() {
        if (this.table != null) {
            BackgroundThreadHandler.INSTANCE.accessAndPush(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ DReport this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    DTable dTable = DReport.access$getTable$p(this.this$0);
                    if (dTable == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                        dTable = null;
                    }
                    dTable.setItems(DReport.access$buildRows(this.this$0));
                    DTable dTable2 = DReport.access$getTable$p(this.this$0);
                    if (dTable2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                        dTable2 = null;
                    }
                    dTable2.getModel().fireContentChanged();
                    ColumnsSelector columnsSelector = DReport.access$getColumnsSelector$p(this.this$0);
                    DTable dTable3 = DReport.access$getTable$p(this.this$0);
                    if (dTable3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                        dTable3 = null;
                    }
                    columnsSelector.build(dTable3);
                }
            }));
        }
    }

    @Override
    public void columnMoved(@NotNull int[] pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.reorder(pos);
        this.model.columnMoved(pos);
        this.redisplay();
    }

    @Override
    public void resetWidth() {
        BackgroundThreadHandler.INSTANCE.access(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DReport this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DTable dTable = DReport.access$getTable$p(this.this$0);
                if (dTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                    dTable = null;
                }
                dTable.resetWidth();
            }
        }));
    }

    @Override
    public int getSelectedColumn() {
        DTable dTable = this.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        return dTable.getSelectedColumn();
    }

    @Override
    @NotNull
    public Point getSelectedCell() {
        DTable dTable = this.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        int n = dTable.getSelectedColumn();
        DTable dTable2 = this.table;
        if (dTable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable2 = null;
        }
        return new Point(n, dTable2.getSelectedRow());
    }

    @Override
    public void setColumnLabel(int column, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        BackgroundThreadHandler.INSTANCE.access(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(this, column, label){
            final /* synthetic */ DReport this$0;
            final /* synthetic */ int $column;
            final /* synthetic */ String $label;
            {
                this.this$0 = $receiver;
                this.$column = $column;
                this.$label = $label;
                super(0);
            }

            public final void invoke() {
                DTable dTable = DReport.access$getTable$p(this.this$0);
                if (dTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                    dTable = null;
                }
                dTable.getColumnByKey(String.valueOf(this.$column)).setHeader(this.$label);
            }
        }));
    }

    @NotNull
    public final int[] getDisplayOrder() {
        int[] displayOrder = new int[this.model.getColumnCount()];
        int n = this.model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            DTable dTable = this.table;
            if (dTable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                dTable = null;
            }
            displayOrder[i] = dTable.convertColumnIndexToModel(i);
        }
        return displayOrder;
    }

    public final int getColumnCount() {
        DTable dTable = this.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        return dTable.getColumnCount();
    }

    private final void addTableListeners() {
        MReport currentModel = this.model;
        DTable dTable = this.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        Map<Grid.Column<?>, VerticalLayout> $this$forEach$iv = dTable.getColumnToHeaderMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Grid.Column<?>, VerticalLayout>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Grid.Column<?>, VerticalLayout> element$iv;
            Map.Entry<Grid.Column<?>, VerticalLayout> entry = element$iv = iterator.next();
            boolean bl = false;
            Grid.Column<?> gridColumn = entry.getKey();
            VerticalLayout header = entry.getValue();
            this.addHeaderListeners(gridColumn, header);
        }
        DTable dTable2 = this.table;
        if (dTable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable2 = null;
        }
        dTable2.addItemClickListener(arg_0 -> DReport.addTableListeners$lambda$2(currentModel, this, arg_0));
        DTable dTable3 = this.table;
        if (dTable3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable3 = null;
        }
        dTable3.addColumnReorderListener(arg_0 -> DReport.addTableListeners$lambda$4(this, arg_0));
        DTable dTable4 = this.table;
        if (dTable4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable4 = null;
        }
        dTable4.addSelectionListener(arg_0 -> DReport.addTableListeners$lambda$5(this, arg_0));
        DTable dTable5 = this.table;
        if (dTable5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable5 = null;
        }
        dTable5.getDataProvider().addDataProviderListener(arg_0 -> DReport.addTableListeners$lambda$6(this, arg_0));
    }

    @NotNull
    public final List<ContextMenu> getContextMenuList() {
        return this.contextMenuList;
    }

    private final void addHeaderListeners(Grid.Column<?> gridColumn, VerticalLayout header) {
        MReport currentModel = this.model;
        ContextMenu labelPopupMenu = new ContextMenu();
        this.contextMenuList.add(labelPopupMenu);
        labelPopupMenu.setTarget((Component)header);
        labelPopupMenu.addItem(VlibProperties.getString("set_column_info"), arg_0 -> DReport.addHeaderListeners$lambda$7(this, gridColumn, arg_0));
        labelPopupMenu.addItem(VlibProperties.getString("sort_ASC"), arg_0 -> DReport.addHeaderListeners$lambda$8(currentModel, this, gridColumn, arg_0));
        labelPopupMenu.addItem(VlibProperties.getString("sort_DSC"), arg_0 -> DReport.addHeaderListeners$lambda$9(currentModel, this, gridColumn, arg_0));
        labelPopupMenu.addItem(VlibProperties.getString("add_column"), arg_0 -> DReport.addHeaderListeners$lambda$10(this, gridColumn, arg_0));
        VReportColumn vReportColumn = currentModel.getAccessibleColumn(this.getSelectedColumnIndex(gridColumn));
        Intrinsics.checkNotNull((Object)vReportColumn);
        if (vReportColumn.isAddedAtRuntime()) {
            labelPopupMenu.addItem(VlibProperties.getString("remove_column"), arg_0 -> DReport.addHeaderListeners$lambda$11(this, gridColumn, arg_0));
            labelPopupMenu.addItem(VlibProperties.getString("set_column_data"), arg_0 -> DReport.addHeaderListeners$lambda$12(this, gridColumn, arg_0));
        }
        header.addClickListener(arg_0 -> DReport.addHeaderListeners$lambda$13(currentModel, this, gridColumn, arg_0));
    }

    public final int getSelectedColumnIndex(@NotNull Grid.Column<?> gridColumn) {
        Intrinsics.checkNotNullParameter(gridColumn, (String)"gridColumn");
        String string = gridColumn.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        return Integer.parseInt(string);
    }

    private final void setInfoTable() {
        DTable dTable = this.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        this.setStatisticsText(dTable.getModel().getModel$galite_core().getRowCount() + "/" + this.model.getBaseRowCount() + "/" + this.model.getVisibleRowCount());
    }

    private final List<ReportModelItem> buildRows() {
        List rows = new ArrayList();
        int n = this.model.getRowCount();
        for (int i = 0; i < n; ++i) {
            rows.add(new ReportModelItem(i));
        }
        return rows;
    }

    private static final void build$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addTableListeners$lambda$2(MReport $currentModel, DReport this$0, ItemClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)$currentModel, (String)"$currentModel");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int row = ((ReportModelItem)event.getItem()).getRowIndex();
        String string = event.getColumn().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        int col = Integer.parseInt(string);
        if (event.getButton() == 0) {
            if (event.getClickCount() == 2) {
                if ($currentModel.isRowLine(row)) {
                    VWindow vWindow = this$0.getModel();
                    Intrinsics.checkNotNull((Object)vWindow);
                    vWindow.performAsyncAction(new Action(this$0){
                        final /* synthetic */ DReport this$0;
                        {
                            this.this$0 = $receiver;
                            super("edit_line");
                        }

                        public void execute() {
                            DReport.access$getReport$p(this.this$0).editLine();
                        }
                    });
                } else if (row >= 0) {
                    if ($currentModel.isRowFold(row, col)) {
                        $currentModel.unfoldingRow(row, col);
                    } else {
                        $currentModel.foldingRow(row, col);
                    }
                }
            } else if (event.isShiftKey() && event.isCtrlKey()) {
                $currentModel.sortColumn(col);
            } else if (event.isCtrlKey()) {
                if (row >= 0) {
                    if ($currentModel.isRowFold(row, col)) {
                        $currentModel.unfoldingRow(row, col);
                    } else {
                        $currentModel.foldingRow(row, col);
                    }
                }
            } else if (event.isShiftKey()) {
                if ($currentModel.isColumnFold(col)) {
                    $currentModel.unfoldingColumn(col);
                } else {
                    $currentModel.foldingColumn(col);
                }
            }
        } else if (event.getButton() == 2) {
            if (row >= 0) {
                if ($currentModel.isRowFold(row, col)) {
                    $currentModel.unfoldingRow(row, col);
                } else {
                    $currentModel.foldingRow(row, col);
                }
            }
        } else if (event.getButton() == 1) {
            if ($currentModel.isColumnFold(col)) {
                $currentModel.unfoldingColumn(col);
            } else {
                $currentModel.foldingColumn(col);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void addTableListeners$lambda$4(DReport this$0, ColumnReorderEvent event) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DTable dTable = this$0.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        List list = event.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
        Iterable iterable = list;
        DTable dTable2 = dTable;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Grid.Column column = (Grid.Column)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            collection.add(Integer.parseInt(string));
        }
        dTable2.setViewColumns(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
        int[] newColumnOrder = new int[this$0.model.getColumnCount()];
        DTable dTable3 = this$0.table;
        if (dTable3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable3 = null;
        }
        List<Integer> visibleColumns = dTable3.getViewColumns();
        int hiddenColumnsCount = 0;
        int n = newColumnOrder.length;
        for (int i = 0; i < n; ++i) {
            VReportColumn vReportColumn = this$0.model.getAccessibleColumn(i);
            Intrinsics.checkNotNull((Object)vReportColumn);
            if (!vReportColumn.isVisible()) {
                ++hiddenColumnsCount;
                newColumnOrder[i] = this$0.model.getDisplayOrder(i);
                continue;
            }
            newColumnOrder[i] = ((Number)visibleColumns.get(i - hiddenColumnsCount)).intValue();
        }
        this$0.model.columnMoved(newColumnOrder);
    }

    private static final void addTableListeners$lambda$5(DReport this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.report.setMenu();
    }

    private static final void addTableListeners$lambda$6(DReport this$0, DataChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setInfoTable();
        DTable dTable = this$0.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        dTable.resetCachedInfos();
    }

    private static final void addHeaderListeners$lambda$7(DReport this$0, Grid.Column $gridColumn, ClickEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gridColumn, (String)"$gridColumn");
        DTable dTable = this$0.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        dTable.setSelectedColumn(this$0.getSelectedColumnIndex($gridColumn));
        VWindow vWindow = this$0.getModel();
        Intrinsics.checkNotNull((Object)vWindow);
        vWindow.performAsyncAction(new Action(this$0){
            final /* synthetic */ DReport this$0;
            {
                this.this$0 = $receiver;
                super("set_column_info");
            }

            public void execute() {
                DReport.access$getReport$p(this.this$0).setColumnInfo();
            }
        });
    }

    private static final void addHeaderListeners$lambda$8(MReport $currentModel, DReport this$0, Grid.Column $gridColumn, ClickEvent it) {
        Intrinsics.checkNotNullParameter((Object)$currentModel, (String)"$currentModel");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gridColumn, (String)"$gridColumn");
        $currentModel.sortColumn(this$0.getSelectedColumnIndex($gridColumn), 1);
    }

    private static final void addHeaderListeners$lambda$9(MReport $currentModel, DReport this$0, Grid.Column $gridColumn, ClickEvent it) {
        Intrinsics.checkNotNullParameter((Object)$currentModel, (String)"$currentModel");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gridColumn, (String)"$gridColumn");
        $currentModel.sortColumn(this$0.getSelectedColumnIndex($gridColumn), -1);
    }

    private static final void addHeaderListeners$lambda$10(DReport this$0, Grid.Column $gridColumn, ClickEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gridColumn, (String)"$gridColumn");
        this$0.addColumn(this$0.getSelectedColumnIndex($gridColumn));
    }

    private static final void addHeaderListeners$lambda$11(DReport this$0, Grid.Column $gridColumn, ClickEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gridColumn, (String)"$gridColumn");
        this$0.removeColumn(this$0.getSelectedColumnIndex($gridColumn));
    }

    private static final void addHeaderListeners$lambda$12(DReport this$0, Grid.Column $gridColumn, ClickEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gridColumn, (String)"$gridColumn");
        DTable dTable = this$0.table;
        if (dTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            dTable = null;
        }
        dTable.setSelectedColumn(this$0.getSelectedColumnIndex($gridColumn));
        VWindow vWindow = this$0.getModel();
        Intrinsics.checkNotNull((Object)vWindow);
        vWindow.performAsyncAction(new Action(this$0){
            final /* synthetic */ DReport this$0;
            {
                this.this$0 = $receiver;
                super("set_column_data");
            }

            public void execute() {
                DReport.access$getReport$p(this.this$0).setColumnData();
            }
        });
    }

    private static final void addHeaderListeners$lambda$13(MReport $currentModel, DReport this$0, Grid.Column $gridColumn, ClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)$currentModel, (String)"$currentModel");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gridColumn, (String)"$gridColumn");
        if (event.getButton() == 0) {
            if (event.isCtrlKey()) {
                if ($currentModel.isColumnFold(this$0.getSelectedColumnIndex($gridColumn))) {
                    $currentModel.unfoldingColumn(this$0.getSelectedColumnIndex($gridColumn));
                } else {
                    $currentModel.foldingColumn(this$0.getSelectedColumnIndex($gridColumn));
                }
            } else if (event.isShiftKey()) {
                $currentModel.sortColumn(this$0.getSelectedColumnIndex($gridColumn));
            }
        }
    }

    public static final /* synthetic */ DTable access$getTable$p(DReport $this) {
        return $this.table;
    }

    public static final /* synthetic */ void access$addHeaderListeners(DReport $this, Grid.Column gridColumn, VerticalLayout header) {
        $this.addHeaderListeners(gridColumn, header);
    }

    public static final /* synthetic */ VReport access$getReport$p(DReport $this) {
        return $this.report;
    }

    public static final /* synthetic */ List access$buildRows(DReport $this) {
        return $this.buildRows();
    }

    public static final /* synthetic */ ColumnsSelector access$getColumnsSelector$p(DReport $this) {
        return $this.columnsSelector;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/report/DReport$ReportModelItem;", "", "rowIndex", "", "(Lorg/kopi/galite/visual/ui/vaadin/report/DReport;I)V", "reportRow", "Lorg/kopi/galite/visual/report/VReportRow;", "getReportRow", "()Lorg/kopi/galite/visual/report/VReportRow;", "getRowIndex", "()I", "getValueAt", "", "columnIndex", "galite-core"})
    public final class ReportModelItem {
        private final int rowIndex;

        public ReportModelItem(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public final int getRowIndex() {
            return this.rowIndex;
        }

        @NotNull
        public final String getValueAt(int columnIndex) {
            VReportColumn vReportColumn = DReport.this.model.getAccessibleColumns()[columnIndex];
            Intrinsics.checkNotNull((Object)vReportColumn);
            return vReportColumn.format(DReport.this.model.getValueAt(this.rowIndex, columnIndex));
        }

        @Nullable
        public final VReportRow getReportRow() {
            return DReport.this.model.getRow(this.rowIndex);
        }
    }
}

