/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.report;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.BrowserWindowResizeEvent;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.report.UReport;
import org.kopi.galite.visual.report.VDecimalColumn;
import org.kopi.galite.visual.report.VIntegerColumn;
import org.kopi.galite.visual.report.VReportColumn;
import org.kopi.galite.visual.report.VSeparatorColumn;
import org.kopi.galite.visual.ui.vaadin.report.ColumnStyleGenerator;
import org.kopi.galite.visual.ui.vaadin.report.DReport;
import org.kopi.galite.visual.ui.vaadin.report.ReportCellStyler;
import org.kopi.galite.visual.ui.vaadin.report.VTable;

@CssImport.Container(value={@CssImport(value="./styles/galite/report.css"), @CssImport(value="./styles/galite/report.css", themeFor="vaadin-grid")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u00012\u00020\u0004:\u0001HB\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010*\u001a\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u00162\u0006\u0010+\u001a\u00020\u001d2\b\b\u0002\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001dH\u0016J\u0010\u00102\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u001dH\u0016J\u0006\u00104\u001a\u00020\u001dJ \u00105\u001a\u0002062\u0006\u0010,\u001a\u00020-2\u0010\u00107\u001a\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0016J\u0010\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0014J\u0010\u0010;\u001a\u00020/2\u0006\u0010<\u001a\u00020=H\u0014J\u001a\u0010>\u001a\u00020/2\u0010\u0010,\u001a\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0016H\u0016J\u0010\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020AH\u0016J\u0006\u0010B\u001a\u00020/J\u0010\u0010C\u001a\u00020/2\u0006\u0010D\u001a\u00020\u001dH\u0002J\u0006\u0010E\u001a\u00020/J\f\u0010F\u001a\u00020/*\u00020GH\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R!\u0010\u0014\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001fR \u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006I"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/report/DTable;", "Lcom/vaadin/flow/component/grid/Grid;", "Lorg/kopi/galite/visual/ui/vaadin/report/DReport$ReportModelItem;", "Lorg/kopi/galite/visual/ui/vaadin/report/DReport;", "Lorg/kopi/galite/visual/report/UReport$UTable;", "model", "Lorg/kopi/galite/visual/ui/vaadin/report/VTable;", "(Lorg/kopi/galite/visual/ui/vaadin/report/VTable;)V", "browserWindowResizeListener", "Lcom/vaadin/flow/shared/Registration;", "getBrowserWindowResizeListener", "()Lcom/vaadin/flow/shared/Registration;", "setBrowserWindowResizeListener", "(Lcom/vaadin/flow/shared/Registration;)V", "cellStyler", "Lorg/kopi/galite/visual/ui/vaadin/report/ReportCellStyler;", "getCellStyler", "()Lorg/kopi/galite/visual/ui/vaadin/report/ReportCellStyler;", "setCellStyler", "(Lorg/kopi/galite/visual/ui/vaadin/report/ReportCellStyler;)V", "columnToHeaderMap", "", "Lcom/vaadin/flow/component/grid/Grid$Column;", "Lcom/vaadin/flow/component/orderedlayout/VerticalLayout;", "getColumnToHeaderMap", "()Ljava/util/Map;", "getModel", "()Lorg/kopi/galite/visual/ui/vaadin/report/VTable;", "selectedColumn", "", "getSelectedColumn", "()I", "setSelectedColumn", "(I)V", "selectedRow", "getSelectedRow", "viewColumns", "", "getViewColumns", "()Ljava/util/List;", "setViewColumns", "(Ljava/util/List;)V", "addColumn", "key", "column", "Lorg/kopi/galite/visual/report/VReportColumn;", "buildColumns", "", "convertColumnIndexToModel", "viewColumnIndex", "convertColumnIndexToView", "modelColumnIndex", "getColumnCount", "getColumnNameComponent", "Lcom/vaadin/flow/component/Component;", "gridColumn", "onAttach", "attachEvent", "Lcom/vaadin/flow/component/AttachEvent;", "onDetach", "detachEvent", "Lcom/vaadin/flow/component/DetachEvent;", "removeColumn", "removeColumnByKey", "columnKey", "", "resetCachedInfos", "resetColumnSize", "pos", "resetWidth", "setWindowHeight", "Lcom/vaadin/flow/component/page/Page;", "ColumnValueProvider", "galite-core"})
@SourceDebugExtension(value={"SMAP\nDTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DTable.kt\norg/kopi/galite/visual/ui/vaadin/report/DTable\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,257:1\n13374#2,3:258\n*S KotlinDebug\n*F\n+ 1 DTable.kt\norg/kopi/galite/visual/ui/vaadin/report/DTable\n*L\n120#1:258,3\n*E\n"})
public final class DTable
extends Grid<DReport.ReportModelItem>
implements UReport.UTable {
    @NotNull
    private final VTable model;
    private int selectedColumn;
    @NotNull
    private List<Integer> viewColumns;
    @NotNull
    private final Map<Grid.Column<?>, VerticalLayout> columnToHeaderMap;
    public ReportCellStyler cellStyler;
    public Registration browserWindowResizeListener;

    public DTable(@NotNull VTable model2) {
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        this.model = model2;
        this.selectedColumn = -1;
        this.viewColumns = new ArrayList();
        this.columnToHeaderMap = new LinkedHashMap();
        this.setItems(this.model);
        this.buildColumns();
        GridVariant[] gridVariantArray = new GridVariant[]{GridVariant.LUMO_COMPACT, GridVariant.LUMO_COLUMN_BORDERS};
        this.addThemeVariants(gridVariantArray);
        this.getThemeNames().add((Object)"report");
        this.getClassNames().add((Object)"small");
        this.getClassNames().add((Object)"borderless");
        this.getClassNames().add((Object)"report");
        this.setWidthFull();
    }

    @NotNull
    public final VTable getModel() {
        return this.model;
    }

    public final int getSelectedRow() {
        DReport.ReportModelItem reportModelItem = (DReport.ReportModelItem)this.asSingleSelect().getValue();
        return reportModelItem != null ? reportModelItem.getRowIndex() : -1;
    }

    public final int getSelectedColumn() {
        return this.selectedColumn;
    }

    public final void setSelectedColumn(int n) {
        this.selectedColumn = n;
    }

    @NotNull
    public final List<Integer> getViewColumns() {
        return this.viewColumns;
    }

    public final void setViewColumns(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.viewColumns = list;
    }

    @NotNull
    public final Map<Grid.Column<?>, VerticalLayout> getColumnToHeaderMap() {
        return this.columnToHeaderMap;
    }

    @NotNull
    public final ReportCellStyler getCellStyler() {
        ReportCellStyler reportCellStyler = this.cellStyler;
        if (reportCellStyler != null) {
            return reportCellStyler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cellStyler");
        return null;
    }

    public final void setCellStyler(@NotNull ReportCellStyler reportCellStyler) {
        Intrinsics.checkNotNullParameter((Object)reportCellStyler, (String)"<set-?>");
        this.cellStyler = reportCellStyler;
    }

    @NotNull
    public final Registration getBrowserWindowResizeListener() {
        Registration registration = this.browserWindowResizeListener;
        if (registration != null) {
            return registration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"browserWindowResizeListener");
        return null;
    }

    public final void setBrowserWindowResizeListener(@NotNull Registration registration) {
        Intrinsics.checkNotNullParameter((Object)registration, (String)"<set-?>");
        this.browserWindowResizeListener = registration;
    }

    protected void onAttach(@NotNull AttachEvent attachEvent) {
        Intrinsics.checkNotNullParameter((Object)attachEvent, (String)"attachEvent");
        Page page = attachEvent.getUI().getPage();
        Intrinsics.checkNotNull((Object)page);
        this.setWindowHeight(page);
        Registration registration = page.addBrowserWindowResizeListener(arg_0 -> DTable.onAttach$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)registration, (String)"addBrowserWindowResizeListener(...)");
        this.setBrowserWindowResizeListener(registration);
    }

    private final void setWindowHeight(Page $this$setWindowHeight) {
        String js = "return Vaadin.Flow.getBrowserDetailsParameters();";
        $this$setWindowHeight.executeJs(js, new Serializable[0]).then(arg_0 -> DTable.setWindowHeight$lambda$1(this, arg_0));
    }

    protected void onDetach(@NotNull DetachEvent detachEvent) {
        Intrinsics.checkNotNullParameter((Object)detachEvent, (String)"detachEvent");
        this.getBrowserWindowResizeListener().remove();
    }

    /*
     * WARNING - void declaration
     */
    private final void buildColumns() {
        VReportColumn[] $this$forEachIndexed$iv = this.model.getAccessibleColumns();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (VReportColumn item$iv : $this$forEachIndexed$iv) {
            void column;
            int n = index$iv++;
            VReportColumn vReportColumn = item$iv;
            int index = n;
            boolean bl = false;
            void v1 = column;
            Intrinsics.checkNotNull((Object)v1);
            Grid.Column<DReport.ReportModelItem> gridColumn = this.addColumn(index, (VReportColumn)v1);
            gridColumn.setHeader(this.getColumnNameComponent((VReportColumn)column, gridColumn));
            gridColumn.setFlexGrow(0);
        }
    }

    @NotNull
    public final Component getColumnNameComponent(@NotNull VReportColumn column, @NotNull Grid.Column<DReport.ReportModelItem> gridColumn) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter(gridColumn, (String)"gridColumn");
        VerticalLayout verticalLayout = new VerticalLayout[]{new Span(column.getLabel())};
        VerticalLayout it = verticalLayout = new VerticalLayout((Component[])verticalLayout);
        boolean bl = false;
        it.getElement().setProperty("title", column.getHelp());
        this.columnToHeaderMap.put(gridColumn, it);
        return (Component)verticalLayout;
    }

    @Override
    public int convertColumnIndexToModel(int viewColumnIndex) {
        return ((Number)this.viewColumns.get(viewColumnIndex)).intValue();
    }

    @Override
    public int convertColumnIndexToView(int modelColumnIndex) {
        return this.viewColumns.indexOf(modelColumnIndex);
    }

    @NotNull
    public final Grid.Column<DReport.ReportModelItem> addColumn(int key, @NotNull VReportColumn column) {
        Grid.Column column2;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        ColumnValueProvider provider = new ColumnValueProvider(key, column);
        this.viewColumns.add(key);
        Grid.Column it = column2 = this.addColumn(provider, new String[0]);
        boolean bl = false;
        provider.setColumn((Grid.Column<DReport.ReportModelItem>)it);
        ((Grid.Column)it.setKey(String.valueOf(key)).setResizable(true)).setClassNameGenerator((SerializableFunction)new ColumnStyleGenerator(this.model.getModel$galite_core(), column)).setSortable(false);
        Grid.Column column3 = column2;
        Intrinsics.checkNotNullExpressionValue((Object)column3, (String)"also(...)");
        return column3;
    }

    public static /* synthetic */ Grid.Column addColumn$default(DTable dTable, int n, VReportColumn vReportColumn, int n2, Object object) {
        if ((n2 & 2) != 0) {
            VReportColumn vReportColumn2 = dTable.model.getAccessibleColumns()[n];
            Intrinsics.checkNotNull((Object)vReportColumn2);
            vReportColumn = vReportColumn2;
        }
        return dTable.addColumn(n, vReportColumn);
    }

    public void removeColumnByKey(@NotNull String columnKey) {
        Intrinsics.checkNotNullParameter((Object)columnKey, (String)"columnKey");
        this.viewColumns.remove((Object)Integer.parseInt(columnKey));
        super.removeColumnByKey(columnKey);
    }

    public void removeColumn(@NotNull Grid.Column<DReport.ReportModelItem> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        String string = column.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        this.viewColumns.remove((Object)Integer.parseInt(string));
        super.removeColumn(column);
    }

    public final int getColumnCount() {
        return this.model.getColumnCount();
    }

    public final void resetWidth() {
        int n = this.model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.resetColumnSize(i);
        }
    }

    private final void resetColumnSize(int pos) {
        VReportColumn column = this.model.getModel$galite_core().getAccessibleColumn(this.convertColumnIndexToModel(pos));
        int width = 0;
        VReportColumn vReportColumn = column;
        Intrinsics.checkNotNull((Object)vReportColumn);
        if (vReportColumn.isFolded() && !(column instanceof VSeparatorColumn)) {
            width = 1;
        } else if (column instanceof VDecimalColumn || column instanceof VIntegerColumn) {
            width = RangesKt.coerceAtLeast((int)column.getLabel().length(), (int)column.getWidth());
            width = RangesKt.coerceAtLeast((int)width, (int)this.model.getModel$galite_core().computeColumnWidth(this.convertColumnIndexToModel(pos)));
        } else {
            width = RangesKt.coerceAtLeast((int)column.getLabel().length(), (int)column.getWidth());
        }
        if (width != 0) {
            width = width * 9 + 2;
        }
        ((Grid.Column)this.getColumns().get(pos)).setWidth(width + 12 + "px");
    }

    public final void resetCachedInfos() {
        this.selectedColumn = -1;
        this.select(null);
    }

    private static final void onAttach$lambda$0(DTable this$0, BrowserWindowResizeEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setHeight(event.getHeight() - 200 + "px");
    }

    private static final void setWindowHeight$lambda$1(DTable this$0, JsonValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type elemental.json.JsonObject");
        this$0.setHeight(((JsonObject)it).get("v-wh").asNumber() - (double)200 + "px");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u0012\u0012\b\u0012\u00060\u0002R\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0010\u001a\u00020\u00042\n\u0010\u0011\u001a\u00060\u0002R\u00020\u0003H\u0016R&\u0010\n\u001a\u000e\u0012\b\u0012\u00060\u0002R\u00020\u0003\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/report/DTable$ColumnValueProvider;", "Lcom/vaadin/flow/function/ValueProvider;", "Lorg/kopi/galite/visual/ui/vaadin/report/DReport$ReportModelItem;", "Lorg/kopi/galite/visual/ui/vaadin/report/DReport;", "", "columnIndex", "", "columnModel", "Lorg/kopi/galite/visual/report/VReportColumn;", "(Lorg/kopi/galite/visual/ui/vaadin/report/DTable;ILorg/kopi/galite/visual/report/VReportColumn;)V", "column", "Lcom/vaadin/flow/component/grid/Grid$Column;", "getColumn", "()Lcom/vaadin/flow/component/grid/Grid$Column;", "setColumn", "(Lcom/vaadin/flow/component/grid/Grid$Column;)V", "apply", "source", "galite-core"})
    public final class ColumnValueProvider
    implements ValueProvider<DReport.ReportModelItem, String> {
        private final int columnIndex;
        @NotNull
        private final VReportColumn columnModel;
        @Nullable
        private Grid.Column<DReport.ReportModelItem> column;

        public ColumnValueProvider(@NotNull int columnIndex, VReportColumn columnModel) {
            Intrinsics.checkNotNullParameter((Object)columnModel, (String)"columnModel");
            this.columnIndex = columnIndex;
            this.columnModel = columnModel;
        }

        @Nullable
        public final Grid.Column<DReport.ReportModelItem> getColumn() {
            return this.column;
        }

        public final void setColumn(@Nullable Grid.Column<DReport.ReportModelItem> column) {
            this.column = column;
        }

        @NotNull
        public String apply(@NotNull DReport.ReportModelItem source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Grid.Column<DReport.ReportModelItem> column = this.column;
            if (column != null) {
                column.setTextAlign(this.columnModel.getAlign() == 4 ? ColumnTextAlign.END : ColumnTextAlign.START);
            }
            DTable.this.getCellStyler().updateStyles(source.getRowIndex(), this.columnIndex);
            return source.getValueAt(this.columnIndex);
        }
    }
}

