/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.upload;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.NativeButton;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.base.BackgroundThreadHandler;
import org.kopi.galite.visual.ui.vaadin.base.LocalizedProperties;
import org.kopi.galite.visual.ui.vaadin.base.VInputButton;
import org.kopi.galite.visual.ui.vaadin.common.Dialog;
import org.kopi.galite.visual.ui.vaadin.common.VSpan;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0004J\u0010\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/upload/UploadDialog;", "Lorg/kopi/galite/visual/ui/vaadin/common/Dialog;", "Lcom/vaadin/flow/component/HasStyle;", "receiver", "Lcom/vaadin/flow/component/upload/Receiver;", "(Lcom/vaadin/flow/component/upload/Receiver;)V", "buttons", "Lcom/vaadin/flow/component/orderedlayout/HorizontalLayout;", "cancel", "Lorg/kopi/galite/visual/ui/vaadin/base/VInputButton;", "ok", "getReceiver", "()Lcom/vaadin/flow/component/upload/Receiver;", "title", "Lorg/kopi/galite/visual/ui/vaadin/common/VSpan;", "upload", "Lcom/vaadin/flow/component/upload/Upload;", "getUpload", "()Lcom/vaadin/flow/component/upload/Upload;", "addHandlers", "", "releaseLockOnUpload", "setImage", "setLocale", "locale", "", "setMimeType", "mimeType", "galite-core"})
public final class UploadDialog
extends Dialog
implements HasStyle {
    @NotNull
    private final Receiver receiver;
    @NotNull
    private final VSpan title;
    @NotNull
    private final VInputButton ok;
    @NotNull
    private final VInputButton cancel;
    @NotNull
    private final HorizontalLayout buttons;
    @NotNull
    private final Upload upload;

    public UploadDialog(@NotNull Receiver receiver) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        this.receiver = receiver;
        this.title = new VSpan();
        this.ok = new VInputButton(null, 1, null);
        this.cancel = new VInputButton(null, 1, null);
        Component[] componentArray = new Component[]{this.cancel, this.ok};
        this.buttons = new HorizontalLayout(componentArray);
        this.upload = new Upload(this.receiver);
        this.setClassName("k-upload");
        this.buttons.setSpacing(true);
        this.buttons.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        this.setCloseOnOutsideClick(false);
        this.buttons.setClassName("k-upload-buttons");
        this.ok.getStyle().set("cursor", "pointer");
        this.cancel.getStyle().set("cursor", "pointer");
        componentArray = new Component[]{this.title};
        this.setHeader(componentArray);
        componentArray = new Component[]{this.buttons};
        this.setFooter(componentArray);
        componentArray = new Component[]{this.upload};
        this.add(componentArray);
        this.addHandlers();
    }

    @NotNull
    public final Receiver getReceiver() {
        return this.receiver;
    }

    @NotNull
    public final Upload getUpload() {
        return this.upload;
    }

    protected final void setImage() {
    }

    public final void setLocale(@Nullable String locale) {
        NativeButton uploadButton = new NativeButton(LocalizedProperties.INSTANCE.getString(locale, "BROWSE"));
        this.upload.setUploadButton((Component)uploadButton);
        this.ok.setCaption(LocalizedProperties.INSTANCE.getString(locale, "UPLOAD"));
        this.cancel.setCaption(LocalizedProperties.INSTANCE.getString(locale, "CANCEL"));
        this.title.setText(LocalizedProperties.INSTANCE.getString(locale, "UPTITLE"));
    }

    public final void setMimeType(@Nullable String mimeType) {
        String[] stringArray = new String[]{mimeType};
        this.upload.setAcceptedFileTypes(stringArray);
    }

    private final void addHandlers() {
        this.ok.addClickListener(arg_0 -> UploadDialog.addHandlers$lambda$0(this, arg_0));
        this.cancel.addClickListener(arg_0 -> UploadDialog.addHandlers$lambda$1(this, arg_0));
        this.addDialogCloseActionListener(arg_0 -> UploadDialog.addHandlers$lambda$2(this, arg_0));
    }

    private final void releaseLockOnUpload() {
        Receiver receiver = this.receiver;
        Intrinsics.checkNotNull((Object)receiver, (String)"null cannot be cast to non-null type java.lang.Object");
        BackgroundThreadHandler.INSTANCE.releaseLock(receiver);
    }

    private static final void addHandlers$lambda$0(UploadDialog this$0, ClickEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.releaseLockOnUpload();
    }

    private static final void addHandlers$lambda$1(UploadDialog this$0, ClickEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.receiver.receiveUpload(null, null);
        this$0.releaseLockOnUpload();
    }

    private static final void addHandlers$lambda$2(UploadDialog this$0, Dialog.DialogCloseActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.releaseLockOnUpload();
    }
}

