/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.welcome;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.applayout.AppLayout;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.common.VContent;
import org.kopi.galite.visual.ui.vaadin.common.VHeader;
import org.kopi.galite.visual.ui.vaadin.common.VMain;
import org.kopi.galite.visual.ui.vaadin.event.LoginWindowListener;
import org.kopi.galite.visual.ui.vaadin.login.VEmptyModuleList;
import org.kopi.galite.visual.ui.vaadin.login.VLoginView;
import org.kopi.galite.visual.ui.vaadin.login.VLoginWindow;
import org.kopi.galite.visual.ui.vaadin.welcome.WelcomeViewEvent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B;\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u001a\u001a\u00020\u00152\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00150\u001cJ\u0006\u0010\u001e\u001a\u00020\u0015J\u0006\u0010\u001f\u001a\u00020\u0015J \u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010#\u001a\u00020\u00152\b\u0010\u0005\u001a\u0004\u0018\u00010\nJ\u0010\u0010$\u001a\u00020\u00152\b\u0010%\u001a\u0004\u0018\u00010\nJ\u0010\u0010&\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00010\nJ%\u0010'\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bH\u0004\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\n2\b\u0010+\u001a\u0004\u0018\u00010\nJ\u001c\u0010,\u001a\u00020\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010-\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\nJ\u0010\u0010.\u001a\u00020\u00152\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\nJ\u0006\u00101\u001a\u00020\u0015J\u0006\u00102\u001a\u00020\u0015R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/welcome/WelcomeView;", "Lcom/vaadin/flow/component/applayout/AppLayout;", "Lcom/vaadin/flow/component/HasStyle;", "Lcom/vaadin/flow/component/HasSize;", "Lorg/kopi/galite/visual/ui/vaadin/event/LoginWindowListener;", "locale", "Ljava/util/Locale;", "languages", "", "slogan", "", "logo", "href", "(Ljava/util/Locale;[Ljava/util/Locale;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "header", "Lorg/kopi/galite/visual/ui/vaadin/common/VHeader;", "loginWindow", "Lorg/kopi/galite/visual/ui/vaadin/login/VLoginWindow;", "main", "Lorg/kopi/galite/visual/ui/vaadin/common/VMain;", "addLoginWindowListener", "", "l", "addSupportedLanguage", "language", "isocode", "addWelcomeViewListener", "listener", "Lkotlin/Function1;", "Lorg/kopi/galite/visual/ui/vaadin/welcome/WelcomeViewEvent;", "clear", "focus", "onLogin", "username", "password", "setDefaultLocale", "setError", "error", "setHref", "setLanguages", "(Ljava/util/Locale;[Ljava/util/Locale;)V", "setLogo", "url", "alt", "setResources", "setSelectedLanguage", "setSloganImage", "setTarget", "target", "setWaitInfo", "unsetWaitInfo", "galite-core"})
@SourceDebugExtension(value={"SMAP\nWelcomeView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WelcomeView.kt\norg/kopi/galite/visual/ui/vaadin/welcome/WelcomeView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1#2:204\n*E\n"})
public final class WelcomeView
extends AppLayout
implements HasStyle,
HasSize,
LoginWindowListener {
    @Nullable
    private VHeader header;
    @Nullable
    private VMain main;
    @Nullable
    private VLoginWindow loginWindow;

    public WelcomeView(@NotNull Locale locale, @Nullable Locale[] languages, @Nullable String slogan, @Nullable String logo, @Nullable String href) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.setClassName("k-welcome-view");
        this.header = new VHeader();
        this.main = new VMain();
        this.loginWindow = new VLoginWindow();
        Component[] componentArray = new Component[]{this.header};
        this.addToNavbar(componentArray);
        this.setContent((Component)this.main);
        VHeader vHeader = this.header;
        Intrinsics.checkNotNull((Object)((Object)vHeader));
        vHeader.setMainMenu((Component)new VEmptyModuleList());
        VContent content = new VContent();
        VMain vMain = this.main;
        Intrinsics.checkNotNull((Object)((Object)vMain));
        vMain.setContent((Component)content);
        VLoginView loginView = new VLoginView();
        loginView.setLoginWindow((Component)this.loginWindow);
        content.setContent(loginView);
        this.setHref(href);
        this.setResources(logo, slogan);
        this.setTarget("_blank");
        this.focus();
        this.addLoginWindowListener(this);
        this.setDefaultLocale(locale.toString());
        this.setLanguages(locale, languages);
    }

    protected final void setLanguages(@NotNull Locale locale, @Nullable Locale[] languages) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNull((Object)languages);
        for (Locale language : languages) {
            String string = language.getDisplayName(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            this.addSupportedLanguage(string, language.toString());
            if (!Intrinsics.areEqual((Object)locale, (Object)language)) continue;
            String string2 = language.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            this.setSelectedLanguage(string2);
        }
    }

    public final void setHref(@Nullable String href) {
        VHeader vHeader = this.header;
        Intrinsics.checkNotNull((Object)((Object)vHeader));
        vHeader.setHref(href);
    }

    public final void setTarget(@NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        VHeader vHeader = this.header;
        Intrinsics.checkNotNull((Object)((Object)vHeader));
        vHeader.setTarget(target);
    }

    public final void setLogo(@NotNull String url, @Nullable String alt) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        VHeader vHeader = this.header;
        Intrinsics.checkNotNull((Object)((Object)vHeader));
        vHeader.setImage(url, alt);
    }

    public final void addSupportedLanguage(@NotNull String language, @Nullable String isocode) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        VLoginWindow vLoginWindow = this.loginWindow;
        Intrinsics.checkNotNull((Object)((Object)vLoginWindow));
        vLoginWindow.addSupportedLanguage(language, isocode);
    }

    public final void addLoginWindowListener(@NotNull LoginWindowListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        VLoginWindow vLoginWindow = this.loginWindow;
        Intrinsics.checkNotNull((Object)((Object)vLoginWindow));
        vLoginWindow.addLoginWindowListener(l);
    }

    public final void addWelcomeViewListener(@NotNull Function1<? super WelcomeViewEvent, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.addListener(WelcomeViewEvent.class, arg_0 -> WelcomeView.addWelcomeViewListener$lambda$0(listener, arg_0));
    }

    public final void setSloganImage(@Nullable String slogan) {
        VLoginWindow vLoginWindow = this.loginWindow;
        Intrinsics.checkNotNull((Object)((Object)vLoginWindow));
        vLoginWindow.setSloganImage(slogan);
    }

    public final void setDefaultLocale(@Nullable String locale) {
        VLoginWindow vLoginWindow = this.loginWindow;
        Intrinsics.checkNotNull((Object)((Object)vLoginWindow));
        vLoginWindow.setLocale(locale);
    }

    public final void setSelectedLanguage(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        VLoginWindow vLoginWindow = this.loginWindow;
        Intrinsics.checkNotNull((Object)((Object)vLoginWindow));
        vLoginWindow.setSelectedLanguage(language);
    }

    public final void setError(@Nullable String error2) {
        VLoginWindow vLoginWindow = this.loginWindow;
        Intrinsics.checkNotNull((Object)((Object)vLoginWindow));
        vLoginWindow.setError(error2);
    }

    public final void focus() {
        VLoginWindow vLoginWindow = this.loginWindow;
        Intrinsics.checkNotNull((Object)((Object)vLoginWindow));
        vLoginWindow.focus();
    }

    public final void clear() {
        this.header = null;
        this.main = null;
        this.loginWindow = null;
    }

    @Override
    public void onLogin(@NotNull String username, @NotNull String password, @NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.fireEvent(new WelcomeViewEvent(this, username, password, language));
    }

    private final void setResources(String logo, String slogan) {
        block1: {
            if (logo != null) {
                this.setLogo(logo, null);
            }
            String string = slogan;
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            this.setSloganImage(it);
        }
    }

    public final void setWaitInfo() {
        VLoginWindow vLoginWindow = this.loginWindow;
        Intrinsics.checkNotNull((Object)((Object)vLoginWindow));
        vLoginWindow.setWaitInfo();
    }

    public final void unsetWaitInfo() {
        VLoginWindow vLoginWindow = this.loginWindow;
        Intrinsics.checkNotNull((Object)((Object)vLoginWindow));
        vLoginWindow.unsetWaitInfo();
    }

    private static final void addWelcomeViewListener$lambda$0(Function1 $tmp0, WelcomeViewEvent p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0);
    }
}

