/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.chart;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.util.ResourceBundleWrapper;
import org.kopi.galite.visual.ApplicationContext;
import org.kopi.galite.visual.chart.UChartType;
import org.kopi.galite.visual.chart.VDataSeries;
import org.kopi.galite.visual.chart.VDimensionData;
import org.kopi.galite.visual.chart.VMeasureData;

public abstract class DAbstractChartType
extends ChartPanel
implements UChartType {
    private final String title;
    private final VDataSeries[] series;

    protected DAbstractChartType(String title, VDataSeries[] series) {
        super(null, true, true, true, true, true);
        this.title = title;
        this.series = series;
        localizationResources = ResourceBundleWrapper.getBundle((String)"org.jfree.chart.LocalizationBundle", (Locale)ApplicationContext.Companion.getDefaultLocale());
    }

    @Override
    public void build() {
        JFreeChart chart2 = this.createChart(this.title, this.series);
        if (chart2 != null) {
            this.setChart(chart2);
            this.setPreferredSize(new Dimension(800, 500));
        }
    }

    protected CategoryDataset createDataset(VDataSeries[] series) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (VDataSeries serie : series) {
            VMeasureData[] measures;
            VDimensionData dimension = serie.getDimension();
            for (VMeasureData measure : measures = serie.getMeasures()) {
                dataset.addValue(measure.getValue(), (Comparable)((Object)measure.getName()), dimension.getValue());
            }
        }
        return dataset;
    }

    protected void writeAsPDF(OutputStream destination, int width, int height, int marginLeft, int marginRight, int marginTop, int marginBottom, FontMapper mapper) throws IOException {
        Rectangle pageSize = new Rectangle((float)width, (float)height);
        Document document = new Document(pageSize, (float)marginLeft, (float)marginRight, (float)marginTop, (float)marginBottom);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)destination);
            document.addAuthor("kopi");
            document.addSubject(this.title);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2 = tp.createGraphics((float)width, (float)height, mapper);
            Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, width, height);
            this.getChart().draw(g2, (Rectangle2D)r2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
        catch (DocumentException de) {
            throw new IOException(de.getMessage());
        }
        document.close();
    }

    protected Color getPlotBackground() {
        return new Color(239, 235, 222);
    }

    protected Color getChartBackground() {
        return new Color(248, 247, 241);
    }

    protected Color getGridLineColor() {
        return new Color(107, 130, 239);
    }

    protected abstract JFreeChart createChart(String var1, VDataSeries[] var2);
}

