/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.spellchecker;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.kopi.galite.visual.VlibProperties;
import org.kopi.vkopi.lib.ui.swing.spellchecker.SpellChecker;
import org.kopi.vkopi.lib.ui.swing.spellchecker.Suggestions;

public class SpellcheckerDialog
extends JDialog {
    private SpellChecker spellChecker;
    private List<String> suggestions;
    private JTextField changeTo;
    private JTextField originalWordTextField;
    private JList suggestionsList;
    private static final long serialVersionUID = -220369137180783262L;

    public SpellcheckerDialog(Frame owner, String title, SpellChecker spellchecker) {
        super(owner);
        this.spellChecker = spellchecker;
        this.setModal(true);
        this.setTitle(title);
        this.buildDisplay();
        this.initSuggestionElements();
    }

    public String getSelectedWord() {
        return this.changeTo.getText();
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        CloseDialogActionListener actionListener = new CloseDialogActionListener();
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    private void addRow(Box mainBox, JComponent labelComponent, Component component) {
        Box hBox = Box.createHorizontalBox();
        mainBox.add(hBox);
        Dimension labelComponentDim = new Dimension(100, labelComponent.getPreferredSize().height);
        labelComponent.setPreferredSize(labelComponentDim);
        labelComponent.setMinimumSize(labelComponentDim);
        labelComponent.setMaximumSize(labelComponentDim);
        hBox.add(labelComponent);
        hBox.add(Box.createHorizontalGlue());
        hBox.add(component);
        hBox.add(Box.createHorizontalGlue());
    }

    private void buildDisplay() {
        JButton cancelButton = new JButton(new CancelAction());
        JButton changeButton = new JButton(new ChangeAction());
        JButton changeAllButton = new JButton(new ChangeAllAction());
        JButton ignoreButton = new JButton(new IgnoreAction());
        JButton ignoreAllButton = new JButton(new IgnoreAllAction());
        this.changeTo = new JTextField();
        this.changeTo.setMinimumSize(new Dimension(200, this.changeTo.getPreferredSize().height));
        this.changeTo.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.changeTo.getPreferredSize().height));
        this.originalWordTextField = new JTextField();
        this.originalWordTextField.setMinimumSize(new Dimension(200, this.originalWordTextField.getPreferredSize().height));
        this.originalWordTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.originalWordTextField.getPreferredSize().height));
        this.suggestionsList = new JList();
        this.suggestionsList.setSelectionMode(0);
        this.suggestionsList.addListSelectionListener(new MyListSelectionListener());
        this.suggestionsList.setMinimumSize(new Dimension(200, 300));
        this.suggestionsList.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.suggestionsList.setPreferredSize(new Dimension(200, 300));
        JScrollPane suggestionsPane = new JScrollPane(this.suggestionsList);
        Box mainBox = Box.createVerticalBox();
        JPanel buttonPanel = new JPanel();
        this.getContentPane().add(mainBox);
        JLabel jLabel = new JLabel(VlibProperties.getString("aspell-dialog-not-in"));
        this.addRow(mainBox, jLabel, this.originalWordTextField);
        jLabel = new JLabel(VlibProperties.getString("aspell-dialog-change-to"));
        this.addRow(mainBox, jLabel, this.changeTo);
        jLabel = new JLabel(VlibProperties.getString("aspell-dialog-suggestions"));
        Box hBox = Box.createHorizontalBox();
        hBox.add(suggestionsPane);
        hBox.add(Box.createHorizontalGlue());
        this.getRootPane().setDefaultButton(ignoreButton);
        buttonPanel.setPreferredSize(new Dimension(200, 100));
        buttonPanel.add(ignoreButton);
        buttonPanel.add(ignoreAllButton);
        buttonPanel.add(changeButton);
        buttonPanel.add(changeAllButton);
        buttonPanel.add(cancelButton);
        hBox.add(buttonPanel);
        hBox.add(Box.createHorizontalGlue());
        this.addRow(mainBox, jLabel, hBox);
        this.pack();
    }

    private void checkNext() {
        if (this.spellChecker.checkNext()) {
            this.initSuggestionElements();
        } else {
            this.dispose();
        }
    }

    private void initSuggestionElements() {
        Suggestions result = this.spellChecker.getSuggestions();
        this.suggestions = result.getSuggestions();
        DefaultComboBoxModel<Object> model2 = new DefaultComboBoxModel<Object>(result.getSuggestions().toArray());
        this.suggestionsList.setModel(model2);
        this.originalWordTextField.setText(result.getOriginalWord());
        if (this.suggestions.size() > 0) {
            this.suggestionsList.setSelectedIndex(0);
            this.suggestionsList.grabFocus();
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedIndex = SpellcheckerDialog.this.suggestionsList.getSelectedIndex();
            if (selectedIndex >= 0) {
                SpellcheckerDialog.this.changeTo.setText(SpellcheckerDialog.this.suggestions.get(selectedIndex));
            }
        }
    }

    private class CloseDialogActionListener
    implements ActionListener {
        private CloseDialogActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpellcheckerDialog.this.dispose();
        }
    }

    private class IgnoreAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 3082583855533470939L;

        private IgnoreAllAction() {
            super(VlibProperties.getString("aspell-dialog-ignore-all"));
            this.putValue("MnemonicKey", new Integer(71));
            this.putValue("AcceleratorKey", new Integer(71));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SpellcheckerDialog.this.spellChecker.ignoreAll(SpellcheckerDialog.this.getSelectedWord());
            SpellcheckerDialog.this.checkNext();
        }
    }

    private class IgnoreAction
    extends AbstractAction {
        private static final long serialVersionUID = -5969056223868591429L;

        private IgnoreAction() {
            super(VlibProperties.getString("aspell-dialog-ignore"));
            this.putValue("MnemonicKey", new Integer(73));
            this.putValue("AcceleratorKey", new Integer(73));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SpellcheckerDialog.this.spellChecker.ignore(SpellcheckerDialog.this.getSelectedWord());
            SpellcheckerDialog.this.checkNext();
        }
    }

    private class ChangeAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 8492059401975099177L;

        private ChangeAllAction() {
            super(VlibProperties.getString("aspell-dialog-change-all"));
            this.putValue("MnemonicKey", new Integer(76));
            this.putValue("AcceleratorKey", new Integer(76));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SpellcheckerDialog.this.spellChecker.changeAll(SpellcheckerDialog.this.getSelectedWord());
            SpellcheckerDialog.this.checkNext();
        }
    }

    private class ChangeAction
    extends AbstractAction {
        private static final long serialVersionUID = -9046898360749709345L;

        private ChangeAction() {
            super(VlibProperties.getString("aspell-dialog-change"));
            this.putValue("MnemonicKey", new Integer(67));
            this.putValue("AcceleratorKey", new Integer(67));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SpellcheckerDialog.this.spellChecker.change(SpellcheckerDialog.this.getSelectedWord());
            SpellcheckerDialog.this.checkNext();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 9054956716054138769L;

        private CancelAction() {
            super(VlibProperties.getString("aspell-dialog-cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SpellcheckerDialog.this.dispose();
        }
    }
}

