/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.kopi.galite.visual.MessageCode;
import org.kopi.vkopi.lib.ui.swing.visual.SwingThreadHandler;

public class WaitWindow {
    Frame frame;
    int seconds = 0;
    long time;
    JDialog waitDialog;
    Timer timer;
    JProgressBar progressBar;
    JLabel text;

    public WaitWindow(Frame frame) {
        this.frame = frame;
    }

    public final void setWaitDialog(String message, int maxTime) {
        if (this.waitDialog == null) {
            this.waitDialog = new JDialog(this.frame, "no frame", true);
            this.waitDialog.setUndecorated(true);
            this.waitDialog.setDefaultCloseOperation(0);
            this.progressBar = new JProgressBar(0, maxTime);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.text = new JLabel("<html><b> " + MessageCode.INSTANCE.getMessage("VIS-00067") + " </b><br>" + message);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this.text, "North");
            panel.add((Component)this.progressBar, "South");
            panel.setBorder(new CompoundBorder(new LineBorder(Color.black, 1), new EmptyBorder(2, 2, 2, 2)));
            this.waitDialog.getContentPane().add(panel);
            this.timer = new Timer(250, new TimerListener());
            this.timer.start();
            this.time = System.currentTimeMillis();
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Point parentPos = new Point(0, 0);
            this.waitDialog.pack();
            SwingUtilities.convertPointToScreen(parentPos, this.frame);
            int posx = parentPos.x + this.frame.getSize().width / 2 - this.waitDialog.getSize().width / 2;
            int posy = parentPos.y + this.frame.getSize().height / 2 - this.waitDialog.getSize().height / 2;
            if (posx < 0) {
                posx = 0;
            } else if (posx + this.waitDialog.getSize().width > screen.width) {
                posx = screen.width - this.waitDialog.getSize().width;
            }
            if (posy < 0) {
                posy = 0;
            } else if (posy + this.waitDialog.getSize().height > screen.height) {
                posy = screen.height - this.waitDialog.getSize().height;
            }
            posx = Math.max(posx, 0);
            posy = Math.max(posy, 0);
            this.waitDialog.setLocation(posx, posy);
            final JDialog wd = this.waitDialog;
            SwingThreadHandler.start(new Runnable(){

                @Override
                public void run() {
                    wd.setVisible(true);
                }
            });
        } else {
            this.text.setText("<html><b> " + MessageCode.INSTANCE.getMessage("VIS-00067") + " </b><br>" + message);
            this.progressBar.setMaximum(maxTime);
        }
    }

    public void updateMessage(String message) {
        if (this.waitDialog != null) {
            this.text.setText("<html><b> " + MessageCode.INSTANCE.getMessage("VIS-00067") + " </b><br>" + message);
        }
    }

    public final void unsetWaitDialog() {
        this.waitDialog.setVisible(false);
        this.timer.stop();
        this.waitDialog.dispose();
        this.waitDialog = null;
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            long newTime = System.currentTimeMillis();
            WaitWindow.this.seconds = (int)((long)WaitWindow.this.seconds + (newTime - WaitWindow.this.time));
            WaitWindow.this.time = newTime;
            WaitWindow.this.progressBar.setValue(WaitWindow.this.seconds);
        }
    }
}

