/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.calendar;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.Action;
import org.kopi.galite.visual.MessageCode;
import org.kopi.galite.visual.VExecFailedException;
import org.kopi.galite.visual.fullcalendar.VFullCalendarBlock;
import org.kopi.galite.visual.fullcalendar.VFullCalendarEntry;
import org.kopi.galite.visual.ui.vaadin.base.BackgroundThreadHandler;
import org.kopi.galite.visual.ui.vaadin.base.Utils;
import org.vaadin.stefan.fullcalendar.CalendarView;
import org.vaadin.stefan.fullcalendar.CalendarViewImpl;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.EntryClickedEvent;
import org.vaadin.stefan.fullcalendar.EntryDroppedEvent;
import org.vaadin.stefan.fullcalendar.EntryResizedEvent;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.FullCalendarBuilder;
import org.vaadin.stefan.fullcalendar.TimeslotsSelectedEvent;

@CssImport(value="./styles/galite/fullcalendar.css")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u00011B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0003J\u0006\u0010!\u001a\u00020\u001cJ\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020#J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0014J\u0006\u0010)\u001a\u00020\u001cJ\b\u0010*\u001a\u00020\u001cH\u0002J\b\u0010+\u001a\u00020\u001cH\u0002J\b\u0010,\u001a\u00020\u001cH\u0002J\b\u0010-\u001a\u00020\u001cH\u0002J\u0016\u0010-\u001a\u00020\u001c2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/calendar/DAbstractFullCalendar;", "Lcom/vaadin/flow/component/orderedlayout/VerticalLayout;", "model", "Lorg/kopi/galite/visual/fullcalendar/VFullCalendarBlock;", "type", "Lorg/vaadin/stefan/fullcalendar/CalendarViewImpl;", "(Lorg/kopi/galite/visual/fullcalendar/VFullCalendarBlock;Lorg/vaadin/stefan/fullcalendar/CalendarViewImpl;)V", "calendar", "Lorg/vaadin/stefan/fullcalendar/FullCalendar;", "getCalendar", "()Lorg/vaadin/stefan/fullcalendar/FullCalendar;", "currentUI", "Lcom/vaadin/flow/component/UI;", "getCurrentUI", "()Lcom/vaadin/flow/component/UI;", "setCurrentUI", "(Lcom/vaadin/flow/component/UI;)V", "datePicker", "Lcom/vaadin/flow/component/datepicker/DatePicker;", "getDatePicker", "()Lcom/vaadin/flow/component/datepicker/DatePicker;", "header", "Lcom/vaadin/flow/component/orderedlayout/HorizontalLayout;", "getHeader", "()Lcom/vaadin/flow/component/orderedlayout/HorizontalLayout;", "getModel", "()Lorg/kopi/galite/visual/fullcalendar/VFullCalendarBlock;", "addEntryListeners", "", "check", "startDateTime", "Ljava/time/LocalDateTime;", "endDateTime", "enter", "getSelectedDate", "Ljava/time/LocalDate;", "goToDate", "date", "onAttach", "attachEvent", "Lcom/vaadin/flow/component/AttachEvent;", "refreshEntries", "removeAllEntries", "setDatePickerListeners", "setHeader", "updateEntries", "entries", "", "Lorg/kopi/galite/visual/fullcalendar/VFullCalendarEntry;", "FullCalendarEntry", "galite-core"})
@SourceDebugExtension(value={"SMAP\nDAbstractFullCalendar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DAbstractFullCalendar.kt\norg/kopi/galite/visual/ui/vaadin/calendar/DAbstractFullCalendar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1549#2:235\n1620#2,3:236\n1549#2:239\n1620#2,3:240\n819#2:243\n847#2,2:244\n1549#2:246\n1620#2,3:247\n*S KotlinDebug\n*F\n+ 1 DAbstractFullCalendar.kt\norg/kopi/galite/visual/ui/vaadin/calendar/DAbstractFullCalendar\n*L\n106#1:235\n106#1:236,3\n108#1:239\n108#1:240,3\n122#1:243\n122#1:244,2\n212#1:246\n212#1:247,3\n*E\n"})
public class DAbstractFullCalendar
extends VerticalLayout {
    @NotNull
    private final VFullCalendarBlock model;
    @NotNull
    private final CalendarViewImpl type;
    @NotNull
    private final FullCalendar calendar;
    @NotNull
    private final DatePicker datePicker;
    @NotNull
    private final HorizontalLayout header;
    @Nullable
    private UI currentUI;

    protected DAbstractFullCalendar(@NotNull VFullCalendarBlock model2, @NotNull CalendarViewImpl type) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.model = model2;
        this.type = type;
        FullCalendar fullCalendar = FullCalendarBuilder.create().build();
        Intrinsics.checkNotNullExpressionValue((Object)fullCalendar, (String)"build(...)");
        this.calendar = fullCalendar;
        this.datePicker = new DatePicker(LocalDate.now());
        this.header = new HorizontalLayout();
        this.setWidth("150vh");
        this.setHeight("70vh");
        this.calendar.setSizeFull();
        this.calendar.changeView((CalendarView)this.type);
        this.updateEntries();
        this.setHeader();
        Component[] componentArray = new Component[]{this.calendar};
        this.add(componentArray);
        this.setDatePickerListeners();
        this.addEntryListeners();
    }

    @NotNull
    protected final VFullCalendarBlock getModel() {
        return this.model;
    }

    @NotNull
    protected final FullCalendar getCalendar() {
        return this.calendar;
    }

    @NotNull
    protected final DatePicker getDatePicker() {
        return this.datePicker;
    }

    @NotNull
    protected final HorizontalLayout getHeader() {
        return this.header;
    }

    @Nullable
    protected final UI getCurrentUI() {
        return this.currentUI;
    }

    protected final void setCurrentUI(@Nullable UI uI) {
        this.currentUI = uI;
    }

    public final void refreshEntries() {
        this.updateEntries();
    }

    @NotNull
    public final LocalDate getSelectedDate() {
        Object object = this.datePicker.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (LocalDate)object;
    }

    public final void goToDate(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        BackgroundThreadHandler.INSTANCE.access(this.currentUI, (Function0<Unit>)((Function0)new Function0<Unit>(this, date){
            final /* synthetic */ DAbstractFullCalendar this$0;
            final /* synthetic */ LocalDate $date;
            {
                this.this$0 = $receiver;
                this.$date = $date;
                super(0);
            }

            public final void invoke() {
                this.this$0.getCalendar().gotoDate(this.$date);
            }
        }));
    }

    public final void enter() {
        BackgroundThreadHandler.INSTANCE.access(this.currentUI, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getDatePicker().focus();
            }
        }));
    }

    private final void updateEntries() {
        this.model.getForm().performAsyncAction(new Action(this){
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.this$0 = $receiver;
                super("Fetch entries");
            }

            public void execute() {
                VFullCalendarBlock vFullCalendarBlock = this.this$0.getModel();
                Object object = this.this$0.getDatePicker().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                List<VFullCalendarEntry> queryList = vFullCalendarBlock.fetchEntries((LocalDate)object);
                DAbstractFullCalendar.access$updateEntries(this.this$0, queryList);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void updateEntries(List<VFullCalendarEntry> entries) {
        void $this$filterNotTo$iv$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List list = this.calendar.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntries(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Entry entry = (Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.calendar.DAbstractFullCalendar.FullCalendarEntry");
            collection.add(((FullCalendarEntry)it).getUpdatedModel());
        }
        List currentEntries = (List)destination$iv$iv;
        Iterable $this$map$iv2 = CollectionsKt.minus((Iterable)entries, (Iterable)CollectionsKt.toSet((Iterable)currentEntries));
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void fcEntry;
            VFullCalendarEntry bl = (VFullCalendarEntry)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Object object = fcEntry.getValues().get(this.model.getIdField());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            int record = (Integer)object;
            FullCalendarEntry entry = new FullCalendarEntry(record, (VFullCalendarEntry)fcEntry);
            LocalDateTime start = fcEntry.getStart();
            LocalDateTime end = fcEntry.getEnd();
            entry.setTitle(fcEntry.getDescription());
            entry.setStart(start, this.calendar.getTimezone());
            entry.setEnd(end, this.calendar.getTimezone());
            entry.setColor(Utils.INSTANCE.toString(fcEntry.getColor(record)));
            collection.add(entry);
        }
        List newEntries = (List)destination$iv$iv2;
        List list2 = this.calendar.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntries(...)");
        Iterable $this$filterNot$iv = list2;
        boolean $i$f$filterNot = false;
        destination$iv$iv2 = $this$filterNot$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Entry it = (Entry)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.calendar.DAbstractFullCalendar.FullCalendarEntry");
            if (entries.contains(((FullCalendarEntry)it).getUpdatedModel())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List dirtyEntries = (List)destination$iv$iv3;
        BackgroundThreadHandler.INSTANCE.access(this.currentUI, (Function0<Unit>)((Function0)new Function0<Unit>(this, (List<FullCalendarEntry>)newEntries, (List<? extends Entry>)dirtyEntries){
            final /* synthetic */ DAbstractFullCalendar this$0;
            final /* synthetic */ List<FullCalendarEntry> $newEntries;
            final /* synthetic */ List<Entry> $dirtyEntries;
            {
                this.this$0 = $receiver;
                this.$newEntries = $newEntries;
                this.$dirtyEntries = $dirtyEntries;
                super(0);
            }

            public final void invoke() {
                this.this$0.getCalendar().addEntries((Iterable)this.$newEntries);
                this.this$0.getCalendar().removeEntries((Iterable)this.$dirtyEntries);
            }
        }));
    }

    private final void setHeader() {
        this.header.setId("fullCalendar-header");
        this.datePicker.setId("fullCalendar-date-picker");
        Component[] componentArray = new Component[]{this.datePicker};
        this.header.add(componentArray);
        componentArray = new Component[]{this.header};
        super.add(componentArray);
    }

    private final void setDatePickerListeners() {
        this.datePicker.addValueChangeListener(new HasValue.ValueChangeListener(this){
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.this$0 = $receiver;
            }

            public final void valueChanged(AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate> event) {
                if (event.isFromClient()) {
                    this.this$0.getModel().getForm().performAsyncAction(new Action(this.this$0, event){
                        final /* synthetic */ DAbstractFullCalendar this$0;
                        final /* synthetic */ AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate> $event;
                        {
                            this.this$0 = $receiver;
                            this.$event = $event;
                            super("Selected date changed");
                        }

                        public void execute() {
                            VFullCalendarBlock vFullCalendarBlock = this.this$0.getModel();
                            Object object = this.$event.getOldValue();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOldValue(...)");
                            LocalDate localDate = (LocalDate)object;
                            Object object2 = this.$event.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getValue(...)");
                            vFullCalendarBlock.dateChanged$galite_core(localDate, (LocalDate)object2);
                        }
                    });
                }
            }
        });
    }

    private final void addEntryListeners() {
        this.calendar.addEntryClickedListener(arg_0 -> DAbstractFullCalendar.addEntryListeners$lambda$3(this, arg_0));
        this.calendar.addEntryResizedListener(arg_0 -> DAbstractFullCalendar.addEntryListeners$lambda$4(this, arg_0));
        this.calendar.addEntryDroppedListener(arg_0 -> DAbstractFullCalendar.addEntryListeners$lambda$5(this, arg_0));
        this.calendar.addTimeslotsSelectedListener(arg_0 -> DAbstractFullCalendar.addEntryListeners$lambda$6(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="to be removed when dateField is not supported")
    private final void check(LocalDateTime startDateTime, LocalDateTime endDateTime) {
        if (this.model.getDateField() != null && startDateTime.getDayOfWeek() != endDateTime.getDayOfWeek()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list = this.calendar.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntries(...)");
            Iterable iterable = list;
            DAbstractFullCalendar dAbstractFullCalendar = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Entry entry = (Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.calendar.DAbstractFullCalendar.FullCalendarEntry");
                collection.add(((FullCalendarEntry)it).getModel());
            }
            dAbstractFullCalendar.updateEntries((List)destination$iv$iv);
            throw new VExecFailedException(MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00070", null, false, 6, null));
        }
    }

    private final void removeAllEntries() {
        BackgroundThreadHandler.INSTANCE.access(this.currentUI, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getCalendar().removeAllEntries();
            }
        }));
    }

    protected void onAttach(@NotNull AttachEvent attachEvent) {
        Intrinsics.checkNotNullParameter((Object)attachEvent, (String)"attachEvent");
        this.currentUI = attachEvent.getUI();
    }

    private static final void addEntryListeners$lambda$3(DAbstractFullCalendar this$0, EntryClickedEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.model.getForm().performAsyncAction(new Action(this$0, it){
            final /* synthetic */ DAbstractFullCalendar this$0;
            final /* synthetic */ EntryClickedEvent $it;
            {
                this.this$0 = $receiver;
                this.$it = $it;
                super("entry clicked");
            }

            public void execute() {
                VFullCalendarBlock vFullCalendarBlock = this.this$0.getModel();
                Entry entry = this.$it.getEntry();
                Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.calendar.DAbstractFullCalendar.FullCalendarEntry");
                vFullCalendarBlock.openForEdit$galite_core(((FullCalendarEntry)entry).getRecord());
            }
        });
    }

    private static final void addEntryListeners$lambda$4(DAbstractFullCalendar this$0, EntryResizedEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.model.getForm().performAsyncAction(new Action(it, this$0){
            final /* synthetic */ EntryResizedEvent $it;
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.$it = $it;
                this.this$0 = $receiver;
                super("entry time edited");
            }

            public void execute() {
                Entry newEntry = this.$it.applyChangesOnEntry();
                LocalDateTime newStart = newEntry.getStart();
                LocalDateTime newEnd = newEntry.getEnd();
                Intrinsics.checkNotNull((Object)newStart);
                Intrinsics.checkNotNull((Object)newEnd);
                DAbstractFullCalendar.access$check(this.this$0, newStart, newEnd);
                VFullCalendarBlock vFullCalendarBlock = this.this$0.getModel();
                Entry entry = this.$it.getEntry();
                Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.calendar.DAbstractFullCalendar.FullCalendarEntry");
                vFullCalendarBlock.openForEdit$galite_core(((FullCalendarEntry)entry).getRecord(), newStart, newEnd);
            }
        });
    }

    private static final void addEntryListeners$lambda$5(DAbstractFullCalendar this$0, EntryDroppedEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.model.getForm().performAsyncAction(new Action(it, this$0){
            final /* synthetic */ EntryDroppedEvent $it;
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.$it = $it;
                this.this$0 = $receiver;
                super("entry time edited");
            }

            public void execute() {
                Entry newEntry = this.$it.applyChangesOnEntry();
                LocalDateTime newStart = newEntry.getStart();
                LocalDateTime newEnd = newEntry.getEnd();
                Intrinsics.checkNotNull((Object)newStart);
                Intrinsics.checkNotNull((Object)newEnd);
                DAbstractFullCalendar.access$check(this.this$0, newStart, newEnd);
                VFullCalendarBlock vFullCalendarBlock = this.this$0.getModel();
                Entry entry = this.$it.getEntry();
                Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.calendar.DAbstractFullCalendar.FullCalendarEntry");
                vFullCalendarBlock.openForEdit$galite_core(((FullCalendarEntry)entry).getRecord(), newStart, newEnd);
            }
        });
    }

    private static final void addEntryListeners$lambda$6(DAbstractFullCalendar this$0, TimeslotsSelectedEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.model.getForm().performAsyncAction(new Action(it, this$0){
            final /* synthetic */ TimeslotsSelectedEvent $it;
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.$it = $it;
                this.this$0 = $receiver;
                super("new entry");
            }

            public void execute() {
                LocalDateTime start = this.$it.getStartDateTime();
                LocalDateTime end = this.$it.getEndDateTime();
                Intrinsics.checkNotNull((Object)start);
                Intrinsics.checkNotNull((Object)end);
                DAbstractFullCalendar.access$check(this.this$0, start, end);
                this.this$0.getModel().openForEdit(start, end);
            }
        });
    }

    public static final /* synthetic */ void access$updateEntries(DAbstractFullCalendar $this, List entries) {
        $this.updateEntries(entries);
    }

    public static final /* synthetic */ void access$check(DAbstractFullCalendar $this, LocalDateTime startDateTime, LocalDateTime endDateTime) {
        $this.check(startDateTime, endDateTime);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\r"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/calendar/DAbstractFullCalendar$FullCalendarEntry;", "Lorg/vaadin/stefan/fullcalendar/Entry;", "record", "", "model", "Lorg/kopi/galite/visual/fullcalendar/VFullCalendarEntry;", "(ILorg/kopi/galite/visual/fullcalendar/VFullCalendarEntry;)V", "getModel", "()Lorg/kopi/galite/visual/fullcalendar/VFullCalendarEntry;", "getRecord", "()I", "updatedModel", "getUpdatedModel", "galite-core"})
    public static final class FullCalendarEntry
    extends Entry {
        private final int record;
        @NotNull
        private final VFullCalendarEntry model;

        public FullCalendarEntry(int record, @NotNull VFullCalendarEntry model2) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            this.record = record;
            this.model = model2;
        }

        public final int getRecord() {
            return this.record;
        }

        @NotNull
        public final VFullCalendarEntry getModel() {
            return this.model;
        }

        @NotNull
        public final VFullCalendarEntry getUpdatedModel() {
            LocalDateTime localDateTime = this.getStart();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getStart(...)");
            LocalDateTime localDateTime2 = this.getEnd();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getEnd(...)");
            return this.model.copy(localDateTime, localDateTime2);
        }
    }
}

