/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.form;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutEvent;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import java.time.LocalDate;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.VExecFailedException;
import org.kopi.galite.visual.base.UComponent;
import org.kopi.galite.visual.form.Alignment;
import org.kopi.galite.visual.form.BlockAlignment;
import org.kopi.galite.visual.form.UBlock;
import org.kopi.galite.visual.form.UForm;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VConstants;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VFieldUI;
import org.kopi.galite.visual.ui.vaadin.block.Block;
import org.kopi.galite.visual.ui.vaadin.block.BlockLayout;
import org.kopi.galite.visual.ui.vaadin.block.SimpleBlockLayout;
import org.kopi.galite.visual.ui.vaadin.form.DBlockDropHandler;
import org.kopi.galite.visual.ui.vaadin.form.DFieldUI;
import org.kopi.galite.visual.ui.vaadin.form.DForm;
import org.kopi.galite.visual.ui.vaadin.form.Form;
import org.kopi.galite.visual.ui.vaadin.form.Page;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@CssImport(value="./styles/galite/block.css")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u000205H\u0016J\u000e\u00106\u001a\u0002012\u0006\u00107\u001a\u000208J\u0018\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\tH\u0016J\b\u0010<\u001a\u000201H\u0016J\b\u0010=\u001a\u000201H\u0016J\b\u0010>\u001a\u000201H\u0016J\u001a\u0010?\u001a\u0002012\u0006\u0010:\u001a\u00020\u00062\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\u001a\u0010B\u001a\u0002012\u0006\u0010:\u001a\u00020\u00062\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\b\u0010C\u001a\u000201H\u0016J\u0018\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020AH\u0014J\u001a\u0010F\u001a\u0004\u0018\u00010\f2\u0006\u0010E\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020AH\u0002J\b\u0010G\u001a\u000201H\u0014J\b\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u000201H\u0016J\u0010\u0010K\u001a\u0002012\u0006\u0010L\u001a\u00020\u001dH\u0014J\b\u0010M\u001a\u000201H\u0016J\b\u0010N\u001a\u000201H\u0016J\b\u0010O\u001a\u000201H\u0014J,\u0010P\u001a\u0002012\u0006\u0010Q\u001a\u00020\u001d2\u0006\u0010R\u001a\u00020\u001d2\b\u0010S\u001a\u0004\u0018\u00010T2\b\u0010U\u001a\u0004\u0018\u00010TH\u0016J\u0010\u0010V\u001a\u00020\u001d2\u0006\u0010W\u001a\u00020\u001dH\u0016J\n\u0010X\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010Y\u001a\u00020\u001dH\u0014J\b\u0010Z\u001a\u00020\u001dH\u0016J\u0010\u0010Z\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020[H\u0016J\u0010\u0010\\\u001a\u00020\u001d2\u0006\u0010]\u001a\u00020\u001dH\u0016J\n\u0010^\u001a\u0004\u0018\u00010_H\u0016J\u0010\u0010`\u001a\u00020\u001d2\u0006\u0010R\u001a\u00020\u001dH\u0002J\u0010\u0010a\u001a\u0002012\u0006\u0010b\u001a\u00020_H\u0016J\b\u0010c\u001a\u00020\tH\u0016J\b\u0010d\u001a\u00020\tH\u0016J\u0010\u0010e\u001a\u0002012\u0006\u0010f\u001a\u00020gH\u0014J\u0014\u0010h\u001a\u0002012\f\u0010i\u001a\b\u0012\u0004\u0012\u00020\u001d0jJ\b\u0010k\u001a\u000201H\u0016J\u0006\u0010l\u001a\u000201J\u0018\u0010m\u001a\u0002012\u0006\u0010R\u001a\u00020\u001d2\u0006\u0010n\u001a\u00020\u001dH\u0016J\u0010\u0010o\u001a\u0002012\u0006\u0010p\u001a\u00020\tH\u0016J\b\u0010q\u001a\u000201H\u0016J\u0006\u0010r\u001a\u000201J\u0010\u0010s\u001a\u0002012\u0006\u0010t\u001a\u00020\u001dH\u0016J-\u0010u\u001a\u0002012\u0006\u0010v\u001a\u00020\u001d2\b\u0010w\u001a\u0004\u0018\u00010T2\f\u0010x\u001a\b\u0012\u0002\b\u0003\u0018\u00010yH\u0000\u00a2\u0006\u0002\bzJ\u0010\u0010{\u001a\u0002012\u0006\u0010|\u001a\u00020\tH\u0016J\u000e\u0010}\u001a\u0002012\u0006\u0010~\u001a\u00020\u001dJ\b\u0010\u007f\u001a\u000201H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0084.\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001fR\u0014\u0010%\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\"R\u0014\u0010*\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001bR\u001a\u0010,\u001a\u00020\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001f\"\u0004\b.\u0010/\u00a8\u0006\u0080\u0001"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DBlock;", "Lorg/kopi/galite/visual/ui/vaadin/block/Block;", "Lorg/kopi/galite/visual/form/UBlock;", "parent", "Lorg/kopi/galite/visual/ui/vaadin/form/DForm;", "model", "Lorg/kopi/galite/visual/form/VBlock;", "(Lorg/kopi/galite/visual/ui/vaadin/form/DForm;Lorg/kopi/galite/visual/form/VBlock;)V", "activeRecordSetFromDisplay", "", "columnViews", "", "Lorg/kopi/galite/visual/form/VFieldUI;", "getColumnViews", "()[Lorg/kopi/galite/visual/form/VFieldUI;", "setColumnViews", "([Lorg/kopi/galite/visual/form/VFieldUI;)V", "[Lorg/kopi/galite/visual/form/VFieldUI;", "currentUI", "Lcom/vaadin/flow/component/UI;", "getCurrentUI", "()Lcom/vaadin/flow/component/UI;", "setCurrentUI", "(Lcom/vaadin/flow/component/UI;)V", "displayToSortedRec", "", "getDisplayToSortedRec", "()[I", "displayedFields", "", "getDisplayedFields", "()I", "formView", "getFormView", "()Lorg/kopi/galite/visual/ui/vaadin/form/DForm;", "maxColumnPos", "getMaxColumnPos", "maxRowPos", "getMaxRowPos", "getModel", "()Lorg/kopi/galite/visual/form/VBlock;", "getParent", "sortedRecToDisplay", "getSortedRecToDisplay", "sortedToprec", "getSortedToprec", "setSortedToprec", "(I)V", "add", "", "comp", "Lorg/kopi/galite/visual/base/UComponent;", "constraints", "Lorg/kopi/galite/visual/form/Alignment;", "addRecordPositionPanel", "form", "Lorg/kopi/galite/visual/ui/vaadin/form/Form;", "blockAccessChanged", "block", "newAccess", "blockChanged", "blockCleared", "blockClosed", "blockViewModeEntered", "activeField", "Lorg/kopi/galite/visual/form/VField;", "blockViewModeLeaved", "clear", "createFieldDisplay", "index", "createFieldDisplays", "createFields", "createLayout", "Lorg/kopi/galite/visual/ui/vaadin/block/BlockLayout;", "enter", "enterRecord", "recno", "filterHidden", "filterShown", "fireActiveRecordChanged", "fireColorChanged", "col", "rec", "foreground", "", "background", "getColumnPos", "x", "getCurrentDisplay", "getCurrentRecord", "getDisplayLine", "Lorg/kopi/galite/visual/form/UForm;", "getRecordFromDisplayLine", "line", "getSelectedDate", "Ljava/time/LocalDate;", "getSortedPosition", "goToDate", "date", "inDetailMode", "isEnabled", "onAttach", "attachEvent", "Lcom/vaadin/flow/component/AttachEvent;", "onValueChange", "event", "Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;", "orderChanged", "rebuildCachedInfos", "recordInfoChanged", "info", "refresh", "force", "refreshEntries", "release", "setActiveRecordFromDisplay", "displayLine", "setBorder", "style", "title", "page", "Lorg/kopi/galite/visual/ui/vaadin/form/Page;", "setBorder$galite_core", "setEnabled", "enabled", "setScrollPos", "value", "validRecordNumberChanged", "galite-core"})
@SourceDebugExtension(value={"SMAP\nDBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DBlock.kt\norg/kopi/galite/visual/ui/vaadin/form/DBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,536:1\n1864#2,3:537\n1#3:540\n13309#4,2:541\n*S KotlinDebug\n*F\n+ 1 DBlock.kt\norg/kopi/galite/visual/ui/vaadin/form/DBlock\n*L\n113#1:537,3\n492#1:541,2\n*E\n"})
public class DBlock
extends Block
implements UBlock {
    @NotNull
    private final DForm parent;
    @NotNull
    private final VBlock model;
    @NotNull
    private final DForm formView;
    protected VFieldUI[] columnViews;
    private final int maxRowPos;
    private final int maxColumnPos;
    private final int displayedFields;
    @NotNull
    private final int[] sortedRecToDisplay;
    @NotNull
    private final int[] displayToSortedRec;
    private int sortedToprec;
    @Nullable
    private UI currentUI;
    private boolean activeRecordSetFromDisplay;

    public DBlock(@NotNull DForm parent, @NotNull VBlock model2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(model2.isDroppable() ? new DBlockDropHandler(model2) : null, parent.getContent());
        this.parent = parent;
        this.model = model2;
        this.formView = this.parent;
        this.maxRowPos = this.model.getMaxRowPos();
        this.maxColumnPos = this.model.getMaxColumnPos();
        this.displayedFields = this.model.getDisplayedFields();
        this.model.addBlockListener(this);
        this.addRecordPositionPanel(this.parent.getContent());
        if (this.model.isMulti()) {
            this.sortedRecToDisplay = new int[this.model.getBufferSize()];
            this.displayToSortedRec = new int[this.model.getDisplaySize()];
        } else {
            this.sortedRecToDisplay = new int[1];
            this.displayToSortedRec = new int[1];
        }
        this.rebuildCachedInfos();
        this.createFields();
        int n = this.model.getBufferSize();
        for (int i = 0; i < n; ++i) {
            if (this.model.getRecordInfoAt(i) == 0) continue;
            this.fireRecordInfoChanged(i, this.model.getRecordInfoAt(i));
        }
    }

    @NotNull
    public final DForm getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public final VBlock getModel() {
        return this.model;
    }

    @Override
    @NotNull
    protected final DForm getFormView() {
        return this.formView;
    }

    @NotNull
    protected final VFieldUI[] getColumnViews() {
        if (this.columnViews != null) {
            return this.columnViews;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"columnViews");
        return null;
    }

    protected final void setColumnViews(@NotNull VFieldUI[] vFieldUIArray) {
        Intrinsics.checkNotNullParameter((Object)vFieldUIArray, (String)"<set-?>");
        this.columnViews = vFieldUIArray;
    }

    protected final int getMaxRowPos() {
        return this.maxRowPos;
    }

    protected final int getMaxColumnPos() {
        return this.maxColumnPos;
    }

    protected final int getDisplayedFields() {
        return this.displayedFields;
    }

    @NotNull
    protected final int[] getSortedRecToDisplay() {
        return this.sortedRecToDisplay;
    }

    @NotNull
    protected final int[] getDisplayToSortedRec() {
        return this.displayToSortedRec;
    }

    protected final int getSortedToprec() {
        return this.sortedToprec;
    }

    protected final void setSortedToprec(int n) {
        this.sortedToprec = n;
    }

    @Nullable
    protected final UI getCurrentUI() {
        return this.currentUI;
    }

    protected final void setCurrentUI(@Nullable UI uI) {
        this.currentUI = uI;
    }

    /*
     * WARNING - void declaration
     */
    protected void createFields() {
        List<VField> fields = this.model.getFields();
        int index = 0;
        this.setColumnViews(new VFieldUI[fields.size()]);
        Iterable $this$forEachIndexed$iv = fields;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void field;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VField vField2 = (VField)item$iv;
            int i = n;
            boolean bl = false;
            this.getColumnViews()[i] = this.createFieldDisplays(index, (VField)field);
            if (this.getColumnViews()[i] == null) continue;
            ++index;
        }
    }

    public final void rebuildCachedInfos() {
        int i;
        int cnt = 0;
        for (i = 0; i < this.sortedToprec; ++i) {
            this.sortedRecToDisplay[i] = -1;
        }
        while (cnt < this.model.getDisplaySize() && i < this.model.getBufferSize()) {
            this.sortedRecToDisplay[i] = this.model.isSortedRecordDeleted(i) ? -1 : cnt++;
            ++i;
        }
        while (i < this.model.getBufferSize()) {
            this.sortedRecToDisplay[i] = -1;
            ++i;
        }
        cnt = this.sortedToprec;
        for (i = 0; i < this.model.getDisplaySize(); ++i) {
            while (cnt < this.model.getBufferSize() && this.model.isSortedRecordDeleted(cnt)) {
                ++cnt;
            }
            if (cnt >= this.model.getBufferSize()) continue;
            this.displayToSortedRec[i] = cnt++;
        }
    }

    private final VFieldUI createFieldDisplays(int index, VField model2) {
        return !model2.isInternal() ? this.createFieldDisplay(index, model2) : null;
    }

    @NotNull
    protected VFieldUI createFieldDisplay(int index, @NotNull VField model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return new DFieldUI(this, model2, index);
    }

    protected void enterRecord(int recno) {
        this.refresh(true);
    }

    public void refresh(boolean force) {
        int i;
        boolean redisplay = false;
        int recno = 0;
        if (!this.model.isMulti()) {
            return;
        }
        if (this.model.getActiveRecord() == -1) {
            this.rebuildCachedInfos();
            int n = this.getColumnViews().length;
            for (int i2 = 0; i2 < n; ++i2) {
                if (this.getColumnViews()[i2] == null) continue;
                VFieldUI vFieldUI = this.getColumnViews()[i2];
                Intrinsics.checkNotNull((Object)vFieldUI);
                vFieldUI.scrollTo(this.sortedToprec);
            }
            return;
        }
        recno = this.model.getSortedPosition(this.model.getActiveRecord());
        if (recno < this.sortedToprec) {
            this.sortedToprec = recno;
            int scrollMore = this.model.getDisplaySize() / 4;
            for (i = recno - 1; scrollMore > 0 && i > 0; --i) {
                if (this.model.isSortedRecordDeleted(i)) continue;
                --this.sortedToprec;
                --scrollMore;
            }
            redisplay = true;
        } else {
            int displine = 0;
            for (int i3 = this.sortedToprec; i3 < recno; ++i3) {
                if (this.model.isSortedRecordDeleted(i3)) continue;
                ++displine;
            }
            if (displine < this.model.getDisplaySize()) {
                redisplay = force;
            } else {
                do {
                    if (!this.model.isSortedRecordDeleted(this.sortedToprec)) {
                        --displine;
                    }
                    ++this.sortedToprec;
                } while (displine >= this.model.getDisplaySize());
                int scrollMore = this.model.getDisplaySize() / 4;
                for (int i4 = recno + 1; scrollMore > 0 && i4 < this.model.getBufferSize(); ++i4) {
                    if (this.model.isSortedRecordDeleted(i4)) continue;
                    ++this.sortedToprec;
                    --scrollMore;
                }
                redisplay = true;
            }
        }
        this.rebuildCachedInfos();
        if (redisplay) {
            int n = this.getColumnViews().length;
            for (i = 0; i < n; ++i) {
                if (this.getColumnViews()[i] == null) continue;
                VFieldUI vFieldUI = this.getColumnViews()[i];
                Intrinsics.checkNotNull((Object)vFieldUI);
                vFieldUI.scrollTo(this.sortedToprec);
            }
        }
    }

    public final void onValueChange(@NotNull HasValue.ValueChangeEvent<Integer> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (this.activeRecordSetFromDisplay) {
            this.activeRecordSetFromDisplay = false;
        } else {
            Object object = event.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            this.setScrollPos(((Number)object).intValue());
        }
    }

    public final void addRecordPositionPanel(@NotNull Form form) {
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        if (this.model.isMulti() && this.model.noChart()) {
            KeyModifier[] keyModifierArray = new KeyModifier[]{KeyModifier.of((String)"Alt")};
            Shortcuts.addShortcutListener((Component)((Component)this), arg_0 -> DBlock.addRecordPositionPanel$lambda$1(form, arg_0), (Key)Key.KEY_I, (KeyModifier[])keyModifierArray);
        }
    }

    public void setActiveRecordFromDisplay(int displayLine) {
        this.activeRecordSetFromDisplay = true;
        this.fireActiveRecordChanged();
        this.refresh(false);
    }

    protected void fireActiveRecordChanged() {
        this.getForm().setCurrentPosition(this.getSortedPosition(this.getCurrentRecord() - 1) + 1, this.model.getRecordCount());
    }

    private final int getSortedPosition(int rec) {
        return this.model.getSortedPosition(rec);
    }

    protected int getCurrentRecord() {
        int current = 1;
        if (this.model.isMulti()) {
            current = this.model.getActiveRecord() + 1;
        }
        return current;
    }

    protected void onAttach(@NotNull AttachEvent attachEvent) {
        Intrinsics.checkNotNullParameter((Object)attachEvent, (String)"attachEvent");
        this.currentUI = attachEvent.getUI();
    }

    public void fireColorChanged(int col, int rec, @Nullable String foreground, @Nullable String background) {
    }

    public final void setScrollPos(int value) {
        boolean bl;
        int value2 = value;
        boolean bl2 = bl = value2 < this.model.getBufferSize();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.sortedToprec != value2) {
            int recno = 0;
            while (value2 > 0) {
                if (!this.model.isSortedRecordDeleted(recno)) {
                    --value2;
                }
                ++recno;
            }
            if (this.model.getActiveField() != null) {
                int lastVisibleRec = recno;
                int nbDisplay = this.model.getDisplaySize() - 1;
                int activeRecord = this.model.getActiveRecord();
                boolean inside = false;
                while (nbDisplay > 0) {
                    if (!this.model.isSortedRecordDeleted(lastVisibleRec)) {
                        --nbDisplay;
                    }
                    if (activeRecord == this.model.getDataPosition(lastVisibleRec)) {
                        inside = true;
                    }
                    ++lastVisibleRec;
                }
                this.sortedToprec = recno;
                if (inside) {
                    if (this.model.getActiveField() != null) {
                        VField vField2 = this.model.getActiveField();
                        Intrinsics.checkNotNull((Object)vField2);
                        vField2.updateText();
                    }
                    this.blockChanged();
                } else {
                    int nextRec;
                    int n = nextRec = this.model.getSortedPosition(this.model.getActiveRecord()) < recno ? this.model.getDataPosition(recno) : this.model.getDataPosition(lastVisibleRec);
                    if (this.model.noMove() || !this.model.isRecordAccessible(nextRec)) {
                        throw new VExecFailedException();
                    }
                    this.model.changeActiveRecord(nextRec);
                }
            } else {
                if (this.model.noMove() || this.model.isRecordDeleted(this.model.getDataPosition(recno))) {
                    throw new VExecFailedException();
                }
                this.sortedToprec = recno;
                this.blockChanged();
                if (this.model != this.model.getForm().getActiveBlock()) {
                    this.model.setActiveRecord(-1);
                }
            }
        }
    }

    @Override
    public void clear() {
        this.sortedToprec = 0;
        this.refresh(true);
    }

    public final void setBorder$galite_core(int style, @Nullable String title, @Nullable Page<?> page) {
        block1: {
            if (style == 0) break block1;
            String string = title;
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.setCaption(it, page);
            }
        }
    }

    @Override
    @NotNull
    public UForm getFormView() {
        return this.formView;
    }

    @Override
    public int getDisplayLine(int recno) {
        if (recno < 0) {
            return -1;
        }
        int pos = this.model.getSortedPosition(recno);
        return pos < 0 ? -1 : this.sortedRecToDisplay[pos];
    }

    @Override
    public int getDisplayLine() {
        return this.getDisplayLine(this.model.getActiveRecord());
    }

    @Override
    public int getRecordFromDisplayLine(int line) {
        return this.model.getDataPosition(this.displayToSortedRec[line]);
    }

    @Override
    public void add(@Nullable UComponent comp, @NotNull Alignment constraints) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        this.addComponent(comp instanceof Component ? (Component)comp : null, constraints.getX(), constraints.getY(), constraints.getWidth(), constraints.getHeight(), constraints.getAlignRight(), constraints.getUseAll());
    }

    @Override
    public int getColumnPos(int x) {
        return 0;
    }

    @Override
    public boolean inDetailMode() {
        return false;
    }

    @Override
    @NotNull
    public BlockLayout createLayout() {
        SimpleBlockLayout layout2 = new SimpleBlockLayout(2 * this.maxColumnPos, this.maxRowPos, this);
        if (this.model.getAlignment() != null) {
            BlockAlignment blockAlignment = this.model.getAlignment();
            Intrinsics.checkNotNull((Object)blockAlignment);
            UBlock uBlock = this.formView.getBlockView(blockAlignment.getBlock());
            Intrinsics.checkNotNull((Object)uBlock, (String)"null cannot be cast to non-null type com.vaadin.flow.component.Component");
            Component component = (Component)uBlock;
            String string = this.model.getName();
            BlockAlignment blockAlignment2 = this.model.getAlignment();
            Intrinsics.checkNotNull((Object)blockAlignment2);
            int[] nArray = blockAlignment2.getTargets();
            BlockAlignment blockAlignment3 = this.model.getAlignment();
            Intrinsics.checkNotNull((Object)blockAlignment3);
            layout2.setBlockAlignment(component, string, nArray, blockAlignment3.isChart());
        }
        return layout2;
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public final void release() {
        VFieldUI[] $this$forEach$iv = this.getColumnViews();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            VConstants vConstants;
            VFieldUI element$iv;
            VFieldUI it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            VConstants vConstants2 = it;
            if (vConstants2 != null && (vConstants2 = ((VFieldUI)vConstants2).getModel()) != null) {
                ((VField)vConstants2).removeFieldListener(it.getFieldHandler());
            }
            if ((vConstants = it) == null || (vConstants = ((VFieldUI)vConstants).getModel()) == null) continue;
            ((VField)vConstants).removeFieldChangeListener(it.getFieldHandler());
        }
    }

    @Override
    public void blockClosed() {
    }

    @Override
    public void blockChanged() {
        this.refresh(true);
    }

    @Override
    public void blockCleared() {
        this.clear();
    }

    @Override
    public void blockAccessChanged(@NotNull VBlock block2, boolean newAccess) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
    }

    @Override
    public void blockViewModeLeaved(@NotNull VBlock block2, @Nullable VField activeField) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
    }

    @Override
    public void blockViewModeEntered(@NotNull VBlock block2, @Nullable VField activeField) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
    }

    @Override
    public void validRecordNumberChanged() {
    }

    @Override
    public void recordInfoChanged(int rec, int info) {
    }

    @Override
    public void orderChanged() {
        this.refresh(true);
    }

    @Override
    public void filterHidden() {
    }

    @Override
    public void filterShown() {
    }

    @Override
    public void refreshEntries() {
    }

    @Override
    @Nullable
    public LocalDate getSelectedDate() {
        return null;
    }

    @Override
    public void goToDate(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
    }

    @Override
    public void enter() {
    }

    @Override
    @Nullable
    public UBlock getCurrentDisplay() {
        return this;
    }

    private static final void addRecordPositionPanel$lambda$1(Form $form, ShortcutEvent shortcutEvent) {
        Intrinsics.checkNotNullParameter((Object)$form, (String)"$form");
        $form.showBlockInfo();
    }
}

