/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.form;

import com.vaadin.flow.component.upload.FailedEvent;
import com.vaadin.flow.component.upload.SucceededEvent;
import com.vaadin.flow.component.upload.receivers.MemoryBuffer;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VFieldUI;
import org.kopi.galite.visual.form.VImageField;
import org.kopi.galite.visual.ui.vaadin.base.BackgroundThreadHandler;
import org.kopi.galite.visual.ui.vaadin.field.ImageField;
import org.kopi.galite.visual.ui.vaadin.form.DLabel;
import org.kopi.galite.visual.ui.vaadin.form.DObjectField;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001+B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\fH\u0016J\u0010\u0010#\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010\u0013J\u0010\u0010%\u001a\u00020\u001a2\b\u0010&\u001a\u0004\u0018\u00010\u0013J\b\u0010'\u001a\u00020\u001aH\u0016J\b\u0010(\u001a\u00020\u001aH\u0016J\b\u0010)\u001a\u00020\u001aH\u0016J\b\u0010*\u001a\u00020\u001aH\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DImageField;", "Lorg/kopi/galite/visual/ui/vaadin/form/DObjectField;", "model", "Lorg/kopi/galite/visual/form/VFieldUI;", "label", "Lorg/kopi/galite/visual/ui/vaadin/form/DLabel;", "align", "", "options", "width", "height", "detail", "", "(Lorg/kopi/galite/visual/form/VFieldUI;Lorg/kopi/galite/visual/ui/vaadin/form/DLabel;IIIIZ)V", "buffer", "Lcom/vaadin/flow/component/upload/receivers/MemoryBuffer;", "field", "Lorg/kopi/galite/visual/ui/vaadin/field/ImageField;", "image", "", "createFileName", "", "baseName", "getObject", "", "onRemove", "", "event", "Lcom/vaadin/flow/dom/DomEvent;", "onUploadFailed", "Lcom/vaadin/flow/component/upload/FailedEvent;", "onUploadSucceeded", "Lcom/vaadin/flow/component/upload/SucceededEvent;", "setBlink", "b", "setImage", "bytes", "setObject", "s", "updateAccess", "updateColor", "updateFocus", "updateText", "DynamicImageResource", "galite-core"})
public final class DImageField
extends DObjectField {
    @Nullable
    private byte[] image;
    @NotNull
    private MemoryBuffer buffer;
    @NotNull
    private final ImageField field;

    public DImageField(@NotNull VFieldUI model2, @Nullable DLabel label, int align, int options, int width, int height, boolean detail) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(model2, label, align, options, detail);
        this.buffer = new MemoryBuffer();
        this.field = new ImageField(width, height, this.buffer);
        this.field.setImageWidth(width);
        this.field.setImageHeight(height);
        this.field.addObjectFieldListener(this);
        this.field.getUpload().addSucceededListener(this::onUploadSucceeded);
        this.field.getUpload().addFailedListener(this::onUploadFailed);
        this.field.getUpload().getElement().addEventListener("upload-abort", this::onRemove);
        this.setFieldContent(this.field);
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.image;
    }

    public final void setObject(@Nullable byte[] s) {
        BackgroundThreadHandler.INSTANCE.access(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(s, this){
            final /* synthetic */ byte[] $s;
            final /* synthetic */ DImageField this$0;
            {
                this.$s = $s;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.$s == null) {
                    DImageField.access$getField$p(this.this$0).setData((AbstractStreamResource)this.$s);
                } else {
                    DImageField.access$getField$p(this.this$0).setData((AbstractStreamResource)new DynamicImageResource(DImageField.access$createFileName(this.this$0, "image"), (Function0<? extends InputStream>)((Function0)new Function0<InputStream>(this.$s){
                        final /* synthetic */ byte[] $s;
                        {
                            this.$s = $s;
                            super(0);
                        }

                        @NotNull
                        public final InputStream invoke() {
                            return new ByteArrayInputStream(this.$s);
                        }
                    })));
                    this.this$0.setBlink(false);
                    this.this$0.setBlink(true);
                }
            }
        }));
        this.image = s;
    }

    @Override
    public void setBlink(boolean b) {
    }

    @Override
    public void updateAccess() {
        DLabel dLabel = this.getLabel$galite_core();
        Intrinsics.checkNotNull((Object)dLabel);
        dLabel.update(this.getModel$galite_core(), this.getPosition());
    }

    @Override
    public void updateText() {
        VField vField2 = this.getModel();
        Intrinsics.checkNotNull((Object)vField2, (String)"null cannot be cast to non-null type org.kopi.galite.visual.form.VImageField");
        this.setObject(((VImageField)vField2).getImage(this.getModel$galite_core().getBlockView().getRecordFromDisplayLine(this.getPosition())));
        super.updateText();
    }

    @Override
    public void updateFocus() {
        DLabel dLabel = this.getLabel$galite_core();
        Intrinsics.checkNotNull((Object)dLabel);
        dLabel.update(this.getModel$galite_core(), this.getPosition());
        super.updateFocus();
    }

    @Override
    public void updateColor() {
    }

    public final void onRemove(@NotNull DomEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.setObject(null);
        this.setImage(null);
    }

    private final String createFileName(String baseName) {
        return baseName + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")) + ".png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onUploadSucceeded(SucceededEvent event) {
        try {
            InputStream inputStream = this.buffer.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
            this.setObject(bytes);
            this.setImage(bytes);
        }
        finally {
            if (event.getContentLength() > 0x3200000L) {
                this.getModel().getForm().unsetProgressDialog();
            }
        }
    }

    public final void setImage(@Nullable byte[] bytes) {
        this.getModel().setChangedUI(true);
        this.getModel().setImage(bytes);
        this.getModel().onAfterDrop();
    }

    private final void onUploadFailed(FailedEvent event) {
        event.getReason().printStackTrace(System.err);
        new Thread(() -> DImageField.onUploadFailed$lambda$0(this, event)).start();
    }

    private static final void onUploadFailed$lambda$0(DImageField this$0, FailedEvent $event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        this$0.getModel().getForm().error($event.getReason().getMessage());
        BackgroundThreadHandler.INSTANCE.updateUI(this$0.getCurrentUI());
    }

    public static final /* synthetic */ ImageField access$getField$p(DImageField $this) {
        return $this.field;
    }

    public static final /* synthetic */ String access$createFileName(DImageField $this, String baseName) {
        return $this.createFileName(baseName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DImageField$DynamicImageResource;", "Lcom/vaadin/flow/server/StreamResource;", "fileName", "", "streamSource", "Lkotlin/Function0;", "Ljava/io/InputStream;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "galite-core"})
    public static final class DynamicImageResource
    extends StreamResource {
        public DynamicImageResource(@NotNull String fileName, @NotNull Function0<? extends InputStream> streamSource) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter(streamSource, (String)"streamSource");
            super(fileName, () -> DynamicImageResource._init_$lambda$0(streamSource));
            this.setCacheTime(0L);
        }

        private static final InputStream _init_$lambda$0(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (InputStream)$tmp0.invoke();
        }
    }
}

