/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.grid;

import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.type.DefaultFormatKt;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorTextField;
import org.kopi.galite.visual.ui.vaadin.grid.InvalidEditorFieldException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J \u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorDateField;", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorTextField;", "()V", "check", "", "text", "", "format", "year", "", "month", "day", "isDate", "d", "m", "y", "isLeapYear", "parseDate", "", "s", "stringToInt", "in", "validate", "galite-core"})
@SourceDebugExtension(value={"SMAP\nGridEditorDateField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridEditorDateField.kt\norg/kopi/galite/visual/ui/vaadin/grid/GridEditorDateField\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,146:1\n37#2,2:147\n*S KotlinDebug\n*F\n+ 1 GridEditorDateField.kt\norg/kopi/galite/visual/ui/vaadin/grid/GridEditorDateField\n*L\n52#1:147,2\n*E\n"})
public final class GridEditorDateField
extends GridEditorTextField {
    public GridEditorDateField() {
        super(10);
    }

    @Override
    protected boolean check(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char element = text.charAt(i);
            if (('0' <= element ? element < ':' : false) || element == '.' || element == '/') continue;
            return false;
        }
        return true;
    }

    @Override
    public void validate() {
        this.parseDate(this.getValue());
    }

    /*
     * WARNING - void declaration
     */
    private final void parseDate(String s) {
        void $this$toTypedArray$iv;
        int month = 0;
        int year = -2;
        Object object = s;
        Regex regex = new Regex("[#./]");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] tokens = thisCollection$iv.toArray(new String[0]);
        if (tokens.length == 0) {
            throw new InvalidEditorFieldException(this, "00003", new Object[0]);
        }
        int day = this.stringToInt(tokens[0]);
        if (tokens.length >= 2) {
            month = this.stringToInt(tokens[1]);
        }
        if (tokens.length >= 3) {
            year = this.stringToInt(tokens[2]);
        }
        if (tokens.length > 3 || day == -1 || month == -1 || year == -1) {
            throw new InvalidEditorFieldException(this, "00003", new Object[0]);
        }
        if (month == 0) {
            LocalDate localDate = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now(...)");
            LocalDate now = localDate;
            month = now.getMonthValue();
            year = now.getYear();
        } else if (year == -2) {
            LocalDate localDate = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now(...)");
            LocalDate now = localDate;
            year = now.getYear();
        } else if (year < 50) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        } else if (year < 1000) {
            throw new InvalidEditorFieldException(this, "00003", new Object[0]);
        }
        if (!this.isDate(day, month, year)) {
            throw new InvalidEditorFieldException(this, "00003", new Object[0]);
        }
        this.setValue(this.format(year, month, day));
    }

    private final int stringToInt(String in) {
        int n;
        try {
            n = Integer.valueOf(in);
        }
        catch (Exception e) {
            n = -1;
        }
        return n;
    }

    private final boolean isDate(int d, int m, int y) {
        boolean bl;
        if (y < 1 || m < 1 || m > 12 || d < 1) {
            bl = false;
        } else {
            switch (m) {
                case 2: {
                    if (d <= (this.isLeapYear(y) ? 29 : 28)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    if (d <= 30) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = d <= 31;
                }
            }
        }
        return bl;
    }

    private final boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private final String format(int year, int month, int day) {
        LocalDate localDate = LocalDate.of(year, month, day);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"of(...)");
        return DefaultFormatKt.format((LocalDate)localDate);
    }
}

