/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.list;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.KeyDownEvent;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.server.AbstractStreamResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.form.VListDialog;
import org.kopi.galite.visual.list.VImageColumn;
import org.kopi.galite.visual.list.VListColumn;
import org.kopi.galite.visual.ui.vaadin.base.Image;
import org.kopi.galite.visual.ui.vaadin.common.VImage;
import org.kopi.galite.visual.ui.vaadin.form.DImageField;
import org.kopi.galite.visual.ui.vaadin.list.ListFilter;

@CssImport(value="./styles/galite/list.css")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004J\u0015\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\b\u001a\u00060\u0002R\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/list/ListTable;", "Lcom/vaadin/flow/component/grid/Grid;", "Lorg/kopi/galite/visual/ui/vaadin/list/ListTable$ListDialogItem;", "model", "Lorg/kopi/galite/visual/form/VListDialog;", "(Lorg/kopi/galite/visual/form/VListDialog;)V", "getModel", "()Lorg/kopi/galite/visual/form/VListDialog;", "selectedItem", "getSelectedItem", "()Lorg/kopi/galite/visual/ui/vaadin/list/ListTable$ListDialogItem;", "widthStyler", "Lcom/vaadin/flow/component/html/Div;", "getWidthStyler$galite_core", "()Lcom/vaadin/flow/component/html/Div;", "setWidthStyler$galite_core", "(Lcom/vaadin/flow/component/html/Div;)V", "addKeyDownListener", "", "listener", "Lcom/vaadin/flow/component/ComponentEventListener;", "Lcom/vaadin/flow/component/KeyDownEvent;", "buildColumns", "buildRows", "getColumnWidth", "", "col", "installFilters", "setTableWidth", "setTableWidth$galite_core", "ListDialogItem", "galite-core"})
@SourceDebugExtension(value={"SMAP\nListTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListTable.kt\norg/kopi/galite/visual/ui/vaadin/list/ListTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1549#2:198\n1620#2,3:199\n1559#2:203\n1590#2,4:204\n1#3:202\n*S KotlinDebug\n*F\n+ 1 ListTable.kt\norg/kopi/galite/visual/ui/vaadin/list/ListTable\n*L\n54#1:198\n54#1:199,3\n96#1:203\n96#1:204,4\n*E\n"})
public final class ListTable
extends Grid<ListDialogItem> {
    @NotNull
    private final VListDialog model;
    @NotNull
    private Div widthStyler;

    public ListTable(@NotNull VListDialog model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.model = model2;
        this.widthStyler = new Div();
        this.setColumnReorderingAllowed(true);
        this.buildRows();
        this.buildColumns();
        this.setTableWidth$galite_core(this.model);
        this.installFilters(this.model);
    }

    @NotNull
    public final VListDialog getModel() {
        return this.model;
    }

    @NotNull
    public final Div getWidthStyler$galite_core() {
        return this.widthStyler;
    }

    public final void setWidthStyler$galite_core(@NotNull Div div) {
        Intrinsics.checkNotNullParameter((Object)div, (String)"<set-?>");
        this.widthStyler = div;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRows() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.model.getCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ListDialogItem((int)it));
        }
        List items = (List)destination$iv$iv;
        this.setItems(items);
    }

    private final void buildColumns() {
        int n = this.model.getColumnCount();
        for (int col = 0; col < n; ++col) {
            if (this.model.getColumns()[col] instanceof VImageColumn) {
                this.addColumn((Renderer)new ComponentRenderer(arg_0 -> ListTable.buildColumns$lambda$2(col, arg_0))).setHeader((Component)new Span(this.model.getColumnName(col))).setKey(String.valueOf(col));
                continue;
            }
            this.addColumn(arg_0 -> ListTable.buildColumns$lambda$3(col, arg_0)).setHeader((Component)new Span(this.model.getColumnName(col))).setKey(String.valueOf(col));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void installFilters(@NotNull VListDialog model2) {
        void $this$mapIndexedTo$iv$iv;
        HeaderRow filterRow;
        HeaderRow headerRow;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        HeaderRow it = headerRow = (filterRow = this.appendHeaderRow());
        boolean bl = false;
        this.getElement().getClassList().add((Object)"list-filter");
        List list = this.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
        Iterable $this$mapIndexed$iv = list;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void column;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Grid.Column column2 = (Grid.Column)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            HeaderRow.HeaderCell cell = (HeaderRow.HeaderCell)filterRow.getCell((Grid.Column)column);
            TextField filterField = new TextField();
            Icon search = new Icon(VaadinIcon.SEARCH);
            filterField.setWidthFull();
            filterField.setSuffixComponent((Component)search);
            filterField.setClassName("filter-text");
            if (!(this.model.getColumns()[i] instanceof VImageColumn)) {
                filterField.addValueChangeListener(new HasValue.ValueChangeListener(this){
                    final /* synthetic */ ListTable this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void valueChanged(AbstractField.ComponentValueChangeEvent<TextField, String> it) {
                        DataProvider dataProvider = this.this$0.getDataProvider();
                        Intrinsics.checkNotNull((Object)dataProvider, (String)"null cannot be cast to non-null type com.vaadin.flow.data.provider.ListDataProvider<@[FlexibleNullability] org.kopi.galite.visual.ui.vaadin.list.ListTable.ListDialogItem?>");
                        ((ListDataProvider)dataProvider).refreshAll();
                    }
                });
                filterField.setValueChangeMode(ValueChangeMode.EAGER);
            } else {
                filterField.setReadOnly(true);
            }
            cell.setComponent((Component)filterField);
            collection.add(filterField);
        }
        List filterFields2 = (List)destination$iv$iv;
        DataProvider dataProvider = this.getDataProvider();
        Intrinsics.checkNotNull((Object)dataProvider, (String)"null cannot be cast to non-null type com.vaadin.flow.data.provider.ListDataProvider<@[FlexibleNullability] org.kopi.galite.visual.ui.vaadin.list.ListTable.ListDialogItem?>");
        ((ListDataProvider)dataProvider).setFilter((SerializablePredicate)new ListFilter(filterFields2, model2, true, false));
        this.getElement().getClassList().add((Object)"filtered");
    }

    public final void addKeyDownListener(@NotNull ComponentEventListener<KeyDownEvent> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.addListener(KeyDownEvent.class, listener);
    }

    public final void setTableWidth$galite_core(@NotNull VListDialog model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        int width = 0;
        int n = model2.getColumnCount();
        for (int col = 0; col < n; ++col) {
            int columnWidth = this.getColumnWidth(model2, col) + 36;
            this.getColumnByKey(String.valueOf(col)).setWidth(columnWidth + "px");
            width += columnWidth;
        }
        this.widthStyler.setWidth((float)width + 20.0f, Unit.PIXELS);
        this.widthStyler.setMinWidth((float)width + 20.0f, Unit.PIXELS);
    }

    private final int getColumnWidth(VListDialog model2, int col) {
        int width = 0;
        width = 0;
        int n = model2.getCount();
        for (int row = 0; row < n; ++row) {
            int n2;
            VListColumn vListColumn = model2.getColumns()[col];
            Intrinsics.checkNotNull((Object)vListColumn);
            String value = String.valueOf(vListColumn.formatObject(model2.getValueAt(row, col)));
            VListColumn vListColumn2 = model2.getColumns()[col];
            Intrinsics.checkNotNull((Object)vListColumn2);
            if (vListColumn2 instanceof VImageColumn) {
                VListColumn vListColumn3 = model2.getColumns()[col];
                Intrinsics.checkNotNull((Object)vListColumn3);
                n2 = vListColumn3.getWidth();
            } else {
                int n3 = value.length();
                String string = model2.getTitles()[col];
                Intrinsics.checkNotNull((Object)string);
                n2 = RangesKt.coerceAtLeast((int)width, (int)RangesKt.coerceAtLeast((int)n3, (int)string.length()));
            }
            width = n2;
        }
        return 8 * width;
    }

    @NotNull
    public final ListDialogItem getSelectedItem() {
        Object object = this.asSingleSelect().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ListDialogItem)object;
    }

    private static final Image buildColumns$lambda$2(int $col, ListDialogItem item) {
        Image image;
        Image image2;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Object object = item.getValueAt($col);
        Image image3 = image2 = object instanceof Image ? (Image)object : null;
        if (image2 != null) {
            Object $this$buildColumns_u24lambda_u242_u24lambda_u241 = object = image2;
            boolean bl = false;
            $this$buildColumns_u24lambda_u242_u24lambda_u241.getElement().getStyle().set("outline", "1px solid lightgreen");
            $this$buildColumns_u24lambda_u242_u24lambda_u241.setWidth("100px");
            $this$buildColumns_u24lambda_u242_u24lambda_u241.setHeight("100px");
            ((VImage)((Object)$this$buildColumns_u24lambda_u242_u24lambda_u241)).setBorder(0);
            $this$buildColumns_u24lambda_u242_u24lambda_u241.getElement().setProperty("borderStyle", "none");
            $this$buildColumns_u24lambda_u242_u24lambda_u241.setSrc((AbstractStreamResource)new DImageField.DynamicImageResource(((VImage)((Object)$this$buildColumns_u24lambda_u242_u24lambda_u241)).createFileName("image"), (Function0<? extends InputStream>)((Function0)new Function0<InputStream>(image2){
                final /* synthetic */ Image $image;
                {
                    this.$image = $image;
                    super(0);
                }

                @NotNull
                public final InputStream invoke() {
                    return new ByteArrayInputStream(this.$image.getSource());
                }
            })));
            image = image2;
        } else {
            image = new Image(null, null, 3, null);
        }
        return image;
    }

    private static final Object buildColumns$lambda$3(int $col, ListDialogItem it) {
        return it.getValueAt($col);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/list/ListTable$ListDialogItem;", "", "row", "", "(Lorg/kopi/galite/visual/ui/vaadin/list/ListTable;I)V", "getRow", "()I", "formatObject", "o", "col", "getValueAt", "galite-core"})
    public final class ListDialogItem {
        private final int row;

        public ListDialogItem(int row) {
            this.row = row;
        }

        public final int getRow() {
            return this.row;
        }

        @Nullable
        public final Object getValueAt(int col) {
            return this.formatObject(ListTable.this.getModel().getData()[col][ListTable.this.getModel().getTranslatedIdents()[this.row]], col);
        }

        private final Object formatObject(Object o, int col) {
            Object object;
            VListColumn vListColumn = ListTable.this.getModel().getColumns()[col];
            Intrinsics.checkNotNull((Object)vListColumn);
            if (vListColumn.formatObject(o) instanceof Image) {
                VListColumn vListColumn2 = ListTable.this.getModel().getColumns()[col];
                Intrinsics.checkNotNull((Object)vListColumn2);
                object = vListColumn2.formatObject(o);
            } else {
                VListColumn vListColumn3 = ListTable.this.getModel().getColumns()[col];
                Intrinsics.checkNotNull((Object)vListColumn3);
                object = String.valueOf(vListColumn3.formatObject(o));
            }
            return object;
        }
    }
}

