/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.main;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.base.Utils;
import org.kopi.galite.visual.ui.vaadin.common.VCaption;
import org.kopi.galite.visual.ui.vaadin.main.MainWindow;
import org.kopi.galite.visual.ui.vaadin.main.VWindowsMenu;
import org.kopi.galite.visual.ui.vaadin.main.VWindowsMenuItem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\bJ\b\u0010\u0015\u001a\u0004\u0018\u00010\bJ\b\u0010\u0016\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\bJ\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/main/VWindowContainer;", "Lcom/vaadin/flow/component/html/Div;", "menu", "Lorg/kopi/galite/visual/ui/vaadin/main/VWindowsMenu;", "(Lorg/kopi/galite/visual/ui/vaadin/main/VWindowsMenu;)V", "caption", "Lorg/kopi/galite/visual/ui/vaadin/common/VCaption;", "currentWindow", "Lcom/vaadin/flow/component/Component;", "isEmpty", "", "()Z", "pane", "windowToCaptionMap", "Lorg/kopi/galite/visual/ui/vaadin/main/VWindowContainer$WindowMap;", "addWindow", "", "window", "title", "", "removeWindow", "showNextWindow", "showPreviousWindow", "showWindow", "updateWindowTitle", "WindowMap", "galite-core"})
public final class VWindowContainer
extends Div {
    @NotNull
    private final VWindowsMenu menu;
    @NotNull
    private final WindowMap windowToCaptionMap;
    @Nullable
    private Component currentWindow;
    @NotNull
    private final Div pane;
    @NotNull
    private final VCaption caption;

    public VWindowContainer(@NotNull VWindowsMenu menu) {
        Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
        this.menu = menu;
        this.windowToCaptionMap = new WindowMap(this, null, 1, null);
        this.pane = new Div();
        Div captionWrapper = new Div();
        this.setClassName("k-window-container");
        this.pane.setClassName("k-container-pane");
        this.caption = new VCaption(false);
        this.caption.setClassName("k-window-caption");
        captionWrapper.setId("session");
        Component[] componentArray = new Component[]{this.caption};
        captionWrapper.add(componentArray);
        componentArray = new Component[]{captionWrapper};
        this.add(componentArray);
        componentArray = new Component[]{this.pane};
        this.add(componentArray);
    }

    public final void addWindow(@NotNull Component window, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Component[] componentArray = new Component[]{window};
        this.pane.add(componentArray);
        ((Map)this.windowToCaptionMap).put(window, title);
    }

    @Nullable
    public final Component removeWindow(@NotNull Component window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Component previousWindow = this.windowToCaptionMap.previousWindowOf(window);
        String caption = (String)this.windowToCaptionMap.remove((Object)window);
        if (caption != null) {
            this.caption.setCaption("");
            Component[] componentArray = new Component[]{window};
            this.pane.remove(componentArray);
            if (!((Map)this.windowToCaptionMap).isEmpty() && previousWindow != null) {
                return this.showWindow(previousWindow);
            }
        }
        return null;
    }

    public final void updateWindowTitle(@NotNull Component window, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        ((Map)this.windowToCaptionMap).put(window, title);
        this.caption.setCaption(title);
    }

    @Nullable
    public final Component showWindow(@Nullable Component window) {
        block8: {
            block7: {
                if (((Map)this.windowToCaptionMap).containsKey(window)) break block7;
                Object[] objectArray = this.pane.getChildren().toArray();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
                if (!ArraysKt.contains((Object[])objectArray, (Object)window)) break block8;
            }
            if (!Intrinsics.areEqual((Object)this.currentWindow, (Object)window)) {
                VWindowsMenuItem vWindowsMenuItem = this.menu.getItemFor(window);
                if (vWindowsMenuItem != null) {
                    vWindowsMenuItem.addClassName("item-selected");
                }
                VWindowsMenuItem vWindowsMenuItem2 = this.menu.getItemFor(this.currentWindow);
                if (vWindowsMenuItem2 != null) {
                    vWindowsMenuItem2.removeClassName("item-selected");
                }
                Component component = this.currentWindow;
                if (component != null) {
                    component.setVisible(false);
                }
                this.currentWindow = window;
                Component component2 = window;
                Intrinsics.checkNotNull((Object)component2);
                component2.setVisible(true);
                this.caption.setCaption((String)this.windowToCaptionMap.get((Object)window));
                MainWindow mainWindow = Utils.INSTANCE.findMainWindow((Component)this);
                Intrinsics.checkNotNull((Object)((Object)mainWindow));
                mainWindow.getApplication().setPageTitle$galite_core(this.caption.getCaption());
            }
            return window;
        }
        return null;
    }

    @Nullable
    public final Component showNextWindow() {
        return this.showWindow(this.windowToCaptionMap.nextWindowOf(this.currentWindow));
    }

    @Nullable
    public final Component showPreviousWindow() {
        return this.showWindow(this.windowToCaptionMap.previousWindowOf(this.currentWindow));
    }

    public final boolean isEmpty() {
        return this.windowToCaptionMap.isEmpty();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0017\u001a\u00020\u0018H\u0096\u0001J\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0096\u0001J\u0011\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0003H\u0096\u0001J\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u0002H\u0096\u0003J\t\u0010\u001f\u001a\u00020\u001aH\u0096\u0001J\u0012\u0010 \u001a\u0004\u0018\u00010\u00022\b\u0010!\u001a\u0004\u0018\u00010\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00022\b\u0010!\u001a\u0004\u0018\u00010\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u001e\u0010$\u001a\u00020\u00182\u0014\u0010%\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030&H\u0016J\u001a\u0010'\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0018\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0003H\u0016R$\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\b0\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/main/VWindowContainer$WindowMap;", "", "Lcom/vaadin/flow/component/Component;", "", "windowMap", "(Lorg/kopi/galite/visual/ui/vaadin/main/VWindowContainer;Ljava/util/Map;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "windowList", "", "clear", "", "containsKey", "", "key", "containsValue", "value", "get", "isEmpty", "nextWindowOf", "window", "previousWindowOf", "put", "putAll", "from", "", "putIfAbsent", "remove", "galite-core"})
    public final class WindowMap
    implements Map<Component, String>,
    KMutableMap {
        @NotNull
        private final Map<Component, String> windowMap;
        @NotNull
        private final List<Component> windowList;
        final /* synthetic */ VWindowContainer this$0;

        public WindowMap(@NotNull VWindowContainer this$0, Map<Component, String> windowMap) {
            Intrinsics.checkNotNullParameter(windowMap, (String)"windowMap");
            this.this$0 = this$0;
            this.windowMap = windowMap;
            this.windowList = new ArrayList();
        }

        public /* synthetic */ WindowMap(VWindowContainer vWindowContainer, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            this(vWindowContainer, map);
        }

        @NotNull
        public Set<Map.Entry<Component, String>> getEntries() {
            return this.windowMap.entrySet();
        }

        @NotNull
        public Set<Component> getKeys() {
            return this.windowMap.keySet();
        }

        public int getSize() {
            return this.windowMap.size();
        }

        @NotNull
        public Collection<String> getValues() {
            return this.windowMap.values();
        }

        @Override
        public void clear() {
            this.windowMap.clear();
        }

        public boolean containsKey(@NotNull Component key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.windowMap.containsKey(key);
        }

        public boolean containsValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.windowMap.containsValue(value);
        }

        @Nullable
        public String get(@NotNull Component key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.windowMap.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.windowMap.isEmpty();
        }

        @Override
        @Nullable
        public String put(@NotNull Component key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.windowList.add(key);
            return this.windowMap.put(key, value);
        }

        @Override
        public void putAll(@NotNull Map<? extends Component, ? extends String> from) {
            Intrinsics.checkNotNullParameter(from, (String)"from");
            this.windowList.addAll((Collection<Component>)from.keySet());
            this.windowMap.putAll(from);
        }

        @Override
        @Nullable
        public String putIfAbsent(@NotNull Component key, @NotNull String value) {
            String string;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String it = string = Map.super.putIfAbsent(key, value);
            boolean bl = false;
            if (it != null) {
                this.windowList.add(key);
            }
            return string;
        }

        @Nullable
        public String remove(@NotNull Component key) {
            String string;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String it = string = this.windowMap.remove(key);
            boolean bl = false;
            if (it != null) {
                this.windowList.remove(key);
            }
            return string;
        }

        public boolean remove(@NotNull Component key, @NotNull String value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            boolean it = bl = this.windowMap.remove(key, value);
            boolean bl2 = false;
            if (it) {
                this.windowList.remove(key);
            }
            return bl;
        }

        @Nullable
        public final Component nextWindowOf(@Nullable Component window) {
            int componentIndex = CollectionsKt.indexOf(this.windowList, (Object)window);
            if (++componentIndex >= this.windowList.size()) {
                componentIndex = 0;
            }
            return (Component)CollectionsKt.getOrNull(this.windowList, (int)componentIndex);
        }

        @Nullable
        public final Component previousWindowOf(@Nullable Component window) {
            int componentIndex = CollectionsKt.indexOf(this.windowList, (Object)window);
            if (--componentIndex < 0) {
                componentIndex = ((Map)this.this$0.windowToCaptionMap).size() - 1;
            }
            return (Component)CollectionsKt.getOrNull(this.windowList, (int)componentIndex);
        }
    }
}

