/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0003J2\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00032\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\f2\u0006\u0010\b\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/kopi/galite/visual/util/PropertyManager;", "", "resourcesFileName", "", "(Ljava/lang/String;)V", "getResourcesFileName", "()Ljava/lang/String;", "getString", "key", "resourceName", "visitedResources", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "Companion", "galite-core"})
public final class PropertyManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String resourcesFileName;
    @NotNull
    private static final Hashtable<String, Object> resources = new Hashtable();

    public PropertyManager(@NotNull String resourcesFileName) {
        Intrinsics.checkNotNullParameter((Object)resourcesFileName, (String)"resourcesFileName");
        this.resourcesFileName = resourcesFileName;
    }

    @NotNull
    public final String getResourcesFileName() {
        return this.resourcesFileName;
    }

    @Nullable
    public final String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getString(this.resourcesFileName, new ArrayList<String>(), key);
    }

    @Nullable
    public final String getString(@Nullable String resourceName, @NotNull ArrayList<String> visitedResources, @NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter(visitedResources, (String)"visitedResources");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ResourceBundle resource = null;
        if (resourceName == null) {
            return null;
        }
        if (resources.containsKey(resourceName)) {
            if (!(resources.get(resourceName) instanceof ResourceBundle)) {
                return null;
            }
            resource = (ResourceBundle)resources.get(resourceName);
        } else {
            try {
                resource = ResourceBundle.getBundle(resourceName);
                ((Map)resources).put(resourceName, resource);
            }
            catch (MissingResourceException mre) {
                System.err.println(resourceName + ".properties not found, will use default properties");
                ((Map)resources).put(resourceName, "");
                resource = null;
            }
        }
        if (resource == null) {
            string = null;
        } else {
            Object object;
            String string2;
            try {
                string2 = resource.getString(key);
            }
            catch (Exception e) {
                string2 = null;
            }
            Object value = string2;
            if (value != null) {
                return value;
            }
            String p = null;
            visitedResources.add(resourceName);
            try {
                object = new StringTokenizer(resource.getString("parent"));
            }
            catch (Exception e) {
                return null;
            }
            StringTokenizer st = object;
            while (value == null && st.hasMoreTokens()) {
                Intrinsics.checkNotNullExpressionValue((Object)st.nextToken(), (String)"nextToken(...)");
                if (visitedResources.contains(p)) continue;
                try {
                    object = this.getString(p, visitedResources, key);
                }
                catch (Exception e) {
                    object = null;
                }
                value = object;
            }
            string = value;
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/kopi/galite/visual/util/PropertyManager$Companion;", "", "()V", "resources", "Ljava/util/Hashtable;", "", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

