/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.chart;

import java.awt.Color;
import java.awt.Paint;
import java.util.Locale;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.TableOrder;
import org.kopi.galite.visual.ApplicationContext;
import org.kopi.galite.visual.chart.VDataSeries;
import org.kopi.galite.visual.chart.VMeasureData;
import org.kopi.vkopi.lib.ui.swing.chart.DAbstractChartType;

public class DPieChart
extends DAbstractChartType {
    public DPieChart(String title, VDataSeries[] series) {
        super(title, series);
    }

    @Override
    protected JFreeChart createChart(String title, VDataSeries[] series) {
        JFreeChart chart2;
        if (series.length == 1) {
            PieDataset dataset = this.createPieDataset(series[0]);
            chart2 = ChartFactory.createPieChart((String)title, (PieDataset)dataset, (boolean)true, (boolean)true, (Locale)ApplicationContext.Companion.getDefaultLocale());
            PiePlot plot = (PiePlot)chart2.getPlot();
            plot.setIgnoreNullValues(true);
            plot.setIgnoreZeroValues(true);
            plot.setBackgroundPaint((Paint)this.getPlotBackground());
        } else {
            CategoryDataset dataset = this.createDataset(series);
            chart2 = ChartFactory.createMultiplePieChart((String)title, (CategoryDataset)dataset, (TableOrder)TableOrder.BY_ROW, (boolean)true, (boolean)true, (boolean)false);
            MultiplePiePlot plot = (MultiplePiePlot)chart2.getPlot();
            plot.setAggregatedItemsPaint((Paint)new Color(239, 235, 222));
            plot.setBackgroundPaint((Paint)this.getPlotBackground());
        }
        chart2.setBackgroundPaint((Paint)this.getChartBackground());
        return chart2;
    }

    protected PieDataset createPieDataset(VDataSeries series) {
        VMeasureData[] measures;
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (VMeasureData measure : measures = series.getMeasures()) {
            dataset.setValue((Comparable)((Object)measure.getName()), measure.getValue());
        }
        return dataset;
    }
}

