/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.UndoManager;
import org.kopi.galite.visual.Action;
import org.kopi.galite.visual.ApplicationConfiguration;
import org.kopi.galite.visual.ApplicationContext;
import org.kopi.galite.visual.VlibProperties;
import org.kopi.galite.visual.form.ModelTransformer;
import org.kopi.galite.visual.form.UTextField;
import org.kopi.galite.visual.form.VConstants;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VFieldUI;
import org.kopi.galite.visual.form.VStringField;
import org.kopi.galite.visual.ui.swing.visual.DMenuTree;
import org.kopi.vkopi.lib.ui.swing.base.JHtmlTextArea;
import org.kopi.vkopi.lib.ui.swing.base.TextSelecter;
import org.kopi.vkopi.lib.ui.swing.form.DField;
import org.kopi.vkopi.lib.ui.swing.form.DForm;
import org.kopi.vkopi.lib.ui.swing.form.DLabel;
import org.kopi.vkopi.lib.ui.swing.form.KopiDocument;
import org.kopi.vkopi.lib.ui.swing.form.KopiFieldDocument;
import org.kopi.vkopi.lib.ui.swing.form.KopiScanDocument;
import org.kopi.vkopi.lib.ui.swing.form.KopiStyledDocument;
import org.kopi.vkopi.lib.ui.swing.spellchecker.SpellChecker;
import org.kopi.vkopi.lib.ui.swing.spellchecker.SpellException;
import org.kopi.vkopi.lib.ui.swing.visual.DWindow;
import org.kopi.vkopi.lib.ui.swing.visual.Utils;

public class DTextField
extends DField
implements UTextField,
VConstants {
    protected JTextComponent field;
    protected boolean inside = false;
    protected boolean noEdit;
    protected boolean scanner;
    protected KopiDocument document;
    protected ModelTransformer transformer;
    protected DocumentListener listener;
    private UndoManager undoManager;
    private MouseListener mouseListener;
    private boolean selectionAfterUpdateDisabled = false;

    public DTextField(VFieldUI model2, DLabel label, int align, int options, boolean detail) {
        super(model2, label, align, options, detail);
        this.noEdit = (options & 2) != 0;
        boolean bl = this.scanner = (options & 1) != 0 && this.getModel().getHeight() > 1;
        this.transformer = this.getModel().getHeight() == 1 || !this.scanner && (this.getModel().getTypeOptions() & 0x10000) > 0 ? new DefaultTransformer(this.getModel().getWidth(), this.getModel().getHeight()) : (!this.scanner ? new NewlineTransformer(this.getModel().getWidth(), this.getModel().getHeight()) : new ScannerTransformer(this));
        this.document = this.hasStyledContent() ? new KopiStyledDocument(this.getModel(), this.transformer) : (!this.scanner ? new KopiFieldDocument(this.getModel(), this.transformer) : new KopiScanDocument(this.getModel(), this.transformer));
        this.undoManager = new UndoManager();
        this.listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DTextField.this.getModel().setChanged(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DTextField.this.getModel().setChanged(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DTextField.this.getModel().setChanged(true);
            }
        };
        JComponent comp = this.createFieldGUI(this.getModel().getWidth(), this.getModel().getHeight(), this.getModel().getHeight() == 1 ? 1 : ((VStringField)this.getModel()).getVisibleHeight(), (options & 1) != 0, this.scanner, new DField.DFieldMouseListener(), align);
        if (model2.hasAutofill() && this.getModel().getDefaultAccess() >= 1) {
            this.document.setAutofill(true);
        }
        if (model2.hasAction()) {
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DTextField.this.model.executeAction();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    DTextField.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    DTextField.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            this.field.setEditable(false);
        }
        this.add((Component)comp, "Center");
    }

    public JPopupMenu createPopupMenu() {
        javax.swing.Action[] bookmarks;
        int i;
        JMenu menu;
        ApplicationConfiguration.Language[] languages;
        ApplicationConfiguration appDefaults;
        String dictionaryServer;
        JPopupMenu popup = new JPopupMenu();
        if (this.model.hasAutofill() && this.getModel().getDefaultAccess() > 1) {
            popup.add(new ListAction());
        }
        if ((this.options & 2) == 0) {
            javax.swing.Action redo = ((DWindow)this.getModel().getForm().getDisplay()).getRedoAction();
            javax.swing.Action undo = ((DWindow)this.getModel().getForm().getDisplay()).getUndoAction();
            if (redo != null) {
                popup.add(redo);
            }
            if (undo != null) {
                popup.add(undo);
            }
        }
        if ((dictionaryServer = (appDefaults = ApplicationConfiguration.Companion.getConfiguration()).getDictionaryServer()) != null && (languages = appDefaults.getDictionaryLanguages()).length > 0) {
            menu = new JMenu(VlibProperties.getString("aspell-menu-title"));
            for (i = 0; i < languages.length; ++i) {
                final String spellCommand = dictionaryServer + " " + languages[i].getOptions();
                AbstractAction spellChecker = new AbstractAction(VlibProperties.getString(languages[i].getLanguage())){
                    private static final long serialVersionUID = 5656229829162013955L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (DTextField.this.field.isEditable()) {
                            SpellChecker spellChecker = new SpellChecker(spellCommand, Utils.getFrameAncestor(DTextField.this.field), DTextField.this.document);
                            try {
                                spellChecker.check();
                            }
                            catch (SpellException se) {
                                se.printStackTrace();
                            }
                        }
                    }
                };
                menu.add(spellChecker);
            }
            popup.add(menu);
        }
        if (ApplicationContext.Companion.getMenu() != null && (bookmarks = ((DMenuTree)ApplicationContext.Companion.getMenu().getDisplay()).getBookmarkActions()).length > 0) {
            popup.addSeparator();
            menu = new JMenu(VlibProperties.getString("toolbar-title"));
            for (i = 0; i < bookmarks.length; ++i) {
                menu.add(bookmarks[i]);
            }
            popup.add(menu);
        }
        return popup;
    }

    @Override
    public Object getObject() {
        return this.getText();
    }

    @Override
    public String getText() {
        return this.document.getModelText();
    }

    @Override
    public void setDisplayProperties() {
        this.document.setState(this.state);
        this.field.invalidate();
        this.field.validate();
        this.field.repaint();
    }

    @Override
    public void updateAccess() {
        if (this.model.hasAction() && this.mouseListener != null) {
            if (this.getAccess() >= 2) {
                this.field.addMouseListener(this.mouseListener);
                this.document.setHasAction(true);
            } else {
                this.field.removeMouseListener(this.mouseListener);
                this.document.setHasAction(false);
            }
        }
        this.label.update(this.getModel(), this.getPosition());
        this.document.setState(this.state);
        super.updateAccess();
    }

    @Override
    public synchronized void updateText() {
        this.document.setState(this.state);
        String newModelTxt = this.getModel().getText(this.getRowController().getBlockView().getRecordFromDisplayLine(this.getPosition()));
        String currentModelTxt = this.document.getModelText();
        if (newModelTxt == null && currentModelTxt != null || !newModelTxt.equals(currentModelTxt)) {
            this.document.removeDocumentListener(this.listener);
            this.document.removeUndoableEditListener(this.undoManager);
            this.document.removeUndoableEditListener(((DWindow)this.getModel().getForm().getDisplay()).getUndoableEditListener());
            this.document.setModelText(newModelTxt);
            if (this.inside) {
                this.document.addDocumentListener(this.listener);
                this.document.addUndoableEditListener(this.undoManager);
                if (this.field.isEditable()) {
                    this.document.addUndoableEditListener(((DWindow)this.getModel().getForm().getDisplay()).getUndoableEditListener());
                }
            }
        }
        super.updateText();
        if (this.modelHasFocus() && !this.selectionAfterUpdateDisabled) {
            TextSelecter.TEXT_SELECTOR.selectText(this.field);
            this.selectionAfterUpdateDisabled = false;
        }
    }

    @Override
    public synchronized void updateFocus() {
        this.document.setState(this.state);
        this.label.update(this.getModel(), this.getPosition());
        this.fireMouseHasChanged();
        if (!this.modelHasFocus()) {
            if (this.inside) {
                this.inside = false;
                this.leaveMe();
            }
        } else if (!this.inside) {
            this.inside = true;
            this.enterMe();
        }
        super.updateFocus();
    }

    private void enterMe() {
        VField model2 = this.getModel();
        if (this.scanner) {
            this.document.setModelText("");
        }
        this.field.setEditable(!this.noEdit);
        this.field.setFocusable(true);
        ((DWindow)model2.getForm().getDisplay()).setUndoManager(this.undoManager);
        if (!this.noEdit) {
            this.document.addUndoableEditListener(((DWindow)model2.getForm().getDisplay()).getUndoableEditListener());
        }
        this.document.addDocumentListener(this.listener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DTextField.this.field.requestFocusInWindow();
            }
        });
    }

    private void leaveMe() {
        VField model2 = this.getModel();
        if (!this.noEdit) {
            this.document.removeUndoableEditListener(((DWindow)model2.getForm().getDisplay()).getUndoableEditListener());
        }
        this.document.removeDocumentListener(this.listener);
        this.field.setEditable(false);
        this.field.setFocusable(false);
        this.reInstallSelectionFocusListener();
        if (this.scanner) {
            this.document.setModelText(this.document.getModelText());
        }
    }

    @Override
    public void setHasCriticalValue(boolean b) {
        if (b) {
            this.document.setHasCriticalValue(true);
            this.repaint();
        } else {
            this.document.setHasCriticalValue(false);
            this.setDisplayProperties();
            this.repaint();
        }
    }

    @Override
    public void updateColor() {
        if (this.getForeground() != null) {
            this.field.setForeground(this.getForeground());
        } else {
            this.field.setForeground(UIManager.getLookAndFeelDefaults().getColor("TextField.foreground"));
        }
        if (this.document != null) {
            this.document.setBgColor(this.getBackground());
        }
        this.field.repaint();
    }

    @Override
    public void setBlink(boolean b) {
        if (b) {
            this.document.setAlert(true);
            this.repaint();
        } else {
            this.document.setAlert(false);
            this.setDisplayProperties();
            this.repaint();
        }
    }

    private JComponent createFieldGUI(int col, int rows, int visibleRows, boolean noEcho, boolean scanner, MouseListener mouseListener, int align) {
        JScrollPane scroller;
        JTextComponent textfield;
        if (noEcho && rows == 1) {
            textfield = new JPasswordField(col){
                private static final long serialVersionUID = -6305606934554696596L;

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    ++dim.width;
                    return dim;
                }
            };
        } else if (rows > 1) {
            if (scanner) {
                col = 40;
            }
            if (this.hasStyledContent()) {
                textfield = new JHtmlTextArea(visibleRows, col);
            } else {
                textfield = new JTextArea(visibleRows, col);
                ((JTextArea)textfield).setLineWrap(true);
                ((JTextArea)textfield).setWrapStyleWord(true);
            }
        } else {
            textfield = new JTextField(col){
                private static final long serialVersionUID = -2960748127356900841L;

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    if (this.getColumns() != 0) {
                        Insets insets = this.getInsets();
                        size.width = 1 + this.getColumns() * this.getColumnWidth() + insets.left + insets.right;
                    }
                    return size;
                }
            };
            ((JTextField)textfield).setHorizontalAlignment(align);
        }
        textfield.setFocusable(false);
        textfield.setEditable(false);
        textfield.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        textfield.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        textfield.setDocument(this.document);
        if (this.hasStyledContent()) {
            ((KopiStyledDocument)this.document).setEditorKit((HTMLEditorKit)((JHtmlTextArea)textfield).getEditorKit());
        }
        textfield.addMouseListener(new RightMenu());
        textfield.addMouseListener(mouseListener);
        if (!this.noEdit) {
            textfield.addFocusListener(TextSelecter.TEXT_SELECTOR);
        }
        if (rows > visibleRows && !scanner) {
            scroller = new JScrollPane();
            scroller.setHorizontalScrollBarPolicy(31);
            scroller.setVerticalScrollBarPolicy(22);
            scroller.setViewportBorder(null);
            scroller.getViewport().setView(textfield);
            scroller.setSize(this.getPreferredSize());
            scroller.setBorder(null);
            scroller.setFocusable(false);
            if (mouseListener != null) {
                scroller.addMouseListener(mouseListener);
            }
            scroller.setViewportBorder(textfield.getBorder());
            textfield.setBorder(null);
        } else {
            scroller = null;
        }
        textfield.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DTextField.this.invalidate();
                DTextField.this.validate();
                DTextField.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DTextField.this.invalidate();
                DTextField.this.validate();
                DTextField.this.repaint();
            }
        });
        this.field = textfield;
        ((DForm)this.getModel().getForm().getDisplay()).getEnvironment().addDefaultTextKey(textfield, rows > 1);
        if (scroller != null) {
            return scroller;
        }
        return textfield;
    }

    protected boolean hasStyledContent() {
        if (this.getModel() instanceof VStringField) {
            return ((VStringField)this.getModel()).isStyled();
        }
        return false;
    }

    @Override
    public void removeSelectionFocusListener() {
        if (!this.noEdit) {
            this.field.removeFocusListener(TextSelecter.TEXT_SELECTOR);
        }
    }

    @Override
    public void addSelectionFocusListener() {
        if (!this.noEdit) {
            this.field.addFocusListener(TextSelecter.TEXT_SELECTOR);
        }
    }

    public void reInstallSelectionFocusListener() {
        this.removeSelectionFocusListener();
        this.addSelectionFocusListener();
    }

    public static String convertToSingleLine(String source, int col, int row) {
        StringBuffer target = new StringBuffer();
        int length = source.length();
        int start = 0;
        while (start < length) {
            int i;
            int j;
            int index = source.indexOf(10, start);
            if (index - start < col && index != -1) {
                target.append(source.substring(start, index));
                for (j = index - start; j < col; ++j) {
                    target.append(' ');
                }
                start = index + 1;
                if (start != length) continue;
                for (j = 0; j < col; ++j) {
                    target.append(' ');
                }
                continue;
            }
            if (start + col >= length) {
                target.append(source.substring(start, length));
                for (j = length; j < start + col; ++j) {
                    target.append(' ');
                }
                start = length;
                continue;
            }
            for (i = start + col - 1; i > start && !Character.isWhitespace(source.charAt(i)); --i) {
            }
            index = i == start ? start + col : i + 1;
            target.append(source.substring(start, index));
            for (int j2 = (index - start) % col; j2 != 0 && j2 < col; ++j2) {
                target.append(' ');
            }
            start = index;
        }
        return target.toString();
    }

    public static String convertFixedTextToSingleLine(String source, int col, int row) {
        StringBuffer target = new StringBuffer();
        int length = source.length();
        int start = 0;
        while (start < length) {
            int i;
            int j;
            int index = source.indexOf(10, start);
            if (index - start < col && index != -1) {
                target.append(source.substring(start, index));
                for (j = index - start; j < col; ++j) {
                    target.append(' ');
                }
                start = index + 1;
                if (start != length) continue;
                for (j = 0; j < col; ++j) {
                    target.append(' ');
                }
                continue;
            }
            if (start + col >= length) {
                target.append(source.substring(start, length));
                for (j = length; j < start + col; ++j) {
                    target.append(' ');
                }
                start = length;
                continue;
            }
            for (i = start + col; i > start && !Character.isWhitespace(source.charAt(i)); --i) {
            }
            index = i == start ? start + col : i;
            target.append(source.substring(start, index));
            for (int j2 = index - start; j2 < col; ++j2) {
                target.append(' ');
            }
            start = index + 1;
        }
        return target.toString();
    }

    @Override
    public void setSelectionAfterUpdateDisabled(boolean disable) {
        this.selectionAfterUpdateDisabled = disable;
    }

    static class DefaultTransformer
    implements ModelTransformer {
        int col;
        int row;

        public DefaultTransformer(int col, int row) {
            this.col = col;
            this.row = row;
        }

        @Override
        public String toGui(String modelTxt) {
            return modelTxt;
        }

        @Override
        public String toModel(String guiTxt) {
            return guiTxt;
        }

        @Override
        public boolean checkFormat(String source) {
            return this.row == 1 ? true : DTextField.convertToSingleLine(source, this.col, this.row).length() <= this.row * this.col;
        }
    }

    static class NewlineTransformer
    implements ModelTransformer {
        int col;
        int row;

        public NewlineTransformer(int col, int row) {
            this.col = col;
            this.row = row;
        }

        @Override
        public String toModel(String source) {
            return DTextField.convertFixedTextToSingleLine(source, this.col, this.row);
        }

        @Override
        public String toGui(String source) {
            StringBuffer target = new StringBuffer();
            int length = source.length();
            int usedRows = 1;
            for (int start = 0; start < length; start += this.col) {
                String line = source.substring(start, Math.min(start + this.col, length));
                int last = -1;
                for (int i = line.length() - 1; last == -1 && i >= 0; --i) {
                    if (Character.isWhitespace(line.charAt(i))) continue;
                    last = i;
                }
                if (last != -1) {
                    target.append(line.substring(0, last + 1));
                }
                if (usedRows >= this.row) continue;
                if (start + this.col < length) {
                    target.append('\n');
                }
                ++usedRows;
            }
            return target.toString();
        }

        @Override
        public boolean checkFormat(String source) {
            return source.length() <= this.row * this.col;
        }
    }

    static class ScannerTransformer
    implements ModelTransformer {
        private DTextField field;

        public ScannerTransformer(DTextField field) {
            this.field = field;
        }

        @Override
        public String toGui(String modelTxt) {
            if (modelTxt == null || "".equals(modelTxt)) {
                return VlibProperties.getString("scan-ready");
            }
            if (this.field.field.isEditable()) {
                return VlibProperties.getString("scan-read") + " " + modelTxt;
            }
            return VlibProperties.getString("scan-finished");
        }

        @Override
        public String toModel(String guiTxt) {
            return guiTxt;
        }

        @Override
        public boolean checkFormat(String software) {
            return true;
        }
    }

    class ListAction
    extends AbstractAction {
        private static final long serialVersionUID = 410472821803045205L;

        ListAction() {
            super(VlibProperties.getString("item-index"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DTextField.this.getModel().getForm().performAsyncAction(new Action(){

                @Override
                public void execute() {
                    DTextField.this.model.transferFocus(DTextField.this);
                    DTextField.this.model.autofillButton();
                }
            });
        }
    }

    private class RightMenu
    extends MouseAdapter
    implements PopupMenuListener {
        JPopupMenu menu;

        private RightMenu() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && this.menu == null && DTextField.this.listener != null) {
                this.menu = DTextField.this.createPopupMenu();
                this.menu.addPopupMenuListener(this);
                this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.menu.removeAll();
            this.menu.removePopupMenuListener(this);
            this.menu = null;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

