/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.kopi.vkopi.lib.ui.swing.base.Utils;

public class ImageFileChooser {
    public static File chooseFile(Component parent) {
        JFileChooser filechooser = new JFileChooser();
        filechooser.addChoosableFileFilter(new ImageFilter());
        filechooser.setFileView(new ImageFileView());
        filechooser.setAccessory(new ImagePreview(filechooser));
        int returnVal = filechooser.showOpenDialog(parent);
        if (returnVal == 0) {
            return filechooser.getSelectedFile();
        }
        return null;
    }

    private static class ImageFilter
    extends FileFilter {
        static final String jpeg = "jpeg";
        static final String jpg = "jpg";
        static final String gif = "gif";

        private ImageFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                String extension = s.substring(i + 1).toLowerCase();
                return gif.equals(extension) || jpeg.equals(extension) || jpg.equals(extension);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Just Images";
        }
    }

    private static class ImageFileView
    extends FileView {
        ImageIcon jpgIcon = Utils.getImage("jpgIcon.gif");
        ImageIcon gifIcon = Utils.getImage("gifIcon.gif");

        private ImageFileView() {
        }

        @Override
        public String getName(File f) {
            return null;
        }

        @Override
        public String getDescription(File f) {
            return null;
        }

        @Override
        public Boolean isTraversable(File f) {
            return null;
        }

        @Override
        public String getTypeDescription(File f) {
            String extension = this.getExtension(f);
            String type = null;
            if (extension != null) {
                if (extension.equals("jpeg") || extension.equals("jpg")) {
                    type = "JPEG Image";
                } else if (extension.equals("gif")) {
                    type = "GIF Image";
                }
            }
            return type;
        }

        @Override
        public Icon getIcon(File f) {
            String extension = this.getExtension(f);
            ImageIcon icon = null;
            if (extension != null) {
                if (extension.equals("jpeg") || extension.equals("jpg")) {
                    icon = this.jpgIcon;
                } else if (extension.equals("gif")) {
                    icon = this.gifIcon;
                }
            }
            return icon;
        }

        private String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }

    private static class ImagePreview
    extends JComponent
    implements PropertyChangeListener {
        ImageIcon thumbnail = null;
        File f = null;
        private static final long serialVersionUID = -253909169278804396L;

        public ImagePreview(JFileChooser fc) {
            this.setPreferredSize(new Dimension(100, 50));
            fc.addPropertyChangeListener(this);
        }

        public void loadImage() {
            if (this.f == null) {
                return;
            }
            ImageIcon tmpIcon = new ImageIcon(this.f.getPath());
            this.thumbnail = tmpIcon.getIconWidth() > 90 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(90, -1, 1)) : tmpIcon;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "SelectedFileChangedProperty") {
                this.f = (File)e.getNewValue();
                if (this.isShowing()) {
                    this.loadImage();
                    this.repaint();
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            if (this.thumbnail == null) {
                this.loadImage();
            }
            if (this.thumbnail != null) {
                int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
                int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
                if (y < 0) {
                    y = 0;
                }
                if (x < 5) {
                    x = 5;
                }
                this.thumbnail.paintIcon(this, g, x, y);
            }
        }
    }
}

