/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.plaf;

import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalScrollBarUI;
import javax.swing.plaf.metal.MetalScrollButton;

public class KopiScrollBarUI
extends MetalScrollBarUI {
    private static Color highlightColor;
    private static Color thumbColor;

    public static ComponentUI createUI(JComponent c) {
        return new KopiScrollBarUI();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new KopiScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new KopiScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Graphics2D g2d = (Graphics2D)g;
        g.setColor(highlightColor);
        g.drawRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        g.setColor(this.trackColor);
        GradientPaint gp = this.scrollbar.getOrientation() == 1 ? new GradientPaint(trackBounds.x, trackBounds.y, this.trackColor, trackBounds.x + trackBounds.width, trackBounds.y, Color.white) : new GradientPaint(trackBounds.x, trackBounds.y, this.trackColor, trackBounds.x, trackBounds.y + trackBounds.height, Color.white);
        g2d.setPaint(gp);
        g.fillRect(trackBounds.x + 1, trackBounds.y, trackBounds.width - 2, trackBounds.height);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        boolean leftToRight = c.getComponentOrientation().isLeftToRight();
        g.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                if (!leftToRight) {
                    ++thumbBounds.width;
                    g.translate(-1, 0);
                } else {
                    thumbBounds.width += 2;
                }
            }
            g.setColor(thumbColor);
            g.fillRect(1, 0, thumbBounds.width - 2, thumbBounds.height);
            int middle = thumbBounds.height / 2;
            g.setColor(highlightColor);
            g.drawLine(2, middle - 3, thumbBounds.width - 5, middle - 3);
            g.drawLine(2, middle, thumbBounds.width - 5, middle);
            g.drawLine(2, middle + 3, thumbBounds.width - 5, middle + 3);
            if (!this.isFreeStanding) {
                if (!leftToRight) {
                    --thumbBounds.width;
                    g.translate(1, 0);
                } else {
                    thumbBounds.width -= 2;
                }
            }
        } else {
            if (!this.isFreeStanding) {
                thumbBounds.height += 2;
            }
            g.setColor(thumbColor);
            g.fillRect(1, 0, thumbBounds.width - 2, thumbBounds.height);
            int middle = thumbBounds.width / 2;
            g.setColor(highlightColor);
            g.drawLine(middle - 3, 3, middle - 3, thumbBounds.height - 5);
            g.drawLine(middle, 3, middle, thumbBounds.height - 5);
            g.drawLine(middle + 3, 3, middle + 3, thumbBounds.height - 5);
            if (!this.isFreeStanding) {
                thumbBounds.height -= 2;
            }
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        thumbColor = UIManager.getColor("ScrollBar.thumb");
    }

    public void stopIt() {
        this.isDragging = false;
        this.scrollTimer.stop();
        this.scrollbar.setValueIsAdjusting(false);
    }

    @Override
    protected BasicScrollBarUI.ScrollListener createScrollListener() {
        return new KopiScrollListener();
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new KopiTrackListener();
    }

    @Override
    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        return new ArrowButtonListener();
    }

    static class KopiScrollButton
    extends MetalScrollButton {
        private boolean isFreeStanding;
        private Color border_color = UIManager.getColor("ScrollBar.highlight");
        private Color thumbColor1 = UIManager.getColor("ScrollBar.thumb");
        private static final long serialVersionUID = 7155986697007639719L;

        public KopiScrollButton(int direction, int width, boolean freeStanding) {
            super(direction, width, freeStanding);
            this.isFreeStanding = freeStanding;
        }

        @Override
        public void paint(Graphics g) {
            boolean leftToRight = this.getComponentOrientation().isLeftToRight();
            boolean isEnabled = this.getParent().isEnabled();
            ColorUIResource arrowColor = isEnabled ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlDisabled();
            boolean isPressed = this.getModel().isPressed();
            int width = this.getWidth();
            int height = this.getHeight();
            int w = width;
            int h = height;
            int arrowHeight = (height + 1) / 4;
            if (!isEnabled) {
                g.setColor(this.thumbColor1);
            } else if (isPressed) {
                g.setColor(MetalLookAndFeel.getControlShadow());
            } else {
                g.setColor(this.thumbColor1);
            }
            g.fillRect(0, 0, width, height);
            if (this.getDirection() == 1) {
                if (!this.isFreeStanding) {
                    ++height;
                    g.translate(0, -1);
                    if (!leftToRight) {
                        ++width;
                        g.translate(-1, 0);
                    } else {
                        width += 2;
                    }
                }
                g.setColor(arrowColor);
                int startY = (h + 1 - arrowHeight) / 2;
                int startX = w / 2;
                for (int line = 0; line < arrowHeight; ++line) {
                    g.drawLine(startX - line, startY + line, startX + line + 1, startY + line);
                }
                if (isEnabled) {
                    g.setColor(this.border_color);
                    g.drawRect(0, 0, width - 1, height - 1);
                }
                if (!this.isFreeStanding) {
                    --height;
                    g.translate(0, 1);
                    if (!leftToRight) {
                        --width;
                        g.translate(1, 0);
                    } else {
                        width -= 2;
                    }
                }
            } else if (this.getDirection() == 5) {
                if (!this.isFreeStanding) {
                    ++height;
                    if (!leftToRight) {
                        ++width;
                        g.translate(-1, 0);
                    } else {
                        width += 2;
                    }
                }
                g.setColor(arrowColor);
                int startY = (h + 1 - arrowHeight) / 2 + arrowHeight - 1;
                int startX = w / 2;
                for (int line = 0; line < arrowHeight; ++line) {
                    g.drawLine(startX - line, startY - line, startX + line + 1, startY - line);
                }
                if (isEnabled) {
                    g.setColor(this.border_color);
                    g.drawRect(0, 0, width - 1, height - 1);
                } else {
                    this.drawDisabledBorder(g, 0, -1, width, height + 1);
                }
                if (!this.isFreeStanding) {
                    --height;
                    if (!leftToRight) {
                        --width;
                        g.translate(1, 0);
                    } else {
                        width -= 2;
                    }
                }
            } else if (this.getDirection() == 3) {
                if (!this.isFreeStanding) {
                    height += 2;
                    ++width;
                }
                g.setColor(arrowColor);
                int startX = (w + 1 - arrowHeight) / 2 + arrowHeight - 1;
                int startY = h / 2;
                for (int line = 0; line < arrowHeight; ++line) {
                    g.drawLine(startX - line, startY - line, startX - line, startY + line + 1);
                }
                if (isEnabled) {
                    g.setColor(this.border_color);
                    g.drawRect(0, 0, width - 1, height - 1);
                } else {
                    this.drawDisabledBorder(g, -1, 0, width + 1, height);
                }
                if (!this.isFreeStanding) {
                    height -= 2;
                    --width;
                }
            } else if (this.getDirection() == 7) {
                if (!this.isFreeStanding) {
                    height += 2;
                    ++width;
                    g.translate(-1, 0);
                }
                g.setColor(arrowColor);
                int startX = (w + 1 - arrowHeight) / 2;
                int startY = h / 2;
                for (int line = 0; line < arrowHeight; ++line) {
                    g.drawLine(startX + line, startY - line, startX + line, startY + line + 1);
                }
                if (isEnabled) {
                    g.setColor(this.border_color);
                    g.drawRect(0, 0, width - 1, height - 1);
                } else {
                    this.drawDisabledBorder(g, 0, 0, width + 1, height);
                }
                if (!this.isFreeStanding) {
                    height -= 2;
                    --width;
                    g.translate(1, 0);
                }
            }
        }

        protected void drawDisabledBorder(Graphics g, int x, int y, int width, int height) {
            g.drawRect(x, y, width, height);
        }
    }

    protected class KopiScrollListener
    extends BasicScrollBarUI.ScrollListener {
        public KopiScrollListener() {
            super(KopiScrollBarUI.this);
        }

        public KopiScrollListener(int dir, boolean block2) {
            super(KopiScrollBarUI.this, dir, block2);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isChildOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow())) {
                KopiScrollBarUI.this.stopIt();
            } else {
                super.actionPerformed(e);
            }
        }

        private boolean isChildOf(Container con) {
            if (con == null) {
                return false;
            }
            for (Container parent = KopiScrollBarUI.this.scrollbar; parent != null; parent = parent.getParent()) {
                if (parent != con) continue;
                return true;
            }
            return false;
        }
    }

    protected class KopiTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected KopiTrackListener() {
            super(KopiScrollBarUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            window.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    KopiScrollBarUI.this.stopIt();
                }
            });
            super.mousePressed(e);
        }
    }

    protected class ArrowButtonListener
    extends BasicScrollBarUI.ArrowButtonListener {
        protected ArrowButtonListener() {
            super(KopiScrollBarUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            window.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    KopiScrollBarUI.this.stopIt();
                }
            });
            super.mousePressed(e);
        }
    }
}

