/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.kopi.galite.visual.Action;
import org.kopi.galite.visual.ApplicationContext;
import org.kopi.galite.visual.MessageCode;
import org.kopi.galite.visual.MessageListener;
import org.kopi.galite.visual.UIFactory;
import org.kopi.galite.visual.UWindow;
import org.kopi.galite.visual.VActor;
import org.kopi.galite.visual.VException;
import org.kopi.galite.visual.VRuntimeException;
import org.kopi.galite.visual.VWindow;
import org.kopi.galite.visual.VlibProperties;
import org.kopi.galite.visual.WaitInfoListener;
import org.kopi.galite.visual.ui.swing.visual.DMenuTree;
import org.kopi.galite.visual.util.LineBreaker;
import org.kopi.vkopi.lib.ui.swing.base.JButtonPanel;
import org.kopi.vkopi.lib.ui.swing.base.JDisablePanel;
import org.kopi.vkopi.lib.ui.swing.base.KnownBugs;
import org.kopi.vkopi.lib.ui.swing.base.Utils;
import org.kopi.vkopi.lib.ui.swing.visual.DActor;
import org.kopi.vkopi.lib.ui.swing.visual.DFootPanel;
import org.kopi.vkopi.lib.ui.swing.visual.DMenuBar;
import org.kopi.vkopi.lib.ui.swing.visual.DObject;
import org.kopi.vkopi.lib.ui.swing.visual.ProgressWindow;
import org.kopi.vkopi.lib.ui.swing.visual.SwingThreadHandler;
import org.kopi.vkopi.lib.ui.swing.visual.WaitWindow;

public abstract class DWindow
extends JPanel
implements UWindow {
    public Exception runtimeDebugInfo;
    private boolean inAction;
    private Action currentAction;
    private LinkedList<AWTEvent> currentEventQueue;
    private int returnCode = -1;
    private final ActionRunner actionRunner = new ActionRunner();
    private static int closeOptionPaneWith;
    private VWindow model;
    private ProgressWindow progressWindow;
    private WaitWindow waitWindow;
    private DMenuBar menuBar;
    private DFootPanel footPanel;
    private JPanel buttonPanel;
    private JPanel contentPanel;
    private boolean firstTime;
    private boolean dialog;
    private Frame frame;
    private Frame parentFrame;
    private JFrame self;
    private WindowHandler windowhandler;
    private WaitInfoHandler waitInfoHandler;
    private MessageHandler messageHandler;
    private DUndoableEditListener undoableListener;
    private UndoManager undo;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    private static Hashtable<Object, javax.swing.Action> actions;
    public static final ImageIcon ICN_WAIT;
    public static final ImageIcon ICN_ERROR;
    public static final ImageIcon ICN_WARNING;
    public static final ImageIcon ICN_ASK;
    public static final ImageIcon ICN_NOTICE;
    public static final KopiFocusManager focusManager;
    private static final long serialVersionUID = -354641750611433552L;
    static Bookmarks[] BOOKMARKS;

    protected DWindow(VWindow model2) {
        this.model = model2;
        this.setName(model2.getTitle());
        model2.setDisplay(this);
        for (int i = 0; i < 10; ++i) {
            this.registerKeyboardAction(BOOKMARKS[i], null, KeyStroke.getKeyStroke(48 + i, 128), 2);
        }
        this.installKeyMapping();
        this.firstTime = true;
        this.undoableListener = new DUndoableEditListener();
        this.undo = null;
        this.setLayout(new BoxLayout(this, 1));
        this.setFocusable(false);
        this.setFocusCycleRoot(true);
        this.menuBar = new DMenuBar();
        this.createEditMenu();
        this.buttonPanel = new JButtonPanel();
        this.add(this.buttonPanel);
        this.contentPanel = new JPanel();
        this.add(this.contentPanel);
        this.footPanel = new DFootPanel(this);
        this.add(this.footPanel);
        this.addActorsToGUI(this.getModel().getActors());
        model2.addVActionListener(this);
        model2.addModelCloseListener(this);
        this.waitInfoHandler = new WaitInfoHandler();
        model2.addWaitInfoListener(this.waitInfoHandler);
        model2.addWaitDialogListener(this);
        model2.addProgressDialogListener(this);
        this.messageHandler = new MessageHandler();
        model2.addMessageListener(this.messageHandler);
    }

    private void installKeyMapping() {
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 5542024298880296191L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Component)e.getSource()).dispatchEvent(new KeyEvent((Component)e.getSource(), 401, e.getWhen(), 0, 40, '\uffff'));
            }
        }, null, KeyStroke.getKeyStroke(78, 128), 2);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 7162561739019316550L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Component)e.getSource()).dispatchEvent(new KeyEvent((Component)e.getSource(), 401, e.getWhen(), 0, 38, '\uffff'));
            }
        }, null, KeyStroke.getKeyStroke(80, 128), 2);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 156538846733910281L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Component)e.getSource()).dispatchEvent(new KeyEvent((Component)e.getSource(), 401, e.getWhen(), 0, 37, '\uffff'));
            }
        }, null, KeyStroke.getKeyStroke(83, 128), 2);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 6571246407660269667L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Component)e.getSource()).dispatchEvent(new KeyEvent((Component)e.getSource(), 401, e.getWhen(), 0, 39, '\uffff'));
            }
        }, null, KeyStroke.getKeyStroke(69, 128), 2);
    }

    @Override
    public VWindow getModel() {
        return this.model;
    }

    public void setModel(VWindow model2) {
        this.model = model2;
        this.addActorsToGUI(this.getModel().getActors());
        this.setWindowFocusEnabled(true);
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    @Override
    public synchronized void setWindowFocusEnabled(boolean enabled) {
        if (enabled) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    @Override
    public void setVisible(boolean b) {
        this.setVisibleImpl(b);
    }

    @Override
    public void setTitle(String title) {
        if (this.self != null) {
            this.self.setTitle(title);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(int code) {
        VWindow model2 = this.model;
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                System.err.println("ERROR: Call of DWindow.close(int x) ouside of Event-Dispatching Thread");
                Thread.dumpStack();
            }
            if (model2 != null) {
                this.release();
            }
            this.dispose();
            if (model2 != null) {
                model2.destroyModel();
            }
        }
        finally {
            if (model2 != null) {
                VWindow vWindow = model2;
                synchronized (vWindow) {
                    this.returnCode = code;
                    model2.notifyAll();
                }
            }
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void close() {
        this.closeWindow();
    }

    @Override
    public void closeWindow() {
        if (!this.getModel().allowQuit()) {
            return;
        }
        this.getModel().willClose(0);
    }

    @Override
    public void modelClosed(final int type) {
        SwingThreadHandler.start(new Runnable(){

            @Override
            public void run() {
                DWindow.this.close(type);
            }
        });
    }

    public void build() {
    }

    public JFrame getFrame() {
        return this.self;
    }

    public void displayNotice(String message) {
        SwingThreadHandler.verifyRunsInEventThread("DWindow displayNotice");
        this.verifyNotInTransaction("DWindow.displayNotice(" + message + ")");
        DWindow.displayNotice(this.frame, message);
    }

    public static void displayNotice(Component frame, String message) {
        Object[] options = new Object[]{VlibProperties.getString("CLOSE")};
        JOptionPane.showOptionDialog(frame, message, VlibProperties.getString("Notice"), -1, 1, ICN_NOTICE, options, options[0]);
    }

    public void displayError(String message) {
        SwingThreadHandler.verifyRunsInEventThread("DWindow displayError");
        this.verifyNotInTransaction("DWindow.displayError(" + message + ")");
        if (message.length() > 100) {
            message = LineBreaker.Companion.addBreakForWidth(message, 100);
        }
        DWindow.displayError(this.frame, message);
    }

    public static void displayError(Component parent, String message) {
        Object[] options = new Object[]{VlibProperties.getString("CLOSE")};
        JOptionPane.showOptionDialog(parent, message, VlibProperties.getString("Error"), -1, 0, ICN_ERROR, options, options[0]);
    }

    public static int askPostition(Component parent, int current, int total) {
        int userInput;
        Object[] options = new Object[]{VlibProperties.getString("OK"), VlibProperties.getString("NO")};
        JOptionPane pane = new JOptionPane(VlibProperties.getString("position-number") + " :", 3, 0, null, options, options[0]);
        pane.setWantsInput(true);
        pane.setComponentOrientation(parent.getComponentOrientation());
        JDialog dialog = pane.createDialog(parent, current + " " + VlibProperties.getString("from") + " " + total);
        dialog.setVisible(true);
        dialog.dispose();
        Object obj = pane.getInputValue();
        String s = obj == JOptionPane.UNINITIALIZED_VALUE ? null : (String)obj;
        try {
            userInput = Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return current;
        }
        return userInput < 1 ? 1 : (userInput > total ? total : userInput);
    }

    public void displayWarning(String message) {
        SwingThreadHandler.verifyRunsInEventThread("DWindow displayWarning");
        this.verifyNotInTransaction("DWindow.displayWarning(" + message + ")");
        Object[] options = new Object[]{VlibProperties.getString("CLOSE")};
        JOptionPane.showOptionDialog(this.frame, message, VlibProperties.getString("Warning"), -1, 2, ICN_WARNING, options, options[0]);
    }

    public boolean askUser(String message, boolean yesIsDefault) {
        SwingThreadHandler.verifyRunsInEventThread("DWindow askUser");
        this.verifyNotInTransaction("DWindow.askUser(" + message + ")");
        return this.askUserImpl(message, yesIsDefault);
    }

    public boolean askUserImpl(String message, boolean yesIsDefault) {
        SwingThreadHandler.verifyRunsInEventThread("DWindow askUser");
        Object[] options = new Object[]{VlibProperties.getString("OK"), VlibProperties.getString("NO")};
        return 0 == DWindow.showOptionDialog(this.self, message, VlibProperties.getString("Question"), 0, 3, ICN_ASK, options, options[yesIsDefault ? 0 : 1]);
    }

    public UndoableEditListener getUndoableEditListener() {
        return this.undoableListener;
    }

    public UndoManager getUndoManager() {
        return this.undo;
    }

    public void setUndoManager(UndoManager undo) {
        this.undo = undo;
        if (this.undoAction != null) {
            this.undoAction.update();
            this.redoAction.update();
        }
    }

    protected void createEditMenu() {
    }

    private static Hashtable<Object, javax.swing.Action> createActionTable(JTextComponent textComponent) {
        Hashtable<Object, javax.swing.Action> actions = new Hashtable<Object, javax.swing.Action>();
        javax.swing.Action[] actionsArray = textComponent.getActions();
        for (int i = 0; i < actionsArray.length; ++i) {
            javax.swing.Action a = actionsArray[i];
            actions.put(a.getValue("Name"), a);
        }
        return actions;
    }

    protected javax.swing.Action getActionByName(String name) {
        return actions.get(name);
    }

    public javax.swing.Action getRedoAction() {
        return this.redoAction;
    }

    public javax.swing.Action getUndoAction() {
        return this.undoAction;
    }

    public void performAction(Action action2, boolean block2) {
        this.performAsyncAction(action2);
    }

    @Override
    public void performAsyncAction(Action action2) {
        this.performActionImpl(action2, true);
    }

    @Override
    public void performBasicAction(Action action2) {
        this.performActionImpl(action2, false);
    }

    private void performActionImpl(Action action2, boolean asynch) {
        SwingThreadHandler.verifyRunsInEventThread("DForm:performActionImpl");
        if (this.inAction) {
            Toolkit.getDefaultToolkit().beep();
            System.out.println("Action " + action2 + " not executed. Another command \"" + this.currentAction + "\" is processed.");
            return;
        }
        if (KnownBugs.paintIconReload != null) {
            String text = KnownBugs.paintIconReload + "\nfailed:" + KnownBugs.paintIconFailure;
            KnownBugs.paintIconReload = null;
            KnownBugs.paintIconFailure = false;
            ApplicationContext.Companion.reportTrouble("DWindow", "DWindow.performActionImpl(" + action2 + ", " + asynch + ")", text, new RuntimeException("Painting Error - Load retried (Never Thrown)"));
        } else if (KnownBugs.paintIconFailure) {
            KnownBugs.paintIconFailure = false;
            ApplicationContext.Companion.reportTrouble("DWindow", "DWindow.performActionImpl(" + action2 + ", " + asynch + ")", "no more info", new RuntimeException("Painting Error (Never Thrown)"));
        }
        this.inAction = true;
        this.currentEventQueue = focusManager.enqueueKeyEvents();
        this.getModel().setCommandsEnabled(false);
        this.currentAction = action2;
        this.runtimeDebugInfo = new RuntimeException(this.currentAction.toString());
        if (!asynch || !this.getModel().allowAsynchronousOperation()) {
            this.actionRunner.run();
        } else {
            Thread currentThread = new Thread(this.actionRunner);
            currentThread.start();
        }
    }

    @Override
    public void openURL(String url) throws Exception {
        throw new Exception("Unsupported operation");
    }

    public void reportError(VRuntimeException e) {
        if (e.getMessage() != null) {
            this.messageHandler.error(e.getMessage());
        }
    }

    public boolean getInAction() {
        SwingThreadHandler.verifyRunsInEventThread("getInAction");
        return this.inAction;
    }

    @Override
    public final void setInformationText(final String text) {
        SwingThreadHandler.startAndWait(new Runnable(){

            @Override
            public void run() {
                if (DWindow.this.footPanel != null) {
                    DWindow.this.footPanel.setInformationText(text);
                }
            }
        });
    }

    public final void setStatisticsText(final String text) {
        SwingThreadHandler.startAndWait(new Runnable(){

            @Override
            public void run() {
                if (DWindow.this.footPanel != null) {
                    DWindow.this.footPanel.setStatisticsText(text);
                }
            }
        });
    }

    public final void setStatePanel(JPanel panel) {
        this.footPanel.setStatePanel(panel);
    }

    @Override
    public final void setProgressDialog(String message, int totalJobs) {
        if (this.progressWindow == null) {
            this.progressWindow = new ProgressWindow(this.getFrame());
        }
        this.progressWindow.setProgressDialog(message, totalJobs);
    }

    @Override
    public final void unsetProgressDialog() {
        if (this.progressWindow != null) {
            this.progressWindow.unsetProgressDialog();
            this.progressWindow = null;
        }
    }

    @Override
    public final void setTotalJobs(int totalJobs) {
        if (this.progressWindow != null) {
            this.progressWindow.setTotalJobs(totalJobs);
        }
    }

    @Override
    public final void setCurrentJob(int currentJob) {
        if (this.progressWindow != null) {
            this.progressWindow.setCurrentJob(currentJob);
        }
    }

    @Override
    public final void updateWaitDialogMessage(String message) {
        if (this.waitWindow != null) {
            this.waitWindow.updateMessage(message);
        }
    }

    @Override
    public final void setWaitDialog(String message, int maxTime) {
        if (this.waitWindow == null) {
            this.waitWindow = new WaitWindow(this.getFrame());
        }
        this.waitWindow.setWaitDialog(message, maxTime);
    }

    @Override
    public final void unsetWaitDialog() {
        if (this.waitWindow != null) {
            this.waitWindow.unsetWaitDialog();
            this.waitWindow = null;
        }
    }

    @Override
    public final void setWaitInfo(String message) {
        this.waitInfoHandler.setWaitInfo(message);
    }

    @Override
    public final void unsetWaitInfo() {
        this.waitInfoHandler.unsetWaitInfo();
    }

    @Override
    public void fileProduced(File file, String name) {
    }

    public synchronized void release() {
        SwingThreadHandler.verifyRunsInEventThread("DWindow release: DISPOSE MUST BE CALLED in the event dispatching Thread.");
        if (this.parentFrame != null && this.parentFrame instanceof JFrame) {
            this.parentFrame.removeWindowListener(this.windowhandler);
            this.parentFrame.removeWindowFocusListener(this.windowhandler);
            this.parentFrame.setFocusableWindowState(true);
            ((JFrame)this.parentFrame).getGlassPane().setVisible(false);
            this.parentFrame.toFront();
            this.windowhandler = null;
            this.setVisible(false);
        }
        this.model.removeVActionListener(this);
        this.model.removeWaitInfoListener(this.waitInfoHandler);
        this.model.removeMessageListener(this.messageHandler);
        this.getActionMap().clear();
        this.getInputMap().clear();
        this.frame = null;
        this.parentFrame = null;
        this.undoableListener = null;
        this.undo = null;
        this.undoAction = null;
        this.redoAction = null;
        this.footPanel = null;
        this.menuBar = null;
        this.buttonPanel = null;
        this.contentPanel = null;
        this.model = null;
        this.self.setJMenuBar(null);
        org.kopi.galite.visual.base.Utils.Companion.freeMemory();
        this.self = null;
    }

    @Override
    public void dispose() {
        JFrame frame = this.getFrame();
        this.disposeAfterLostFocus(frame);
    }

    private void disposeAfterLostFocus(final Window window) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (window != null) {
                    window.setVisible(false);
                    window.dispose();
                }
            }
        });
    }

    protected DMenuBar getDMenuBar() {
        return this.menuBar;
    }

    @Override
    public abstract void run() throws VException;

    private void addActorsToGUI(List<VActor> actorDefs) {
        if (actorDefs != null) {
            for (int i = 0; i < actorDefs.size(); ++i) {
                DActor actorView = (DActor)UIFactory.uiFactory.createView(actorDefs.get(i));
                this.addButton(this.buttonPanel, actorView);
                this.menuBar.addItem(actorView);
            }
        }
        this.buttonPanel.add(Box.createGlue());
    }

    private void addButton(JPanel panel, DActor actorView) {
        if (actorView.getModel().getIconName() != null) {
            panel.add(actorView.getButton());
        }
    }

    public JFrame createFrame() {
        this.dialog = false;
        if (this.firstTime) {
            JFrame f = new JFrame();
            f.setTitle(this.getModel().getTitle());
            if (DObject.windowIcon != null || this.getModel().getSmallIcon() != null) {
                f.setIconImage(this.getModel().getSmallIcon() == null ? DObject.windowIcon : ((ImageIcon)((Object)this.getModel().getSmallIcon())).getImage());
            }
            f.getContentPane().setLayout(new BorderLayout());
            f.getContentPane().add((Component)this, "Center");
            f.setDefaultCloseOperation(0);
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DWindow.this.closeWindow();
                }
            });
            f.setLocation(50, 50);
            this.menuBar.finalizeMenu();
            f.setJMenuBar(this.menuBar);
            this.self = f;
            this.frame = this.self;
        }
        return this.self;
    }

    JFrame createModalDialog(Frame frame) {
        final JFrame f = this.createFrame();
        this.parentFrame = frame;
        this.dialog = true;
        if (this.parentFrame instanceof JFrame) {
            JDisablePanel glass = new JDisablePanel();
            glass.setOpaque(false);
            MouseInputAdapter adapter = new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    f.toFront();
                    f.requestFocusInWindow();
                }
            };
            glass.addMouseListener(adapter);
            glass.addMouseMotionListener(adapter);
            ((JFrame)this.parentFrame).setGlassPane(glass);
            this.windowhandler = new WindowHandler(f, true);
            this.parentFrame.addWindowListener(this.windowhandler);
            this.parentFrame.addWindowFocusListener(this.windowhandler);
            this.parentFrame.setFocusableWindowState(false);
            f.addWindowListener(new WindowHandler(this.parentFrame, false));
            SwingThreadHandler.verifyRunsInEventThread("DWindow createModalDialog: set glasspane visible.");
            glass.setVisible(true);
        }
        return f;
    }

    private void setVisibleImpl(boolean b) {
        if (b) {
            if (this.firstTime) {
                this.self.pack();
                this.firstTime = false;
            }
            if (this.dialog && this.parentFrame != null) {
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                Point parentPos = new Point(0, 0);
                SwingUtilities.convertPointToScreen(parentPos, this.parentFrame);
                int posx = parentPos.x + this.parentFrame.getSize().width / 2 - this.self.getSize().width / 2;
                int posy = parentPos.y + this.parentFrame.getSize().height / 2 - this.self.getSize().height / 2;
                if (posx < 0) {
                    posx = 0;
                }
                if (posx + this.self.getSize().width > screen.width) {
                    posx = screen.width - this.self.getSize().width;
                }
                if (posy < 0) {
                    posy = 0;
                }
                if (posy + this.self.getSize().height > screen.height) {
                    posy = screen.height - this.self.getSize().height;
                }
                posx = Math.max(posx, 0);
                posy = Math.max(posy, 0);
                this.self.setLocation(posx, posy);
            }
        }
        this.self.setVisible(b);
        super.setVisible(b);
    }

    protected void verifyNotInTransaction(String message) {
        if (VWindow.Companion.inTransaction() && this.debugMessageInTransaction()) {
            try {
                ApplicationContext.Companion.reportTrouble("DWindow", message + " IN TRANSACTION", this.toString(), new RuntimeException("displayNotice in Transaction"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean debugMessageInTransaction() {
        boolean debugMessageInTransaction;
        try {
            debugMessageInTransaction = ApplicationContext.Companion.getDefaults().debugMessageInTransaction();
        }
        catch (Exception e) {
            debugMessageInTransaction = false;
        }
        return debugMessageInTransaction;
    }

    public static int showOptionDialog(JFrame frame, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        SwingThreadHandler.verifyRunsInEventThread("DWindow: showOptionDialog");
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        final JDialog dialog = pane.createDialog(frame, title);
        pane.selectInitialValue();
        closeOptionPaneWith = -1;
        pane.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 8837346594485054607L;

            @Override
            public void actionPerformed(ActionEvent e) {
                closeOptionPaneWith = 0;
                dialog.dispose();
            }
        }, null, KeyStroke.getKeyStroke((int)((String)options[0]).charAt(0), 0), 2);
        pane.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -2466568795023067881L;

            @Override
            public void actionPerformed(ActionEvent e) {
                closeOptionPaneWith = 1;
                dialog.dispose();
            }
        }, null, KeyStroke.getKeyStroke((int)((String)options[1]).charAt(0), 0), 2);
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (closeOptionPaneWith >= 0) {
            return closeOptionPaneWith;
        }
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    static {
        actions = DWindow.createActionTable(new JTextField());
        ICN_WAIT = Utils.getImage("wait.gif");
        ICN_ERROR = Utils.getImage("error.gif");
        ICN_WARNING = Utils.getImage("warning.gif");
        ICN_ASK = Utils.getImage("ask.gif");
        ICN_NOTICE = Utils.getImage("notice.gif");
        BOOKMARKS = new Bookmarks[10];
        for (int i = 0; i < 10; ++i) {
            DWindow.BOOKMARKS[i] = new Bookmarks(i);
        }
        focusManager = new KopiFocusManager();
        FocusManager.setCurrentManager(focusManager);
    }

    class ActionRunner
    implements Runnable {
        ActionRunner() {
        }

        @Override
        public void run() {
            try {
                if (DWindow.this.currentAction == null) {
                    return;
                }
                DWindow.this.currentAction.run();
                if (DWindow.this.getModel() != null) {
                    DWindow.this.getModel().executedAction(DWindow.this.currentAction);
                }
            }
            catch (VRuntimeException v) {
                v.printStackTrace();
                DWindow.this.reportError(v);
            }
            catch (Throwable exc) {
                exc.printStackTrace();
                DWindow.this.getModel().fatalError(DWindow.this.getModel(), "VWindow.performActionImpl(final KopiAction action)", exc);
            }
            finally {
                this.setInAction();
            }
        }

        private void setInAction() {
            try {
                Runnable actionSetter = new Runnable(){

                    @Override
                    public void run() {
                        LinkedList<AWTEvent> eventList = DWindow.this.currentEventQueue;
                        DWindow.this.currentEventQueue = null;
                        DWindow.this.currentAction = null;
                        DWindow.this.inAction = false;
                        DWindow.this.setWindowFocusEnabled(true);
                        if (DWindow.this.getModel() != null) {
                            DWindow.this.getModel().setCommandsEnabled(true);
                        }
                        focusManager.dequeueKeyEvents(eventList);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    actionSetter.run();
                } else {
                    SwingUtilities.invokeAndWait(actionSetter);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class Bookmarks
    extends AbstractAction {
        int item;
        private static final long serialVersionUID = -836013840309056928L;

        public Bookmarks(int i) {
            this.item = i;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            javax.swing.Action[] bookmarks;
            if (ApplicationContext.Companion.getMenu() != null && this.item < (bookmarks = ((DMenuTree)ApplicationContext.Companion.getMenu().getDisplay()).getBookmarkActions()).length) {
                bookmarks[this.item].actionPerformed(e);
            }
        }
    }

    protected class DUndoableEditListener
    implements UndoableEditListener {
        protected DUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (DWindow.this.undoAction != null && DWindow.this.redoAction != null) {
                DWindow.this.undoAction.update();
                DWindow.this.redoAction.update();
            }
        }
    }

    class WaitInfoHandler
    implements WaitInfoListener {
        @Override
        public void setWaitInfo(final String message) {
            SwingThreadHandler.startAndWait(new Runnable(){

                @Override
                public void run() {
                    if (DWindow.this.footPanel != null) {
                        DWindow.this.setCursor(Cursor.getPredefinedCursor(3));
                        DWindow.this.footPanel.setWaitInfo(message);
                    }
                }
            });
        }

        @Override
        public void unsetWaitInfo() {
            SwingThreadHandler.startAndWait(new Runnable(){

                @Override
                public void run() {
                    if (DWindow.this.footPanel != null) {
                        DWindow.this.setCursor(Cursor.getDefaultCursor());
                        DWindow.this.footPanel.unsetWaitInfo();
                    }
                }
            });
        }
    }

    class MessageHandler
    implements MessageListener {
        int value;

        MessageHandler() {
        }

        @Override
        public void notice(final String message) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    DWindow.this.displayNotice(message);
                }
            };
            SwingThreadHandler.startAndWait(runner);
        }

        @Override
        public void error(final String message) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    DWindow.this.displayError(message);
                }
            };
            SwingThreadHandler.startAndWait(runner);
        }

        @Override
        public void warn(final String message) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    DWindow.this.displayError(message);
                }
            };
            SwingThreadHandler.startAndWait(runner);
        }

        @Override
        public int ask(final String message, final boolean yesIsDefault) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    boolean retVal = DWindow.this.askUser(message, yesIsDefault);
                    MessageHandler.this.value = retVal ? 1 : 2;
                }
            };
            SwingThreadHandler.startAndWait(runner);
            return this.value;
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 4341094988092005822L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DWindow.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println(MessageCode.INSTANCE.getMessage("VIS-00029") + ex);
            }
            this.update();
            DWindow.this.redoAction.update();
        }

        protected void update() {
            if (DWindow.this.undo != null && DWindow.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", VlibProperties.getString("item-undo"));
            } else {
                this.setEnabled(false);
                this.putValue("Name", VlibProperties.getString("item-undo"));
            }
        }
    }

    public class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -8042055084991466893L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DWindow.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println(MessageCode.INSTANCE.getMessage("VIS-00030") + ex);
                ex.printStackTrace();
            }
            this.update();
            DWindow.this.undoAction.update();
        }

        protected void update() {
            if (DWindow.this.undo != null && DWindow.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", VlibProperties.getString("item-redo"));
            } else {
                this.setEnabled(false);
                this.putValue("Name", VlibProperties.getString("item-redo"));
            }
        }
    }

    static class KopiFocusManager
    extends DefaultFocusManager {
        private LinkedList<AWTEvent> enqueuedKeyEvents;
        private boolean dispatchEnqueued = false;

        KopiFocusManager() {
        }

        protected void dequeueKeyEvents(LinkedList<AWTEvent> enqueuedEvents) {
            if (enqueuedEvents == this.enqueuedKeyEvents && this.enqueuedKeyEvents != null) {
                this.enqueuedKeyEvents = null;
                this.dispatchEnqueued = false;
                if (enqueuedEvents != null) {
                    Iterator iter = enqueuedEvents.iterator();
                    while (iter.hasNext()) {
                        super.dispatchEvent((AWTEvent)iter.next());
                    }
                }
            }
        }

        protected LinkedList<AWTEvent> enqueueKeyEvents() {
            if (this.enqueuedKeyEvents != null) {
                this.enqueuedKeyEvents = new LinkedList<AWTEvent>(this.enqueuedKeyEvents);
                return this.enqueuedKeyEvents;
            }
            this.enqueuedKeyEvents = new LinkedList<AWTEvent>();
            return this.enqueuedKeyEvents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean dispatchEvent(AWTEvent e) {
            block10: {
                if (this.enqueuedKeyEvents == null) break block10;
                switch (e.getID()) {
                    case 400: 
                    case 401: 
                    case 402: {
                        this.enqueuedKeyEvents.addLast(e);
                        return true;
                    }
                    case 1004: {
                        try {
                            super.dispatchEvent(e);
                        }
                        finally {
                            if (this.dispatchEnqueued && this.enqueuedKeyEvents != null) {
                                LinkedList<AWTEvent> enqueuedEvents = this.enqueuedKeyEvents;
                                this.enqueuedKeyEvents = null;
                                this.dispatchEnqueued = false;
                                Iterator iter = enqueuedEvents.iterator();
                                while (iter.hasNext()) {
                                    super.dispatchEvent((AWTEvent)iter.next());
                                }
                            }
                        }
                        return true;
                    }
                    case 207: {
                        this.dispatchEnqueued = true;
                        return super.dispatchEvent(e);
                    }
                }
            }
            return super.dispatchEvent(e);
        }
    }

    static class WindowHandler
    extends WindowAdapter
    implements WindowFocusListener {
        private final Frame client;
        private final boolean active;

        WindowHandler(Frame client, boolean active) {
            this.client = client;
            this.active = active;
        }

        public void windowGainedFocus(FocusEvent e) {
            if (this.active) {
                this.client.toFront();
                this.client.requestFocusInWindow();
            }
        }

        public void windowLostFocus(FocusEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (this.active) {
                this.client.toFront();
                this.client.requestFocusInWindow();
            }
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.client.setState(1);
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            this.client.setState(0);
        }
    }
}

