/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.Component;
import java.util.Date;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.kopi.galite.database.Connection;
import org.kopi.galite.visual.Application;
import org.kopi.galite.visual.ApplicationConfiguration;
import org.kopi.galite.visual.ApplicationContext;
import org.kopi.galite.visual.Executable;
import org.kopi.galite.visual.FileHandler;
import org.kopi.galite.visual.ImageHandler;
import org.kopi.galite.visual.ModelCloseListener;
import org.kopi.galite.visual.Module;
import org.kopi.galite.visual.PrinterManager;
import org.kopi.galite.visual.PropertyException;
import org.kopi.galite.visual.Registry;
import org.kopi.galite.visual.UIFactory;
import org.kopi.galite.visual.VException;
import org.kopi.galite.visual.VMenuTree;
import org.kopi.galite.visual.VWindow;
import org.kopi.galite.visual.VerifyConfiguration;
import org.kopi.galite.visual.WindowController;
import org.kopi.galite.visual.base.UComponent;
import org.kopi.galite.visual.l10n.LocalizationManager;
import org.kopi.galite.visual.print.PrintManager;
import org.kopi.vkopi.lib.ui.swing.base.Utils;
import org.kopi.vkopi.lib.ui.swing.plaf.KopiLookAndFeel;
import org.kopi.vkopi.lib.ui.swing.visual.ApplicationOptions;
import org.kopi.vkopi.lib.ui.swing.visual.DWindow;
import org.kopi.vkopi.lib.ui.swing.visual.JApplicationContext;
import org.kopi.vkopi.lib.ui.swing.visual.JFileHandler;
import org.kopi.vkopi.lib.ui.swing.visual.JImageHandler;
import org.kopi.vkopi.lib.ui.swing.visual.JUIFactory;
import org.kopi.vkopi.lib.ui.swing.visual.JWindowController;
import org.kopi.vkopi.lib.ui.swing.visual.SplashScreen;

public abstract class JApplication
implements Application {
    private static Application instance;
    private ApplicationOptions options;
    private VMenuTree menuTree;
    private Connection connection;
    private boolean isGeneratingHelp;
    private SplashScreen splash;
    private Registry registry;
    private Locale defaultLocale;
    private LocalizationManager localizationManager;
    private PrintManager printManager;
    private PrinterManager printerManager;
    private ApplicationConfiguration configuration;
    private final Date startupTime = new Date();

    public JApplication(Registry registry) {
        instance = this;
        this.registry = registry;
    }

    static Application getInstance() {
        return instance;
    }

    public static ApplicationOptions getApplicationOptions() {
        return instance != null ? ((JApplication)JApplication.instance).options : null;
    }

    public static void quit() {
        if (instance != null && instance.allowQuit()) {
            System.exit(0);
        }
    }

    @Override
    public void logout() {
        if (this.allowQuit()) {
            this.menuTree.getDisplay().closeWindow();
        }
    }

    @Override
    public void startApplication() {
        block9: {
            if (this.options.form != null) {
                Object form;
                if (this.options.form.indexOf(".") != -1) {
                    form = this.options.form;
                } else {
                    String appli = this.getClass().getName();
                    int index = appli.lastIndexOf(46);
                    form = appli.substring(0, index + 1) + this.options.form;
                }
                try {
                    Executable module = Module.Companion.startForm(this.connection, (String)form, "initial form");
                    if (module instanceof VWindow) {
                        ((VWindow)module).addModelCloseListener(new ModelCloseListener(){

                            @Override
                            public void modelClosed(int type) {
                                JApplication.this.exitWithError(type);
                            }

                            @Override
                            public void dispose() {
                            }
                        });
                        break block9;
                    }
                    this.exitWithError(1);
                }
                catch (VException e) {
                    e.printStackTrace();
                    this.exitWithError(1);
                }
            } else {
                try {
                    String url = this.getURL();
                    this.menuTree = new VMenuTree(this.connection);
                    this.menuTree.setTitle(this.getUserName() + "@" + url.substring(url.indexOf("//") + 2));
                    this.menuTree.doNotModal();
                }
                catch (VException e) {
                    e.printStackTrace();
                    this.exitWithError(1);
                }
            }
        }
        this.removeSplashScreen();
    }

    @Override
    public boolean allowQuit() {
        return true;
    }

    @Override
    public PrintManager getPrintManager() {
        return this.printManager;
    }

    @Override
    public void setPrintManager(PrintManager printManager) {
        this.printManager = printManager;
    }

    @Override
    public PrinterManager getPrinterManager() {
        return this.printerManager;
    }

    @Override
    public void setPrinterManager(PrinterManager printerManager) {
        this.printerManager = printerManager;
    }

    @Override
    public ApplicationConfiguration getApplicationConfiguration() {
        return this.configuration;
    }

    @Override
    public void setApplicationConfiguration(ApplicationConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getURL() {
        return this.connection.getUrl();
    }

    public void initialize() {
        if (this.registry != null) {
            this.registry.buildDependencies();
        }
    }

    protected ImageIcon getSplashScreenImage() {
        return Utils.getImage("splash.jpg");
    }

    private void displaySplashScreen() {
        ImageIcon img = this.getSplashScreenImage();
        if (img != null) {
            this.splash = new SplashScreen(img.getImage(), null);
            this.splash.setVisible(true);
        }
    }

    private void removeSplashScreen() {
        if (this.splash != null) {
            this.splash.setVisible(false);
            this.splash.dispose();
            this.splash = null;
        }
    }

    private void exitWithError(int code) {
        this.removeSplashScreen();
        System.exit(code);
    }

    @Override
    public String getUserIP() {
        return null;
    }

    public boolean run(String[] args) {
        try {
            UIManager.setLookAndFeel(new KopiLookAndFeel());
        }
        catch (Exception e) {
            System.err.println("Undefined look and feel: Kopi Look & Feel must be installed!");
            System.exit(1);
            return false;
        }
        if (!this.processCommandLine(args)) {
            return false;
        }
        this.displaySplashScreen();
        this.initialize();
        if (!this.connectToDatabase()) {
            this.exitWithError(1);
            return false;
        }
        try {
            UIManager.setLookAndFeel(new KopiLookAndFeel());
        }
        catch (Exception e) {
            System.err.println("Undefined look and feel: Kopi Look & Feel must be installed!");
        }
        this.startApplication();
        return true;
    }

    private boolean processCommandLine(String[] args) {
        this.options = new ApplicationOptions();
        if (!this.options.parseCommandLine(args)) {
            return false;
        }
        if (this.options.locale == null) {
            System.err.println("Warning: a default locale was not specified!");
            this.defaultLocale = null;
        } else {
            char[] chars = this.options.locale.toCharArray();
            if (chars.length != 5 || chars[0] < 'a' || chars[0] > 'z' || chars[1] < 'a' || chars[1] > 'z' || chars[2] != '_' || chars[3] < 'A' || chars[3] > 'Z' || chars[4] < 'A' || chars[4] > 'Z') {
                System.err.println("Error: Wrong locale format.");
                this.options.usage();
                return false;
            }
            this.defaultLocale = new Locale(this.options.locale.substring(0, 2), this.options.locale.substring(3, 5));
        }
        this.localizationManager = new LocalizationManager(this.defaultLocale, Locale.getDefault());
        return true;
    }

    public void verifyConfiguration() {
        VerifyConfiguration verifyConfiguration = VerifyConfiguration.Companion.getVerifyConfiguration();
        try {
            verifyConfiguration.verifyConfiguration(ApplicationContext.Companion.getDefaults().getSMTPServer(), ApplicationContext.Companion.getDefaults().getDebugMailRecipient(), ApplicationContext.Companion.getDefaults().getApplicationName());
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
    }

    private boolean connectToDatabase() {
        if (this.options.username != null) {
            try {
                this.connection = Connection.Companion.createConnection(this.options.database, this.options.driver, this.options.username, this.options.password, this.options.lookupUserId, this.options.schema, Integer.valueOf(this.options.trace), 8, this.options.maxRetries, this.options.waitMin, this.options.waitMax, null);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                this.options.usage();
                this.connection = null;
            }
        }
        if (this.connection == null) {
            this.removeSplashScreen();
            this.connection = this.login(this.options.database, this.options.driver, this.options.username, this.options.password, this.options.schema, this.options.maxRetries, this.options.waitMin, this.options.waitMax);
            this.displaySplashScreen();
        }
        return this.connection != null;
    }

    public boolean isNobugReport() {
        return this.options != null && this.options.nobugreport;
    }

    @Override
    public Date getStartupTime() {
        return this.startupTime;
    }

    @Override
    public VMenuTree getMenu() {
        return this.menuTree;
    }

    public void setGeneratingHelp() {
        this.isGeneratingHelp = true;
    }

    @Override
    public boolean isGeneratingHelp() {
        return this.isGeneratingHelp;
    }

    @Override
    public String getUserName() {
        return this.connection.getUserName();
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public LocalizationManager getLocalizationManager() {
        return this.localizationManager;
    }

    @Override
    public void displayError(UComponent parent, String message) {
        DWindow.displayError((Component)((Object)parent), message);
    }

    @Override
    public void notice(String message) {
        this.menuTree.notice(message);
    }

    @Override
    public void error(String message) {
        this.menuTree.error(message);
    }

    @Override
    public void warn(String message) {
        this.menuTree.warn(message);
    }

    @Override
    public int ask(String message, boolean yesIsDefault) {
        return 3;
    }

    static {
        ApplicationContext.Companion.setApplicationContext(new JApplicationContext());
        FileHandler.Companion.setFileHandler(new JFileHandler());
        ImageHandler.Companion.setImageHandler(new JImageHandler());
        WindowController.Companion.setWindowController(new JWindowController());
        UIFactory.uiFactory = new JUIFactory();
    }
}

