/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.database;

import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003B\u0017\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016R\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/kopi/galite/database/DBException;", "Ljava/sql/SQLException;", "original", "(Ljava/sql/SQLException;)V", "query", "", "sqlException", "(Ljava/lang/String;Ljava/sql/SQLException;)V", "getSqlException", "()Ljava/sql/SQLException;", "getErrorCode", "", "getSQLState", "galite-data"})
public abstract class DBException
extends SQLException {
    @NotNull
    private final SQLException sqlException;

    public DBException(@Nullable String query, @NotNull SQLException sqlException) {
        Intrinsics.checkNotNullParameter((Object)sqlException, (String)"sqlException");
        super(Intrinsics.stringPlus((String)sqlException.getMessage(), (Object)(query != null ? "\n---- BEGIN QUERY TRACE ----\n" + query + "\n----  END QUERY TRACE   ----" : "")), sqlException.getSQLState(), sqlException.getErrorCode());
        this.sqlException = sqlException;
    }

    @NotNull
    public final SQLException getSqlException() {
        return this.sqlException;
    }

    public DBException(@NotNull SQLException original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this(null, original);
    }

    @Override
    public int getErrorCode() {
        return this.sqlException.getErrorCode();
    }

    @Override
    @NotNull
    public String getSQLState() {
        String string = this.sqlException.getSQLState();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sqlException.sqlState");
        return string;
    }
}

