/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.database;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0086\u0002J\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u000f"}, d2={"Lorg/kopi/galite/database/Configuration;", "", "configBundle", "Ljava/util/Properties;", "(Ljava/util/Properties;)V", "getConfigBundle", "()Ljava/util/Properties;", "setConfigBundle", "get", "", "key", "getConfigurationBundle", "load", "", "Companion", "galite-data"})
public final class Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Properties configBundle;
    @Nullable
    private static Configuration instance;
    @Nullable
    private static ResourceBundle resourceBundle;
    @NotNull
    private static final String CONFIGURATION_FILE = "conf/config.properties";
    @NotNull
    private static final String RESOURCE_FILE = "config";

    public Configuration(@NotNull Properties configBundle) {
        Intrinsics.checkNotNullParameter((Object)configBundle, (String)"configBundle");
        this.configBundle = configBundle;
        instance = this;
        resourceBundle = Companion.loadResourceBundle();
    }

    public /* synthetic */ Configuration(Properties properties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            properties = new Properties();
        }
        this(properties);
    }

    @NotNull
    public final Properties getConfigBundle() {
        return this.configBundle;
    }

    public final void setConfigBundle(@NotNull Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"<set-?>");
        this.configBundle = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        InputStream inputStream;
        InputStream input = null;
        try {
            System.out.println((Object)("Working Directory = " + System.getProperty("user.dir")));
            input = new FileInputStream(CONFIGURATION_FILE);
            this.configBundle.load(input);
            inputStream = input;
        }
        catch (Throwable throwable) {
            InputStream inputStream2 = input;
            if (inputStream2 != null) {
                inputStream2.close();
            }
            throw throwable;
        }
        inputStream.close();
    }

    @Nullable
    public final String get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.configBundle.getProperty(key);
    }

    @NotNull
    public final Properties getConfigurationBundle() {
        return this.configBundle;
    }

    public Configuration() {
        this(null, 1, null);
    }

    static {
        resourceBundle = Companion.loadResourceBundle();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\b\u0010\u0015\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/kopi/galite/database/Configuration$Companion;", "", "()V", "CONFIGURATION_FILE", "", "RESOURCE_FILE", "instance", "Lorg/kopi/galite/database/Configuration;", "getInstance", "()Lorg/kopi/galite/database/Configuration;", "setInstance", "(Lorg/kopi/galite/database/Configuration;)V", "resourceBundle", "Ljava/util/ResourceBundle;", "getResourceBundle", "()Ljava/util/ResourceBundle;", "setResourceBundle", "(Ljava/util/ResourceBundle;)V", "getDefault", "getString", "key", "loadResourceBundle", "galite-data"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Configuration getDefault() {
            return this.getInstance();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final String getString(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            try {
                if (this.getInstance() == null) {
                    this.setInstance(new Configuration(null, 1, null));
                    Configuration configuration = this.getInstance();
                    Intrinsics.checkNotNull((Object)configuration);
                    configuration.load();
                }
                Configuration configuration = this.getInstance();
                Intrinsics.checkNotNull((Object)configuration);
                String string2 = configuration.get(key);
                string2 = string2;
                if (string != null) return string2;
                ResourceBundle resourceBundle = this.getResourceBundle();
                if (resourceBundle == null) {
                    return null;
                }
                string2 = resourceBundle.getString(key);
                return string2;
            }
            catch (IOException e) {
                if (this.getResourceBundle() == null) return null;
                ResourceBundle resourceBundle = this.getResourceBundle();
                Intrinsics.checkNotNull((Object)resourceBundle);
                if (!resourceBundle.containsKey(key)) return null;
                ResourceBundle resourceBundle2 = this.getResourceBundle();
                Intrinsics.checkNotNull((Object)resourceBundle2);
                String string = resourceBundle2.getString(key);
                return string;
            }
            catch (MissingResourceException e) {
                return null;
            }
        }

        @Nullable
        public final ResourceBundle loadResourceBundle() {
            ResourceBundle resourceBundle;
            try {
                resourceBundle = ResourceBundle.getBundle(Configuration.RESOURCE_FILE);
            }
            catch (MissingResourceException e) {
                resourceBundle = null;
            }
            return resourceBundle;
        }

        @Nullable
        public final Configuration getInstance() {
            return instance;
        }

        public final void setInstance(@Nullable Configuration configuration) {
            instance = configuration;
        }

        @Nullable
        public final ResourceBundle getResourceBundle() {
            return resourceBundle;
        }

        public final void setResourceBundle(@Nullable ResourceBundle resourceBundle) {
            Configuration.resourceBundle = resourceBundle;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

