/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.database;

import java.sql.SQLException;
import java.util.NoSuchElementException;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.DatabaseConfig;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.kopi.galite.database.ConnectionKt;
import org.kopi.galite.database.Users;
import org.kopi.galite.util.base.InconsistencyException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)BG\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\fB_\b\u0012\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0012B_\b\u0012\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0013BG\b\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010&\u001a\u00020\tJ\b\u0010'\u001a\u00020(H\u0002R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u001a\u0010 \u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001e\u00a8\u0006*"}, d2={"Lorg/kopi/galite/database/Connection;", "", "connection", "Ljava/sql/Connection;", "lookupUserId", "", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "traceLevel", "", "isolationLevel", "maxRetries", "(Ljava/sql/Connection;ZLorg/jetbrains/exposed/sql/Schema;Ljava/lang/Integer;ILjava/lang/Integer;)V", "url", "", "driver", "userName", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Integer;ILjava/lang/Integer;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/exposed/sql/Schema;Ljava/lang/Integer;ILjava/lang/Integer;)V", "dataSource", "Ljavax/sql/DataSource;", "(Ljavax/sql/DataSource;ZLorg/jetbrains/exposed/sql/Schema;Ljava/lang/Integer;ILjava/lang/Integer;)V", "dbConnection", "Lorg/jetbrains/exposed/sql/Database;", "getDbConnection", "()Lorg/jetbrains/exposed/sql/Database;", "setDbConnection", "(Lorg/jetbrains/exposed/sql/Database;)V", "getPassword", "()Ljava/lang/String;", "getUrl", "user", "getUser", "()I", "setUser", "(I)V", "getUserName", "getUserID", "setUserID", "", "Companion", "galite-data"})
public final class Connection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final String userName;
    @Nullable
    private final String password;
    @NotNull
    private Database dbConnection;
    private int user;
    private static final int USERID_TO_DETERMINE = -1;
    private static final int USERID_NO_LOOKUP = -2;

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getUserName() {
        return this.userName;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    @NotNull
    public final Database getDbConnection() {
        return this.dbConnection;
    }

    public final void setDbConnection(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"<set-?>");
        this.dbConnection = database;
    }

    public final int getUser() {
        return this.user;
    }

    public final void setUser(int n) {
        this.user = n;
    }

    private Connection(final java.sql.Connection connection, boolean lookupUserId, Schema schema, Integer traceLevel, int isolationLevel, Integer maxRetries) {
        DatabaseConfig configuration = ConnectionKt.databaseConfig(schema, traceLevel, isolationLevel, maxRetries);
        this.dbConnection = Database.Companion.connect$default((Database.Companion)Database.Companion, (Function0)((Function0)new Function0<java.sql.Connection>(){

            @NotNull
            public final java.sql.Connection invoke() {
                return connection;
            }
        }), (DatabaseConfig)configuration, null, (int)4, null);
        this.url = this.dbConnection.getUrl();
        String string = connection.getMetaData().getUserName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connection.metaData.userName");
        this.userName = string;
        this.password = null;
        this.user = !lookupUserId ? -2 : -1;
        this.setUserID();
    }

    /* synthetic */ Connection(java.sql.Connection connection, boolean bl, Schema schema, Integer n, int n2, Integer n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            bl = true;
        }
        if ((n4 & 4) != 0) {
            schema = null;
        }
        if ((n4 & 8) != 0) {
            n = null;
        }
        if ((n4 & 0x10) != 0) {
            n2 = 8;
        }
        if ((n4 & 0x20) != 0) {
            n3 = null;
        }
        this(connection, bl, schema, n, n2, n3);
    }

    private Connection(String url, String driver, String userName, String password, boolean lookupUserId, String schema, Integer traceLevel, int isolationLevel, Integer maxRetries) {
        Schema schema2;
        Connection connection = this;
        String string = url;
        String string2 = driver;
        String string3 = userName;
        String string4 = password;
        boolean bl = lookupUserId;
        String string5 = schema;
        if (string5 == null) {
            schema2 = null;
        } else {
            String string6 = string5;
            boolean bl2 = bl;
            String string7 = string4;
            String string8 = string3;
            String string9 = string2;
            String string10 = string;
            Connection connection2 = connection;
            boolean bl3 = false;
            Schema schema3 = new Schema(schema, null, null, null, null, null, null, 126, null);
            connection = connection2;
            string = string10;
            string2 = string9;
            string3 = string8;
            string4 = string7;
            bl = bl2;
            schema2 = schema3;
        }
        connection(string, string2, string3, string4, bl, schema2, traceLevel, isolationLevel, maxRetries);
    }

    /* synthetic */ Connection(String string, String string2, String string3, String string4, boolean bl, String string5, Integer n, int n2, Integer n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            bl = true;
        }
        if ((n4 & 0x20) != 0) {
            string5 = null;
        }
        if ((n4 & 0x40) != 0) {
            n = null;
        }
        if ((n4 & 0x80) != 0) {
            n2 = 8;
        }
        if ((n4 & 0x100) != 0) {
            n3 = null;
        }
        this(string, string2, string3, string4, bl, string5, n, n2, n3);
    }

    private Connection(String url, String driver, String userName, String password, boolean lookupUserId, Schema schema, Integer traceLevel, int isolationLevel, Integer maxRetries) {
        DatabaseConfig configuration = ConnectionKt.databaseConfig(schema, traceLevel, isolationLevel, maxRetries);
        this.dbConnection = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)url, (String)driver, (String)userName, (String)password, null, (DatabaseConfig)configuration, null, (int)80, null);
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.user = !lookupUserId ? -2 : -1;
        this.setUserID();
    }

    /* synthetic */ Connection(String string, String string2, String string3, String string4, boolean bl, Schema schema, Integer n, int n2, Integer n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            bl = true;
        }
        if ((n4 & 0x20) != 0) {
            schema = null;
        }
        if ((n4 & 0x40) != 0) {
            n = null;
        }
        if ((n4 & 0x80) != 0) {
            n2 = 8;
        }
        if ((n4 & 0x100) != 0) {
            n3 = null;
        }
        this(string, string2, string3, string4, bl, schema, n, n2, n3);
    }

    private Connection(DataSource dataSource, boolean lookupUserId, Schema schema, Integer traceLevel, int isolationLevel, Integer maxRetries) {
        DatabaseConfig configuration = ConnectionKt.databaseConfig(schema, traceLevel, isolationLevel, maxRetries);
        this.dbConnection = Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)dataSource, null, (DatabaseConfig)configuration, null, (int)10, null);
        this.url = this.dbConnection.getUrl();
        String string = dataSource.getConnection().getMetaData().getUserName();
        if (string == null) {
            string = "";
        }
        this.userName = string;
        this.user = !lookupUserId ? -2 : -1;
        this.password = null;
    }

    /* synthetic */ Connection(DataSource dataSource, boolean bl, Schema schema, Integer n, int n2, Integer n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            bl = true;
        }
        if ((n4 & 4) != 0) {
            schema = null;
        }
        if ((n4 & 8) != 0) {
            n = null;
        }
        if ((n4 & 0x10) != 0) {
            n2 = 8;
        }
        if ((n4 & 0x20) != 0) {
            n3 = null;
        }
        this(dataSource, bl, schema, n, n2, n3);
    }

    public final int getUserID() {
        switch (this.user) {
            case -2: {
                throw new InconsistencyException("user id must not be queried");
            }
            case -1: {
                throw new InconsistencyException("user id not yet determined");
            }
        }
        return this.user;
    }

    private final void setUserID() {
        if (this.user != -2) {
            if (Intrinsics.areEqual((Object)this.userName, (Object)"root") || Intrinsics.areEqual((Object)this.userName, (Object)"lgvplus") || Intrinsics.areEqual((Object)this.userName, (Object)"tbadmin") || Intrinsics.areEqual((Object)this.userName, (Object)"dba")) {
                this.user = -2;
            } else {
                try {
                    ThreadLocalTransactionManagerKt.transaction$default(null, (Function1)((Function1)new Function1<Transaction, Unit>(this){
                        final /* synthetic */ Connection this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull Transaction $this$transaction) {
                            void $this$invoke_u24lambda_u2d0;
                            void $this$select$iv;
                            Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                            FieldSet fieldSet = Users.INSTANCE.slice((Expression)Users.INSTANCE.getId(), new Expression[0]);
                            Connection connection = this.this$0;
                            boolean $i$f$select = false;
                            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
                            void var8_6 = $this$select$iv;
                            Connection connection2 = this.this$0;
                            boolean bl = false;
                            Op op = $this$invoke_u24lambda_u2d0.eq((ExpressionWithColumnType)Users.INSTANCE.getShortName(), (Object)connection.getUserName());
                            connection2.setUser(((Number)((ResultRow)CollectionsKt.single((Iterable)((Iterable)QueriesKt.select((FieldSet)var8_6, (Op)op)))).get((Expression)Users.INSTANCE.getId())).intValue());
                        }
                    }), (int)1, null);
                }
                catch (NoSuchElementException e) {
                    throw new SQLException("user unknown");
                }
                catch (IllegalArgumentException e) {
                    throw new SQLException("different users with same name");
                }
                catch (SQLException e) {
                    String string = e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    throw new InconsistencyException(string);
                }
            }
        }
    }

    public /* synthetic */ Connection(java.sql.Connection connection, boolean lookupUserId, Schema schema, Integer traceLevel, int isolationLevel, Integer maxRetries, DefaultConstructorMarker $constructor_marker) {
        this(connection, lookupUserId, schema, traceLevel, isolationLevel, maxRetries);
    }

    public /* synthetic */ Connection(String url, String driver, String userName, String password, boolean lookupUserId, String schema, Integer traceLevel, int isolationLevel, Integer maxRetries, DefaultConstructorMarker $constructor_marker) {
        this(url, driver, userName, password, lookupUserId, schema, traceLevel, isolationLevel, maxRetries);
    }

    public /* synthetic */ Connection(DataSource dataSource, boolean lookupUserId, Schema schema, Integer traceLevel, int isolationLevel, Integer maxRetries, DefaultConstructorMarker $constructor_marker) {
        this(dataSource, lookupUserId, schema, traceLevel, isolationLevel, maxRetries);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JK\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00042\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0011JK\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00042\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0014Jc\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00042\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001aJY\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/kopi/galite/database/Connection$Companion;", "", "()V", "USERID_NO_LOOKUP", "", "USERID_TO_DETERMINE", "createConnection", "Lorg/kopi/galite/database/Connection;", "connection", "Ljava/sql/Connection;", "lookupUserId", "", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "traceLevel", "isolationLevel", "maxRetries", "(Ljava/sql/Connection;ZLorg/jetbrains/exposed/sql/Schema;Ljava/lang/Integer;ILjava/lang/Integer;)Lorg/kopi/galite/database/Connection;", "dataSource", "Ljavax/sql/DataSource;", "(Ljavax/sql/DataSource;ZLorg/jetbrains/exposed/sql/Schema;Ljava/lang/Integer;ILjava/lang/Integer;)Lorg/kopi/galite/database/Connection;", "url", "", "driver", "userName", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Integer;ILjava/lang/Integer;)Lorg/kopi/galite/database/Connection;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/exposed/sql/Schema;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/kopi/galite/database/Connection;", "galite-data"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Connection createConnection(@NotNull java.sql.Connection connection, boolean lookupUserId, @Nullable Schema schema, @Nullable Integer traceLevel, int isolationLevel, @Nullable Integer maxRetries) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            return new Connection(connection, lookupUserId, schema, traceLevel, isolationLevel, maxRetries, null);
        }

        public static /* synthetic */ Connection createConnection$default(Companion companion, java.sql.Connection connection, boolean bl, Schema schema, Integer n, int n2, Integer n3, int n4, Object object) {
            if ((n4 & 2) != 0) {
                bl = true;
            }
            if ((n4 & 4) != 0) {
                schema = null;
            }
            if ((n4 & 8) != 0) {
                n = null;
            }
            if ((n4 & 0x10) != 0) {
                n2 = 8;
            }
            if ((n4 & 0x20) != 0) {
                n3 = null;
            }
            return companion.createConnection(connection, bl, schema, n, n2, n3);
        }

        @NotNull
        public final Connection createConnection(@NotNull String url, @NotNull String driver, @NotNull String userName, @NotNull String password, boolean lookupUserId, @Nullable String schema, @Nullable Integer traceLevel, int isolationLevel, @Nullable Integer maxRetries) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            return new Connection(url, driver, userName, password, lookupUserId, schema, traceLevel, isolationLevel, maxRetries, null);
        }

        public static /* synthetic */ Connection createConnection$default(Companion companion, String string, String string2, String string3, String string4, boolean bl, String string5, Integer n, int n2, Integer n3, int n4, Object object) {
            if ((n4 & 0x10) != 0) {
                bl = true;
            }
            if ((n4 & 0x20) != 0) {
                string5 = null;
            }
            if ((n4 & 0x40) != 0) {
                n = null;
            }
            if ((n4 & 0x80) != 0) {
                n2 = 8;
            }
            if ((n4 & 0x100) != 0) {
                n3 = null;
            }
            return companion.createConnection(string, string2, string3, string4, bl, string5, n, n2, n3);
        }

        @NotNull
        public final Connection createConnection(@NotNull String url, @NotNull String driver, @NotNull String userName, @NotNull String password, boolean lookupUserId, @Nullable Schema schema, @Nullable Integer traceLevel, @Nullable Integer maxRetries) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            return new Connection(url, driver, userName, password, lookupUserId, schema, traceLevel, 0, maxRetries, 128, null);
        }

        public static /* synthetic */ Connection createConnection$default(Companion companion, String string, String string2, String string3, String string4, boolean bl, Schema schema, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                bl = true;
            }
            if ((n3 & 0x20) != 0) {
                schema = null;
            }
            if ((n3 & 0x40) != 0) {
                n = null;
            }
            if ((n3 & 0x80) != 0) {
                n2 = null;
            }
            return companion.createConnection(string, string2, string3, string4, bl, schema, n, n2);
        }

        @NotNull
        public final Connection createConnection(@NotNull DataSource dataSource, boolean lookupUserId, @Nullable Schema schema, @Nullable Integer traceLevel, int isolationLevel, @Nullable Integer maxRetries) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            return new Connection(dataSource, lookupUserId, schema, traceLevel, isolationLevel, maxRetries, null);
        }

        public static /* synthetic */ Connection createConnection$default(Companion companion, DataSource dataSource, boolean bl, Schema schema, Integer n, int n2, Integer n3, int n4, Object object) {
            if ((n4 & 2) != 0) {
                bl = true;
            }
            if ((n4 & 4) != 0) {
                schema = null;
            }
            if ((n4 & 8) != 0) {
                n = null;
            }
            if ((n4 & 0x10) != 0) {
                n2 = 8;
            }
            if ((n4 & 0x20) != 0) {
                n3 = null;
            }
            return companion.createConnection(dataSource, bl, schema, n, n2, n3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

