/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.database;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.NextVal;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SQLExpressionBuilderKt;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.Table;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/kopi/galite/database/Utils;", "", "()V", "Companion", "galite-data"})
public final class Utils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NULL_LITERAL = "NULL";

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kopi/galite/database/Utils$Companion;", "", "()V", "NULL_LITERAL", "", "getDualTableName", "Lorg/jetbrains/exposed/sql/Table;", "getNextTableId", "", "table", "toSql", "l", "trailString", "input", "trimString", "galite-data"})
    public static final class Companion {
        private Companion() {
        }

        public final int getNextTableId(@NotNull Table table) {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            NextVal seqNextVal = SQLExpressionBuilderKt.nextIntVal((Sequence)new Sequence(table.nameInDatabaseCase() + "Id", null, null, null, null, null, null, 126, null));
            Query seqNextValQuery = QueriesKt.selectAll((FieldSet)this.getDualTableName().slice((Expression)seqNextVal, new Expression[0]));
            ResultRow resultRow = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)seqNextValQuery));
            Integer n2 = n = resultRow == null ? null : (Integer)resultRow.get((Expression)seqNextVal);
            if (n == null) {
                throw new RuntimeException("Unable to get the sequence next value for table " + table.nameInDatabaseCase());
            }
            int id = n;
            return id;
        }

        @NotNull
        public final Table getDualTableName() {
            return new Table("DUAL");
        }

        @NotNull
        public final String trimString(@NotNull String input) {
            String string;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            char[] buffer = new char[input.length()];
            int bufpos = 0;
            int state = 0;
            int n = 0;
            int n2 = input.length();
            while (n < n2) {
                int n3;
                char element = input.charAt(n);
                ++n;
                if (Character.isWhitespace(element)) {
                    state = state == 0 ? 0 : 2;
                    continue;
                }
                if (state == 2) {
                    n3 = bufpos;
                    bufpos = n3 + 1;
                    buffer[n3] = 32;
                }
                n3 = bufpos;
                bufpos = n3 + 1;
                buffer[n3] = element;
                state = 1;
            }
            if (bufpos == 0) {
                string = "";
            } else {
                n = 0;
                string = new String(buffer, n, bufpos);
            }
            return string;
        }

        @Nullable
        public final String trailString(@NotNull String input) {
            String string;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int last = -1;
            for (int i = input.length() - 1; last == -1 && i >= 0; --i) {
                if (Character.isWhitespace(input.charAt(i))) continue;
                last = i;
            }
            if (last == -1) {
                string = "";
            } else if (last == input.length()) {
                string = input;
            } else {
                String string2 = input.substring(0, last + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = string2;
            }
            return string;
        }

        @NotNull
        public final String toSql(@Nullable String l) {
            String string;
            if (l == null) {
                string = Utils.NULL_LITERAL;
            } else {
                StringBuffer b = new StringBuffer();
                b.append('\'');
                int n = 0;
                while (n < l.length()) {
                    char element = l.charAt(n);
                    ++n;
                    if (element == '\'') {
                        b.append('\'');
                    }
                    b.append(element);
                }
                b.append('\'');
                String string2 = b.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n        val b = String\u2026     b.toString()\n      }");
                string = string2;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

