/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.kopi.galite.database.Configuration;
import org.kopi.galite.database.Connection;
import org.kopi.galite.database.ConnectionOptions;
import org.kopi.galite.database.Versions;
import org.kopi.galite.database.installed.TransDB;
import org.kopi.galite.util.base.InconsistencyException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J#\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0019\u0010\u0019\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u0019\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fR\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/kopi/galite/database/Migration;", "", "()V", "TRANSDBS", "", "Lorg/kopi/galite/database/installed/TransDB;", "getTRANSDBS", "()[Lorg/kopi/galite/database/installed/TransDB;", "options", "Lorg/kopi/galite/database/ConnectionOptions;", "getOptions", "()Lorg/kopi/galite/database/ConnectionOptions;", "setOptions", "(Lorg/kopi/galite/database/ConnectionOptions;)V", "checkOptions", "", "connection", "Lorg/kopi/galite/database/Connection;", "processCommandLine", "loadModuleVersion", "", "module", "", "args", "([Ljava/lang/String;Lorg/kopi/galite/database/ConnectionOptions;)Z", "run", "([Ljava/lang/String;)Z", "", "traceLog", "galite-data"})
@SourceDebugExtension(value={"SMAP\nMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Migration.kt\norg/kopi/galite/database/Migration\n+ 2 Queries.kt\norg/jetbrains/exposed/sql/QueriesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n14#2:154\n1549#3:155\n1620#3,3:156\n*S KotlinDebug\n*F\n+ 1 Migration.kt\norg/kopi/galite/database/Migration\n*L\n133#1:154\n133#1:155\n133#1:156,3\n*E\n"})
public abstract class Migration {
    @NotNull
    private ConnectionOptions options = new ConnectionOptions(null, 1, null);

    public final boolean run(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        boolean processCommandLine = this.processCommandLine(args, this.getOptions());
        try {
            this.run(processCommandLine);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(boolean processCommandLine) {
        Connection dbConnection = this.connection(processCommandLine);
        try {
            Ref.IntRef currentVersion = new Ref.IntRef();
            currentVersion.element = -1;
            Ref.ObjectRef currentModule = new Ref.ObjectRef();
            currentModule.element = "";
            for (TransDB transDB : this.getTRANSDBS()) {
                if (!Intrinsics.areEqual((Object)transDB.getModule(), (Object)currentModule.element)) {
                    currentModule.element = transDB.getModule();
                    ThreadLocalTransactionManagerKt.transaction((Database)dbConnection.getDbConnection(), (Function1)((Function1)new Function1<Transaction, Unit>(currentVersion, this, (Ref.ObjectRef<String>)currentModule){
                        final /* synthetic */ Ref.IntRef $currentVersion;
                        final /* synthetic */ Migration this$0;
                        final /* synthetic */ Ref.ObjectRef<String> $currentModule;
                        {
                            this.$currentVersion = $currentVersion;
                            this.this$0 = $receiver;
                            this.$currentModule = $currentModule;
                            super(1);
                        }

                        public final void invoke(@NotNull Transaction $this$transaction) {
                            Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                            this.$currentVersion.element = Migration.access$loadModuleVersion(this.this$0, (String)this.$currentModule.element);
                        }
                    }));
                    if (this.traceLog(processCommandLine)) {
                        System.out.println((Object)("Current version of module \"" + transDB.getModule() + "\" = " + currentVersion.element));
                    }
                }
                if (transDB.getVersion() <= currentVersion.element) continue;
                if (this.traceLog(processCommandLine)) {
                    System.out.println((Object)("Executing transDB " + transDB.getVersion() + " of module \"" + transDB.getModule() + "\""));
                }
                ThreadLocalTransactionManagerKt.transaction((Database)dbConnection.getDbConnection(), (Function1)((Function1)new Function1<Transaction, Unit>(transDB){
                    final /* synthetic */ TransDB $transDB;
                    {
                        this.$transDB = $transDB;
                        super(1);
                    }

                    public final void invoke(@NotNull Transaction $this$transaction) {
                        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                        this.$transDB.run();
                    }
                }));
            }
        }
        finally {
            dbConnection.getPoolConnection().close();
        }
    }

    private final boolean processCommandLine(String[] args, ConnectionOptions options) {
        return options.parseCommandLine(args) && this.checkOptions();
    }

    public final boolean checkOptions() {
        return this.getOptions().database != null && this.getOptions().driver != null && this.getOptions().username != null && this.getOptions().password != null;
    }

    @NotNull
    public Connection connection(boolean processCommandLine) {
        Connection connection;
        if (processCommandLine) {
            String string = this.getOptions().database;
            Intrinsics.checkNotNull((Object)string);
            String string2 = this.getOptions().driver;
            Intrinsics.checkNotNull((Object)string2);
            String string3 = this.getOptions().username;
            Intrinsics.checkNotNull((Object)string3);
            String string4 = this.getOptions().password;
            Intrinsics.checkNotNull((Object)string4);
            connection = Connection.Companion.createConnection$default(Connection.Companion, string, string2, string3, string4, false, this.getOptions().schema, this.getOptions().trace, 0, this.getOptions().maxRetries, this.getOptions().waitMin, this.getOptions().waitMax, null, 2176, null);
        } else {
            String string = Configuration.Companion.getString("database");
            Intrinsics.checkNotNull((Object)string);
            String string5 = Configuration.Companion.getString("driver");
            Intrinsics.checkNotNull((Object)string5);
            String string6 = Configuration.Companion.getString("username");
            Intrinsics.checkNotNull((Object)string6);
            String string7 = Configuration.Companion.getString("password");
            Intrinsics.checkNotNull((Object)string7);
            String string8 = Configuration.Companion.getString("trace");
            String string9 = Configuration.Companion.getString("maxRetries");
            String string10 = Configuration.Companion.getString("waitMin");
            String string11 = Configuration.Companion.getString("waitMax");
            connection = Connection.Companion.createConnection$default(Connection.Companion, string, string5, string6, string7, false, Configuration.Companion.getString("schema"), string8 != null ? Integer.valueOf(Integer.parseInt(string8)) : null, 0, string9 != null ? Integer.valueOf(Integer.parseInt(string9)) : null, string10 != null ? Long.valueOf(Long.parseLong(string10)) : null, string11 != null ? Long.valueOf(Long.parseLong(string11)) : null, null, 2176, null);
        }
        return connection;
    }

    public final boolean traceLog(boolean processCommandLine) {
        Integer n;
        if (processCommandLine) {
            n = this.getOptions().trace;
        } else {
            String string = Configuration.Companion.getString("trace");
            n = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        }
        Integer traceLevel = n;
        return traceLevel == null || traceLevel > 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int loadModuleVersion(String module) {
        int n;
        if (QueriesKt.exists((Table)Versions.INSTANCE)) {
            void $this$mapTo$iv$iv;
            Iterable $this$loadModuleVersion_u24lambda_u240;
            FieldSet $this$select$iv = Versions.INSTANCE.slice((Expression)Versions.INSTANCE.getNumber(), new Expression[0]);
            boolean $i$f$select = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Object object = $this$select$iv;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)QueriesKt.select((FieldSet)object, (Op)$this$loadModuleVersion_u24lambda_u240.eq((ExpressionWithColumnType)Versions.INSTANCE.getPackageName(), module)).orderBy((Expression)Versions.INSTANCE.getDate(), SortOrder.DESC);
            boolean $i$f$map = false;
            $this$loadModuleVersion_u24lambda_u240 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResultRow resultRow = (ResultRow)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(((Number)it.get((Expression)Versions.INSTANCE.getNumber())).intValue());
            }
            Integer n2 = (Integer)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            n = n2 != null ? n2 : -1;
        } else if (Intrinsics.areEqual((Object)module, (Object)"galite")) {
            n = -1;
        } else {
            throw new InconsistencyException("Can not find table Versionen. Please run Galite TransDB");
        }
        return n;
    }

    @NotNull
    public ConnectionOptions getOptions() {
        return this.options;
    }

    public void setOptions(@NotNull ConnectionOptions connectionOptions) {
        Intrinsics.checkNotNullParameter((Object)((Object)connectionOptions), (String)"<set-?>");
        this.options = connectionOptions;
    }

    @NotNull
    public abstract TransDB[] getTRANSDBS();

    public static final /* synthetic */ int access$loadModuleVersion(Migration $this, String module) {
        return $this.loadModuleVersion(module);
    }
}

